/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal;

import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.dto.VersionableWithExtraInfo;
import com.ibm.team.scm.common.internal.gc.ExternalLinks;
import com.ibm.team.scm.common.internal.gc.ExternalLinksDTOUtils;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.Assert;

public final class ItemWithLinks<T extends IItem> {
    private final T item;
    private final ExternalLinks links;

    public static <T extends IItem> ItemWithLinks<T> create(VersionableWithExtraInfo withExtraInfo) {
        List linkEntries = withExtraInfo.getLinks();
        return new ItemWithLinks<IVersionable>(withExtraInfo.getVersionable(), ExternalLinksDTOUtils.createFromExternalLinkEntries(linkEntries));
    }

    public static <T extends IItem> ItemWithLinks<T> create(T item, ExternalLinks links) {
        if (item == null) {
            return null;
        }
        if (links == null) {
            links = ExternalLinks.create();
        }
        return new ItemWithLinks<T>(item, links);
    }

    private ItemWithLinks(T item, ExternalLinks links) {
        Assert.isNotNull(item);
        Assert.isNotNull((Object)links);
        this.item = item;
        this.links = links;
    }

    public ItemWithLinks(T item) {
        this(item, ExternalLinks.create());
    }

    public T getItem() {
        return this.item;
    }

    public ExternalLinks getLinks() {
        return this.links;
    }

    public String toString() {
        return MessageFormat.format("ItemWithLinks [stateId={0}, itemId={1}, links={2}]", this.item.getStateId(), this.item.getItemId(), this.links);
    }

    public IItemType getItemType() {
        return this.item.getItemType();
    }
}

