/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal;

import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.internal.ItemWithLinks;
import com.ibm.team.scm.common.internal.gc.ExternalLinks;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;

public final class FetchedItems<T extends IItem> {
    private final Map<StateId<T>, T> itemMap = NewCollection.hashMap();
    private final Map<StateId<T>, ExternalLinks> links = NewCollection.hashMap();
    private Map<ItemId<T>, T> itemIdMap;
    private Map<ItemId<T>, ExternalLinks> linksById;

    public static <T extends IItem> FetchedItems<T> createFromStateMap(Map<StateId<T>, T> items) {
        return new FetchedItems<T>(items);
    }

    public static <T extends IItem> FetchedItems<T> createFromItemIdMap(Map<ItemId<T>, T> itemsById) {
        HashMap items = NewCollection.hashMap();
        for (IItem item : itemsById.values()) {
            Assert.isLegal((boolean)item.hasStateId(), (String)"All items must hvae a state ID");
            items.put(new StateId((IItemHandle)item), item);
        }
        return new FetchedItems(items);
    }

    private FetchedItems(Map<StateId<T>, T> items) {
        this.itemMap.putAll(items);
    }

    public void put(StateId<T> state, T item) {
        this.itemMap.put(state, item);
    }

    public T get(StateId<? extends T> state) {
        return (T)((IItem)this.itemMap.get(state));
    }

    public ItemWithLinks<T> getItemWithLinks(StateId<? extends T> state) {
        T item = this.get(state);
        if (item == null) {
            return null;
        }
        return ItemWithLinks.create(item, this.getLinks(state));
    }

    public ItemWithLinks<T> getItemWithLinks(ItemId<? extends T> itemId) {
        if (this.itemIdMap == null) {
            this.itemIdMap = NewCollection.hashMap();
            this.linksById = NewCollection.hashMap();
            for (Map.Entry<StateId<T>, T> entry : this.itemMap.entrySet()) {
                IItem item = (IItem)entry.getValue();
                ItemId id = new ItemId((IItemHandle)item);
                this.itemIdMap.put(id, item);
                ExternalLinks l = this.links.get(entry.getKey());
                if (l == null) continue;
                this.linksById.put(id, l);
            }
        }
        return ItemWithLinks.create((IItem)this.itemIdMap.get(itemId), this.linksById.get(itemId));
    }

    public Set<Map.Entry<StateId<T>, T>> entrySet() {
        return Collections.unmodifiableMap(this.itemMap).entrySet();
    }

    public Set<StateId<T>> keySet() {
        return Collections.unmodifiableMap(this.itemMap).keySet();
    }

    public List<T> items() {
        return NewCollection.arrayList(Collections.unmodifiableCollection(this.itemMap.values()));
    }

    public Map<StateId<T>, T> getItemMap() {
        return Collections.unmodifiableMap(this.itemMap);
    }

    public ExternalLinks getLinks(StateId<? extends T> state) {
        ExternalLinks result = this.links.get(state);
        if (result == null) {
            return ExternalLinks.create();
        }
        return result;
    }

    public void putLink(StateId<? extends T> state, ExternalLinks itemLinks) {
        Assert.isLegal((boolean)this.itemMap.containsKey(state), (String)"Only store links for fetched items");
        StateId<? extends T> stateNormalized = state;
        this.links.put(stateNormalized, itemLinks);
    }
}

