/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.dto;

import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.dto.ISynchronizationTime;
import com.ibm.team.scm.common.internal.dto.SyncTime;
import com.ibm.team.scm.common.internal.dto.SynchronizationTime;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.eclipse.core.runtime.IProgressMonitor;

public interface ISyncTime {
    public static final SyncTimeFactory FACTORY = new SyncTimeFactory();
    public static final ISyncTime TIME_NONE = new SyncTime(0L);

    public String toString();

    public ISynchronizationTime toSynchronizationTime();

    public static class SyncTimeFactory {
        private static final ISyncTime BASELINE_TIME = new SyncTime(1L);
        private final SecureRandom r = new SecureRandom();
        private MessageDigest md;

        SyncTimeFactory() {
        }

        public ISyncTime createFrom(String s) {
            long v = Long.valueOf(s);
            if (v == 0L) {
                return TIME_NONE;
            }
            return new SyncTime(v);
        }

        public ISyncTime createFrom(ISynchronizationTime s) {
            return new SyncTime(((SynchronizationTime)s).getTime());
        }

        public ISyncTime generate() {
            long n;
            while ((n = this.r.nextLong()) == 0L) {
            }
            return new SyncTime(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ISyncTime convertFromUUID(UUID id) {
            try {
                byte[] result;
                SecureRandom secureRandom = this.r;
                synchronized (secureRandom) {
                    MessageDigest digest = this.md;
                    if (digest == null) {
                        this.md = digest = MessageDigest.getInstance("MD5");
                    }
                    result = digest.digest(id.getUuidValue().getBytes("UTF-8"));
                }
                long state = 0L;
                int i = 0;
                while (i < 8) {
                    state = state << 8 | (long)(result[i] & 0xFF);
                    ++i;
                }
                if (state == 0L) {
                    ++state;
                }
                return new SyncTime(state);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public ISyncTime getConfigTimeFor(IBaselineHandle b, IProgressMonitor mon) {
            return BASELINE_TIME;
        }
    }
}

