/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.dto;

import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.scm.common.dto.IAccessGroupScope;
import com.ibm.team.scm.common.dto.IArchivedScope;
import com.ibm.team.scm.common.dto.IContributorDeferringScope;
import com.ibm.team.scm.common.dto.IPrivateScope;
import com.ibm.team.scm.common.dto.IProcessAreaScope;
import com.ibm.team.scm.common.dto.IPublicScope;
import com.ibm.team.scm.common.dto.ITeamAreaPrivateScope;
import com.ibm.team.scm.common.dto.IUnknownScope;
import com.ibm.team.scm.common.internal.dto.AccessGroupScope;
import com.ibm.team.scm.common.internal.dto.ContributorDeferringScope;
import com.ibm.team.scm.common.internal.dto.ProcessAreaScope;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.dto.TeamAreaPrivateScope;

public interface IReadScope {
    public static final IReadScopeFactory FACTORY = new IReadScopeFactory(){

        @Override
        public IContributorDeferringScope createContributorDeferringScope() {
            return ScmDtoFactory.eINSTANCE.createContributorDeferringScope();
        }

        @Override
        public IContributorDeferringScope createContributorDeferringScope(IProjectAreaHandle pArea) {
            ContributorDeferringScope scope = ScmDtoFactory.eINSTANCE.createContributorDeferringScope();
            scope.setScope((IAuditableHandle)pArea);
            return scope;
        }

        @Override
        public IProcessAreaScope createProcessAreaScope() {
            return ScmDtoFactory.eINSTANCE.createProcessAreaScope();
        }

        @Override
        public IProcessAreaScope createProcessAreaScope(IProcessAreaHandle processArea) {
            ProcessAreaScope newScope = ScmDtoFactory.eINSTANCE.createProcessAreaScope();
            newScope.setProcessArea((IAuditableHandle)processArea);
            return newScope;
        }

        @Override
        public ITeamAreaPrivateScope createTeamAreaPrivateScope() {
            return ScmDtoFactory.eINSTANCE.createTeamAreaPrivateScope();
        }

        @Override
        public ITeamAreaPrivateScope createTeamAreaPrivateScope(ITeamAreaHandle teamArea) {
            TeamAreaPrivateScope scope = ScmDtoFactory.eINSTANCE.createTeamAreaPrivateScope();
            scope.setTeamArea((IAuditableHandle)teamArea);
            return scope;
        }

        @Override
        public IPublicScope createPublicScope() {
            return ScmDtoFactory.eINSTANCE.createPublicScope();
        }

        @Override
        public IPrivateScope createPrivateScope() {
            return ScmDtoFactory.eINSTANCE.createPrivateScope();
        }

        @Override
        public IAccessGroupScope createAccessGroupScope() {
            return ScmDtoFactory.eINSTANCE.createAccessGroupScope();
        }

        @Override
        public IAccessGroupScope createAccessGroupScope(IAccessGroup accessGroup) {
            AccessGroupScope scope = ScmDtoFactory.eINSTANCE.createAccessGroupScope();
            scope.setAccessGroupId(accessGroup.getGroupContextId());
            return scope;
        }

        @Override
        public IUnknownScope createUnknownScope() {
            return ScmDtoFactory.eINSTANCE.createUnknownScope();
        }

        @Override
        public IArchivedScope createArchivedScope() {
            return ScmDtoFactory.eINSTANCE.createArchivedScope();
        }
    };
    public static final String READSCOPE_PUBLIC = "public_scope";
    public static final String READSCOPE_CONTRIBUTOR_DEFERRING = "contributor_deferring_scope";
    public static final String READSCOPE_PRIVATE = "private_scope";
    public static final String READSCOPE_PROCESS_AREA = "process_area_scope";
    public static final String READSCOPE_TEAM_AREA_PRIVATE = "team_area_private_scope";
    public static final String READSCOPE_ACCESS_GROUP = "access_group_scope";
    public static final String READSCOPE_UNKNOWN = "unknown_scope";
    public static final String READSCOPE_ARCHIVED = "archived_scope";
    public static final String READSCOPE_DELETED = "deleted_scope";

    public String getScopeType();

    public static interface IReadScopeFactory {
        public IContributorDeferringScope createContributorDeferringScope();

        public IContributorDeferringScope createContributorDeferringScope(IProjectAreaHandle var1);

        public IProcessAreaScope createProcessAreaScope();

        public IProcessAreaScope createProcessAreaScope(IProcessAreaHandle var1);

        public ITeamAreaPrivateScope createTeamAreaPrivateScope();

        public ITeamAreaPrivateScope createTeamAreaPrivateScope(ITeamAreaHandle var1);

        public IPublicScope createPublicScope();

        public IPrivateScope createPrivateScope();

        public IArchivedScope createArchivedScope();

        public IAccessGroupScope createAccessGroupScope(IAccessGroup var1);

        public IAccessGroupScope createAccessGroupScope();

        public IUnknownScope createUnknownScope();
    }
}

