/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.dto;

import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.dto.ISelectedVersionablesPageDescriptor;
import com.ibm.team.scm.common.internal.dto2.DateOrderedItemQueryPageDescriptor;
import com.ibm.team.scm.common.internal.dto2.DateOrderedQueryPageDescriptor;
import com.ibm.team.scm.common.internal.dto2.InitialPageDescriptor;
import com.ibm.team.scm.common.internal.dto2.ScmDto2Factory;
import com.ibm.team.scm.common.internal.dto2.SelectedVersionablesPageDescriptor;
import com.ibm.team.scm.common.internal.dto2.StringOrderedQueryPageDescriptor;
import com.ibm.team.scm.common.internal.util.QueryPageDescriptorSerializer;
import java.sql.Timestamp;

public interface IQueryPageDescriptor {
    public static final int MAX_PAGE_SIZE = 512;
    public static final IQueryPageDescriptorSerializer SERIALIZER = new QueryPageDescriptorSerializer();
    public static final IQueryPageDescriptorFactory FACTORY = new IQueryPageDescriptorFactory(){

        @Override
        public int getFactoryMaxPageSize() {
            return 512;
        }
    };

    public int getMaxPageSize();

    public static interface IQueryPageDescriptorFactory {
        default public IQueryPageDescriptor forDateOrderedQuery(Timestamp timestamp, int pageSize) {
            if (pageSize > this.getFactoryMaxPageSize()) {
                throw new IllegalArgumentException(NLS.bind((String)"The maximum page size is {0}", (Object)this.getFactoryMaxPageSize()));
            }
            if (pageSize <= 0) {
                throw new IllegalArgumentException("Page size must be greater than 0.");
            }
            DateOrderedQueryPageDescriptor pageDescriptor = ScmDto2Factory.eINSTANCE.createDateOrderedQueryPageDescriptor();
            pageDescriptor.setMaxPageSize(pageSize);
            pageDescriptor.setTimestamp(timestamp);
            return pageDescriptor;
        }

        default public IQueryPageDescriptor forDateOrderedItemQuery(Timestamp timestamp, UUID itemId, int pageSize) {
            if (pageSize > this.getFactoryMaxPageSize()) {
                throw new IllegalArgumentException(NLS.bind((String)"The maximum page size is {0}", (Object)this.getFactoryMaxPageSize()));
            }
            if (pageSize <= 0) {
                throw new IllegalArgumentException("Page size must be greater than 0.");
            }
            if (itemId == null) {
                throw new IllegalArgumentException("An item ID must be provided.");
            }
            DateOrderedItemQueryPageDescriptor pageDescriptor = ScmDto2Factory.eINSTANCE.createDateOrderedItemQueryPageDescriptor();
            pageDescriptor.setMaxPageSize(pageSize);
            pageDescriptor.setTimestamp(timestamp);
            pageDescriptor.setItemId(itemId);
            return pageDescriptor;
        }

        default public IQueryPageDescriptor forStringOrderedQuery(String boundaryString, UUID itemId, int pageSize) {
            if (pageSize > this.getFactoryMaxPageSize()) {
                throw new IllegalArgumentException(NLS.bind((String)"The maximum page size is {0}", (Object)this.getFactoryMaxPageSize()));
            }
            if (pageSize <= 0) {
                throw new IllegalArgumentException("Page size must be greater than 0.");
            }
            if (itemId == null) {
                throw new IllegalArgumentException("An item ID must be provided.");
            }
            StringOrderedQueryPageDescriptor pageDescriptor = ScmDto2Factory.eINSTANCE.createStringOrderedQueryPageDescriptor();
            pageDescriptor.setMaxPageSize(pageSize);
            pageDescriptor.setString(boundaryString);
            pageDescriptor.setItemId(itemId);
            return pageDescriptor;
        }

        default public IQueryPageDescriptor forFirstPage(int pageSize) {
            if (pageSize > this.getFactoryMaxPageSize()) {
                throw new IllegalArgumentException(NLS.bind((String)"The maximum page size is {0}", (Object)this.getFactoryMaxPageSize()));
            }
            if (pageSize <= 0) {
                throw new IllegalArgumentException("Page size must be greater than 0.");
            }
            InitialPageDescriptor pageDescriptor = ScmDto2Factory.eINSTANCE.createInitialPageDescriptor();
            pageDescriptor.setMaxPageSize(pageSize);
            return pageDescriptor;
        }

        public int getFactoryMaxPageSize();

        default public ISelectedVersionablesPageDescriptor forFirstSelectionsPage(int pageSize, UUID changeHistoryId) {
            if (pageSize > this.getFactoryMaxPageSize()) {
                throw new IllegalArgumentException(NLS.bind((String)"The maximum page size is {0}", (Object)this.getFactoryMaxPageSize()));
            }
            if (pageSize <= 0) {
                throw new IllegalArgumentException("Page size must be greater than 0.");
            }
            if (changeHistoryId == null) {
                throw new IllegalArgumentException("Change history id must not be null");
            }
            SelectedVersionablesPageDescriptor pageDescriptor = ScmDto2Factory.eINSTANCE.createSelectedVersionablesPageDescriptor();
            pageDescriptor.setMaxPageSize(pageSize);
            pageDescriptor.setChangeHistoryId(changeHistoryId);
            return pageDescriptor;
        }

        default public ISelectedVersionablesPageDescriptor forSelectionsPage(int pageSize, UUID changeHistoryId, int[] indicies) {
            if (pageSize > this.getFactoryMaxPageSize()) {
                throw new IllegalArgumentException(NLS.bind((String)"The maximum page size is {0}", (Object)this.getFactoryMaxPageSize()));
            }
            if (pageSize <= 0) {
                throw new IllegalArgumentException("Page size must be greater than 0.");
            }
            if (changeHistoryId == null) {
                throw new IllegalArgumentException("Change history id must not be null");
            }
            if (indicies == null || indicies.length == 0) {
                throw new IllegalArgumentException("Indicies must have at least 1 element");
            }
            int[] nArray = indicies;
            int n = indicies.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                if (i < 0) {
                    throw new IllegalArgumentException("All elements in indicies must be positive values");
                }
                ++n2;
            }
            SelectedVersionablesPageDescriptor pageDescriptor = ScmDto2Factory.eINSTANCE.createSelectedVersionablesPageDescriptor();
            pageDescriptor.setMaxPageSize(pageSize);
            pageDescriptor.setChangeHistoryId(changeHistoryId);
            int[] nArray2 = indicies;
            int n3 = indicies.length;
            n = 0;
            while (n < n3) {
                int i = nArray2[n];
                pageDescriptor.getIndicies().add(i);
                ++n;
            }
            return pageDescriptor;
        }
    }

    public static interface IQueryPageDescriptorSerializer {
        public String serialize(IQueryPageDescriptor var1) throws TeamRepositoryException;

        public IQueryPageDescriptor deserialize(String var1, int var2) throws TeamRepositoryException;
    }
}

