/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.dto;

import com.ibm.team.scm.common.internal.dto2.LockPageFetchDescriptor;
import com.ibm.team.scm.common.internal.dto2.ScmDto2Factory;
import org.eclipse.osgi.util.NLS;

public interface ILockPageFetchDescriptor {
    public static final int MAX_PAGE_SIZE = 2048;
    public static final ILockPageFetchDescriptorFactory FACTORY = new ILockPageFetchDescriptorFactory(){

        @Override
        public ILockPageFetchDescriptor maxEntries(int maxEntries) {
            if (maxEntries > 2048) {
                throw new IllegalArgumentException(NLS.bind((String)"The most entries that can be fetched in a page is {0}", (Object)2048));
            }
            if (maxEntries <= 0) {
                throw new IllegalArgumentException("maxEntries must be greater than 0.");
            }
            LockPageFetchDescriptor desc = ScmDto2Factory.eINSTANCE.createLockPageFetchDescriptor();
            desc.setPageSize(maxEntries);
            return desc;
        }
    };

    public void setLocksPerPage(int var1);

    public static interface ILockPageFetchDescriptorFactory {
        public ILockPageFetchDescriptor maxEntries(int var1);
    }
}

