/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.dto;

import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.dto2.LocateChangeSetCriteria;
import com.ibm.team.scm.common.internal.dto2.ScmDto2Factory;
import java.util.List;

public interface ILocateChangeSetsSearchCriteria {
    public static final ILocateChangeSetSearchCriteriaFactory FACTORY = new ILocateChangeSetSearchCriteriaFactory(){

        @Override
        public ILocateChangeSetsSearchCriteria create(List<IChangeSetHandle> changeSets, List<IWorkspaceHandle> workspaces, List<IBaselineSetHandle> snapshots, List<IBaselineHandle> baselines, boolean includeCopies) {
            if (changeSets == null || workspaces == null || snapshots == null || baselines == null) {
                throw new IllegalArgumentException();
            }
            LocateChangeSetCriteria result = ScmDto2Factory.eINSTANCE.createLocateChangeSetCriteria();
            result.getChangeSetsToLocate().addAll(changeSets);
            result.getWorkspacesToSearch().addAll(workspaces);
            result.getSnapshotsToSearch().addAll(snapshots);
            result.getBaselinesToSearch().addAll(baselines);
            result.setIncludeCopies(includeCopies);
            return result;
        }

        @Override
        public ILocateChangeSetsSearchCriteria create(List<IChangeSetHandle> changeSets, List<IWorkspaceHandle> workspaces, List<IBaselineSetHandle> snapshots, List<IBaselineHandle> baselines) {
            return this.create(changeSets, workspaces, snapshots, baselines, false);
        }
    };

    public List<IChangeSetHandle> getChangeSets();

    public List<IWorkspaceHandle> getWorkspaces();

    public List<IBaselineSetHandle> getSnapshots();

    public List<IBaselineHandle> getBaselines();

    public boolean isIncludeCopies();

    public static interface ILocateChangeSetSearchCriteriaFactory {
        public ILocateChangeSetsSearchCriteria create(List<IChangeSetHandle> var1, List<IWorkspaceHandle> var2, List<IBaselineSetHandle> var3, List<IBaselineHandle> var4);

        public ILocateChangeSetsSearchCriteria create(List<IChangeSetHandle> var1, List<IWorkspaceHandle> var2, List<IBaselineSetHandle> var3, List<IBaselineHandle> var4, boolean var5);
    }
}

