/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.dto;

import com.ibm.team.scm.common.internal.dto2.CustomAttributeSearchFilter;
import com.ibm.team.scm.common.internal.dto2.ScmDto2Factory;

public interface ICustomAttributeSearchFilter {
    public static final String STRING_TYPE = "String";
    public static final String BOOLEAN_TYPE = "Boolean";
    public static final CustomAttributeSearchFilterFactory FACTORY = new CustomAttributeSearchFilterFactory();

    public String getName();

    public String getType();

    public String getStringValue();

    public boolean getBooleanValue();

    public boolean hasValue();

    public static class CustomAttributeSearchFilterFactory {
        private CustomAttributeSearchFilterFactory() {
        }

        private CustomAttributeSearchFilter newInstance() {
            return ScmDto2Factory.eINSTANCE.createCustomAttributeSearchFilter();
        }

        public ICustomAttributeSearchFilter attributeMatches(String key, String value) {
            if (key == null || value == null) {
                throw new IllegalArgumentException();
            }
            CustomAttributeSearchFilter newInstance = this.newInstance();
            newInstance.setAttributeName(key);
            String normalizedvalue = value.replace("\r\n", "\n");
            newInstance.setStringValue(normalizedvalue);
            return newInstance;
        }

        public ICustomAttributeSearchFilter hasAttribute(String name) {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            CustomAttributeSearchFilter newInstance = this.newInstance();
            newInstance.setAttributeName(name);
            return newInstance;
        }

        public ICustomAttributeSearchFilter hasBooleanAttribute(String name) {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            CustomAttributeSearchFilter newInstance = this.newInstance();
            newInstance.setValueType(ICustomAttributeSearchFilter.BOOLEAN_TYPE);
            newInstance.setAttributeName(name);
            return newInstance;
        }

        public ICustomAttributeSearchFilter attributeMatches(String key, boolean value) {
            if (key == null) {
                throw new IllegalArgumentException();
            }
            CustomAttributeSearchFilter newInstance = this.newInstance();
            newInstance.setValueType(ICustomAttributeSearchFilter.BOOLEAN_TYPE);
            newInstance.setAttributeName(key);
            newInstance.setStringValue(Boolean.toString(value));
            return newInstance;
        }
    }
}

