/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.dto;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IHistoryReference;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.dto.ComponentOperationDescriptor;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.dto2.WorkspaceComponentState;

public interface IComponentOpDescriptor {
    public static final int ADD = 1;
    public static final int DROP = 2;
    public static final int REPLACE = 3;
    public static final IComponentOpDescriptorFactory FACTORY = new IComponentOpDescriptorFactory(){

        private ComponentOperationDescriptor create(IComponentHandle component, int type, boolean detailed) {
            if (component == null) {
                throw new IllegalArgumentException();
            }
            ComponentOperationDescriptor result = ScmDtoFactory.eINSTANCE.createComponentOperationDescriptor();
            result.setKind(type);
            result.setComponent(component);
            result.setRequiresDetailedReport(detailed);
            return result;
        }

        @Override
        public IComponentOpDescriptor addComponent(IComponentHandle component, boolean detailed) {
            ComponentOperationDescriptor result = this.create(component, 1, detailed);
            return result;
        }

        @Override
        public IComponentOpDescriptor addComponent(IComponentHandle component, IContextHandle seed, boolean detailed) {
            if (seed == null) {
                throw new IllegalArgumentException();
            }
            ComponentOperationDescriptor result = this.create(component, 1, detailed);
            result.setSeed((IItemHandle)seed);
            return result;
        }

        @Override
        public IComponentOpDescriptor addComponent(IComponentHandle component, IContextHandle seed, IWorkspaceHandle source, boolean detailed) {
            if (seed == null) {
                throw new IllegalArgumentException();
            }
            ComponentOperationDescriptor result = this.create(component, 1, detailed);
            result.setSeed((IItemHandle)seed);
            result.setSource(source);
            return result;
        }

        @Override
        public IComponentOpDescriptor dropComponent(IComponentHandle component, boolean detailed) {
            ComponentOperationDescriptor result = this.create(component, 2, detailed);
            return result;
        }

        @Override
        public IComponentOpDescriptor replaceComponent(IComponentHandle component, IContextHandle seed, boolean detailed) {
            if (seed == null) {
                throw new IllegalArgumentException();
            }
            ComponentOperationDescriptor result = this.create(component, 3, detailed);
            result.setSeed((IItemHandle)seed);
            return result;
        }

        @Override
        public IComponentOpDescriptor replaceComponent(IComponentHandle component, IContextHandle seed, IWorkspaceHandle source, boolean detailed) {
            if (seed == null) {
                throw new IllegalArgumentException();
            }
            ComponentOperationDescriptor result = this.create(component, 3, detailed);
            result.setSeed((IItemHandle)seed);
            result.setSource(source);
            return result;
        }

        @Override
        public boolean isValid(int kind) {
            return kind >= 1 && kind <= 3;
        }

        @Override
        public IComponentOpDescriptor[] array(IComponentOpDescriptor descriptor) {
            return new IComponentOpDescriptor[]{descriptor};
        }

        @Override
        public IComponentOpDescriptor addComponent(IHistoryReference history, IComponentHandle component, boolean detailed) {
            if (history == null || component == null) {
                throw new IllegalArgumentException();
            }
            ComponentOperationDescriptor result = this.create(component, 1, detailed);
            if (history instanceof IWorkspaceHandle) {
                result.setSeed((IItemHandle)((IWorkspaceHandle)history));
            } else if (history instanceof IBaselineSetHandle) {
                result.setSeed((IItemHandle)((IBaselineSetHandle)history));
            } else if (history instanceof WorkspaceComponentState) {
                result.setWorkspaceComponentState(history);
            } else {
                throw new IllegalArgumentException();
            }
            return result;
        }

        @Override
        public IComponentOpDescriptor replaceComponent(IHistoryReference history, IComponentHandle component, boolean detailed) {
            if (history == null || component == null) {
                throw new IllegalArgumentException();
            }
            ComponentOperationDescriptor result = this.create(component, 3, detailed);
            if (history instanceof IWorkspaceHandle) {
                result.setSeed((IItemHandle)((IWorkspaceHandle)history));
            } else if (history instanceof IBaselineSetHandle) {
                result.setSeed((IItemHandle)((IBaselineSetHandle)history));
            } else if (history instanceof WorkspaceComponentState) {
                result.setWorkspaceComponentState(history);
            } else {
                throw new IllegalArgumentException();
            }
            return result;
        }
    };

    public int getKind();

    public IComponentHandle getComponent();

    public boolean requiresDetailedReport();

    public IContextHandle getReplaceOrAddSeed();

    public IWorkspaceHandle getOperationSource();

    public IHistoryReference getHistoryReference();

    public static interface IComponentOpDescriptorFactory {
        public IComponentOpDescriptor addComponent(IComponentHandle var1, boolean var2);

        public IComponentOpDescriptor addComponent(IComponentHandle var1, IContextHandle var2, boolean var3);

        public IComponentOpDescriptor addComponent(IComponentHandle var1, IContextHandle var2, IWorkspaceHandle var3, boolean var4);

        public IComponentOpDescriptor addComponent(IHistoryReference var1, IComponentHandle var2, boolean var3);

        public IComponentOpDescriptor dropComponent(IComponentHandle var1, boolean var2);

        public IComponentOpDescriptor replaceComponent(IComponentHandle var1, IContextHandle var2, boolean var3);

        public IComponentOpDescriptor replaceComponent(IComponentHandle var1, IContextHandle var2, IWorkspaceHandle var3, boolean var4);

        public IComponentOpDescriptor replaceComponent(IHistoryReference var1, IComponentHandle var2, boolean var3);

        public IComponentOpDescriptor[] array(IComponentOpDescriptor var1);

        public boolean isValid(int var1);
    }
}

