/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.dto;

import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.internal.dto2.ComponentAtBaselineFilter;
import com.ibm.team.scm.common.internal.dto2.ComponentFilter;
import com.ibm.team.scm.common.internal.dto2.ScmDto2Factory;
import java.util.Collection;
import java.util.List;

public interface IComponentFilter {
    public static final IComponentFilterFactory FACTORY = new IComponentFilterFactory(){

        @Override
        public IComponentFilter containingComponent(IComponentHandle component) {
            if (component == null) {
                throw new IllegalArgumentException();
            }
            ComponentFilter filter = ScmDto2Factory.eINSTANCE.createComponentFilter();
            filter.setComponent(component);
            return filter;
        }

        @Override
        public IComponentFilter containingComponentAtBaseline(IComponentHandle component, Collection<IBaselineHandle> baselines) {
            if (component == null) {
                throw new IllegalArgumentException();
            }
            if (baselines == null || baselines.isEmpty()) {
                throw new IllegalArgumentException();
            }
            ComponentAtBaselineFilter filter = ScmDto2Factory.eINSTANCE.createComponentAtBaselineFilter();
            filter.setComponent(component);
            filter.getBaselines().addAll(baselines);
            return filter;
        }
    };

    public IComponentHandle getComponent();

    public List<IBaselineHandle> getBaselines();

    public static interface IComponentFilterFactory {
        public IComponentFilter containingComponent(IComponentHandle var1);

        public IComponentFilter containingComponentAtBaseline(IComponentHandle var1, Collection<IBaselineHandle> var2);
    }
}

