/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.changenodes;

import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.changenodes.IChangeNode;
import com.ibm.team.scm.common.internal.changenodes.IntermediateNode;
import com.ibm.team.scm.common.internal.changenodes.ItemChangeNode;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.providers.ItemProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ChangeSetStatesUtil {
    private static final Comparator<IChangeSet> changeSetDateComparator = new Comparator<IChangeSet>(){

        @Override
        public int compare(IChangeSet o1, IChangeSet o2) {
            return o1.modified().compareTo(o2.modified());
        }
    };

    /*
     * Could not resolve type clashes
     */
    private static List<ItemChangeNode> createOrderedChangeNodes(IVersionableHandle v, Collection<IChangeSet> ordered) {
        Map<UUID, IntermediateNode> nodes = NewCollection.hashMap(ordered.size() * 4 / 3);
        ArrayList<ItemChangeNode> orderedNodes = NewCollection.arrayList(ordered.size());
        HashSet<UUID> merges = NewCollection.hashSet();
        HashSet<UUID> newMerges = NewCollection.hashSet();
        for (IChangeSet changeSet : ordered) {
            Object pred2;
            IChange c = null;
            for (Object o : changeSet.changes()) {
                IChange chg = (IChange)o;
                if (!chg.item().sameItemId((IItemHandle)v)) continue;
                c = chg;
                break;
            }
            if (c == null) {
                ItemChangeNode undoNode = new ItemChangeNode(null, changeSet, IChangeNode.NodeType.UNDO);
                ChangeSetStatesUtil.addUndoDeps(changeSet.getPredecessorState(), nodes, undoNode);
                ChangeSetStatesUtil.addUndoDeps(changeSet.getMergePredecessorState(), nodes, undoNode);
                ChangeSetStatesUtil.adjustPredecessors(undoNode);
                for (Object pred2 : undoNode.getPredecessors()) {
                    if (ChangeSetStatesUtil.isNoOpComparedToPredecessor(undoNode, (ItemChangeNode)pred2)) continue;
                    orderedNodes.add(undoNode);
                    break;
                }
                nodes.put(changeSet.getStateId(), new IntermediateNode(undoNode, c));
                continue;
            }
            merges.clear();
            newMerges.clear();
            pred2 = c.mergeStates().iterator();
            while (pred2.hasNext()) {
                Object o;
                o = pred2.next();
                merges.add(o == null ? null : ((IVersionableHandle)o).getStateId());
            }
            newMerges.addAll(merges);
            int kind = c.kind();
            IChangeNode.NodeType nodeType = (kind & 1) != 0 ? IChangeNode.NodeType.ADDITION : ((kind & 0x10) != 0 ? IChangeNode.NodeType.DELETE : ((kind & 8) != 0 ? IChangeNode.NodeType.MOVE : ((kind & 4) != 0 ? IChangeNode.NodeType.RENAME : IChangeNode.NodeType.AFTER)));
            ItemChangeNode newNode = new ItemChangeNode(c.afterState(), changeSet, nodeType);
            ChangeSetStatesUtil.addDeps(changeSet.getPredecessorState(), c, nodes, merges, newMerges, newNode);
            ChangeSetStatesUtil.addDeps(changeSet.getMergePredecessorState(), c, nodes, merges, newMerges, newNode);
            ChangeSetStatesUtil.adjustPredecessors(newNode);
            if (newNode.getPredecessors().isEmpty()) {
                ItemChangeNode before = new ItemChangeNode(c.beforeState(), changeSet, IChangeNode.NodeType.BEFORE);
                orderedNodes.add(before);
                newNode.getPredecessors().add(before);
            }
            if (!newMerges.isEmpty()) {
                for (Object o : c.mergeStates()) {
                    if (o == null) {
                        if (!newMerges.contains(null)) continue;
                        ItemChangeNode merge = new ItemChangeNode(null, changeSet, IChangeNode.NodeType.MERGE);
                        orderedNodes.add(merge);
                        newNode.getPredecessors().add(merge);
                        continue;
                    }
                    IVersionableHandle state = (IVersionableHandle)o;
                    if (!newMerges.contains(state.getStateId())) continue;
                    ItemChangeNode merge = new ItemChangeNode(state, changeSet, IChangeNode.NodeType.MERGE);
                    orderedNodes.add(merge);
                    newNode.getPredecessors().add(merge);
                }
            }
            nodes.put(changeSet.getStateId(), new IntermediateNode(newNode, c));
            if (newNode.getPredecessors().size() == 1) {
                ItemChangeNode pred3 = newNode.getPredecessors().get(0);
                if (ChangeSetStatesUtil.isNoOpComparedToPredecessor(newNode, pred3)) continue;
                orderedNodes.add(newNode);
                continue;
            }
            orderedNodes.add(newNode);
        }
        int size = orderedNodes.size();
        int j = 0;
        int i = 0;
        while (i != size) {
            ItemChangeNode node = (ItemChangeNode)orderedNodes.get(i);
            IChangeNode.NodeType type = node.getType();
            if (type == IChangeNode.NodeType.BEFORE || type == IChangeNode.NodeType.MERGE) {
                if (node.getState() != null) {
                    orderedNodes.set(j, node);
                    ++j;
                }
            } else {
                int k = 0;
                ArrayList<ItemChangeNode> predecessors = node.getPredecessors();
                int predSize = predecessors.size();
                int l = 0;
                while (l != predSize) {
                    ItemChangeNode pred = (ItemChangeNode)predecessors.get(l);
                    IChangeNode.NodeType predType = pred.getType();
                    if (predType == IChangeNode.NodeType.BEFORE || predType == IChangeNode.NodeType.MERGE) {
                        if (pred.getState() != null) {
                            predecessors.set(k, pred);
                            ++k;
                        }
                    } else {
                        predecessors.set(k, pred);
                        ++k;
                    }
                    ++l;
                }
                if (k != predSize) {
                    predecessors.subList(k, predSize).clear();
                }
                orderedNodes.set(j, node);
                ++j;
            }
            for (ItemChangeNode pred : node.getPredecessors()) {
                pred.getSuccessors().add(node);
            }
            ++i;
        }
        if (j != size) {
            orderedNodes.subList(j, size).clear();
        }
        return orderedNodes;
    }

    private static List<IChangeSet> orderChangeSets(Collection<IChangeSet> csStates) {
        IChangeSet next;
        int size = csStates.size();
        ArrayList<IChangeSet> ordered = NewCollection.arrayList(size);
        int capacity = size * 4 / 3;
        PriorityQueue<IChangeSet> startQueue = new PriorityQueue<IChangeSet>(2, changeSetDateComparator);
        Map depGraph = NewCollection.hashMap(capacity);
        Map<UUID, Integer> incomingCount = NewCollection.hashMap(capacity);
        for (IChangeSet nextCS : csStates) {
            List<Object> deps;
            IAuditableHandle predecessor = nextCS.getPredecessorState();
            IAuditableHandle mergePredecessor = nextCS.getMergePredecessorState();
            if (predecessor == null && mergePredecessor == null) {
                startQueue.offer(nextCS);
                continue;
            }
            UUID stateId = nextCS.getStateId();
            int c = 0;
            if (predecessor != null) {
                deps = (ArrayList)depGraph.get(predecessor.getStateId());
                if (deps == null) {
                    deps = NewCollection.arrayList(1);
                    depGraph.put(predecessor.getStateId(), deps);
                }
                deps.add(nextCS);
                ++c;
            }
            if (!(mergePredecessor == null || predecessor != null && mergePredecessor.sameStateId((IItemHandle)predecessor))) {
                deps = (List)depGraph.get(mergePredecessor.getStateId());
                if (deps == null) {
                    deps = NewCollection.arrayList(1);
                    depGraph.put(mergePredecessor.getStateId(), deps);
                }
                deps.add(nextCS);
                ++c;
            }
            incomingCount.put(stateId, c);
        }
        while ((next = startQueue.poll()) != null) {
            ordered.add(next);
            Collection deps = (Collection)depGraph.get(next.getStateId());
            if (deps == null) continue;
            for (IChangeSet dep : deps) {
                int cnt = (Integer)incomingCount.get(dep.getStateId());
                if (cnt == 1) {
                    startQueue.offer(dep);
                    continue;
                }
                incomingCount.put(dep.getStateId(), cnt - 1);
            }
        }
        if (ordered.size() != size) {
            throw new IllegalStateException();
        }
        if (size != 0) {
            Set validPredecessors = NewCollection.hashSet(capacity);
            validPredecessors.add(((IChangeSet)ordered.get(size - 1)).getStateId());
            ListIterator it = ordered.listIterator(size);
            while (it.hasPrevious()) {
                IChangeSet prev = (IChangeSet)it.previous();
                if (!validPredecessors.remove(prev.getStateId())) {
                    throw new IllegalStateException();
                }
                IAuditableHandle pr = prev.getPredecessorState();
                if (pr != null) {
                    validPredecessors.add(pr.getStateId());
                }
                if ((pr = prev.getMergePredecessorState()) == null) continue;
                validPredecessors.add(pr.getStateId());
            }
        }
        return ordered;
    }

    private static boolean isNoOpComparedToPredecessor(ItemChangeNode node, ItemChangeNode predecessor) {
        IChangeNode.NodeType predType = predecessor.getType();
        if (predType == IChangeNode.NodeType.BEFORE || predType == IChangeNode.NodeType.MERGE) {
            return false;
        }
        if (node.getType() == IChangeNode.NodeType.UNDO) {
            return predType == IChangeNode.NodeType.UNDO;
        }
        return ChangeSetStatesUtil.sameState(node.getState(), predecessor.getState());
    }

    private static void adjustPredecessors(ItemChangeNode node) {
        int size = node.getPredecessors().size();
        Set uniquePred = NewCollection.hashSet(size * 4 / 3);
        int j = 0;
        int i = 0;
        while (i < size) {
            ItemChangeNode pred;
            ItemChangeNode realPred = pred = node.getPredecessors().get(i);
            if (pred.getPredecessors().size() == 1 && !ChangeSetStatesUtil.isNoOpComparedToPredecessor(pred, realPred = pred.getPredecessors().get(0))) {
                realPred = pred;
            }
            if (uniquePred.add(realPred)) {
                node.getPredecessors().set(j, realPred);
                ++j;
            }
            ++i;
        }
        if (j != size) {
            node.getPredecessors().subList(j, size).clear();
        }
    }

    public static List<IChangeNode> getChangeNodes(IChangeSetHandle cs, IVersionableHandle v, ItemProvider provider, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IChangeSet> csStates;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        List<IAuditableHandle> handles = provider.fetchAllStateHandles(cs, (IProgressMonitor)progress.newChild(25));
        int size = handles.size();
        if (size == 0) {
            return NewCollection.arrayList(0);
        }
        int step = provider.maxStatesPerRequest();
        if (step >= size) {
            csStates = provider.fetchStates(handles, (IProgressMonitor)progress.newChild(75));
        } else {
            csStates = NewCollection.arrayList(size);
            progress.setWorkRemaining(size);
            int i = 0;
            while (size != i) {
                int top = Math.min(size, i + step);
                List<IAuditable> batch = provider.fetchStates(handles.subList(i, top), (IProgressMonitor)progress.newChild(top - i));
                i = top;
                csStates.addAll(batch);
            }
        }
        v = (IVersionableHandle)v.getItemType().createItemHandle(v.getItemId(), null);
        List<IChangeSet> orderedStates = ChangeSetStatesUtil.orderChangeSets(csStates);
        List<IChangeNode> nodeMap = ChangeSetStatesUtil.createOrderedChangeNodes(v, orderedStates);
        return nodeMap;
    }

    private static boolean sameState(IVersionableHandle v1, IVersionableHandle v2) {
        return v1 == null ? v2 == null : v1.sameStateId((IItemHandle)v2);
    }

    private static void addDeps(IAuditableHandle predState, IChange c, Map<UUID, IntermediateNode> nodes, Collection<UUID> merges, Set<UUID> newMerges, ItemChangeNode newNode) {
        if (predState != null) {
            IntermediateNode pred = nodes.get(predState.getStateId());
            ItemChangeNode predNode = pred.getNode();
            if (predNode.getType() == IChangeNode.NodeType.UNDO) {
                for (ItemChangeNode predPred : predNode.getPredecessors()) {
                    if (ChangeSetStatesUtil.isNoOpComparedToPredecessor(predNode, predPred)) continue;
                    newNode.getPredecessors().add(predNode);
                }
            } else if (ChangeSetStatesUtil.sameState(c.beforeState(), pred.getChange().beforeState())) {
                boolean containsAll = true;
                for (Object o : pred.getChange().mergeStates()) {
                    UUID merge;
                    UUID uUID = merge = o == null ? null : ((IVersionableHandle)o).getStateId();
                    if (!merges.contains(merge)) {
                        containsAll = false;
                        break;
                    }
                    newMerges.remove(merge);
                }
                if (containsAll) {
                    newNode.getPredecessors().add(predNode);
                }
            }
        }
    }

    private static void addUndoDeps(IAuditableHandle predState, Map<UUID, IntermediateNode> nodes, ItemChangeNode newNode) {
        if (predState != null) {
            IntermediateNode pred = nodes.get(predState.getStateId());
            newNode.getPredecessors().add(pred.getNode());
        }
    }
}

