/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IManagedItemHandle;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.dto2.ScmDto2Factory;
import com.ibm.team.scm.common.internal.dto2.VersionablePermissionDeniedComponentData;
import com.ibm.team.scm.common.internal.dto2.VersionablePermissionDeniedExceptionData;
import com.ibm.team.scm.common.internal.process.AdvisorDetailConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VersionablePermissionDeniedException
extends PermissionDeniedException {
    public static void createVersionableListElement(Element versionableList, Document doc, UUID repoId, IContextHandle ctx, IComponentHandle ch, IVersionableHandle vh, String label) {
        Element versionableListItem = doc.createElement("item");
        versionableListItem.appendChild(AdvisorDetailConstants.makeVersionableLink(doc, repoId, ctx, ch, label, vh, null, true));
        versionableList.appendChild(versionableListItem);
    }

    private VersionablePermissionDeniedException(String message) {
        super(message);
    }

    public VersionablePermissionDeniedException(String message, Throwable cause) {
        super(message, cause);
    }

    public static VersionablePermissionDeniedException exceptionFor(String message, UUID repoId, IContextHandle context, IComponentHandle component, List<IVersionableHandle> inaccessibleVersionables, boolean isSubtreeRoots) {
        VersionablePermissionDeniedException ex = new VersionablePermissionDeniedException(message);
        VersionablePermissionDeniedExceptionData data = ScmDto2Factory.eINSTANCE.createVersionablePermissionDeniedExceptionData();
        ex.setData(data);
        data.setRepoId(repoId);
        data.setContext(context);
        data.setSubtreeRoots(isSubtreeRoots);
        VersionablePermissionDeniedComponentData cd = ScmDto2Factory.eINSTANCE.createVersionablePermissionDeniedComponentData();
        data.getComponentData().add(cd);
        cd.getVersionables().addAll(inaccessibleVersionables);
        cd.setComponent(component);
        return ex;
    }

    public static VersionablePermissionDeniedException exceptionFor(String message, UUID repoId, IContextHandle context, IComponentHandle component, IVersionableHandle inaccessibleVersionable) {
        return VersionablePermissionDeniedException.exceptionFor(message, repoId, context, component, inaccessibleVersionable, false);
    }

    public static VersionablePermissionDeniedException exceptionFor(String message, UUID repoId, IContextHandle context, IComponentHandle component, IVersionableHandle inaccessibleVersionable, boolean isSubtreeRoot) {
        return VersionablePermissionDeniedException.exceptionFor(message, repoId, context, component, Collections.singletonList(inaccessibleVersionable), isSubtreeRoot);
    }

    public static VersionablePermissionDeniedException exceptionFor(String message, UUID repoId, IContextHandle context, List<VersionablePermissionDeniedException> exceptions, boolean isSubtreeRoots) {
        VersionablePermissionDeniedException ex = new VersionablePermissionDeniedException(message);
        VersionablePermissionDeniedExceptionData data = ScmDto2Factory.eINSTANCE.createVersionablePermissionDeniedExceptionData();
        ex.setData(data);
        data.setRepoId(repoId);
        data.setContext(context);
        data.setSubtreeRoots(isSubtreeRoots);
        for (VersionablePermissionDeniedException vpde : exceptions) {
            Object imbeddedData = vpde.getData();
            if (!(imbeddedData instanceof VersionablePermissionDeniedExceptionData)) continue;
            VersionablePermissionDeniedExceptionData vpded = (VersionablePermissionDeniedExceptionData)imbeddedData;
            data.getComponentData().addAll(vpded.getComponentData());
        }
        return ex;
    }

    public List<IVersionableHandle> getVersionables() {
        Object data = this.getData();
        ArrayList<IVersionableHandle> result = new ArrayList<IVersionableHandle>();
        if (data instanceof VersionablePermissionDeniedExceptionData) {
            VersionablePermissionDeniedExceptionData vpded = (VersionablePermissionDeniedExceptionData)data;
            for (VersionablePermissionDeniedComponentData cd : vpded.getComponentData()) {
                result.addAll(cd.getVersionables());
            }
        }
        return result;
    }

    public boolean isSubtreeRoots() {
        Object data = this.getData();
        if (data instanceof VersionablePermissionDeniedExceptionData) {
            return ((VersionablePermissionDeniedExceptionData)data).isSubtreeRoots();
        }
        return false;
    }

    public List<IComponentHandle> getComponents() {
        Object data = this.getData();
        ArrayList<IComponentHandle> result = new ArrayList<IComponentHandle>();
        if (data instanceof VersionablePermissionDeniedExceptionData) {
            VersionablePermissionDeniedExceptionData vpded = (VersionablePermissionDeniedExceptionData)data;
            for (VersionablePermissionDeniedComponentData cd : vpded.getComponentData()) {
                result.add(cd.getComponent());
            }
        }
        return result;
    }

    public List<IVersionableHandle> getVersionables(IComponentHandle component) {
        Object data = this.getData();
        if (data instanceof VersionablePermissionDeniedExceptionData) {
            VersionablePermissionDeniedExceptionData vpded = (VersionablePermissionDeniedExceptionData)data;
            for (VersionablePermissionDeniedComponentData cd : vpded.getComponentData()) {
                if (!cd.getComponent().sameItemId((IItemHandle)component)) continue;
                return cd.getVersionables();
            }
        }
        return Collections.emptyList();
    }

    public String getAml() {
        Object data = this.getData();
        if (data instanceof VersionablePermissionDeniedExceptionData) {
            return ((VersionablePermissionDeniedExceptionData)data).getAml();
        }
        return this.getMessage();
    }

    public UUID getRepoId() {
        Object data = this.getData();
        if (data instanceof VersionablePermissionDeniedExceptionData) {
            return ((VersionablePermissionDeniedExceptionData)data).getRepoId();
        }
        return null;
    }

    public IContextHandle getContextHandle() {
        IManagedItemHandle context;
        Object data = this.getData();
        if (data instanceof VersionablePermissionDeniedExceptionData && (context = ((VersionablePermissionDeniedExceptionData)data).getContext()) instanceof IContextHandle) {
            return (IContextHandle)context;
        }
        return null;
    }
}

