/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common;

import java.util.ArrayList;
import java.util.Collection;

public final class Pair<U, V> {
    private final U first;
    private final V second;

    public static <U, V> Pair<U, V> create(U first, V second) {
        return new Pair<U, V>(first, second);
    }

    public Pair(U first, V second) {
        this.first = first;
        this.second = second;
    }

    public U getFirst() {
        return this.first;
    }

    public V getSecond() {
        return this.second;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pair other = (Pair)obj;
        if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
            return false;
        }
        return !(this.second == null ? other.second != null : !this.second.equals(other.second));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        return result;
    }

    public String toString() {
        return "<" + this.first + ", " + this.second + ">";
    }

    public static <U, V> Collection<U> getFirstValueSet(Collection<Pair<U, V>> pairs) {
        ArrayList<U> result = new ArrayList<U>(pairs.size());
        for (Pair<U, V> pair : pairs) {
            result.add(pair.getFirst());
        }
        return result;
    }

    public static <U, V> Collection<V> getSecondValueSet(Collection<Pair<U, V>> pairs) {
        ArrayList<V> result = new ArrayList<V>(pairs.size());
        for (Pair<U, V> pair : pairs) {
            result.add(pair.getSecond());
        }
        return result;
    }
}

