/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common;

import com.ibm.team.internal.repository.rcp.streams.DigestComputingInputStream;
import com.ibm.team.internal.repository.rcp.streams.DigestComputingOutputStream;
import com.ibm.team.internal.repository.rcp.util.StringCoder;
import com.ibm.team.scm.common.ContentHashAlgorithmException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class ContentHash {
    public static final String HASH_ALGO = "SHA-256";
    public static final int HASH_RAW_LEN = 32;
    public static final int HASH_CODED_LEN = 43;
    private final String value;

    public static DigestComputingInputStream getDigestComputingStream(InputStream in) throws ContentHashAlgorithmException {
        MessageDigest md = ContentHash.getHashDigest();
        return new DigestComputingInputStream(in, md);
    }

    public static DigestComputingOutputStream getDigestComputingOutputStream(OutputStream out) throws ContentHashAlgorithmException {
        MessageDigest md = ContentHash.getHashDigest();
        return new DigestComputingOutputStream(md, out);
    }

    public static MessageDigest getHashDigest() throws ContentHashAlgorithmException {
        try {
            return MessageDigest.getInstance(HASH_ALGO);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ContentHashAlgorithmException(e);
        }
    }

    public static ContentHash valueOf(InputStream in) throws IOException, ContentHashAlgorithmException {
        MessageDigest md = ContentHash.getHashDigest();
        byte[] buf = new byte[8192];
        int read = in.read(buf);
        while (read != -1) {
            md.update(buf, 0, read);
            read = in.read(buf);
        }
        return new ContentHash(StringCoder.encode((byte[])md.digest()));
    }

    public static ContentHash valueOf(byte[] digest) {
        if (digest == null) {
            throw new IllegalArgumentException();
        }
        if (digest.length != 32) {
            throw new IllegalArgumentException(Integer.toString(digest.length));
        }
        return new ContentHash(StringCoder.encode((byte[])digest));
    }

    public static ContentHash valueOf(String hash) {
        if (hash == null) {
            return null;
        }
        if (hash.length() != 43) {
            throw new IllegalArgumentException(hash);
        }
        if (!StringCoder.isValidCode((String)hash)) {
            throw new IllegalArgumentException(hash);
        }
        return new ContentHash(hash);
    }

    private ContentHash(String value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ContentHash)) {
            return false;
        }
        ContentHash other = (ContentHash)obj;
        return other.value.equals(this.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }

    public byte[] getBytes() {
        return StringCoder.decode((String)this.value);
    }
}

