/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.containers.common.IItemContainerService;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.ILink;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.repository.common.validation.IItemValidator;
import com.ibm.team.scm.client.ContextLock;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IItemCustomAttributes;
import com.ibm.team.scm.client.IVersionableManager;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.content.IVersionedContentManager;
import com.ibm.team.scm.client.internal.BaselineConnection;
import com.ibm.team.scm.client.internal.ChangeSetTracker;
import com.ibm.team.scm.client.internal.Connection;
import com.ibm.team.scm.client.internal.FlowNodeConnection;
import com.ibm.team.scm.client.internal.ItemPermissionChangeEvent;
import com.ibm.team.scm.client.internal.LockEvent;
import com.ibm.team.scm.client.internal.Messages;
import com.ibm.team.scm.client.internal.RemoteRepoDescriptorTask;
import com.ibm.team.scm.client.internal.RemoteRepoDescriptorUtils;
import com.ibm.team.scm.client.internal.SCMClientUtil;
import com.ibm.team.scm.client.internal.ScmClientLibraryContext;
import com.ibm.team.scm.client.internal.VersionableCustomAttributes;
import com.ibm.team.scm.client.internal.VersionableManager;
import com.ibm.team.scm.client.internal.WorkspaceConnection;
import com.ibm.team.scm.client.internal.content.SCMVersionedContentManager;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IBaselineSetHierarchyResult;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IGenericQueryNode;
import com.ibm.team.scm.common.IHistoryReference;
import com.ibm.team.scm.common.IQueryItem;
import com.ibm.team.scm.common.IQueryItemHandle;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import com.ibm.team.scm.common.IRepositoryProgressMonitorHandle;
import com.ibm.team.scm.common.IScmAuthService;
import com.ibm.team.scm.common.IScmItemQueryResult;
import com.ibm.team.scm.common.IScmQueryResult;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.InvalidAuthenticationTokenException;
import com.ibm.team.scm.common.VersionablePermissionDeniedException;
import com.ibm.team.scm.common.dto.IBaselineSearchCriteria;
import com.ibm.team.scm.common.dto.IBaselineSetSearchCriteria;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IChangeSetLinkSummary;
import com.ibm.team.scm.common.dto.IChangeSetSearchCriteria;
import com.ibm.team.scm.common.dto.IComponentSearchCriteria;
import com.ibm.team.scm.common.dto.IConsolidatedChangeSetsPathReport;
import com.ibm.team.scm.common.dto.IConsolidatedChangesReport;
import com.ibm.team.scm.common.dto.ICustomAttributeList;
import com.ibm.team.scm.common.dto.IFileSearchCriteria;
import com.ibm.team.scm.common.dto.IGenericAttributes;
import com.ibm.team.scm.common.dto.IHistoryReferenceDescription;
import com.ibm.team.scm.common.dto.IItemSearchCriteria;
import com.ibm.team.scm.common.dto.ILocateChangeSetsSearchCriteria;
import com.ibm.team.scm.common.dto.ILocateChangeSetsSearchResult;
import com.ibm.team.scm.common.dto.ILockPageFetchDescriptor;
import com.ibm.team.scm.common.dto.ILockSearchCriteria;
import com.ibm.team.scm.common.dto.ILockSearchResult;
import com.ibm.team.scm.common.dto.ILockSearchResult1;
import com.ibm.team.scm.common.dto.ILockSearchResult2;
import com.ibm.team.scm.common.dto.IPagedFetchDescriptor;
import com.ibm.team.scm.common.dto.IPermissionContextProvider;
import com.ibm.team.scm.common.dto.IQueryItemSearchCriteria;
import com.ibm.team.scm.common.dto.IQueryPageDescriptor;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.dto.ISiloedVersionablePath;
import com.ibm.team.scm.common.dto.ISiloedVersionablePathResult;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import com.ibm.team.scm.common.dto.ISynchronizationTimes;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.dto.IVersionableIdentifier;
import com.ibm.team.scm.common.dto.IVersionablePermissionsReport;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import com.ibm.team.scm.common.internal.ChangeHistoryHandle;
import com.ibm.team.scm.common.internal.ChangeSetHandle;
import com.ibm.team.scm.common.internal.Component;
import com.ibm.team.scm.common.internal.ComponentEntry;
import com.ibm.team.scm.common.internal.ComponentEntryHandle;
import com.ibm.team.scm.common.internal.ComponentHandle;
import com.ibm.team.scm.common.internal.ComponentOwnerHandle;
import com.ibm.team.scm.common.internal.ConfigUtil;
import com.ibm.team.scm.common.internal.ConfigurationHandle;
import com.ibm.team.scm.common.internal.IScmHistoryGraphNodeService;
import com.ibm.team.scm.common.internal.IScmImportService;
import com.ibm.team.scm.common.internal.IScmQueryService;
import com.ibm.team.scm.common.internal.QueryItem;
import com.ibm.team.scm.common.internal.dto.BaselineSearchCriteria;
import com.ibm.team.scm.common.internal.dto.BaselineSetSearchCriteria;
import com.ibm.team.scm.common.internal.dto.ClonedChangeSet;
import com.ibm.team.scm.common.internal.dto.ComponentLocks;
import com.ibm.team.scm.common.internal.dto.ContributorLocks;
import com.ibm.team.scm.common.internal.dto.ContributorRefreshParameter;
import com.ibm.team.scm.common.internal.dto.ContributorRefreshResult;
import com.ibm.team.scm.common.internal.dto.CreateLinksResult;
import com.ibm.team.scm.common.internal.dto.ExternalLinkEntries;
import com.ibm.team.scm.common.internal.dto.ExternalLinkEntry;
import com.ibm.team.scm.common.internal.dto.ItemQueryResult;
import com.ibm.team.scm.common.internal.dto.LockParameter;
import com.ibm.team.scm.common.internal.dto.LockReport;
import com.ibm.team.scm.common.internal.dto.LockSearchResult;
import com.ibm.team.scm.common.internal.dto.RemoteRepoDescriptor;
import com.ibm.team.scm.common.internal.dto.ScmAuthToken;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.dto.TransferChangeSetsResult;
import com.ibm.team.scm.common.internal.dto.WorkspaceEnum;
import com.ibm.team.scm.common.internal.dto.WorkspaceItemListResult;
import com.ibm.team.scm.common.internal.dto.WorkspaceLocks;
import com.ibm.team.scm.common.internal.dto.WorkspaceRefreshParameter;
import com.ibm.team.scm.common.internal.dto.WorkspaceRefreshResult;
import com.ibm.team.scm.common.internal.dto2.IncomingLinkDTO;
import com.ibm.team.scm.common.internal.dto2.WorkspaceComponentState;
import com.ibm.team.scm.common.internal.gc.ExternalLinkOptions;
import com.ibm.team.scm.common.internal.util.LockSearchUtil;
import com.ibm.team.scm.common.query.IQueryItemFactory;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class WorkspaceManager
extends EventSource
implements IWorkspaceManager {
    private static final Log log = LogFactory.getLog(WorkspaceManager.class);
    public static final String PLUGIN_ID = "com.ibm.team.scm.common";
    private final IClientLibraryContext context;
    protected final Object lock = new Object();
    protected final Object insertionLock = new Object();
    private final VersionableManager versionableManager;
    private final RemoteRepoDescriptorTask descriptorTask;
    protected final Map<UUID, WeakReference<WorkspaceConnection>> knownWorkspaceConnections = new WeakHashMap<UUID, WeakReference<WorkspaceConnection>>();
    protected final Map<UUID, WeakReference<BaselineConnection>> knownBaselineConnections = new WeakHashMap<UUID, WeakReference<BaselineConnection>>();
    protected final ChangeSetTracker suspendTracker = new ChangeSetTracker(new Comparator<IChangeSet>(){

        @Override
        public int compare(IChangeSet o1, IChangeSet o2) {
            if (o1.sameItemId((IItemHandle)o2)) {
                return 0;
            }
            int compareTo = o1.getLastChangeDate().compareTo(o2.getLastChangeDate());
            if (compareTo == 0) {
                compareTo = o1.getItemId().compareTo((Object)o2.getItemId());
            }
            return compareTo;
        }
    });
    protected final List<IStreamLockReport> heldLocks = new ArrayList<IStreamLockReport>();
    protected final ContributorRefreshParameter contributorTimes = ScmDtoFactory.eINSTANCE.createContributorRefreshParameter();
    protected final Map<UUID, WeakReference<IComponentHandle>> knownComponents = new WeakHashMap<UUID, WeakReference<IComponentHandle>>();
    private final IWorkspaceManager.IVersionableLockOperationFactory lockOpFactory = new LockOperationFactory();
    private volatile boolean initialized;
    private boolean initializing;
    private final IVersionedContentManager contentManager;
    private static ExternalLinkEntry[] NO_OUTGOING_LINKS = new ExternalLinkEntry[0];

    private static void log(String msg) {
        if (log.isTraceEnabled()) {
            log.trace((Object)msg);
        }
    }

    private static <T> int addToList(List<T> target, List<? extends T> source, int maxToAdd) {
        int size = source.size();
        if (maxToAdd < size) {
            target.addAll(source.subList(0, maxToAdd));
            return maxToAdd;
        }
        target.addAll(source);
        return size;
    }

    @Override
    public List<IWorkspaceHandle> findWorkspacesContainingChangeset(IChangeSetHandle changeSet, IWorkspaceSearchCriteria additionalCriteria, int expectedMaximumResultSize, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (changeSet == null) {
                throw new IllegalArgumentException();
            }
            if (expectedMaximumResultSize <= 0) {
                throw new IllegalArgumentException();
            }
            IScmQueryService query = this.getScmQueryService();
            ItemQueryResult r = query.findWorkspacesForChangeset(changeSet, additionalCriteria, expectedMaximumResultSize, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            ArrayList<IWorkspaceHandle> result = new ArrayList<IWorkspaceHandle>();
            expectedMaximumResultSize -= WorkspaceManager.addToList(result, r.getItemHandles(), expectedMaximumResultSize);
            while (expectedMaximumResultSize != 0 && r.getLastTimestamp() != null) {
                IWorkspaceSearchCriteria clone = (IWorkspaceSearchCriteria)EcoreUtil.copy((EObject)((EObject)additionalCriteria));
                clone.setModifiedBeforeOptional((Date)r.getLastTimestamp());
                r = query.findWorkspacesForChangeset(changeSet, clone, expectedMaximumResultSize, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
                expectedMaximumResultSize -= WorkspaceManager.addToList(result, r.getItemHandles(), expectedMaximumResultSize);
            }
            ArrayList<IWorkspaceHandle> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List<IWorkspaceHandle> findWorkspacesContainingComponent(IComponentHandle component, IWorkspaceSearchCriteria additionalCriteria, int expectedMaximumResultSize, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (component == null) {
                throw new IllegalArgumentException();
            }
            if (expectedMaximumResultSize <= 0) {
                throw new IllegalArgumentException();
            }
            IScmQueryService query = this.getScmQueryService();
            ItemQueryResult r = query.findWorkspacesForComponent(component, additionalCriteria, expectedMaximumResultSize, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            ArrayList<IWorkspaceHandle> result = new ArrayList<IWorkspaceHandle>();
            expectedMaximumResultSize -= WorkspaceManager.addToList(result, r.getItemHandles(), expectedMaximumResultSize);
            while (expectedMaximumResultSize != 0 && r.getLastTimestamp() != null) {
                IWorkspaceSearchCriteria clone = (IWorkspaceSearchCriteria)EcoreUtil.copy((EObject)((EObject)additionalCriteria));
                clone.setModifiedBeforeOptional((Date)r.getLastTimestamp());
                r = query.findWorkspacesForComponent(component, clone, expectedMaximumResultSize, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
                expectedMaximumResultSize -= WorkspaceManager.addToList(result, r.getItemHandles(), expectedMaximumResultSize);
            }
            ArrayList<IWorkspaceHandle> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List<ILocateChangeSetsSearchResult> locateChangeSets(ILocateChangeSetsSearchCriteria scope, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (scope == null) {
                throw new IllegalArgumentException("No search criteria scope provided");
            }
            if (scope.getChangeSets().isEmpty()) {
                throw new IllegalArgumentException("No change sets are included in the search criteria scope");
            }
            if (scope.getChangeSets().size() > 256) {
                throw new IllegalArgumentException("There are more than 256 change sets in the search criteria scope");
            }
            this.checkForNullArguments(scope.getChangeSets());
            if (scope.getWorkspaces().isEmpty() && scope.getSnapshots().isEmpty() && scope.getBaselines().isEmpty()) {
                throw new IllegalArgumentException("The search criteria scope must provide at least one workspace, snapshot or baseline");
            }
            if (scope.getWorkspaces().size() + scope.getSnapshots().size() + scope.getBaselines().size() > 512) {
                throw new IllegalArgumentException("The search criteria scope cannot contain more than 512 workspaces, snapshots and baselines");
            }
            this.checkForNullArguments(scope.getWorkspaces());
            this.checkForNullArguments(scope.getSnapshots());
            this.checkForNullArguments(scope.getBaselines());
            IScmQueryService query = this.getScmQueryService();
            ILocateChangeSetsSearchResult[] result = query.findLocateChangeSets(scope, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            List<ILocateChangeSetsSearchResult> list = Arrays.asList(result);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    private void checkForNullArguments(List<? extends IItemHandle> handles) {
        for (IItemHandle iItemHandle : handles) {
            if (iItemHandle != null) continue;
            throw new IllegalArgumentException();
        }
    }

    @Override
    public IUpdateReport compareBaselineSetConfigurations(IBaselineSetHandle local, IBaselineSetHandle remote, List<IComponentHandle> componentsToExclude, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (local == null) {
                throw new IllegalArgumentException();
            }
            if (remote == null) {
                throw new IllegalArgumentException();
            }
            IComponentHandle[] components = null;
            if (componentsToExclude != null) {
                for (IComponentHandle comp : componentsToExclude) {
                    if (comp != null) continue;
                    throw new IllegalArgumentException();
                }
                components = componentsToExclude.toArray(new IComponentHandle[componentsToExclude.size()]);
            }
            IScmService scm = this.getServerConfigurationService();
            IUpdateReport iUpdateReport = scm.compareBaselineSetConfigurations(local, remote, components, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            return iUpdateReport;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IChangeHistorySyncReport compareBaselineSets(IBaselineSetHandle local, IBaselineSetHandle remote, List<IComponentHandle> componentsToExclude, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (local == null) {
                throw new IllegalArgumentException();
            }
            if (remote == null) {
                throw new IllegalArgumentException();
            }
            IComponentHandle[] components = null;
            if (componentsToExclude != null) {
                for (IComponentHandle comp : componentsToExclude) {
                    if (comp != null) continue;
                    throw new IllegalArgumentException();
                }
                components = componentsToExclude.toArray(new IComponentHandle[componentsToExclude.size()]);
            }
            IScmService scm = this.getServerConfigurationService();
            IChangeHistorySyncReport iChangeHistorySyncReport = scm.compareBaselineSets(local, remote, components, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            return iChangeHistorySyncReport;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IChangeHistorySyncReport compareHistories(IHistoryReference localReference, IHistoryReference remoteReference, int flags, List<IComponentHandle> componentsToExclude, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (localReference == null) {
                throw new IllegalArgumentException();
            }
            IComponentHandle[] components = null;
            if (componentsToExclude != null) {
                for (IComponentHandle comp : componentsToExclude) {
                    if (comp != null) continue;
                    throw new IllegalArgumentException();
                }
                components = componentsToExclude.toArray(new IComponentHandle[componentsToExclude.size()]);
            } else {
                components = new IComponentHandle[]{};
            }
            IScmService scm = this.getServerConfigurationService();
            RemoteRepoDescriptor remoteDescriptor = this.extractRemoteDescriptor(remoteReference, (IProgressMonitor)sm.newChild(5));
            IChangeHistorySyncReport iChangeHistorySyncReport = scm.compareHistories(localReference, remoteReference, remoteDescriptor, flags, components, null, (IRepositoryProgressMonitorHandle)this.getRepoMonitor((IProgressMonitor)sm.newChild(95)));
            return iChangeHistorySyncReport;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IUpdateReport compareHistoryConfigurations(IHistoryReference initialReference, IHistoryReference finalReference, int flags, List<IComponentHandle> componentsToExclude, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IComponentHandle[] components = null;
            if (componentsToExclude != null) {
                for (IComponentHandle comp : componentsToExclude) {
                    if (comp != null) continue;
                    throw new IllegalArgumentException();
                }
                components = componentsToExclude.toArray(new IComponentHandle[componentsToExclude.size()]);
            } else {
                components = new IComponentHandle[]{};
            }
            IScmService scm = this.getServerConfigurationService();
            RemoteRepoDescriptor remoteDescriptor = this.extractRemoteDescriptor(finalReference, (IProgressMonitor)sm.newChild(5));
            IUpdateReport iUpdateReport = scm.compareHistoryConfigurations(initialReference, finalReference, remoteDescriptor, flags, components, null, (IRepositoryProgressMonitorHandle)this.getRepoMonitor((IProgressMonitor)sm.newChild(95)));
            return iUpdateReport;
        }
        finally {
            monitor.done();
        }
    }

    private RemoteRepoDescriptor extractRemoteDescriptor(IHistoryReference reference, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repository = null;
        if (reference instanceof IItemHandle) {
            repository = (ITeamRepository)((IItemHandle)reference).getOrigin();
        } else if (reference instanceof WorkspaceComponentState) {
            repository = (ITeamRepository)((WorkspaceComponentState)reference).getWorkspace().getOrigin();
        }
        if (repository != null && !repository.getId().equals((Object)this.teamRepository().getId())) {
            return RemoteRepoDescriptorUtils.getRemoteDescriptor(repository, monitor);
        }
        return null;
    }

    @Override
    public List<IChangeSetHandle> transferChangeSetsFromRemoteRepository(List<IChangeSetHandle> remoteChangesToTransfer, ITeamRepository remoteRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            TransferChangeSetsResult transfered;
            if (remoteChangesToTransfer == null) {
                throw new IllegalArgumentException();
            }
            for (IChangeSetHandle cs : remoteChangesToTransfer) {
                if (cs != null) continue;
                throw new IllegalArgumentException();
            }
            if (remoteRepository == null) {
                throw new IllegalArgumentException();
            }
            if (this.teamRepository().getId().equals((Object)remoteRepository.getId())) {
                throw new IllegalArgumentException();
            }
            IScmService scm = this.getServerConfigurationService();
            ContributorRefreshParameter refreshParameter = this.getRefreshParameter();
            IChangeSetHandle[] sourceChangeSets = remoteChangesToTransfer.toArray(new IChangeSetHandle[remoteChangesToTransfer.size()]);
            RemoteRepoDescriptor remoteDescriptor = null;
            InvalidAuthenticationTokenException authEx = null;
            while (true) {
                RemoteRepoDescriptor newDescriptor = RemoteRepoDescriptorUtils.getRemoteDescriptor(remoteRepository, (IProgressMonitor)sm.newChild(5));
                if (remoteDescriptor != null && newDescriptor.getAuthToken().getTruth().equals(remoteDescriptor.getAuthToken().getTruth())) {
                    throw authEx;
                }
                remoteDescriptor = newDescriptor;
                try {
                    transfered = scm.transferChangesFromRemoteRepository(sourceChangeSets, remoteDescriptor, refreshParameter, (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor((IProgressMonitor)sm.newChild(90)));
                }
                catch (InvalidAuthenticationTokenException e) {
                    if (remoteDescriptor == null) {
                        throw e;
                    }
                    RemoteRepoDescriptorUtils.resetRemoteDescriptor(remoteRepository);
                    authEx = e;
                    sm.setWorkRemaining(100);
                    continue;
                }
                break;
            }
            HashMap<UUID, IChangeSet> changeSets = new HashMap<UUID, IChangeSet>();
            HashMap<UUID, UUID> cloned = new HashMap<UUID, UUID>();
            for (IChangeSet cs : transfered.getReplicatedChangeSets()) {
                changeSets.put(cs.getItemId(), cs);
            }
            for (ClonedChangeSet clone : transfered.getClonedChangeSets()) {
                IChangeSet cs = clone.getTargetChangeSet();
                cloned.put(clone.getSourceChangeSetHandle().getItemId(), cs.getItemId());
                changeSets.put(cs.getItemId(), cs);
            }
            ArrayList<IChangeSet> result = new ArrayList<IChangeSet>(remoteChangesToTransfer.size());
            for (IChangeSetHandle cs : remoteChangesToTransfer) {
                IChangeSet fullCS = (IChangeSet)changeSets.get(cs.getItemId());
                if (fullCS == null) {
                    UUID clone = (UUID)cloned.get(cs.getItemId());
                    fullCS = (IChangeSet)changeSets.get(clone);
                }
                result.add(fullCS);
            }
            List toReturn = this.teamRepository().itemManager().applyItemUpdates(result);
            this.refresh(transfered.getContributorInfo(), (IProgressMonitor)sm);
            List list = toReturn;
            return list;
        }
        finally {
            monitor.done();
        }
    }

    public WorkspaceManager(IClientLibraryContext context) {
        this.context = context = new ScmClientLibraryContext(context);
        this.versionableManager = new VersionableManager(this);
        this.contributorTimes.setContributor((IContributorHandle)context.teamRepository().loggedInContributor());
        this.contributorTimes.setLockTime(0L);
        this.contributorTimes.setSuspendTime(0L);
        this.contributorTimes.setPendingTime(0L);
        this.descriptorTask = new RemoteRepoDescriptorTask(this);
        this.initialized = false;
        this.contentManager = new SCMVersionedContentManager(context);
    }

    @Override
    public ITeamRepository teamRepository() {
        return this.context.teamRepository();
    }

    public IClientLibraryContext getContext() {
        return this.context;
    }

    @Override
    public IVersionableManager versionableManager() {
        return this.versionableManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List knownWorkspaceConnections() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<WorkspaceConnection> connections = new ArrayList<WorkspaceConnection>(this.knownWorkspaceConnections.keySet().size());
            for (WeakReference<WorkspaceConnection> ref : this.knownWorkspaceConnections.values()) {
                WorkspaceConnection connection = null;
                if (ref != null) {
                    connection = (WorkspaceConnection)ref.get();
                }
                if (connection == null) continue;
                connections.add(connection);
            }
            return Collections.unmodifiableList(connections);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkspaceConnection getConnectionIfKnown(IWorkspaceHandle ws) {
        WeakReference<WorkspaceConnection> ref;
        Object object = this.lock;
        synchronized (object) {
            ref = this.knownWorkspaceConnections.get(ws.getItemId());
        }
        if (ref != null) {
            return (WorkspaceConnection)ref.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List knownComponents() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<IComponentHandle> components = new ArrayList<IComponentHandle>(this.knownComponents.keySet().size());
            ArrayList<UUID> staleKeysToBeRemoved = new ArrayList<UUID>();
            for (UUID key : this.knownComponents.keySet()) {
                WeakReference<IComponentHandle> ref = this.knownComponents.get(key);
                if (ref == null) continue;
                IComponentHandle component = (IComponentHandle)ref.get();
                if (component != null) {
                    components.add(component);
                    continue;
                }
                staleKeysToBeRemoved.add(key);
            }
            for (UUID key : staleKeysToBeRemoved) {
                this.knownComponents.remove(key);
            }
            return Collections.unmodifiableList(components);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List knownBaselineConnections() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<BaselineConnection> connections = new ArrayList<BaselineConnection>(this.knownBaselineConnections.values().size());
            for (WeakReference<BaselineConnection> ref : this.knownBaselineConnections.values()) {
                BaselineConnection connection = null;
                if (ref != null) {
                    connection = (BaselineConnection)ref.get();
                }
                if (connection == null) continue;
                connections.add(connection);
            }
            return Collections.unmodifiableList(connections);
        }
    }

    public IFolder createFolder() {
        IFolder f = (IFolder)IFolder.ITEM_TYPE.createItem();
        return f;
    }

    public IScmService getServerConfigurationService() throws TeamRepositoryException {
        IScmService service = (IScmService)this.context.getServiceInterface(IScmService.class);
        if (service == null) {
            throw new NotLoggedInException();
        }
        return service;
    }

    @Override
    public IItemContainerService getItemContainerService() throws TeamRepositoryException {
        IItemContainerService service = (IItemContainerService)this.context.getServiceInterface(IItemContainerService.class);
        if (service == null) {
            throw new NotLoggedInException();
        }
        return service;
    }

    public IScmHistoryGraphNodeService getScmHistoryGraphNodeService() throws TeamRepositoryException {
        IScmHistoryGraphNodeService service = (IScmHistoryGraphNodeService)this.context.getServiceInterface(IScmHistoryGraphNodeService.class);
        if (service == null) {
            throw new NotLoggedInException();
        }
        return service;
    }

    IScmImportService getScmImportService() throws TeamRepositoryException {
        IScmImportService service = (IScmImportService)this.context.getServiceInterface(IScmImportService.class);
        if (service == null) {
            throw new NotLoggedInException();
        }
        return service;
    }

    IScmAuthService getScmAuthService() throws TeamRepositoryException {
        IScmAuthService service = (IScmAuthService)this.context.getServiceInterface(IScmAuthService.class);
        if (service == null) {
            throw new NotLoggedInException();
        }
        return service;
    }

    IScmQueryService getScmQueryService() throws TeamRepositoryException {
        IScmQueryService service = (IScmQueryService)this.context.getServiceInterface(IScmQueryService.class);
        if (service == null) {
            throw new NotLoggedInException();
        }
        return service;
    }

    IQueryService getQueryService() throws TeamRepositoryException {
        IQueryService service = (IQueryService)this.context.getServiceInterface(IQueryService.class);
        if (service == null) {
            throw new NotLoggedInException();
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<? extends IWorkspaceConnection> getWorkspaceConnections(List<? extends IWorkspaceHandle> workspaces, IProgressMonitor monitor) throws TeamRepositoryException {
        this.ensureInitialized(monitor);
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (workspaces == null) {
                throw new IllegalArgumentException();
            }
            WorkspaceManager.log("WorkspaceManager.getWorkspaceConnections() -- " + workspaces.size() + " workspaces");
            ArrayList<IWorkspaceHandle> toFetch = new ArrayList<IWorkspaceHandle>(workspaces.size());
            HashMap<UUID, Object> connections = new HashMap<UUID, Object>((int)((double)workspaces.size() / 0.75));
            Object object = this.lock;
            synchronized (object) {
                for (IWorkspaceHandle iWorkspaceHandle : workspaces) {
                    if (iWorkspaceHandle == null) {
                        throw new IllegalArgumentException();
                    }
                    if (connections.containsKey(iWorkspaceHandle.getItemId())) continue;
                    WeakReference<WorkspaceConnection> cr = this.knownWorkspaceConnections.get(iWorkspaceHandle.getItemId());
                    if (cr != null) {
                        WorkspaceConnection conn = (WorkspaceConnection)cr.get();
                        connections.put(iWorkspaceHandle.getItemId(), conn);
                        if (conn == null) {
                            toFetch.add(iWorkspaceHandle);
                            continue;
                        }
                        if (!conn.isLightweight()) continue;
                        WorkspaceManager.log("WorkspaceManager.getWorkspaceConnections - Refetching data for a lightweight workspace connection - " + conn.getName());
                        toFetch.add(iWorkspaceHandle);
                        continue;
                    }
                    connections.put(iWorkspaceHandle.getItemId(), null);
                    toFetch.add(iWorkspaceHandle);
                }
            }
            if (!toFetch.isEmpty()) {
                int totalSize = toFetch.size();
                WorkspaceRefreshParameter[] workspaceRefreshParameterArray = new WorkspaceRefreshParameter[totalSize];
                int i = 0;
                for (IWorkspaceHandle w : toFetch) {
                    WorkspaceRefreshParameter parm = ScmDtoFactory.eINSTANCE.createWorkspaceRefreshParameter();
                    parm.setWorkspace((IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(w.getItemId(), null));
                    workspaceRefreshParameterArray[i++] = parm;
                }
                int left = totalSize;
                ArrayList<WorkspaceRefreshResult> existing = new ArrayList<WorkspaceRefreshResult>(totalSize);
                int j = 0;
                while (left > 0) {
                    WorkspaceRefreshResult[] result;
                    int from = j * 1024;
                    int size = Math.min(1024, left);
                    WorkspaceRefreshParameter[] subArray = new WorkspaceRefreshParameter[size];
                    System.arraycopy(workspaceRefreshParameterArray, from, subArray, 0, size);
                    WorkspaceManager.log("WorkspaceManager.getWorkspaceConnections(): SERVER CALL:refreshWorkspaces() - (" + subArray.length + " workspaces)");
                    WorkspaceRefreshResult[] workspaceRefreshResultArray = result = this.getServerConfigurationService().refreshWorkspaces(subArray, (IRepositoryProgressMonitorHandle)IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor));
                    int n = result.length;
                    int n2 = 0;
                    while (n2 < n) {
                        WorkspaceRefreshResult w = workspaceRefreshResultArray[n2];
                        if (w != null) {
                            WorkspaceManager.log("SERVER:refreshWorkspaces() returns: " + w.getWorkspace().getName());
                            existing.add(w);
                        }
                        ++n2;
                    }
                    left -= size;
                    ++j;
                }
                List<IWorkspaceConnection> connectionList = this.getWorkspaceConnections(existing.toArray(new WorkspaceRefreshResult[existing.size()]), monitor);
                for (IWorkspaceConnection w : connectionList) {
                    connections.put(w.getResolvedWorkspace().getItemId(), w);
                }
            }
            ArrayList<IWorkspaceConnection> result = new ArrayList<IWorkspaceConnection>(workspaces.size());
            for (IWorkspaceHandle iWorkspaceHandle : workspaces) {
                result.add((IWorkspaceConnection)connections.get(iWorkspaceHandle.getItemId()));
            }
            ArrayList<IWorkspaceConnection> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialized(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.initialized) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                if (this.initialized) {
                    return;
                }
                if (!this.initializing) break;
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    this.lock.wait(500L);
                }
                catch (InterruptedException e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
            }
            this.initializing = true;
        }
        try {
            this.refresh(monitor);
            this.initialized = true;
        }
        catch (Throwable throwable) {
            Object object2 = this.lock;
            synchronized (object2) {
                this.initializing = false;
                this.lock.notify();
            }
            throw throwable;
        }
        Object object3 = this.lock;
        synchronized (object3) {
            this.initializing = false;
            this.lock.notify();
        }
    }

    @Override
    public IWorkspaceConnection getWorkspaceConnectionUntracked(IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        WorkspaceManager.log("WorkspaceManager.getWorkspaceConnectionUntracked() - " + workspaceHandle.getItemId().getUuidValue());
        WorkspaceConnection wsConn = this.getWorkspaceConnectionPrivate(workspaceHandle, false, false, monitor);
        return wsConn;
    }

    @Override
    public IWorkspaceConnection getWorkspaceConnectionTracked(IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        WorkspaceManager.log("WorkspaceManager.getWorkspaceConnectionTracked() - " + workspaceHandle.getItemId().getUuidValue());
        WorkspaceConnection wsConn = this.getWorkspaceConnectionPrivate(workspaceHandle, true, true, monitor);
        return wsConn;
    }

    @Override
    public IWorkspaceConnection getWorkspaceConnection(IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getWorkspaceConnectionPrivate(workspaceHandle, true, false, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WorkspaceConnection getWorkspaceConnectionPrivate(IWorkspaceHandle workspace, boolean fullInfoNeeded, boolean refreshNeeded, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        this.ensureInitialized(monitor);
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        WorkspaceManager.log(String.format("WorkspaceManager.getWorkspaceConnectionPrivate(%s): fullInfoNeeded=%b, refreshNeeded=%b", workspace.getItemId().getUuidValue(), fullInfoNeeded, refreshNeeded));
        try {
            WorkspaceConnection conn = null;
            Object object = this.lock;
            synchronized (object) {
                WeakReference<WorkspaceConnection> ref = this.knownWorkspaceConnections.get(workspace.getItemId());
                if (ref != null) {
                    conn = (WorkspaceConnection)ref.get();
                    if (conn == null) {
                        WorkspaceManager.log("WorkspaceManager.getWorkspaceConnectionPrivate() -- Removing workspace from knownWorkspaceConnections (conn is null) - " + workspace.getItemId());
                        this.knownWorkspaceConnections.remove(workspace.getItemId());
                    } else {
                        WorkspaceManager.log("WorkspaceManager.getWorkspaceConnectionPrivate() -- Found known workspace connection -- " + conn.getNameDebug());
                        if (fullInfoNeeded && (conn.isLightweight() || refreshNeeded)) {
                            WorkspaceManager.log("WorkspaceManager.getWorkspaceConnectionPrivate - SERVER CALL:refreshWorkspaces() - " + workspace.getItemId().getUuidValue());
                            WorkspaceRefreshResult refreshed = this.getServerConfigurationService().refreshWorkspaces(new WorkspaceRefreshParameter[]{this.createEmptyWorkspaceRefreshParameter(workspace)}, (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor))[0];
                            monitor.worked(90);
                            if (refreshed == null) {
                                throw new ItemNotFoundException((IItemHandle)workspace);
                            }
                            WorkspaceManager.log("SERVER:refreshWorkspaces() returns for workspace " + refreshed.getWorkspace().getName());
                            conn.fetchInfoForLightweightConnection(refreshed, monitor);
                        }
                    }
                }
            }
            if (conn == null) {
                WorkspaceRefreshResult result;
                if (!fullInfoNeeded && !refreshNeeded) {
                    WorkspaceManager.log("WorkspaceManager.getWorkspaceConnectionPrivate(conn=null): Constructing lightweight WorkspaceRefreshResult for untracked workspace - " + workspace.getItemId().getUuidValue());
                    result = ScmDtoFactory.eINSTANCE.createWorkspaceRefreshResult();
                    result.setWorkspaceItemId(workspace.getItemId());
                    IWorkspace workspaceComplete = (IWorkspace)this.teamRepository().itemManager().fetchCompleteItem((IItemHandle)workspace, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    result.setWorkspace(workspaceComplete);
                } else {
                    WorkspaceManager.log("WorkspaceManager.getWorkspaceConnectionPrivate(conn=null): SERVER CALL:refreshWorkspaces() - " + workspace.getItemId().getUuidValue());
                    result = this.getServerConfigurationService().refreshWorkspaces(new WorkspaceRefreshParameter[]{this.createEmptyWorkspaceRefreshParameter(workspace)}, (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor))[0];
                    monitor.worked(90);
                    if (result == null) {
                        throw new ItemNotFoundException((IItemHandle)workspace);
                    }
                    WorkspaceManager.log("SERVER:refreshWorkspaces(conn==null) returns " + result.getWorkspace().getName());
                }
                Object object2 = this.insertionLock;
                synchronized (object2) {
                    WeakReference<WorkspaceConnection> ref;
                    Object object3 = this.lock;
                    synchronized (object3) {
                        ref = this.knownWorkspaceConnections.get(workspace.getItemId());
                        if (ref != null) {
                            conn = (WorkspaceConnection)ref.get();
                            if (conn != null) {
                                WorkspaceConnection workspaceConnection = conn;
                                return workspaceConnection;
                            }
                            WorkspaceManager.log("WorkspaceManager.getWorkspaceConnectionPrivate() - Removing workspace from knownWorkspaceConnections (conn is null) - " + workspace.getItemId());
                            this.knownWorkspaceConnections.remove(workspace.getItemId());
                        }
                    }
                    conn = new WorkspaceConnection(this, result, !fullInfoNeeded, monitor);
                    object3 = this.lock;
                    synchronized (object3) {
                        ref = this.knownWorkspaceConnections.get(workspace.getItemId());
                        if (ref != null) {
                            Assert.isTrue((boolean)false, (String)"WorkspaceConnection obtained concurrently.  This should not happen.");
                        }
                        WorkspaceManager.log("WorkspaceManager.getWorkspaceConnectionPrivate() - Adding to knownWorkspaceConnections  - " + conn.getNameDebug());
                        this.knownWorkspaceConnections.put(this.getWorkspaceId(conn), new WeakReference<WorkspaceConnection>(conn));
                    }
                }
                this.sendPropertyChangeEvent("com.ibm.team.repository.PropertyAdd", "workspaces", null, workspace);
            }
            WorkspaceManager.log("WorkspaceManager.getWorkspaceConnectionPrivate() -- Returns " + conn.getNameDebug());
            WorkspaceConnection workspaceConnection = conn;
            return workspaceConnection;
        }
        finally {
            monitor.done();
        }
    }

    private WorkspaceRefreshParameter createEmptyWorkspaceRefreshParameter(IWorkspaceHandle workspace) {
        WorkspaceRefreshParameter parm = ScmDtoFactory.eINSTANCE.createWorkspaceRefreshParameter();
        parm.setWorkspace((IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(workspace.getItemId(), workspace.getStateId()));
        return parm;
    }

    @Override
    public IBaselineConnection getBaselineConnection(IBaselineHandle baselineHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (baselineHandle == null) {
                throw new IllegalArgumentException();
            }
            IBaseline baseline = (IBaseline)this.context.teamRepository().itemManager().fetchCompleteItem((IItemHandle)baselineHandle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            SCMClientUtil.checkMonitor(monitor);
            IBaselineConnection iBaselineConnection = this.getBaselineConnection(baseline, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            return iBaselineConnection;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List<IBaselineConnection> getBaselineConnections(List<IBaselineHandle> baselineHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        if (baselineHandles == null) {
            throw new IllegalArgumentException();
        }
        IItemManager itemManager = this.context.teamRepository().itemManager();
        IFetchResult fetchResult = itemManager.fetchCompleteItemsPermissionAware(baselineHandles, 0, monitor);
        ArrayList<IBaselineConnection> result = new ArrayList<IBaselineConnection>(fetchResult.getRetrievedItems().size());
        for (Object obj : fetchResult.getRetrievedItems()) {
            IBaseline baseline = (IBaseline)obj;
            result.add(this.getBaselineConnection(baseline, null));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBaselineConnection getBaselineConnection(IBaseline baseline, IProgressMonitor unused) throws TeamRepositoryException {
        if (baseline == null) {
            throw new IllegalArgumentException();
        }
        if (!baseline.isComplete()) {
            throw new IllegalArgumentException();
        }
        IBaseline b = (IBaseline)this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(baseline)).get(0);
        boolean added = false;
        BaselineConnection conn = null;
        Object object = this.lock;
        synchronized (object) {
            WeakReference<BaselineConnection> ref = this.knownBaselineConnections.get(b.getItemId());
            if (ref != null && (conn = (BaselineConnection)ref.get()) == null) {
                this.knownBaselineConnections.remove(b.getItemId());
            }
            if (conn == null) {
                conn = new BaselineConnection(this, b);
                this.knownBaselineConnections.put(this.getBaselineId(conn), new WeakReference<BaselineConnection>(conn));
                added = true;
            }
        }
        if (added) {
            this.sendPropertyChangeEvent("com.ibm.team.repository.PropertyAdd", "baselines", null, b);
        }
        return conn;
    }

    @Override
    public IWorkspaceConnection copyWorkspace(IAuditableHandle scopeHandle, IWorkspaceConnection peerWorkspaceConnection, String workspaceName, String description, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.copyWorkspace(scopeHandle, peerWorkspaceConnection, workspaceName, description, null, monitor);
    }

    public IWorkspaceConnection copyWorkspace(IAuditableHandle scopeHandle, IWorkspaceConnection peerWorkspaceConnection, String workspaceName, String description, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IWorkspaceConnection conn;
            WorkspaceRefreshResult refreshResult;
            if (scopeHandle == null) {
                throw new IllegalArgumentException();
            }
            if (peerWorkspaceConnection == null) {
                throw new IllegalArgumentException();
            }
            if (workspaceName == null || workspaceName.equals("")) {
                throw new IllegalArgumentException();
            }
            if (peerWorkspaceConnection.isStream() && !(scopeHandle instanceof IProcessAreaHandle)) {
                throw new IllegalArgumentException();
            }
            if (!peerWorkspaceConnection.isStream() && !(scopeHandle instanceof IContributorHandle)) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.getServerConfigurationService();
            RemoteRepoDescriptor remoteDescriptor = null;
            InvalidAuthenticationTokenException authEx = null;
            while (true) {
                if (!this.sameRepository(peerWorkspaceConnection)) {
                    RemoteRepoDescriptor newDescriptor = RemoteRepoDescriptorUtils.getRemoteDescriptor(peerWorkspaceConnection.teamRepository(), (IProgressMonitor)sm.newChild(5));
                    if (remoteDescriptor != null && newDescriptor.getAuthToken().getTruth().equals(remoteDescriptor.getAuthToken().getTruth())) {
                        throw authEx;
                    }
                    remoteDescriptor = newDescriptor;
                }
                try {
                    refreshResult = service.copyWorkspace(scopeHandle, (IWorkspaceHandle)peerWorkspaceConnection.getResolvedWorkspace(), remoteDescriptor, workspaceName, description, Connection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor((IProgressMonitor)sm));
                }
                catch (InvalidAuthenticationTokenException e) {
                    if (remoteDescriptor == null) {
                        throw e;
                    }
                    RemoteRepoDescriptorUtils.resetRemoteDescriptor(peerWorkspaceConnection.teamRepository());
                    authEx = e;
                    sm.setWorkRemaining(100);
                    continue;
                }
                break;
            }
            sm.worked(90);
            IWorkspaceConnection iWorkspaceConnection = conn = this.getWorkspaceConnections(new WorkspaceRefreshResult[]{refreshResult}, (IProgressMonitor)sm).get(0);
            return iWorkspaceConnection;
        }
        finally {
            sm.done();
        }
    }

    @Override
    public void setComment(IChangeSetHandle changeSet, String comment, IProgressMonitor monitor) throws TeamRepositoryException {
        this.setComment(changeSet, comment, null, monitor);
    }

    public void setComment(IChangeSetHandle changeSet, String comment, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        this.ensureInitialized(monitor);
        try {
            if (changeSet == null) {
                throw new IllegalArgumentException();
            }
            if (comment == null) {
                throw new IllegalArgumentException();
            }
            IStatus check = IItemValidator.INSTANCE.validateAttribute((IType)IChangeSet.ITEM_TYPE, IChangeSet.COMMENT_PROPERTY, (Object)comment);
            if (!check.isOK()) {
                throw new IllegalArgumentException("Comment is not appropriate");
            }
            IScmService service = this.getServerConfigurationService();
            monitor.worked(5);
            IChangeSet newChangeSet = service.setComment(changeSet, comment, Connection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor));
            monitor.worked(75);
            WorkspaceManager.log("Workspace Manager setComment about to applyItemUpdates - refreshing change set " + newChangeSet.getItemId().getUuidValue() + " to stateId " + newChangeSet.getStateId().getUuidValue());
            this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(newChangeSet));
            WorkspaceManager.log("Workspace Manager setComment finished applyItemUpdates");
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void setName(IBaselineSetHandle baselineSet, String name, IProgressMonitor monitor) throws TeamRepositoryException {
        this.setName(baselineSet, name, null, monitor);
    }

    public void setName(IBaselineSetHandle baselineSet, String name, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        this.ensureInitialized(monitor);
        try {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.getServerConfigurationService();
            monitor.worked(5);
            IBaselineSet newBaselineSet = service.setBaselineSetName(baselineSet, name, Connection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor));
            monitor.worked(75);
            this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(newBaselineSet));
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void setComment(IBaselineSetHandle baselineSet, String comment, IProgressMonitor monitor) throws TeamRepositoryException {
        this.setComment(baselineSet, comment, null, monitor);
    }

    public void setComment(IBaselineSetHandle baselineSet, String comment, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        this.ensureInitialized(monitor);
        try {
            if (comment == null) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.getServerConfigurationService();
            monitor.worked(5);
            IBaselineSet newBaselineSet = service.setBaselineSetComment(baselineSet, comment, Connection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor));
            monitor.worked(75);
            this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(newBaselineSet));
        }
        finally {
            monitor.done();
        }
    }

    @Override
    @Deprecated
    public List findWorkspaceAcceptRelationships(IWorkspaceHandle workspaceHandle, IAuditableHandle ownerFilter, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        this.ensureInitialized(monitor);
        try {
            if (workspaceHandle == null) {
                throw new IllegalArgumentException();
            }
            IScmQueryService service = this.getScmQueryService();
            IWorkspaceHandle[] wsHandles = service.findWorkspaceAcceptFlows(workspaceHandle, (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor));
            SCMClientUtil.checkMonitor(monitor);
            monitor.worked(50);
            List workspaces = this.teamRepository().itemManager().fetchCompleteItems(Arrays.asList(wsHandles), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            ArrayList<IWorkspace> matching = new ArrayList<IWorkspace>();
            for (IWorkspace workspace : workspaces) {
                if (workspace == null || ownerFilter != null && !ownerFilter.sameItemId((IItemHandle)workspace.getOwner())) continue;
                matching.add(workspace);
            }
            List list = Collections.unmodifiableList(matching);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void deleteWorkspace(IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        this.deleteWorkspace(workspaceHandle, null, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBaselineSetHandle safelyDeleteStream(IWorkspaceHandle streamHandle, IWorkspaceConnection peerWorkspaceConnection, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        this.ensureInitialized(monitor);
        try {
            if (streamHandle == null) {
                throw new IllegalArgumentException();
            }
            if (peerWorkspaceConnection == null) {
                throw new IllegalArgumentException();
            }
            if (!peerWorkspaceConnection.teamRepository().getId().equals((Object)this.teamRepository().getId())) {
                throw new IllegalArgumentException();
            }
            if (peerWorkspaceConnection.getResolvedWorkspace().sameItemId((IItemHandle)streamHandle)) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.getServerConfigurationService();
            IBaselineSet bs = service.backupAndDeleteStream(streamHandle, (IWorkspaceHandle)peerWorkspaceConnection.getResolvedWorkspace().getItemHandle(), Connection.getSyncTimes(null), (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor));
            monitor.worked(25);
            Object object = this.lock;
            synchronized (object) {
                this.knownWorkspaceConnections.remove(streamHandle.getItemId());
            }
            IItemManager itemManager = this.teamRepository().itemManager();
            itemManager.applyItemDeletes(Collections.singletonList(streamHandle));
            List updates = itemManager.applyItemUpdates(Collections.singletonList(bs));
            IBaselineSet shared = (IBaselineSet)updates.iterator().next();
            this.sendPropertyChangeEvent("com.ibm.team.repository.PropertyRemove", "workspaces", streamHandle, null);
            IBaselineSet iBaselineSet = shared;
            return iBaselineSet;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWorkspace(IWorkspaceHandle workspaceHandle, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        this.ensureInitialized(monitor);
        try {
            if (workspaceHandle == null) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.getServerConfigurationService();
            service.deleteWorkspace(workspaceHandle, Connection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor));
            monitor.worked(25);
            Object object = this.lock;
            synchronized (object) {
                this.knownWorkspaceConnections.remove(workspaceHandle.getItemId());
            }
            this.teamRepository().itemManager().applyItemDeletes(Collections.singletonList(workspaceHandle));
            this.sendPropertyChangeEvent("com.ibm.team.repository.PropertyRemove", "workspaces", workspaceHandle, null);
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List findComponents(String namePattern, IAuditableHandle owner, boolean exact, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            List previouslyExistingComponents;
            if (namePattern == null) {
                throw new IllegalArgumentException();
            }
            monitor = SCMClientUtil.getMonitor(monitor, 100);
            this.ensureInitialized(monitor);
            SCMClientUtil.checkMonitor(monitor);
            IComponentSearchCriteria criteria = IComponentSearchCriteria.FACTORY.newInstance();
            if (owner != null) {
                criteria.getFilterByOwnerOptional().add(owner);
            }
            if (!namePattern.equals("")) {
                if (exact) {
                    criteria.setExactName(namePattern);
                } else {
                    criteria.setPartialName(namePattern);
                }
            }
            List<IComponentHandle> result = this.findComponents(criteria, Integer.MAX_VALUE, monitor);
            ArrayList<IComponentHandle> newComponents = new ArrayList<IComponentHandle>(result.size());
            Object object = this.lock;
            synchronized (object) {
                previouslyExistingComponents = this.knownComponents();
                Set knownComponentIds = ConfigUtil.getItemIds((Collection)previouslyExistingComponents);
                for (IComponentHandle component : result) {
                    if (knownComponentIds.contains(component.getItemId())) continue;
                    newComponents.add(component);
                }
                for (IComponentHandle c : newComponents) {
                    this.knownComponents.put(c.getItemId(), new WeakReference<IComponentHandle>(c));
                }
            }
            this.sendPropertyChangeEvent("com.ibm.team.repository.PropertyAddMany", "components", previouslyExistingComponents, this.knownComponents());
            List<IComponentHandle> list = result;
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List findBaselineSets(String namePattern, IProcessAreaHandle teamScope, boolean exact, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor);
        try {
            if (namePattern == null) {
                throw new IllegalArgumentException();
            }
            IBaselineSetSearchCriteria criteria = IBaselineSetSearchCriteria.FACTORY.newInstance();
            if (!namePattern.equals("")) {
                if (exact) {
                    criteria.setExactName(namePattern);
                } else {
                    criteria.setPartialName(namePattern);
                }
            }
            if (teamScope != null) {
                criteria.setProcessArea(teamScope);
            }
            List handles = this.findBaselineSets(criteria, Integer.MAX_VALUE, monitor);
            List list = this.teamRepository().itemManager().fetchCompleteItems(handles, 0, monitor);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List findBaselineSets(IBaselineSetSearchCriteria criteria, int expectedMaxResults, IProgressMonitor monitor) throws TeamRepositoryException {
        if (criteria == null) {
            throw new IllegalArgumentException();
        }
        if (expectedMaxResults <= 0) {
            throw new IllegalArgumentException();
        }
        if (criteria.isOldestFirst()) {
            throw new IllegalArgumentException();
        }
        monitor = SCMClientUtil.getMonitor(monitor);
        try {
            ItemQueryResult result = this.getScmQueryService().findBaselineSets(criteria, expectedMaxResults, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            ArrayList baselineSets = new ArrayList();
            expectedMaxResults -= WorkspaceManager.addToList(baselineSets, result.getItemHandles(), expectedMaxResults);
            Timestamp prevLastTimestamp = result.getLastTimestamp();
            while (expectedMaxResults != 0 && result.getLastTimestamp() != null) {
                BaselineSetSearchCriteria crit = (BaselineSetSearchCriteria)EcoreUtil.copy((EObject)((EObject)criteria));
                crit.setModifiedBeforeOptional((Date)result.getLastTimestamp());
                result = this.getScmQueryService().findBaselineSets((IBaselineSetSearchCriteria)crit, expectedMaxResults, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
                expectedMaxResults -= WorkspaceManager.addToList(baselineSets, result.getItemHandles(), expectedMaxResults);
                if (result.getLastTimestamp() == null || !prevLastTimestamp.equals(result.getLastTimestamp()) && !prevLastTimestamp.before(result.getLastTimestamp())) continue;
                throw new IllegalArgumentException();
            }
            List list = Collections.unmodifiableList(baselineSets);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IComponent createComponent(String componentName, IAuditableHandle ownerHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.createComponent(componentName, ownerHandle, null, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IComponent createComponent(String componentName, IAuditableHandle ownerHandle, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            this.ensureInitialized(monitor);
            if (componentName == null || componentName.equals("")) {
                throw new IllegalArgumentException();
            }
            if (ownerHandle == null) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.getServerConfigurationService();
            IComponent component = service.createComponent(componentName, ownerHandle, Connection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            IComponent result = (IComponent)this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(component)).iterator().next();
            Object object = this.lock;
            synchronized (object) {
                this.knownComponents.put(result.getItemId(), new WeakReference<IItemHandle>(result.getItemType().createItemHandle(result.getItemId(), result.getStateId())));
            }
            this.sendPropertyChangeEvent("com.ibm.team.repository.PropertyAdd", "components", null, result);
            IComponent iComponent = result;
            return iComponent;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List<IAuditableHandle> findOwnersForComponents(List<? extends IComponentHandle> components, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (components == null || components.isEmpty()) {
                throw new IllegalArgumentException();
            }
            HashSet<UUID> componentIds = new HashSet<UUID>(components.size());
            for (IComponentHandle iComponentHandle : components) {
                if (iComponentHandle == null) {
                    throw new IllegalArgumentException();
                }
                if (componentIds.add(iComponentHandle.getItemId())) continue;
                throw new IllegalArgumentException();
            }
            IComponentHandle[] iComponentHandleArray = components.toArray(new IComponentHandle[components.size()]);
            IScmQueryService service = this.getScmQueryService();
            IAuditableHandle[] owners = service.findComponentOwners(iComponentHandleArray, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            SCMClientUtil.checkMonitor(monitor);
            monitor.worked(40);
            List<IAuditableHandle> list = Arrays.asList(owners);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List<IReadScope> findReadScopeForComponents(List<? extends IComponentHandle> components, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (components == null || components.isEmpty()) {
                throw new IllegalArgumentException();
            }
            HashSet<UUID> componentIds = new HashSet<UUID>(components.size());
            for (IComponentHandle iComponentHandle : components) {
                if (iComponentHandle == null) {
                    throw new IllegalArgumentException();
                }
                if (componentIds.add(iComponentHandle.getItemId())) continue;
                throw new IllegalArgumentException();
            }
            IComponentHandle[] iComponentHandleArray = components.toArray(new IComponentHandle[components.size()]);
            IScmQueryService service = this.getScmQueryService();
            SCMClientUtil.checkMonitor(monitor);
            IReadScope[] scopes = service.findDetailedComponentVisibilities(iComponentHandleArray, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            ArrayList<IReadScope> toReturn = new ArrayList<IReadScope>(scopes.length);
            IReadScope[] iReadScopeArray = scopes;
            int n = scopes.length;
            int n2 = 0;
            while (n2 < n) {
                IReadScope scope = iReadScopeArray[n2];
                toReturn.add(scope);
                ++n2;
            }
            ArrayList<IReadScope> arrayList = toReturn;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IQueryItem createQueryItem(String queryName, String queryDescription, IAuditableHandle ownerHandle, IReadScope readScope, IItemSearchCriteria searchCriteria, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            int type;
            this.ensureInitialized((IProgressMonitor)sm.newChild(5));
            if (searchCriteria instanceof IBaselineSearchCriteria) {
                type = 1;
            } else if (searchCriteria instanceof IBaselineSetSearchCriteria) {
                type = 2;
            } else if (searchCriteria instanceof IChangeSetSearchCriteria) {
                type = 3;
            } else if (searchCriteria instanceof IComponentSearchCriteria) {
                type = 4;
            } else if (searchCriteria instanceof IWorkspaceSearchCriteria) {
                type = 5;
            } else if (searchCriteria instanceof IQueryItemSearchCriteria) {
                type = 6;
            } else {
                throw new IllegalArgumentException();
            }
            IQueryItem query = IQueryItemFactory.INSTANCE.createQueryItem(queryName, queryDescription, ownerHandle, type, readScope);
            query.setSearchCriteria(searchCriteria);
            IQueryItem result = this.getServerConfigurationService().saveQueryItem(query, (IRepositoryProgressMonitorHandle)this.getRepoMonitor((IProgressMonitor)sm.newChild(95)));
            IQueryItem iQueryItem = (IQueryItem)this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(result)).iterator().next();
            return iQueryItem;
        }
        finally {
            sm.done();
        }
    }

    @Override
    public IQueryItem updateQueryItem(IQueryItem query, String queryName, String queryDescription, IAuditableHandle ownerHandle, IReadScope readScope, IItemSearchCriteria searchCriteria, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            this.ensureInitialized((IProgressMonitor)sm.newChild(5));
            if (query == null) {
                throw new IllegalArgumentException();
            }
            if (queryName == null || queryName.equals("")) {
                throw new IllegalArgumentException();
            }
            if (ownerHandle == null) {
                throw new IllegalArgumentException();
            }
            if (readScope == null) {
                throw new IllegalArgumentException();
            }
            if (searchCriteria == null) {
                throw new IllegalArgumentException();
            }
            QueryItem queryToEdit = (QueryItem)query.getWorkingCopy();
            queryToEdit.setRealName(queryName);
            if (queryDescription != null && queryDescription.length() > 0) {
                queryToEdit.setDescription(queryDescription);
            } else {
                queryToEdit.setDescription("");
            }
            queryToEdit.setOwnerAndVisibility(ownerHandle, readScope);
            queryToEdit.setSearchCriteria(searchCriteria);
            if (searchCriteria instanceof IBaselineSearchCriteria) {
                queryToEdit.setType(1);
            } else if (searchCriteria instanceof IBaselineSetSearchCriteria) {
                queryToEdit.setType(2);
            } else if (searchCriteria instanceof IChangeSetSearchCriteria) {
                queryToEdit.setType(3);
            } else if (searchCriteria instanceof IComponentSearchCriteria) {
                queryToEdit.setType(4);
            } else if (searchCriteria instanceof IWorkspaceSearchCriteria) {
                queryToEdit.setType(5);
            } else if (searchCriteria instanceof IQueryItemSearchCriteria) {
                queryToEdit.setType(6);
            }
            IQueryItem result = this.getServerConfigurationService().saveQueryItem((IQueryItem)queryToEdit, (IRepositoryProgressMonitorHandle)this.getRepoMonitor((IProgressMonitor)sm.newChild(95)));
            IQueryItem iQueryItem = query = (IQueryItem)this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(result)).iterator().next();
            return iQueryItem;
        }
        finally {
            sm.done();
        }
    }

    @Override
    public IScmItemQueryResult findQueryItems(IQueryItemSearchCriteria criteria, IQueryPageDescriptor pageDescriptor, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)SCMClientUtil.getMonitor(monitor, 100), (int)100);
        try {
            IScmItemQueryResult queryResult;
            this.ensureInitialized((IProgressMonitor)progress.newChild(5));
            IQueryItem queryItem = IQueryItemFactory.INSTANCE.createQueryItem(this.getTemporaryQueryName(), null, (IAuditableHandle)this.teamRepository().loggedInContributor(), 6, (IReadScope)IReadScope.FACTORY.createPrivateScope());
            queryItem.setSearchCriteria((IItemSearchCriteria)criteria);
            IScmItemQueryResult iScmItemQueryResult = queryResult = (IScmItemQueryResult)this.runQuery(queryItem, pageDescriptor, (IProgressMonitor)progress.newChild(95));
            return iScmItemQueryResult;
        }
        finally {
            progress.done();
        }
    }

    private String getTemporaryQueryName() {
        return UUID.generate().getUuidValue();
    }

    @Override
    public IScmQueryResult runQuery(IQueryItem query, IQueryPageDescriptor nextPage, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.runQuery((IQueryItemHandle)query, false, nextPage, monitor);
    }

    @Override
    public IScmQueryResult runSavedQuery(IQueryItemHandle query, IQueryPageDescriptor nextPage, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.runQuery(query, true, nextPage, monitor);
    }

    private IScmQueryResult runQuery(IQueryItemHandle query, boolean savedQuery, IQueryPageDescriptor nextPage, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            this.ensureInitialized((IProgressMonitor)sm.newChild(5));
            if (savedQuery) {
                IScmQueryResult iScmQueryResult = this.getScmQueryService().fetchAndRunQuery(query, nextPage, (IRepositoryProgressMonitorHandle)this.getRepoMonitor((IProgressMonitor)sm));
                return iScmQueryResult;
            }
            IScmQueryResult iScmQueryResult = this.getScmQueryService().runQuery((IQueryItem)query, nextPage, (IRepositoryProgressMonitorHandle)this.getRepoMonitor((IProgressMonitor)sm));
            return iScmQueryResult;
        }
        finally {
            sm.done();
        }
    }

    public IQueryItem saveQuery(IQueryItem query, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            this.ensureInitialized((IProgressMonitor)sm.newChild(5));
            IQueryItem saveQuery = this.getServerConfigurationService().saveQueryItem(query, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            IQueryItem iQueryItem = (IQueryItem)this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(saveQuery)).iterator().next();
            return iQueryItem;
        }
        finally {
            sm.done();
        }
    }

    @Override
    public void deleteQueryItems(Collection<IQueryItemHandle> queryHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        if (queryHandles == null) {
            throw new IllegalArgumentException();
        }
        for (IQueryItemHandle handle : queryHandles) {
            if (handle != null) continue;
            throw new IllegalArgumentException();
        }
        if (queryHandles.isEmpty()) {
            return;
        }
        try {
            this.ensureInitialized(monitor);
            this.getServerConfigurationService().deleteQueryItems(queryHandles.toArray(new IQueryItemHandle[queryHandles.size()]));
            ArrayList<IQueryItemHandle> toApply = new ArrayList<IQueryItemHandle>(queryHandles);
            this.teamRepository().itemManager().applyItemDeletes(toApply);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IWorkspaceConnection createWorkspace(IContributorHandle scopeHandle, String workspaceName, String description, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return this.createWorkspace(scopeHandle, workspaceName, description, null, null, null, progressMonitor);
    }

    public IWorkspaceConnection createWorkspace(IContributorHandle scopeHandle, String workspaceName, String description, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.createWorkspace(scopeHandle, workspaceName, description, null, null, syncInfo, monitor);
    }

    @Override
    public IWorkspaceConnection createWorkspace(IContributorHandle scopeHandle, String workspaceName, String description, IWorkspaceConnection defaultFlow, IWorkspaceConnection sourceWorkspace, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.createWorkspace(scopeHandle, workspaceName, description, defaultFlow, sourceWorkspace, null, monitor);
    }

    @Override
    public IWorkspaceConnection createWorkspace(IContributorHandle scopeHandle, String workspaceName, String description, IHistoryReference seed, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            this.ensureInitialized(monitor);
            if (scopeHandle == null || workspaceName == null || workspaceName.equals("") || seed == null) {
                throw new IllegalArgumentException();
            }
            RemoteRepoDescriptor remoteDescriptor = this.getRemoteDescriptor(seed, (IProgressMonitor)sm.newChild(5));
            IScmService service = this.getServerConfigurationService();
            sm.setWorkRemaining(90);
            WorkspaceRefreshResult result = service.createWorkspaceFromHistory(scopeHandle, workspaceName, description, remoteDescriptor, seed, null, (IRepositoryProgressMonitorHandle)this.getRepoMonitor((IProgressMonitor)sm.newChild(95)));
            sm.worked(85);
            IWorkspaceConnection iWorkspaceConnection = this.getWorkspaceConnections(new WorkspaceRefreshResult[]{result}, (IProgressMonitor)sm).get(0);
            return iWorkspaceConnection;
        }
        finally {
            sm.done();
        }
    }

    private RemoteRepoDescriptor getRemoteDescriptor(IHistoryReference reference, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            ITeamRepository repository = null;
            if (reference instanceof IItemHandle) {
                repository = (ITeamRepository)((IItemHandle)reference).getOrigin();
            } else if (reference instanceof WorkspaceComponentState) {
                repository = (ITeamRepository)((WorkspaceComponentState)reference).getWorkspace().getOrigin();
            }
            if (repository != null && !this.teamRepository().getId().equals((Object)repository.getId())) {
                RemoteRepoDescriptor newDesc;
                RemoteRepoDescriptor remoteRepoDescriptor = newDesc = RemoteRepoDescriptorUtils.getRemoteDescriptor(repository, (IProgressMonitor)sm);
                return remoteRepoDescriptor;
            }
        }
        finally {
            sm.done();
        }
        return null;
    }

    public IWorkspaceConnection createWorkspace(IContributorHandle scopeHandle, String workspaceName, String description, IWorkspaceConnection defaultFlow, IWorkspaceConnection sourceChangeHistory, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            WorkspaceRefreshResult result;
            this.ensureInitialized((IProgressMonitor)sm.newChild(5));
            if (scopeHandle == null) {
                throw new IllegalArgumentException();
            }
            if (workspaceName == null || workspaceName.equals("")) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.getServerConfigurationService();
            IWorkspaceHandle wsHandle = sourceChangeHistory == null ? null : (IWorkspaceHandle)sourceChangeHistory.getResolvedWorkspace().getItemHandle();
            RemoteRepoDescriptor remoteDescriptorForSeed = null;
            RemoteRepoDescriptor remoteDescriptorForFlow = null;
            InvalidAuthenticationTokenException authEx = null;
            while (true) {
                RemoteRepoDescriptor newDesc;
                boolean changed = false;
                if (sourceChangeHistory != null && !this.sameRepository(sourceChangeHistory)) {
                    newDesc = RemoteRepoDescriptorUtils.getRemoteDescriptor(sourceChangeHistory.teamRepository(), (IProgressMonitor)sm.newChild(5));
                    if (remoteDescriptorForSeed == null || !newDesc.getAuthToken().getTruth().equals(remoteDescriptorForSeed.getAuthToken().getTruth())) {
                        changed = true;
                    }
                    remoteDescriptorForSeed = newDesc;
                }
                if (defaultFlow != null && !this.sameRepository(defaultFlow)) {
                    newDesc = RemoteRepoDescriptorUtils.getRemoteDescriptor(defaultFlow.teamRepository(), (IProgressMonitor)sm.newChild(5));
                    if (remoteDescriptorForFlow == null || !newDesc.getAuthToken().getTruth().equals(remoteDescriptorForFlow.getAuthToken().getTruth())) {
                        changed = true;
                    }
                    remoteDescriptorForFlow = newDesc;
                }
                if (authEx != null && !changed) {
                    throw authEx;
                }
                sm.setWorkRemaining(90);
                try {
                    result = service.createWorkspace(scopeHandle, workspaceName, description, (IWorkspaceHandle)(defaultFlow == null ? null : defaultFlow.getResolvedWorkspace()), remoteDescriptorForFlow, wsHandle, remoteDescriptorForSeed, Connection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.getRepoMonitor((IProgressMonitor)sm));
                }
                catch (InvalidAuthenticationTokenException e) {
                    boolean hasRemote = false;
                    if (remoteDescriptorForSeed != null) {
                        RemoteRepoDescriptorUtils.resetRemoteDescriptor(sourceChangeHistory.teamRepository());
                        hasRemote = true;
                    }
                    if (remoteDescriptorForFlow != null) {
                        RemoteRepoDescriptorUtils.resetRemoteDescriptor(defaultFlow.teamRepository());
                        hasRemote = true;
                    }
                    if (!hasRemote) {
                        throw e;
                    }
                    authEx = e;
                    sm.setWorkRemaining(100);
                    continue;
                }
                break;
            }
            sm.worked(85);
            List<IWorkspaceConnection> conn = this.getWorkspaceConnections(new WorkspaceRefreshResult[]{result}, (IProgressMonitor)sm);
            IWorkspaceConnection iWorkspaceConnection = conn.get(0);
            return iWorkspaceConnection;
        }
        finally {
            sm.done();
        }
    }

    @Override
    public IWorkspaceConnection createWorkspace(IContributorHandle scopeHandle, String workspaceName, String description, IBaselineSetHandle sourceBaselineSet, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            this.ensureInitialized(monitor);
            if (scopeHandle == null) {
                throw new IllegalArgumentException();
            }
            if (workspaceName == null || workspaceName.equals("")) {
                throw new IllegalArgumentException();
            }
            if (sourceBaselineSet == null) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.getServerConfigurationService();
            sm.setWorkRemaining(90);
            WorkspaceRefreshResult result = service.createWorkspaceFromBaselineSet(scopeHandle, workspaceName, description, sourceBaselineSet, (IRepositoryProgressMonitorHandle)this.getRepoMonitor((IProgressMonitor)sm));
            sm.worked(85);
            List<IWorkspaceConnection> conn = this.getWorkspaceConnections(new WorkspaceRefreshResult[]{result}, (IProgressMonitor)sm);
            IWorkspaceConnection iWorkspaceConnection = conn.get(0);
            return iWorkspaceConnection;
        }
        finally {
            sm.done();
        }
    }

    @Override
    public IWorkspaceConnection createStream(IProcessAreaHandle scopeHandle, String streamName, String description, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.createStream(scopeHandle, streamName, description, null, monitor);
    }

    public IWorkspaceConnection createStream(IProcessAreaHandle scopeHandle, String streamName, String description, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            IWorkspaceConnection conn;
            this.ensureInitialized(monitor);
            if (scopeHandle == null) {
                throw new IllegalArgumentException();
            }
            if (streamName == null || streamName.equals("")) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.getServerConfigurationService();
            WorkspaceRefreshResult result = service.createStream(scopeHandle, streamName, description, Connection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor));
            monitor.worked(90);
            IWorkspaceConnection iWorkspaceConnection = conn = this.getWorkspaceConnections(new WorkspaceRefreshResult[]{result}, monitor).get(0);
            return iWorkspaceConnection;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    @Deprecated
    public List findWorkspaceDeliverRelationships(IWorkspaceHandle workspaceHandle, IAuditableHandle ownerFilter, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            this.ensureInitialized(monitor);
            if (workspaceHandle == null) {
                throw new IllegalArgumentException();
            }
            IScmQueryService service = this.getScmQueryService();
            IWorkspaceHandle[] wsHandles = service.findWorkspaceDeliverFlows(workspaceHandle, (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor));
            SCMClientUtil.checkMonitor(monitor);
            monitor.worked(50);
            List workspaces = this.teamRepository().itemManager().fetchCompleteItems(Arrays.asList(wsHandles), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            ArrayList<IWorkspace> matching = new ArrayList<IWorkspace>();
            for (IWorkspace workspace : workspaces) {
                if (workspace == null || ownerFilter != null && !ownerFilter.sameItemId((IItemHandle)workspace.getOwner())) continue;
                matching.add(workspace);
            }
            List list = Collections.unmodifiableList(matching);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    @Deprecated
    public IItemQueryPage findWorkspacesByName(String namePattern, boolean matchWorkspaces, boolean matchStreams, boolean matchOwners, int pageSize, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            this.ensureInitialized(monitor);
            if (namePattern == null) {
                throw new IllegalArgumentException("namePattern must not be null");
            }
            if (!matchWorkspaces && !matchStreams) {
                throw new IllegalArgumentException("either matchWorkspaces or matchStreams must be true (or both)");
            }
            if (pageSize <= 0) {
                throw new IllegalArgumentException("pageSize must be positive");
            }
            IScmQueryService service = this.getScmQueryService();
            IItemQueryPage page = service.findWorkspacesByName(namePattern, matchWorkspaces, matchStreams, matchOwners, pageSize, (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor));
            SCMClientUtil.checkMonitor(monitor);
            monitor.worked(100);
            IItemQueryPage iItemQueryPage = page;
            return iItemQueryPage;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List<IComponentHandle> findComponents(IComponentSearchCriteria criteria, int maximumExpectedResults, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor);
        try {
            if (criteria == null) {
                throw new IllegalArgumentException();
            }
            if (maximumExpectedResults <= 0) {
                throw new IllegalArgumentException();
            }
            IScmQueryService query = this.getScmQueryService();
            ItemQueryResult r = query.findComponents(criteria, maximumExpectedResults, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            ArrayList<IComponentHandle> result = new ArrayList<IComponentHandle>();
            maximumExpectedResults -= WorkspaceManager.addToList(result, r.getItemHandles(), maximumExpectedResults);
            while (maximumExpectedResults != 0 && r.getLastTimestamp() != null) {
                IComponentSearchCriteria clone = (IComponentSearchCriteria)EcoreUtil.copy((EObject)((EObject)criteria));
                clone.setModifiedBeforeOptional((Date)r.getLastTimestamp());
                r = query.findComponents(clone, maximumExpectedResults, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
                maximumExpectedResults -= WorkspaceManager.addToList(result, r.getItemHandles(), maximumExpectedResults);
            }
            ArrayList<IComponentHandle> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List<IWorkspaceHandle> findWorkspaces(IWorkspaceSearchCriteria criteria, int maximumExpectedResults, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor);
        try {
            if (criteria == null) {
                throw new IllegalArgumentException();
            }
            if (maximumExpectedResults <= 0) {
                throw new IllegalArgumentException();
            }
            IScmQueryService query = this.getScmQueryService();
            ItemQueryResult r = query.findWorkspaces(criteria, maximumExpectedResults, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            ArrayList<IWorkspaceHandle> result = new ArrayList<IWorkspaceHandle>();
            maximumExpectedResults -= WorkspaceManager.addToList(result, r.getItemHandles(), maximumExpectedResults);
            while (maximumExpectedResults != 0 && r.getLastTimestamp() != null) {
                IWorkspaceSearchCriteria clone = (IWorkspaceSearchCriteria)EcoreUtil.copy((EObject)((EObject)criteria));
                clone.setModifiedBeforeOptional((Date)r.getLastTimestamp());
                r = query.findWorkspaces(clone, maximumExpectedResults, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
                maximumExpectedResults -= WorkspaceManager.addToList(result, r.getItemHandles(), maximumExpectedResults);
            }
            ArrayList<IWorkspaceHandle> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IItemQueryPage fetchNextPage(final IItemQueryPage page, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!page.hasNext()) {
            return null;
        }
        return (IItemQueryPage)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IItemQueryPage>(){

            public IItemQueryPage run(IProgressMonitor monitor) throws TeamRepositoryException {
                monitor = SCMClientUtil.getMonitor(monitor, 100);
                try {
                    IItemQueryPage result = (IItemQueryPage)WorkspaceManager.this.getQueryService().fetchPage(page.getToken(), page.getNextStartPosition(), page.getSize());
                    SCMClientUtil.checkMonitor(monitor);
                    monitor.worked(100);
                    IItemQueryPage iItemQueryPage = result;
                    return iItemQueryPage;
                }
                finally {
                    monitor.done();
                }
            }
        }, monitor);
    }

    @Override
    public List findAllWorkspaces(IAuditableHandle scope, String namePattern, IProgressMonitor monitor) throws TeamRepositoryException {
        this.ensureInitialized(monitor);
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (scope == null) {
                throw new IllegalArgumentException();
            }
            if (!(scope instanceof IProcessAreaHandle) && !(scope instanceof IContributorHandle)) {
                throw new IllegalArgumentException();
            }
            if (namePattern == null) {
                throw new IllegalArgumentException();
            }
            IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(3);
            criteria.getFilterByOwnerOptional().add(scope);
            if (!namePattern.equals("")) {
                criteria.setPartialName(namePattern);
            }
            IScmQueryService service = this.getScmQueryService();
            WorkspaceRefreshResult[] results = service.findWorkspacesRefreshResults(criteria, Integer.MAX_VALUE, (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor));
            SCMClientUtil.checkMonitor(monitor);
            monitor.worked(33);
            List<IWorkspaceConnection> wsConnections = this.getWorkspaceConnections(results, monitor);
            List<IWorkspaceConnection> list = Collections.unmodifiableList(wsConnections);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IWorkspaceConnection> getWorkspaceConnections(WorkspaceRefreshResult[] results, IProgressMonitor progress) throws TeamRepositoryException {
        WorkspaceManager.log("WorkspaceManager.getWorkspaceConnections() -- " + results.length + " results");
        ArrayList<IWorkspaceConnection> response = new ArrayList<IWorkspaceConnection>(results.length);
        ArrayList<IWorkspace> added = new ArrayList<IWorkspace>(results.length);
        Object object = this.insertionLock;
        synchronized (object) {
            int i = 0;
            while (i < results.length) {
                WeakReference<WorkspaceConnection> ref;
                WorkspaceRefreshResult refreshed = results[i];
                UUID workspaceId = refreshed.getWorkspaceItemId();
                WorkspaceConnection conn = null;
                Object object2 = this.lock;
                synchronized (object2) {
                    ref = this.knownWorkspaceConnections.get(workspaceId);
                    if (ref != null && (conn = (WorkspaceConnection)ref.get()) == null) {
                        WorkspaceManager.log("WorkspaceManager.getWorkspaceConnections - Removing workspace from knownWorkspaceConnections (conn is null) - " + workspaceId.getUuidValue());
                        this.knownWorkspaceConnections.remove(workspaceId);
                    }
                }
                if (conn == null) {
                    conn = new WorkspaceConnection(this, refreshed, progress);
                    object2 = this.lock;
                    synchronized (object2) {
                        ref = this.knownWorkspaceConnections.get(workspaceId);
                        if (ref != null) {
                            Assert.isTrue((boolean)false, (String)"WorkspaceConnection obtained concurrently.  This should not happen.");
                        }
                        WorkspaceManager.log("Adding to knownWorkspaceConnections  - " + conn.getName());
                        this.knownWorkspaceConnections.put(this.getWorkspaceId(conn), new WeakReference<WorkspaceConnection>(conn));
                    }
                    added.add(conn.getResolvedWorkspace());
                }
                response.add(conn);
                ++i;
            }
        }
        this.acquire();
        try {
            for (IWorkspace w : added) {
                this.sendPropertyChangeEvent("com.ibm.team.repository.PropertyAdd", "workspaces", null, w);
            }
        }
        finally {
            this.release();
        }
        return response;
    }

    public List findBaselines(IBaselineSearchCriteria criteria, int maxResults, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (criteria == null) {
                throw new IllegalArgumentException();
            }
            if (maxResults <= 0) {
                throw new IllegalArgumentException();
            }
            if (criteria.getRequiredComponent() == null) {
                throw new IllegalArgumentException();
            }
            ItemQueryResult result = this.getScmQueryService().findBaselines(criteria, maxResults, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            ArrayList baselines = new ArrayList();
            maxResults -= WorkspaceManager.addToList(baselines, result.getItemHandles(), maxResults);
            while (maxResults != 0 && result.getLastTimestamp() != null) {
                BaselineSearchCriteria crit = (BaselineSearchCriteria)EcoreUtil.copy((EObject)((EObject)criteria));
                crit.setModifiedBeforeOptional((Date)result.getLastTimestamp());
                result = this.getScmQueryService().findBaselines((IBaselineSearchCriteria)crit, maxResults, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
                maxResults -= WorkspaceManager.addToList(baselines, result.getItemHandles(), maxResults);
            }
            List list = Collections.unmodifiableList(baselines);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List findAllBaselines(IComponentHandle component, String commentPattern, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (component == null) {
                throw new IllegalArgumentException();
            }
            if (commentPattern == null) {
                throw new IllegalArgumentException();
            }
            IBaselineSearchCriteria criteria = IBaselineSearchCriteria.FACTORY.newInstance();
            criteria.setComponentRequired(component);
            if (commentPattern != null) {
                criteria.setPartialName(commentPattern);
            }
            List findBaselines = this.findBaselines(criteria, Integer.MAX_VALUE, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
            SCMClientUtil.checkMonitor(monitor);
            List baselines = this.teamRepository().itemManager().fetchCompleteItems(findBaselines, Integer.MAX_VALUE, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
            SCMClientUtil.checkMonitor(monitor);
            List list = Collections.unmodifiableList(baselines);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List<IChangeSetLinkSummary> getChangeSetLinkSummary(Collection<? extends IChangeSetHandle> changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getChangeSetLinkSummary(changeSets, null, monitor);
    }

    public List<IChangeSetLinkSummary> getChangeSetLinkSummary(Collection<? extends IChangeSetHandle> changeSets, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        WorkspaceManager.log(String.format("WorkspaceManager.getChangeSetLinkSummary() -- %d change sets%n", changeSets.size()));
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            this.ensureInitialized(monitor);
            if (changeSets == null || changeSets.isEmpty()) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.getServerConfigurationService();
            monitor.worked(5);
            ArrayList<? extends IChangeSetHandle> csets = new ArrayList<IChangeSetHandle>(changeSets);
            ArrayList<IChangeSetLinkSummary> result = new ArrayList<IChangeSetLinkSummary>();
            int left = changeSets.size();
            int from = 0;
            while (left != 0) {
                int toFetch = Math.min(1024, left);
                IChangeSetHandle[] handles = csets.subList(from, from + toFetch).toArray(new IChangeSetHandle[toFetch]);
                WorkspaceManager.log(String.format("WorkspaceManager:getChangeSetLinkSummary(): SERVER CALL:getChangeSetLinkSummaries() -- %d change sets.%n", handles.length));
                IChangeSetLinkSummary[] summaries = service.getChangeSetLinkSummaries(handles, Connection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor));
                SCMClientUtil.checkMonitor(monitor);
                monitor.worked(20);
                result.addAll(Arrays.asList(summaries));
                left -= toFetch;
                from += toFetch;
            }
            ArrayList<IChangeSetLinkSummary> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
            WorkspaceManager.log("return from WorkspaceManager.getChangeSetLinkSummary()");
        }
    }

    @Override
    public CreateLinksResult createLinks(String linkTypeId, IWorkspaceHandle workspace, IChangeSetHandle changeSet, List<URI> resourceUris, List<String> comments, List<String> extraInfos, List<String> contentTypes, boolean doBacklink, boolean force, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            this.ensureInitialized(monitor);
            if (changeSet == null) {
                throw new IllegalArgumentException();
            }
            if (resourceUris == null || resourceUris.isEmpty()) {
                throw new IllegalArgumentException();
            }
            if (comments != null && comments.size() != resourceUris.size()) {
                throw new IllegalArgumentException();
            }
            if (extraInfos != null && extraInfos.size() != resourceUris.size()) {
                throw new IllegalArgumentException();
            }
            if (contentTypes != null && contentTypes.size() != resourceUris.size()) {
                throw new IllegalArgumentException();
            }
            String[] uris = new String[resourceUris.size()];
            int i = 0;
            for (URI uri : resourceUris) {
                uris[i] = uri.toString();
                ++i;
            }
            IScmService service = this.getServerConfigurationService();
            monitor.worked(10);
            CreateLinksResult result = service.createLinks(linkTypeId, workspace, changeSet, uris, comments != null ? comments.toArray(new String[comments.size()]) : null, extraInfos != null ? extraInfos.toArray(new String[extraInfos.size()]) : null, contentTypes != null ? contentTypes.toArray(new String[contentTypes.size()]) : null, doBacklink, force, (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor));
            ITeamRepository repo = this.teamRepository();
            repo.itemManager().applyItemUpdates(result.getLinksAdded());
            ILinkManager linkManager = (ILinkManager)repo.getClientLibrary(ILinkManager.class);
            linkManager.applySavedLinks((Collection)result.getLinksAdded());
            SCMClientUtil.checkMonitor(monitor);
            monitor.worked(90);
            CreateLinksResult createLinksResult = result;
            return createLinksResult;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void deleteLinks(List<ILink> links, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            this.ensureInitialized(monitor);
            if (links == null || links.isEmpty()) {
                throw new IllegalArgumentException();
            }
            ILink[] arg = links.toArray(new ILink[links.size()]);
            IScmService service = this.getServerConfigurationService();
            monitor.worked(10);
            service.deleteLinks(arg, (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor));
            ITeamRepository repo = this.teamRepository();
            ILinkManager linkManager = (ILinkManager)repo.getClientLibrary(ILinkManager.class);
            linkManager.applySavedLinks(links);
            SCMClientUtil.checkMonitor(monitor);
            monitor.worked(90);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void renameComponent(IComponentHandle component, String newName, IProgressMonitor monitor) throws TeamRepositoryException {
        this.renameComponent(component, newName, null, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameComponent(IComponentHandle component, String newName, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            this.ensureInitialized(monitor);
            if (component == null) {
                throw new IllegalArgumentException();
            }
            if (newName == null || newName.equals("")) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.getServerConfigurationService();
            monitor.worked(5);
            IComponent c = service.renameComponent(component, newName, Connection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            monitor.worked(80);
            boolean sendEvent = false;
            Object object = this.lock;
            synchronized (object) {
                sendEvent = this.knownComponents.remove(c.getItemId()) != null;
                this.knownComponents.put(c.getItemId(), new WeakReference<IItemHandle>(c.getItemType().createItemHandle(c.getItemId(), c.getStateId())));
            }
            if (sendEvent) {
                this.sendPropertyChangeEvent("com.ibm.team.repository.PropertyAdd", "components", null, c);
            }
            this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(c));
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void setComponentOwner(IComponentHandle component, IAuditableHandle newOwnerHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        this.setComponentOwner(component, newOwnerHandle, null, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComponentOwner(IComponentHandle component, IAuditableHandle newOwnerHandle, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            this.ensureInitialized(monitor);
            if (component == null) {
                throw new IllegalArgumentException();
            }
            if (newOwnerHandle == null) {
                throw new IllegalArgumentException();
            }
            if (!(newOwnerHandle instanceof IContributorHandle) && !(newOwnerHandle instanceof IProcessAreaHandle)) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.getServerConfigurationService();
            monitor.worked(5);
            IComponent c = service.setComponentOwnerAndVisibility(component, newOwnerHandle, IScmService.DEFAULT_VISIBILITY, Connection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            monitor.worked(80);
            boolean sendEvent = false;
            Object object = this.lock;
            synchronized (object) {
                sendEvent = this.knownComponents.remove(c.getItemId()) != null;
                this.knownComponents.put(c.getItemId(), new WeakReference<IItemHandle>(c.getItemType().createItemHandle(c.getItemId(), c.getStateId())));
            }
            if (sendEvent) {
                this.sendPropertyChangeEvent("com.ibm.team.repository.PropertyAdd", "components", null, c);
            }
            this.queueEvent(new PropertyChangeEvent((IEventSource)this, "com.ibm.team.repository.PropertySet", (Object)component, (Object)"component_owner", null, (Object)newOwnerHandle, 0, (Object)this.teamRepository()));
            this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(c));
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void setComponentCustomAttributes(IComponentHandle component, Map<String, Object> attributesToAdd, String[] attributestoRemove, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            this.ensureInitialized(monitor);
            if (component == null) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.getServerConfigurationService();
            monitor.worked(5);
            IGenericAttributes attrs = IGenericAttributes.FACTORY.newInstance(attributesToAdd);
            IComponent newComponent = service.setComponentCustomAttributes(component, attrs, attributestoRemove, null, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            monitor.worked(80);
            this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(newComponent));
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List findItems(IItemQuery query, Object[] params) throws TeamRepositoryException {
        int PAGE_SIZE = 75;
        IItemQueryPage page = this.getQueryService().queryItems(query, params, PAGE_SIZE);
        ArrayList items = new ArrayList(page.getResultSize());
        items.addAll(page.getItemHandles());
        while (page.hasNext()) {
            page = (IItemQueryPage)this.getQueryService().fetchPage(page.getToken(), page.getNextStartPosition(), PAGE_SIZE);
            items.addAll(page.getItemHandles());
        }
        return this.teamRepository().itemManager().fetchCompleteItems(items, 0, null);
    }

    @Override
    public List findItems(final IItemQuery query, final Object[] params, IProgressMonitor monitor) throws TeamRepositoryException {
        return (List)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<List>(){

            public List run(IProgressMonitor monitor) throws TeamRepositoryException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
                WorkspaceManager.this.ensureInitialized((IProgressMonitor)progress);
                int PAGE_SIZE = 75;
                IItemQueryPage page = WorkspaceManager.this.getQueryService().queryItems(query, params, PAGE_SIZE);
                ArrayList items = new ArrayList(page.getResultSize());
                items.addAll(page.getItemHandles());
                while (page.hasNext()) {
                    if (progress.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    page = (IItemQueryPage)WorkspaceManager.this.getQueryService().fetchPage(page.getToken(), page.getNextStartPosition(), PAGE_SIZE);
                    items.addAll(page.getItemHandles());
                }
                return WorkspaceManager.this.teamRepository().itemManager().fetchCompleteItems(items, 0, (IProgressMonitor)progress.newChild(1));
            }
        }, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches() throws TeamRepositoryException {
        Object object = this.lock;
        synchronized (object) {
            this.knownBaselineConnections.clear();
            this.knownComponents.clear();
            this.knownWorkspaceConnections.clear();
        }
    }

    private UUID getWorkspaceId(WorkspaceConnection conn) {
        return conn.getWorkspaceHandle().getItemId();
    }

    private UUID getBaselineId(BaselineConnection conn) {
        return conn.getBaseline().getItemId();
    }

    private void sendPropertyChangeEvent(String eventType, String property, Object oldValue, Object newValue) {
        this.queueEvent(new PropertyChangeEvent((IEventSource)this, eventType, (Object)this, (Object)property, oldValue, newValue));
    }

    private IRepositoryProgressMonitor getRepoMonitor(IProgressMonitor monitor) {
        return IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)(monitor == null ? new NullProgressMonitor() : monitor));
    }

    @Override
    public Set findAllWorkspaceNames(IAuditableHandle scope, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            this.ensureInitialized(monitor);
            if (scope == null) {
                throw new IllegalArgumentException();
            }
            if (!(scope instanceof IProcessAreaHandle) && !(scope instanceof IContributorHandle)) {
                throw new IllegalArgumentException();
            }
            IScmQueryService querySvc = this.getScmQueryService();
            String[] findWorkspaceNames = querySvc.findWorkspaceNames(scope, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            SCMClientUtil.checkMonitor(monitor);
            Set<String> set = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(findWorkspaceNames)));
            return set;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public Set<String> findAllComponentNames(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            this.ensureInitialized(monitor);
            IScmQueryService querySvc = this.getScmQueryService();
            String[] findWorkspaceNames = querySvc.findComponentNames((IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            SCMClientUtil.checkMonitor(monitor);
            Set<String> set = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(findWorkspaceNames)));
            return set;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List<IChangeSetHandle> findChangeSets(IChangeSetSearchCriteria criteria, int maxResults, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.findChangeSets(criteria, maxResults, null, monitor);
    }

    public List<IChangeSetHandle> findChangeSets(IChangeSetSearchCriteria criteria, int maxResults, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            this.ensureInitialized(monitor);
            if (criteria == null) {
                throw new IllegalArgumentException();
            }
            if (maxResults < 1) {
                throw new IllegalArgumentException();
            }
            if (syncInfo == null) {
                if (criteria.getChangeType() == 0) {
                    List<IChangeSetHandle> list = Collections.emptyList();
                    return list;
                }
                if (criteria.getModifiedAfter() != null && criteria.getModifiedBefore() != null && criteria.getModifiedAfter().compareTo(criteria.getModifiedBefore()) >= 0) {
                    List<IChangeSetHandle> list = Collections.emptyList();
                    return list;
                }
            }
            List<IChangeSetHandle> list = Arrays.asList(this.getScmQueryService().findChangeSets(criteria, maxResults, Connection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor)));
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IChangeSet[] findChangeSetsQuery(IGenericQueryNode query, int expectedMaxResults, IProgressMonitor monitor) throws TeamRepositoryException {
        if (query == null) {
            throw new IllegalArgumentException();
        }
        if (expectedMaxResults <= 0) {
            throw new IllegalArgumentException();
        }
        expectedMaxResults = Math.min(expectedMaxResults, 2048);
        monitor = SCMClientUtil.getMonitor(monitor);
        try {
            ItemQueryResult queryResult = this.getScmQueryService().findChangeSets2(query, expectedMaxResults, false, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            int queryLength = queryResult.getItemHandles().size();
            IChangeSetHandle[] fullResult = queryResult.getItemHandles().toArray(new IChangeSetHandle[queryLength]);
            if (queryLength > 0) {
                ArrayList<IChangeSetHandle> csResult = new ArrayList<IChangeSetHandle>();
                csResult.addAll(this.getChangeSetList(fullResult, fullResult.length, 0, monitor));
                ArrayList changesetList = new ArrayList();
                expectedMaxResults -= WorkspaceManager.addToList(changesetList, csResult, expectedMaxResults);
                IChangeSet[] iChangeSetArray = Collections.unmodifiableList(changesetList).toArray(new IChangeSet[changesetList.size()]);
                return iChangeSetArray;
            }
            IChangeSet[] iChangeSetArray = new IChangeSet[]{};
            return iChangeSetArray;
        }
        finally {
            monitor.done();
        }
    }

    private List<IChangeSetHandle> getChangeSetList(IChangeSetHandle[] handles, int size, int handleIndex, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IChangeSetHandle> partResult = new ArrayList<IChangeSetHandle>(size);
        int partStates = 0;
        while (partStates < size) {
            partResult.add(handles[handleIndex++]);
            ++partStates;
        }
        return this.teamRepository().itemManager().fetchCompleteItems(partResult, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshWorkspaceConnections(Collection<IWorkspaceConnection> connections, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        WorkspaceManager.log(String.format("Calling WorkspaceManager.refreshWorkspaceConnections() -- %d connections", connections.size()));
        try {
            this.ensureInitialized((IProgressMonitor)progress.newChild(1));
            if (connections == null) {
                throw new IllegalArgumentException();
            }
            HashMap<UUID, IWorkspaceConnection> mapping = new HashMap<UUID, IWorkspaceConnection>((int)((double)connections.size() / 0.75));
            ArrayList<WorkspaceRefreshParameter> parms = new ArrayList<WorkspaceRefreshParameter>(connections.size());
            ArrayList<UUID> workspaceIds = new ArrayList<UUID>(connections.size());
            for (IWorkspaceConnection connection : connections) {
                if (connection == null) {
                    throw new IllegalArgumentException();
                }
                mapping.put(connection.getResolvedWorkspace().getItemId(), connection);
                workspaceIds.add(connection.getResolvedWorkspace().getItemId());
                parms.add(((WorkspaceConnection)connection).createRefreshParameter());
            }
            WorkspaceRefreshParameter[] param = parms.toArray(new WorkspaceRefreshParameter[parms.size()]);
            int left = parms.size();
            progress.setWorkRemaining(left);
            int j = 0;
            while (left > 0) {
                int from = j * 1024;
                int size = Math.min(1024, left);
                WorkspaceRefreshParameter[] subArray = new WorkspaceRefreshParameter[size];
                System.arraycopy(param, from, subArray, 0, size);
                SubMonitor child = progress.newChild(1);
                child.setWorkRemaining(100);
                WorkspaceManager.log("WorkspaceManager.refreshWorkspaceConnections(): SERVER CALL:refreshWorkspaces - (" + subArray.length + " workspaces)");
                WorkspaceRefreshResult[] refreshResults = this.getServerConfigurationService().refreshWorkspaces(subArray, (IRepositoryProgressMonitorHandle)IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)progress));
                child.worked(99);
                child.setWorkRemaining(refreshResults.length * 2);
                int i = 0;
                while (i < refreshResults.length) {
                    UUID wsId = (UUID)workspaceIds.get(i);
                    WorkspaceRefreshResult result = refreshResults[i];
                    if (result == null) {
                        Object object = this.lock;
                        synchronized (object) {
                            WorkspaceManager.log("WorkspaceManager.refreshWorkspaceConnections - Removing workspace from knownWorkspaceConnections (result is null) - " + wsId.getUuidValue());
                            this.knownWorkspaceConnections.remove(wsId);
                        }
                        this.teamRepository().itemManager().applyItemDeletes(Collections.singletonList(IWorkspace.ITEM_TYPE.createItemHandle(wsId, null)));
                    } else {
                        WorkspaceManager.log("Returned from server with workspace - " + result.getWorkspace().getName());
                        WorkspaceConnection conn = (WorkspaceConnection)mapping.get(result.getWorkspaceItemId());
                        ContextLock lock = new ContextLock();
                        lock.addExclusive((IContextHandle)conn.getResolvedWorkspace());
                        lock.acquire((IProgressMonitor)child.newChild(1));
                        try {
                            conn.refresh(result, subArray[i], (IProgressMonitor)child.newChild(1));
                        }
                        finally {
                            lock.release();
                        }
                    }
                    ++i;
                }
                child.done();
                left -= size;
                ++j;
            }
        }
        finally {
            progress.done();
        }
    }

    @Override
    public boolean sameRepository(IConnection connection) {
        ITeamRepository tr = connection.teamRepository();
        return this.teamRepository().getId().equals((Object)tr.getId());
    }

    public RemoteRepoDescriptor fetchRepoDescriptor(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 100);
        RemoteRepoDescriptor remoteDescriptor = ScmDtoFactory.eINSTANCE.createRemoteRepoDescriptor();
        ITeamRepository repo = this.teamRepository();
        remoteDescriptor.setRepoRoot(repo.getId());
        remoteDescriptor.setRepoURI(repo.getRepositoryURI());
        ScmAuthToken token = ScmDtoFactory.eINSTANCE.createScmAuthToken();
        token.setUserid(repo.loggedInContributor().getUserId());
        token.setTruth(this.getScmAuthService().createAuthToken((IRepositoryProgressMonitorHandle)IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor)));
        remoteDescriptor.setAuthToken(token);
        X509Certificate[] chain = this.context.getServerCertificatePath();
        if (chain != null) {
            remoteDescriptor.setServerCertificateSignatureAlgorithm(chain[0].getSigAlgOID());
            List l = remoteDescriptor.getServerCertificateSignature();
            byte[] byArray = chain[0].getSignature();
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                l.add(b);
                ++n2;
            }
        }
        monitor.done();
        return remoteDescriptor;
    }

    public RemoteRepoDescriptorTask getDescriptorTask() {
        return this.descriptorTask;
    }

    @Override
    public void applyLockOperations(Collection<IWorkspaceManager.IVersionableLockOperation> lockOperations, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            this.ensureInitialized((IProgressMonitor)progress.newChild(5));
            if (lockOperations == null) {
                throw new IllegalArgumentException();
            }
            HashMap<UUID, WorkspaceLocks> toAdd = new HashMap<UUID, WorkspaceLocks>();
            HashMap<UUID, WorkspaceLocks> toAddSubtree = new HashMap<UUID, WorkspaceLocks>();
            HashMap<UUID, WorkspaceLocks> toRelease = new HashMap<UUID, WorkspaceLocks>();
            HashMap<UUID, WorkspaceLocks> toReleaseSubtree = new HashMap<UUID, WorkspaceLocks>();
            HashMap<UUID, WorkspaceLocks> toDestroy = new HashMap<UUID, WorkspaceLocks>();
            HashMap<UUID, WorkspaceLocks> toTransfer = new HashMap<UUID, WorkspaceLocks>();
            HashMap<UUID, IWorkspaceConnection> streamsWithDestroyedLocks = new HashMap<UUID, IWorkspaceConnection>();
            for (IWorkspaceManager.IVersionableLockOperation op : lockOperations) {
                if (op == null) {
                    throw new IllegalArgumentException();
                }
                LockOperation lockOp = (LockOperation)op;
                IWorkspaceConnection stream = lockOp.stream;
                IContributorHandle contrib = lockOp.contributor;
                IComponentHandle comp = lockOp.component;
                IVersionableHandle vh = lockOp.versionable;
                boolean force = lockOp.force;
                switch (lockOp.kind) {
                    case LOCK_SUBTREE: {
                        this.updateMap(toAddSubtree, stream, (IContributorHandle)this.teamRepository().loggedInContributor(), comp, vh);
                        break;
                    }
                    case LOCK: {
                        this.updateMap(toAdd, stream, (IContributorHandle)this.teamRepository().loggedInContributor(), comp, vh);
                        break;
                    }
                    case UNLOCK: {
                        if (force) {
                            this.updateMap(toDestroy, stream, (IContributorHandle)this.teamRepository().loggedInContributor(), comp, vh);
                            streamsWithDestroyedLocks.put(stream.getResolvedWorkspace().getItemId(), stream);
                            break;
                        }
                        this.updateMap(toRelease, stream, (IContributorHandle)this.teamRepository().loggedInContributor(), comp, vh);
                        break;
                    }
                    case UNLOCK_SUBTREE: {
                        this.updateMap(toReleaseSubtree, stream, (IContributorHandle)this.teamRepository().loggedInContributor(), comp, vh);
                        break;
                    }
                    case TRANSFER: {
                        this.updateMap(toTransfer, stream, contrib, comp, vh);
                    }
                }
            }
            LockParameter parm = ScmDtoFactory.eINSTANCE.createLockParameter();
            parm.getToAcquire().addAll(toAdd.values());
            parm.getToAcquireSubtree().addAll(toAddSubtree.values());
            parm.getToDestroy().addAll(toDestroy.values());
            parm.getToTransfer().addAll(toTransfer.values());
            parm.getToRelease().addAll(toRelease.values());
            parm.getToReleaseSubtree().addAll(toReleaseSubtree.values());
            IScmService scm = this.getServerConfigurationService();
            ContributorRefreshResult result = scm.updateLocks(parm, (IRepositoryProgressMonitorHandle)this.getRepoMonitor((IProgressMonitor)progress.newChild(50)));
            this.refresh(result, (IProgressMonitor)progress.newChild(20));
            HashMap<WorkspaceConnection, HashSet> changeMap = new HashMap<WorkspaceConnection, HashSet>();
            HashSet<IWorkspaceConnection> streamEvents = new HashSet<IWorkspaceConnection>();
            SubMonitor loopProgress = progress.newChild(20).setWorkRemaining(lockOperations.size());
            for (IWorkspaceManager.IVersionableLockOperation op : lockOperations) {
                HashSet changedComponents;
                LockOperation lockOp = (LockOperation)op;
                if (lockOp.kind != OperationKind.LOCK && lockOp.kind != OperationKind.UNLOCK || !lockOp.isStreamOrComponentLock()) continue;
                if (lockOp.isStreamLock() && !streamEvents.contains(lockOp.stream)) {
                    streamEvents.add(lockOp.stream);
                    ((WorkspaceConnection)lockOp.stream).queueEvent(new LockEvent(lockOp.stream, "com.ibm.team.scm.LockEvent.StreamsLocked"));
                }
                if (!changeMap.containsKey(lockOp.stream)) {
                    lockOp.stream.refresh((IProgressMonitor)loopProgress.newChild(1));
                    changedComponents = new HashSet();
                    changeMap.put((WorkspaceConnection)lockOp.stream, changedComponents);
                } else {
                    loopProgress.worked(1);
                }
                if (lockOp.component == null) continue;
                changedComponents = (HashSet)changeMap.get(lockOp.stream);
                changedComponents.add(lockOp.component.getItemId());
            }
            progress.setWorkRemaining(10);
            loopProgress = progress.newChild(10).setWorkRemaining(streamsWithDestroyedLocks.values().size());
            for (IWorkspaceConnection stream : streamsWithDestroyedLocks.values()) {
                stream.refresh((IProgressMonitor)loopProgress.newChild(1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void updateMap(Map<UUID, WorkspaceLocks> map, IWorkspaceConnection stream, IContributorHandle contrib, IComponentHandle comp, IVersionableHandle vh) {
        WorkspaceLocks l = map.get(stream.getResolvedWorkspace().getItemId());
        if (l == null) {
            l = ScmDtoFactory.eINSTANCE.createWorkspaceLocks();
            l.setWorkspace((IWorkspaceHandle)stream.getResolvedWorkspace().getItemHandle());
            map.put(stream.getResolvedWorkspace().getItemId(), l);
        }
        if (comp == null) {
            return;
        }
        ComponentLocks cl = l.getComponentLock(comp);
        if (cl == null) {
            cl = ScmDtoFactory.eINSTANCE.createComponentLocks();
            cl.setComponent(comp);
            l.getComponentLocks().add(cl);
        }
        if (vh == null) {
            return;
        }
        ContributorLocks contribLock = cl.getContributorLock((IContributorHandle)this.teamRepository().loggedInContributor());
        if (contribLock == null) {
            contribLock = ScmDtoFactory.eINSTANCE.createContributorLocks();
            contribLock.setContributor(contrib);
            cl.getContributorLocks().add(contribLock);
        }
        if (!ItemUtil.itemInCollection((IItemHandle)vh, (Collection)contribLock.getVersionables())) {
            contribLock.getVersionables().add(vh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IStreamLockReport> getLocks() throws TeamRepositoryException {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableList(this.heldLocks);
        }
    }

    @Override
    public IWorkspaceManager.IVersionableLockOperationFactory lockOperationFactory() {
        return this.lockOpFactory;
    }

    @Override
    public ILockSearchResult findLocks(ILockSearchCriteria criteria, int maxLocks, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        LockSearchResult locks = ScmDtoFactory.eINSTANCE.createLockSearchResult();
        try {
            this.ensureInitialized((IProgressMonitor)progress.newChild(5));
            if (criteria == null) {
                throw new IllegalArgumentException();
            }
            int lockCount = 0;
            ArrayList<ILockSearchResult2> lockResults = new ArrayList<ILockSearchResult2>();
            Iterator iterator = LockSearchUtil.partitionCriteria((ILockSearchCriteria)criteria, (int)512);
            while (iterator.hasNext() && lockCount < maxLocks) {
                ILockSearchCriteria search = (ILockSearchCriteria)iterator.next();
                ILockPageFetchDescriptor lockPageFetchDescriptor = ILockPageFetchDescriptor.FACTORY.maxEntries(2048);
                while (lockPageFetchDescriptor != null && lockCount < maxLocks) {
                    progress.setWorkRemaining(3);
                    int pageSize = Math.min(maxLocks - lockCount, 2048);
                    lockPageFetchDescriptor.setLocksPerPage(pageSize);
                    ILockSearchResult2 searchPage = this.getScmQueryService().searchFileLocks(search, lockPageFetchDescriptor, (IRepositoryProgressMonitorHandle)this.getRepoMonitor((IProgressMonitor)progress.newChild(1)));
                    lockResults.add(searchPage);
                    lockCount += searchPage.getVersionableLockCount();
                    lockPageFetchDescriptor = searchPage.getNextFetchDescriptor();
                }
            }
            ILockSearchResult2 mergeLockResults = LockSearchUtil.mergeLockResults(lockResults);
            locks.getStreamReports().addAll(mergeLockResults.getStreamReports());
            LockSearchResult lockSearchResult = locks;
            return lockSearchResult;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public ILockSearchResult1 searchLocks(ILockSearchCriteria criteria, int maxResults, IProgressMonitor monitor) throws TeamRepositoryException {
        if (maxResults > 2048 || maxResults <= 0) {
            throw new IllegalArgumentException();
        }
        ILockPageFetchDescriptor lockPageFetchDescriptor = ILockPageFetchDescriptor.FACTORY.maxEntries(maxResults);
        return this.searchLocks(criteria, lockPageFetchDescriptor, monitor);
    }

    @Override
    public ILockSearchResult2 searchLocks(ILockSearchCriteria criteria, ILockPageFetchDescriptor pageDescriptor, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            this.ensureInitialized((IProgressMonitor)subMon.newChild(2));
            if (criteria == null) {
                throw new IllegalArgumentException();
            }
            ILockSearchResult2 iLockSearchResult2 = this.getScmQueryService().searchFileLocks(criteria, pageDescriptor, (IRepositoryProgressMonitorHandle)this.getRepoMonitor((IProgressMonitor)subMon.newChild(98)));
            return iLockSearchResult2;
        }
        finally {
            subMon.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IChangeSetHandle> suspendedChangeSets() {
        Object object = this.lock;
        synchronized (object) {
            return this.suspendTracker.getChangeSets();
        }
    }

    @Override
    public void removeSuspended(Collection changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        if (changeSets == null) {
            throw new IllegalArgumentException();
        }
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            IScmService service = this.getServerConfigurationService();
            ChangeSetHandle[] array = changeSets.toArray(new ChangeSetHandle[changeSets.size()]);
            ContributorRefreshParameter refreshParameter = this.getRefreshParameter();
            ContributorRefreshResult result = service.removeSuspended((IChangeSetHandle[])array, refreshParameter, null, (IRepositoryProgressMonitorHandle)IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor));
            this.refresh(result, monitor);
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IChangeSetHandle> suspendedChangeSets(IComponentHandle component) {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            return this.suspendTracker.getByComponent(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContributorRefreshParameter getRefreshParameter() {
        Object object = this.lock;
        synchronized (object) {
            return this.contributorTimes.duplicate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(ContributorRefreshResult contributorState, IProgressMonitor monitor) throws TeamRepositoryException {
        Object object = this.lock;
        synchronized (object) {
            ContributorRefreshParameter parm = this.getRefreshParameter();
            if (parm == null) {
                if (contributorState != null) {
                    this.acquire();
                    try {
                        this.updateSuspend(contributorState, monitor);
                        this.updateLocks(contributorState);
                    }
                    finally {
                        this.release();
                    }
                }
            } else if (contributorState != null) {
                this.acquire();
                try {
                    if (!contributorState.getContributor().sameItemId((IItemHandle)parm.getContributor())) {
                        this.contributorTimes.reset(contributorState.getContributor());
                        this.updateLocks(contributorState);
                        this.updateSuspend(contributorState, monitor);
                    } else {
                        if (parm.getLockTime() == 0L || FlowNodeConnection.compareTimes(parm.getLockTime(), contributorState.getLockTime()) < 0) {
                            this.updateLocks(contributorState);
                        }
                        if (parm.getSuspendTime() == 0L || FlowNodeConnection.compareTimes(parm.getSuspendTime(), contributorState.getSuspendTime()) < 0 || this.suspendTracker.getChangeSets().size() == 0 && contributorState.getSuspendedChangeSetHandles().size() > 0) {
                            this.updateSuspend(contributorState, monitor);
                        }
                        if (parm.getPendingTime() != 0L) {
                            FlowNodeConnection.compareTimes(parm.getPendingTime(), contributorState.getPendingTime());
                        }
                    }
                }
                finally {
                    this.release();
                }
            }
        }
    }

    private void updateLocks(ContributorRefreshResult contributorState) {
        this.contributorTimes.setLockTime(contributorState.getLockTime());
        ArrayList<IStreamLockReport> before = new ArrayList<IStreamLockReport>(this.heldLocks);
        this.heldLocks.clear();
        for (WorkspaceLocks wl : contributorState.getLocks()) {
            this.heldLocks.add((IStreamLockReport)new LockReport(wl));
        }
        ArrayList<IStreamLockReport> after = new ArrayList<IStreamLockReport>(this.heldLocks);
        this.sendPropertyChangeEvent("com.ibm.team.repository.PropertySet", "user_locks", before, after);
    }

    private void updateSuspend(ContributorRefreshResult contributorState, IProgressMonitor monitor) throws TeamRepositoryException {
        Map beforeSuspended = ConfigUtil.tableForItems(this.suspendTracker.getChangeSets());
        this.contributorTimes.setSuspendTime(contributorState.getSuspendTime());
        Map fullChangeSets = ConfigUtil.tableForItems((Collection)contributorState.getSuspendedChangeSets());
        Map changeSetHandles = ConfigUtil.tableForItems((Collection)contributorState.getSuspendedChangeSetHandles());
        if (fullChangeSets.isEmpty() && changeSetHandles.isEmpty()) {
            for (IChangeSetHandle cs : beforeSuspended.values()) {
                this.suspendTracker.removeChangeSet(cs);
            }
        } else {
            for (IChangeSetHandle cs : beforeSuspended.values()) {
                IChangeSetHandle handle;
                UUID id = cs.getItemId();
                if (!changeSetHandles.containsKey(id) && !fullChangeSets.containsKey(id)) {
                    this.suspendTracker.removeChangeSet(cs);
                    continue;
                }
                boolean full = fullChangeSets.containsKey(id);
                IChangeSetHandle iChangeSetHandle = handle = full ? (IChangeSetHandle)fullChangeSets.get(id) : (IChangeSetHandle)changeSetHandles.get(id);
                if (cs.getStateId() == null || !cs.getStateId().equals((Object)handle.getStateId())) continue;
                if (full) {
                    fullChangeSets.remove(id);
                    continue;
                }
                changeSetHandles.remove(id);
            }
        }
        if (!fullChangeSets.isEmpty()) {
            ArrayList updates = new ArrayList(fullChangeSets.values());
            for (IChangeSet cs : updates) {
                this.suspendTracker.addChangeSet(cs);
            }
            this.teamRepository().itemManager().applyItemUpdates(updates);
        }
        if (!changeSetHandles.isEmpty()) {
            ArrayList toFetch = new ArrayList(changeSetHandles.values());
            List completeStates = this.teamRepository().itemManager().fetchCompleteStates(toFetch, monitor);
            for (IChangeSet cs : completeStates) {
                if (cs == null) continue;
                this.suspendTracker.addChangeSet(cs);
            }
        }
        this.sendPropertyChangeEvent("com.ibm.team.repository.PropertySet", "suspended", beforeSuspended.values(), this.suspendTracker.getChangeSets());
    }

    @Override
    public void refresh(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        ContributorRefreshParameter refreshParameter = this.getRefreshParameter();
        if (this.suspendTracker.getChangeSets().size() == 0) {
            refreshParameter.setSuspendTime(0L);
        }
        ContributorRefreshResult refreshResult = this.getServerConfigurationService().getContributorState(refreshParameter, (IRepositoryProgressMonitorHandle)IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor));
        this.refresh(refreshResult, monitor);
    }

    @Override
    public IVersionedContentManager getSCMContentManager() {
        return this.contentManager;
    }

    public Collection<ComponentEntry> getComponentEntries(IWorkspaceHandle wh, IProgressMonitor monitor) throws TeamRepositoryException {
        ComponentEntry[] result = this.getServerConfigurationService().getComponentEntries(wh, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
        return Arrays.asList(result);
    }

    public ConfigurationHandle getConfigurationForHistory(final ChangeHistoryHandle chh, IProgressMonitor monitor) throws TeamRepositoryException {
        return (ConfigurationHandle)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<ConfigurationHandle>(){

            public ConfigurationHandle run(IProgressMonitor monitor) throws TeamRepositoryException {
                return WorkspaceManager.this.getServerConfigurationService().historyGetConfiguration(chh);
            }
        }, monitor);
    }

    public ComponentOwnerHandle getOwnerRecord(final Component component, IProgressMonitor monitor) throws TeamRepositoryException {
        return (ComponentOwnerHandle)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<ComponentOwnerHandle>(){

            public ComponentOwnerHandle run(IProgressMonitor monitor) throws TeamRepositoryException {
                return WorkspaceManager.this.getServerConfigurationService().getComponentOwnerRecord((ComponentHandle)component);
            }
        }, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setComponentOwnerAndVisibility(IComponentHandle component, IAuditableHandle newOwnerHandle, IReadScope newScope, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            this.ensureInitialized(monitor);
            if (component == null) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.getServerConfigurationService();
            monitor.worked(5);
            IComponent c = service.setComponentOwnerAndVisibility(component, newOwnerHandle, newScope, null, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            monitor.worked(80);
            boolean sendEvent = false;
            Object object = this.lock;
            synchronized (object) {
                sendEvent = this.knownComponents.remove(c.getItemId()) != null;
                this.knownComponents.put(c.getItemId(), new WeakReference<IItemHandle>(c.getItemType().createItemHandle(c.getItemId(), c.getStateId())));
            }
            if (sendEvent) {
                this.sendPropertyChangeEvent("com.ibm.team.repository.PropertyAdd", "components", null, c);
            }
            this.queueEvent(new PropertyChangeEvent((IEventSource)this, "com.ibm.team.repository.PropertySet", (Object)component, (Object)"component_owner", null, (Object)newOwnerHandle, 0, (Object)this.teamRepository()));
            this.queueEvent(new PropertyChangeEvent((IEventSource)this, "com.ibm.team.repository.PropertySet", (Object)component, (Object)"component_visibility", null, (Object)newScope, 0, (Object)this.teamRepository()));
            this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(c));
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void setPermissions(IVersionableHandle[] versionables, IComponentHandle componentHandle, IPermissionContextProvider contextProvider, IProgressMonitor monitor) throws TeamRepositoryException {
        this.setPermissions(versionables, componentHandle, contextProvider, null, monitor);
    }

    public void setPermissions(IVersionableHandle[] versionables, IComponentHandle componentHandle, IPermissionContextProvider contextProvider, ISynchronizationTimes[] syncTimes, IProgressMonitor monitor) throws TeamRepositoryException {
        if (versionables == null) {
            throw new IllegalArgumentException();
        }
        if (componentHandle == null) {
            throw new IllegalArgumentException();
        }
        if (contextProvider == null) {
            throw new IllegalArgumentException();
        }
        IVersionableHandle[] iVersionableHandleArray = versionables;
        int n = versionables.length;
        int n2 = 0;
        while (n2 < n) {
            IVersionableHandle vh = iVersionableHandleArray[n2];
            if (vh == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            IScmService service = this.getServerConfigurationService();
            service.setPermissions(versionables, componentHandle, contextProvider, syncTimes, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            this.queueEvent((Object)new ItemPermissionChangeEvent(this, "item_permission_change_event", versionables, contextProvider.getReadContext()));
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IPermissionContextProvider getPermissions(IVersionableHandle versionable, IComponentHandle componentHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (versionable == null) {
            throw new IllegalArgumentException();
        }
        if (componentHandle == null) {
            throw new IllegalArgumentException();
        }
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            IScmService service = this.getServerConfigurationService();
            IVersionablePermissionsReport[] permissions = service.getPermissions(new IVersionableHandle[]{versionable}, componentHandle, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            if (permissions.length == 0) {
                return null;
            }
            if (permissions.length == 1 && permissions[0].isReportOfInaccessible()) {
                throw VersionablePermissionDeniedException.exceptionFor((String)Messages.WorkspaceManager_0, (UUID)this.context.teamRepository().getId(), null, (IComponentHandle)componentHandle, (IVersionableHandle)versionable);
            }
            IPermissionContextProvider iPermissionContextProvider = permissions[0].getContext();
            return iPermissionContextProvider;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IVersionablePermissionsReport[] getPermissions(IVersionableHandle[] versionables, IComponentHandle componentHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (versionables == null) {
            throw new IllegalArgumentException();
        }
        if (versionables.length == 0) {
            return new IVersionablePermissionsReport[0];
        }
        if (componentHandle == null) {
            throw new IllegalArgumentException();
        }
        IVersionableHandle[] iVersionableHandleArray = versionables;
        int n = versionables.length;
        int n2 = 0;
        while (n2 < n) {
            IVersionableHandle vh = iVersionableHandleArray[n2];
            if (vh == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            IVersionablePermissionsReport[] result;
            IScmService service = this.getServerConfigurationService();
            if (versionables.length <= 2048) {
                IVersionablePermissionsReport[] iVersionablePermissionsReportArray = service.getPermissions(versionables, componentHandle, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
                return iVersionablePermissionsReportArray;
            }
            int left = versionables.length;
            HashSet hiddenItems = new HashSet();
            HashMap<UUID, IVersionablePermissionsReport> reports = new HashMap<UUID, IVersionablePermissionsReport>();
            int i = 0;
            while (left > 0) {
                IVersionablePermissionsReport[] permissions;
                int from = i * 2048;
                int size = Math.min(2048, left);
                IVersionableHandle[] toFetch = new IVersionableHandle[size];
                System.arraycopy(versionables, from, toFetch, 0, size);
                IVersionablePermissionsReport[] iVersionablePermissionsReportArray = permissions = service.getPermissions(toFetch, componentHandle, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
                int n3 = permissions.length;
                int n4 = 0;
                while (n4 < n3) {
                    IVersionablePermissionsReport vpr = iVersionablePermissionsReportArray[n4];
                    if (vpr.isReportOfInaccessible()) {
                        hiddenItems.addAll(vpr.getItemsIds());
                    } else {
                        IAuditableHandle readContext = vpr.getContext().getReadContext();
                        if (readContext != null) {
                            IVersionablePermissionsReport evpr = (IVersionablePermissionsReport)reports.get(readContext.getItemId());
                            if (evpr == null) {
                                reports.put(readContext.getItemId(), vpr);
                            } else {
                                evpr.getItemsIds().addAll(vpr.getItemsIds());
                            }
                        }
                    }
                    ++n4;
                }
                left -= size;
                ++i;
            }
            if (hiddenItems.isEmpty()) {
                result = reports.values().toArray(new IVersionablePermissionsReport[reports.size()]);
            } else {
                result = new IVersionablePermissionsReport[reports.size() + 1];
                result[0] = IVersionablePermissionsReport.FACTORY.createReportOfInaccessible(hiddenItems);
                int i2 = 1;
                for (IVersionablePermissionsReport vpr : reports.values()) {
                    result[i2++] = vpr;
                }
            }
            IVersionablePermissionsReport[] iVersionablePermissionsReportArray = result;
            return iVersionablePermissionsReportArray;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IConsolidatedChangesReport getConsolidatedChanges(IChangeSetHandle[] changeSets, IPagedFetchDescriptor pageDescriptor, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (changeSets == null) {
                throw new IllegalArgumentException();
            }
            int i = 0;
            while (i < changeSets.length) {
                IChangeSetHandle element = changeSets[i];
                if (element == null) {
                    throw new IllegalArgumentException();
                }
                ++i;
            }
            SCMClientUtil.checkMonitor(monitor);
            IScmService service = this.getServerConfigurationService();
            IConsolidatedChangesReport iConsolidatedChangesReport = service.getConsolidatedChanges(changeSets, pageDescriptor, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            return iConsolidatedChangesReport;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IConsolidatedChangeSetsPathReport calculateParentPaths(IContextHandle context, IChangeSetHandle[] changeSets, UUID[] parentIds, IVersionableHandle[] changedParentItems, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (changeSets == null || parentIds == null || changedParentItems == null) {
                throw new IllegalArgumentException();
            }
            IChangeSetHandle[] iChangeSetHandleArray = changeSets;
            int n = changeSets.length;
            int n2 = 0;
            while (n2 < n) {
                IChangeSetHandle changeSet = iChangeSetHandleArray[n2];
                if (changeSet == null) {
                    throw new IllegalArgumentException();
                }
                ++n2;
            }
            iChangeSetHandleArray = parentIds;
            n = parentIds.length;
            n2 = 0;
            while (n2 < n) {
                IChangeSetHandle parentId = iChangeSetHandleArray[n2];
                if (parentId == null) {
                    throw new IllegalArgumentException();
                }
                ++n2;
            }
            iChangeSetHandleArray = changedParentItems;
            n = changedParentItems.length;
            n2 = 0;
            while (n2 < n) {
                IChangeSetHandle changedParentItem = iChangeSetHandleArray[n2];
                if (changedParentItem == null) {
                    throw new IllegalArgumentException();
                }
                ++n2;
            }
            SCMClientUtil.checkMonitor(monitor);
            IConsolidatedChangeSetsPathReport iConsolidatedChangeSetsPathReport = this.getServerConfigurationService().calculateParentPaths(context, changeSets, parentIds, changedParentItems, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            return iConsolidatedChangeSetsPathReport;
        }
        finally {
            monitor.done();
        }
    }

    public ConfigurationHandle getConfiguration(final ComponentEntryHandle entry, IProgressMonitor monitor) throws TeamRepositoryException {
        return (ConfigurationHandle)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<ConfigurationHandle>(){

            public ConfigurationHandle run(IProgressMonitor monitor) throws TeamRepositoryException {
                return WorkspaceManager.this.getServerConfigurationService().getConfigurationForComponentEntry(entry, (IRepositoryProgressMonitorHandle)WorkspaceManager.this.getRepoMonitor(monitor));
            }
        }, monitor);
    }

    @Override
    public void removeChangeSetLinks(List<IChangeSetHandle> changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        this.ensureInitialized(monitor);
        try {
            if (changeSets == null) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.getServerConfigurationService();
            monitor.worked(5);
            WorkspaceItemListResult result = service.removeChangeSetLinks(changeSets.toArray(new IChangeSetHandle[changeSets.size()]), null, (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor));
            monitor.worked(75);
            this.teamRepository().itemManager().applyItemUpdates(result.getItems());
            WorkspaceManager.log("Workspace Manager setComment finished applyItemUpdates");
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IVersionableIdentifier[] getVersionableIdentifiers(IVersionableHandle[] versionableStates, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor);
        Assert.isLegal((versionableStates != null ? 1 : 0) != 0);
        IVersionableHandle[] iVersionableHandleArray = versionableStates;
        int n = versionableStates.length;
        int n2 = 0;
        while (n2 < n) {
            IVersionableHandle versionableState = iVersionableHandleArray[n2];
            Assert.isLegal((boolean)versionableState.hasStateId());
            ++n2;
        }
        return this.getServerConfigurationService().getVersionableIdentifiers(versionableStates, (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor));
    }

    @Override
    public IItemCustomAttributes[] getCustomAttributes(IVersionableHandle[] state, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor);
        Assert.isLegal((state != null ? 1 : 0) != 0);
        Assert.isLegal((state.length > 0 ? 1 : 0) != 0);
        ICustomAttributeList[] extendedPropertiesList = this.getServerConfigurationService().fetchCustomAttributesForVersionable(state, (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor));
        IItemCustomAttributes[] returnedList = new VersionableCustomAttributes[extendedPropertiesList.length];
        int i = 0;
        while (i < extendedPropertiesList.length) {
            returnedList[i] = new VersionableCustomAttributes(state[i], extendedPropertiesList[i], this);
            ++i;
        }
        return returnedList;
    }

    @Override
    public IVersionable[] findVersionablesQuery(IGenericQueryNode query, int expectedMaxResults, IProgressMonitor monitor) throws TeamRepositoryException {
        if (query == null) {
            throw new IllegalArgumentException();
        }
        if (expectedMaxResults <= 0) {
            throw new IllegalArgumentException();
        }
        monitor = SCMClientUtil.getMonitor(monitor);
        try {
            IVersionableHandle[] result = this.getScmQueryService().findVersionablesQuery(query, expectedMaxResults, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            if (result.length > 0) {
                ArrayList<IVersionable> versionablesResult = new ArrayList<IVersionable>();
                if (result.length > 2048) {
                    int fetchedStates = 0;
                    while (fetchedStates < result.length) {
                        int size = Math.min(result.length - fetchedStates, 2048);
                        IVersionableHandle[] partResult = new IVersionableHandle[size];
                        int partStates = 0;
                        while (partStates < size) {
                            partResult[partStates++] = result[fetchedStates++];
                        }
                        IVersionable[] states = this.getServerConfigurationService().fetchStates(partResult, null, null);
                        int i = 0;
                        while (i < states.length) {
                            versionablesResult.add(states[i]);
                            ++i;
                        }
                    }
                } else {
                    IVersionable[] states = this.getServerConfigurationService().fetchStates(result, null, null);
                    int i = 0;
                    while (i < states.length) {
                        versionablesResult.add(states[i]);
                        ++i;
                    }
                }
                ArrayList versionables = new ArrayList();
                expectedMaxResults -= WorkspaceManager.addToList(versionables, versionablesResult, expectedMaxResults);
                IVersionable[] iVersionableArray = Collections.unmodifiableList(versionables).toArray(new IVersionable[versionables.size()]);
                return iVersionableArray;
            }
            IVersionable[] iVersionableArray = new IVersionable[]{};
            return iVersionableArray;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void setCustomAttributes(IBaselineSetHandle snapshot, Map<String, Object> attributesToAdd, String[] attributesToRemove, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        this.ensureInitialized(monitor);
        try {
            IScmService service = this.getServerConfigurationService();
            monitor.worked(5);
            IGenericAttributes attrs = IGenericAttributes.FACTORY.newInstance(attributesToAdd);
            IBaselineSet newBaselineSet = service.setBaselineSetCustomAttributes(snapshot, attrs, attributesToRemove, null, (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor));
            monitor.worked(75);
            this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(newBaselineSet));
        }
        finally {
            monitor.done();
        }
    }

    private IWorkspaceHandle[] findWorkspaceOrStreamQuery(IGenericQueryNode query, int expectedMaxResults, IProgressMonitor monitor, WorkspaceEnum type) throws TeamRepositoryException {
        if (query == null) {
            throw new IllegalArgumentException();
        }
        if (expectedMaxResults <= 0) {
            throw new IllegalArgumentException();
        }
        monitor = SCMClientUtil.getMonitor(monitor);
        try {
            ItemQueryResult queryResult = this.getScmQueryService().findWorkspaces2(query, expectedMaxResults, type, false, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            if (queryResult.getItemHandles().size() > 0) {
                ArrayList wsResult = new ArrayList();
                wsResult.addAll(queryResult.getItemHandles());
                IWorkspaceHandle[] iWorkspaceHandleArray = Collections.unmodifiableList(wsResult).toArray(new IWorkspaceHandle[wsResult.size()]);
                return iWorkspaceHandleArray;
            }
            IWorkspaceHandle[] iWorkspaceHandleArray = new IWorkspaceHandle[]{};
            return iWorkspaceHandleArray;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IWorkspaceHandle[] findWorkspacesQuery(IGenericQueryNode query, int expectedMaxResults, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.findWorkspaceOrStreamQuery(query, expectedMaxResults, monitor, WorkspaceEnum.WORKSPACES_LITERAL);
    }

    @Override
    public IWorkspaceHandle[] findStreamsQuery(IGenericQueryNode query, int expectedMaxResults, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.findWorkspaceOrStreamQuery(query, expectedMaxResults, monitor, WorkspaceEnum.STREAMS_LITERAL);
    }

    private List<IBaseline> getBaselineList(IBaselineHandle[] handles, int size, int handleIndex, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IBaselineHandle> partResult = new ArrayList<IBaselineHandle>(size);
        int partStates = 0;
        while (partStates < size) {
            partResult.add(handles[handleIndex++]);
            ++partStates;
        }
        return this.teamRepository().itemManager().fetchCompleteItems(partResult, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
    }

    @Override
    public IBaseline[] findBaselinesQuery(IGenericQueryNode query, int expectedMaxResults, IProgressMonitor monitor) throws TeamRepositoryException {
        if (query == null) {
            throw new IllegalArgumentException();
        }
        if (expectedMaxResults <= 0) {
            throw new IllegalArgumentException();
        }
        monitor = SCMClientUtil.getMonitor(monitor);
        try {
            ItemQueryResult queryResult = this.getScmQueryService().findBaseline2(query, expectedMaxResults, false, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            int queryLength = queryResult.getItemHandles().size();
            IBaselineHandle[] fullResult = queryResult.getItemHandles().toArray(new IBaselineHandle[queryLength]);
            if (queryLength > 0) {
                ArrayList<IBaseline> blResult = new ArrayList<IBaseline>();
                if (queryLength > 2048) {
                    int fetchedStates = 0;
                    while (fetchedStates < queryLength) {
                        int size = Math.min(queryLength - fetchedStates, 2048);
                        blResult.addAll(this.getBaselineList(fullResult, size, fetchedStates, monitor));
                    }
                } else {
                    blResult.addAll(this.getBaselineList(fullResult, fullResult.length, 0, monitor));
                }
                ArrayList baselineList = new ArrayList();
                expectedMaxResults -= WorkspaceManager.addToList(baselineList, blResult, expectedMaxResults);
                IBaseline[] iBaselineArray = Collections.unmodifiableList(baselineList).toArray(new IBaseline[baselineList.size()]);
                return iBaselineArray;
            }
            IBaseline[] iBaselineArray = new IBaseline[]{};
            return iBaselineArray;
        }
        finally {
            monitor.done();
        }
    }

    private List<IBaselineSet> getSnapshotList(IBaselineSetHandle[] handles, int size, int handleIndex, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IBaselineSetHandle> partResult = new ArrayList<IBaselineSetHandle>(size);
        int partStates = 0;
        while (partStates < size) {
            partResult.add(handles[handleIndex++]);
            ++partStates;
        }
        return this.teamRepository().itemManager().fetchCompleteItems(partResult, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
    }

    @Override
    public IBaselineSet[] findSnapshotsQuery(IGenericQueryNode query, int expectedMaxResults, IProgressMonitor monitor) throws TeamRepositoryException {
        if (query == null) {
            throw new IllegalArgumentException();
        }
        if (expectedMaxResults <= 0) {
            throw new IllegalArgumentException();
        }
        monitor = SCMClientUtil.getMonitor(monitor);
        try {
            ItemQueryResult queryResult = this.getScmQueryService().findBaselineSet2(query, expectedMaxResults, false, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            int queryLength = queryResult.getItemHandles().size();
            IBaselineSetHandle[] fullResult = queryResult.getItemHandles().toArray(new IBaselineSetHandle[queryLength]);
            if (queryLength > 0) {
                ArrayList<IBaselineSet> blResult = new ArrayList<IBaselineSet>();
                if (queryLength > 2048) {
                    int fetchedStates = 0;
                    while (fetchedStates < queryLength) {
                        int size = Math.min(queryLength - fetchedStates, 2048);
                        blResult.addAll(this.getSnapshotList(fullResult, size, fetchedStates, monitor));
                    }
                } else {
                    blResult.addAll(this.getSnapshotList(fullResult, fullResult.length, 0, monitor));
                }
                ArrayList baselineList = new ArrayList();
                expectedMaxResults -= WorkspaceManager.addToList(baselineList, blResult, expectedMaxResults);
                IBaselineSet[] iBaselineSetArray = Collections.unmodifiableList(baselineList).toArray(new IBaselineSet[baselineList.size()]);
                return iBaselineSetArray;
            }
            IBaselineSet[] iBaselineSetArray = new IBaselineSet[]{};
            return iBaselineSetArray;
        }
        finally {
            monitor.done();
        }
    }

    private List<IComponent> getComponentList(IComponentHandle[] handles, int size, int handleIndex, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IComponentHandle> partResult = new ArrayList<IComponentHandle>(size);
        int partStates = 0;
        while (partStates < size) {
            partResult.add(handles[handleIndex++]);
            ++partStates;
        }
        return this.teamRepository().itemManager().fetchCompleteItems(partResult, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
    }

    @Override
    public IComponent[] findComponentsQuery(IGenericQueryNode query, int expectedMaxResults, IProgressMonitor monitor) throws TeamRepositoryException {
        if (query == null) {
            throw new IllegalArgumentException();
        }
        if (expectedMaxResults <= 0) {
            throw new IllegalArgumentException();
        }
        monitor = SCMClientUtil.getMonitor(monitor);
        try {
            ItemQueryResult queryResult = this.getScmQueryService().findComponent2(query, expectedMaxResults, false, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            int queryLength = queryResult.getItemHandles().size();
            IComponentHandle[] fullResult = queryResult.getItemHandles().toArray(new IComponentHandle[queryLength]);
            if (queryLength > 0) {
                ArrayList<IComponent> compResult = new ArrayList<IComponent>();
                if (queryLength > 2048) {
                    int fetchedStates = 0;
                    while (fetchedStates < queryLength) {
                        int size = Math.min(queryLength - fetchedStates, 2048);
                        compResult.addAll(this.getComponentList(fullResult, size, fetchedStates, monitor));
                    }
                } else {
                    compResult.addAll(this.getComponentList(fullResult, fullResult.length, 0, monitor));
                }
                ArrayList componentList = new ArrayList();
                expectedMaxResults -= WorkspaceManager.addToList(componentList, compResult, expectedMaxResults);
                IComponent[] iComponentArray = Collections.unmodifiableList(componentList).toArray(new IComponent[componentList.size()]);
                return iComponentArray;
            }
            IComponent[] iComponentArray = new IComponent[]{};
            return iComponentArray;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IWorkspaceConnection getKnownWorkspaceConnection(IItemHandle workspaceHandle) {
        for (Object connection : this.knownWorkspaceConnections()) {
            IWorkspaceConnection workspaceConnection = (IWorkspaceConnection)connection;
            if (!workspaceConnection.getContextHandle().sameItemId(workspaceHandle)) continue;
            return workspaceConnection;
        }
        return null;
    }

    @Override
    public void addBaselineSetAssociation(IBaselineSetHandle baselineSetHandle, IItemHandle itemHandle, ISynchronizationTimes[] syncTimes, IProgressMonitor monitor) throws TeamRepositoryException {
        if (baselineSetHandle == null) {
            throw new IllegalArgumentException("'baselineSetHandle' cannot be null");
        }
        if (itemHandle == null) {
            throw new IllegalArgumentException("'itemHandle' cannot be null");
        }
        IScmService scmService = this.getServerConfigurationService();
        scmService.addBaselineSetAssociation(baselineSetHandle, itemHandle, syncTimes, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
    }

    @Override
    public boolean removeBaselineSetAssociation(IBaselineSetHandle baselineSetHandle, IItemHandle itemHandle, ISynchronizationTimes[] syncTimes, IProgressMonitor monitor) throws TeamRepositoryException {
        if (baselineSetHandle == null) {
            throw new IllegalArgumentException("'baselineSetHandle' cannot be null");
        }
        if (itemHandle == null) {
            throw new IllegalArgumentException("'itemHandle' cannot be null");
        }
        IScmService scmService = this.getServerConfigurationService();
        return scmService.removeBaselineSetAssociation(baselineSetHandle, itemHandle, syncTimes, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
    }

    @Override
    public IncomingLinkDTO[] getIncomingOSLCLinks(IVersionableHandle vh, String gcURL, IProgressMonitor monitor) throws TeamRepositoryException {
        throw new RuntimeException("Use getRelatedArtifacts instead");
    }

    @Override
    public ExternalLinkEntry[] getOutgoingOSLCLinks(IVersionableHandle vh, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor);
        Assert.isLegal((vh != null && vh.hasStateId() ? 1 : 0) != 0);
        ExternalLinkEntries[] externalLinks = this.getServerConfigurationService().getLinksInternal(new IVersionableHandle[]{vh}, ExternalLinkOptions.DEFAULT, (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor));
        if (externalLinks != null && externalLinks.length > 0 && externalLinks[0] != null && externalLinks[0].isSetLinks()) {
            return externalLinks[0].getLinks().toArray(new ExternalLinkEntry[0]);
        }
        return NO_OUTGOING_LINKS;
    }

    @Override
    @Deprecated
    public ISiloedVersionablePath[] searchFilesByNamePattern(IWorkspaceHandle workspace, IComponentHandle[] componentList, String namePattern, boolean caseSensitive, int maxResult, ISynchronizationTimes[] syncTimes, IProgressMonitor monitor) throws TeamRepositoryException {
        IScmService scmService = this.getServerConfigurationService();
        ISiloedVersionablePath[] siloedVersionablePathList = scmService.searchWorkspaceForFileByNamePattern(workspace, componentList, namePattern, caseSensitive, maxResult, syncTimes, (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor));
        return siloedVersionablePathList;
    }

    @Override
    public IHistoryReferenceDescription getHistoryDescription(IHistoryReference historyReference, IComponentHandle[] filter, IProgressMonitor monitor) throws TeamRepositoryException {
        if (filter == null) {
            filter = new IComponentHandle[]{};
        }
        return this.getServerConfigurationService().getHistoryDescription(historyReference, filter, (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor));
    }

    @Override
    public String[] getDefinedCustomAttributeIdentifiers(IProjectAreaHandle projectArea, int type, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            this.ensureInitialized((IProgressMonitor)sm.newChild(5));
            String[] stringArray = this.getServerConfigurationService().getDefinedCustomAttributeIdentifiers(projectArea, type, (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor));
            return stringArray;
        }
        finally {
            sm.done();
        }
    }

    @Override
    public IBaselineSetHierarchyResult getBaselineSetHierarchy(IBaselineSetHandle snapshot, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getServerConfigurationService().getBaselineSetHierarchy(snapshot, (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor));
    }

    @Override
    public void setChangeSetCustomAttributes(IChangeSetHandle changeset, Map<String, Object> attributesToAdd, String[] attributesToRemove, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            this.ensureInitialized(monitor);
            if (changeset == null) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.getServerConfigurationService();
            monitor.worked(5);
            IGenericAttributes attrs = IGenericAttributes.FACTORY.newInstance(attributesToAdd);
            IChangeSet updatedChangeset = service.setChangeSetCustomAttributes(changeset, attrs, attributesToRemove, null, (IRepositoryProgressMonitorHandle)this.getRepoMonitor(monitor));
            monitor.worked(80);
            this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(updatedChangeset));
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public ISiloedVersionablePathResult searchFiles(IFileSearchCriteria criteria, IQueryPageDescriptor pageDescriptor, ISynchronizationTimes[] syncTimes, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getScmQueryService().searchFiles(criteria, pageDescriptor, syncTimes, (IRepositoryProgressMonitorHandle)SCMClientUtil.monitorFor(monitor));
    }

    static class LockOperation
    implements IWorkspaceManager.IVersionableLockOperation {
        public final OperationKind kind;
        public final IVersionableHandle versionable;
        public final IComponentHandle component;
        public final IWorkspaceConnection stream;
        public final IContributorHandle contributor;
        public final boolean force;

        public LockOperation(OperationKind kind, IWorkspaceConnection stream, IComponentHandle component, IVersionableHandle versionable, IContributorHandle contributor, boolean force) {
            this.kind = kind;
            this.stream = stream;
            this.component = component;
            this.versionable = versionable;
            this.contributor = contributor;
            this.force = force;
        }

        public boolean isStreamOrComponentLock() {
            return this.stream != null && this.versionable == null;
        }

        public boolean isStreamLock() {
            return this.stream != null && this.component == null && this.versionable == null;
        }
    }

    public static class LockOperationFactory
    implements IWorkspaceManager.IVersionableLockOperationFactory {
        private void checkStream(IWorkspaceConnection stream) {
            if (stream == null || !stream.isStream()) {
                throw new IllegalArgumentException();
            }
        }

        private void check(IItemHandle item) {
            if (item == null) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public IWorkspaceManager.IVersionableLockOperation acquire(IVersionableHandle versionable, IWorkspaceConnection stream, IComponentHandle component) {
            this.checkStream(stream);
            this.check((IItemHandle)component);
            this.check((IItemHandle)versionable);
            return new LockOperation(OperationKind.LOCK, stream, component, versionable, null, false);
        }

        @Override
        public IWorkspaceManager.IVersionableLockOperation acquireSubtree(IFolderHandle versionable, IWorkspaceConnection stream, IComponentHandle component) {
            this.checkStream(stream);
            this.check((IItemHandle)component);
            this.check((IItemHandle)versionable);
            return new LockOperation(OperationKind.LOCK_SUBTREE, stream, component, (IVersionableHandle)versionable, null, false);
        }

        @Override
        public IWorkspaceManager.IVersionableLockOperation release(IVersionableHandle versionable, IWorkspaceConnection stream, IComponentHandle component, boolean force) {
            this.checkStream(stream);
            this.check((IItemHandle)component);
            this.check((IItemHandle)versionable);
            return new LockOperation(OperationKind.UNLOCK, stream, component, versionable, null, force);
        }

        @Override
        public IWorkspaceManager.IVersionableLockOperation releaseSubtree(IFolderHandle versionable, IWorkspaceConnection stream, IComponentHandle component) {
            this.checkStream(stream);
            this.check((IItemHandle)component);
            this.check((IItemHandle)versionable);
            return new LockOperation(OperationKind.UNLOCK_SUBTREE, stream, component, (IVersionableHandle)versionable, null, false);
        }

        @Override
        public IWorkspaceManager.IVersionableLockOperation transfer(IVersionableHandle versionable, IWorkspaceConnection stream, IComponentHandle component, IContributorHandle contributor) {
            this.checkStream(stream);
            this.check((IItemHandle)component);
            this.check((IItemHandle)versionable);
            this.check((IItemHandle)contributor);
            return new LockOperation(OperationKind.TRANSFER, stream, component, versionable, contributor, false);
        }

        @Override
        public IWorkspaceManager.IVersionableLockOperation acquireStream(IWorkspaceConnection stream) {
            this.checkStream(stream);
            return new LockOperation(OperationKind.LOCK, stream, null, null, null, false);
        }

        @Override
        public IWorkspaceManager.IVersionableLockOperation releaseStream(IWorkspaceConnection stream) {
            this.checkStream(stream);
            return new LockOperation(OperationKind.UNLOCK, stream, null, null, null, false);
        }

        @Override
        public IWorkspaceManager.IVersionableLockOperation acquireComponent(IWorkspaceConnection stream, IComponentHandle component) {
            this.checkStream(stream);
            this.check((IItemHandle)component);
            return new LockOperation(OperationKind.LOCK, stream, component, null, null, false);
        }

        @Override
        public IWorkspaceManager.IVersionableLockOperation releaseComponent(IWorkspaceConnection stream, IComponentHandle component) {
            this.checkStream(stream);
            this.check((IItemHandle)component);
            return new LockOperation(OperationKind.UNLOCK, stream, component, null, null, false);
        }
    }

    public static enum OperationKind {
        LOCK,
        LOCK_SUBTREE,
        UNLOCK,
        UNLOCK_SUBTREE,
        TRANSFER;

    }
}

