/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;

public class StateLocator<T extends IItem> {
    private ITeamRepository repo;
    private UUID itemId;
    private UUID stateId;
    private IItemType itemType;

    public StateLocator(ITeamRepository repo, IItemType itemType, UUID itemId, UUID stateId) {
        this.repo = repo;
        this.itemId = itemId;
        this.stateId = stateId;
        this.itemType = itemType;
    }

    public ITeamRepository getRepository() {
        return this.repo;
    }

    public UUID getItemUUID() {
        return this.itemId;
    }

    public UUID getStateUUID() {
        return this.stateId;
    }

    public IItemType getItemType() {
        return this.itemType;
    }

    public ItemId<T> getItemId() {
        return new ItemId(this.itemType, this.itemId);
    }

    public StateId<T> getStateId() {
        return new StateId(this.itemType, this.itemId, this.stateId);
    }

    public static <K extends IItem, T extends K> StateLocator<K> upcast(StateLocator<T> toConvert) {
        return toConvert;
    }

    public <K extends IItemHandle> K toHandle() {
        if (this.stateId.equals((Object)StateId.STATE_DELETED)) {
            return null;
        }
        IItemHandle result = this.itemType.createItemHandle((Object)this.repo, this.itemId, this.stateId);
        return (K)result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.itemId == null ? 0 : this.itemId.hashCode());
        result = 31 * result + (this.itemType == null ? 0 : this.itemType.hashCode());
        result = 31 * result + (this.repo == null ? 0 : this.repo.hashCode());
        result = 31 * result + (this.stateId == null ? 0 : this.stateId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StateLocator other = (StateLocator)obj;
        if (this.itemId == null ? other.itemId != null : !this.itemId.equals((Object)other.itemId)) {
            return false;
        }
        if (this.itemType == null ? other.itemType != null : !this.itemType.equals(other.itemType)) {
            return false;
        }
        if (this.repo == null ? other.repo != null : !this.repo.equals(other.repo)) {
            return false;
        }
        return !(this.stateId == null ? other.stateId != null : !this.stateId.equals((Object)other.stateId));
    }

    public static <T extends IItem> StateLocator<T> create(ITeamRepository repository, StateId<T> stateId) {
        return new StateLocator<T>(repository, stateId.getItemType(), stateId.getItemUUID(), stateId.getStateUUID());
    }
}

