/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.TeamServiceException;
import com.ibm.team.scm.client.internal.Messages;
import com.ibm.team.scm.client.internal.ScmClientLibraryContext;
import com.ibm.team.scm.client.internal.ScmProgressMonitorUpdateJob;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import com.ibm.team.scm.common.IRepositoryProgressMonitorHandle;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.UpdatesTeamAdvisorView;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.SocketTimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

class ScmServiceInterfaceProxy
implements InvocationHandler {
    private final Object delegate;
    private final IClientLibraryContext context;
    private IProcessClientService process;
    private IProgressMonitor monitor = new NullProgressMonitor();

    static Object newServiceInterfaceProxy(Class<?> interfaceClass, Object serviceImplementation, IClientLibraryContext context) {
        return Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new ScmServiceInterfaceProxy(serviceImplementation, context));
    }

    protected ScmServiceInterfaceProxy(Object delegate, IClientLibraryContext context) {
        this.delegate = delegate;
        this.context = context;
        this.process = (IProcessClientService)context.teamRepository().getClientLibrary(IProcessClientService.class);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean calledByTeamAdvisorView = this.calledByTeamAdvisorView(method);
        try {
            IRepositoryProgressMonitor monitor = ScmClientLibraryContext.requiresProgressReporting(method, args);
            Object returnVal = null;
            returnVal = monitor != null ? this.invokeCancelableService(method, args, monitor) : method.invoke(this.delegate, args);
            if (!calledByTeamAdvisorView && method.isAnnotationPresent(UpdatesTeamAdvisorView.class)) {
                this.notifyProcess(null, method);
            }
            return returnVal;
        }
        catch (Throwable e) {
            TeamRepositoryException tre = null;
            if (e instanceof TeamRepositoryException) {
                tre = (TeamRepositoryException)e;
            } else {
                Throwable cause = e.getCause();
                if (cause instanceof TeamRepositoryException) {
                    tre = (TeamRepositoryException)cause;
                }
            }
            if (tre != null) {
                if (!calledByTeamAdvisorView && (tre instanceof TeamOperationCanceledException || tre instanceof PermissionDeniedException)) {
                    this.notifyProcess(tre, method);
                }
                throw tre;
            }
            if (e instanceof InvocationTargetException) {
                e = e.getCause();
            }
            throw e;
        }
    }

    private void notifyProcess(final Throwable cause, final Method method) {
        try {
            this.process.execute(new ProcessRunnable(){

                public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                    if (cause == null) {
                        return null;
                    }
                    throw (TeamRepositoryException)cause;
                }

                public String getOperationIdentifier() {
                    return String.valueOf(method.getDeclaringClass().getName()) + "#" + method.getName();
                }

                public boolean equals(Object obj) {
                    if (obj instanceof ProcessRunnable) {
                        return this.getOperationIdentifier().equals(((ProcessRunnable)obj).getOperationIdentifier());
                    }
                    return super.equals(obj);
                }
            }, Messages.ScmServiceInterfaceProxy_0, this.monitor);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
    }

    private Object invokeCancelableService(final Method method, final Object[] args, final IRepositoryProgressMonitor repositoryMonitor) throws TeamRepositoryException {
        try {
            final IProgressMonitor jobProgressMonitor = repositoryMonitor.getWrappedMonitor();
            Object retVal = this.context.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

                public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                    try {
                        ScmServiceInterfaceProxy.this.startPollingForMessages(ScmServiceInterfaceProxy.this.context.teamRepository(), (IRepositoryProgressMonitorHandle)repositoryMonitor, jobProgressMonitor);
                        Object object = method.invoke(ScmServiceInterfaceProxy.this.delegate, args);
                        return object;
                    }
                    catch (Throwable e) {
                        Throwable cause = e.getCause();
                        if (cause != null && cause instanceof TeamRepositoryException) {
                            Throwable subCause;
                            if (cause instanceof TeamServiceException && (subCause = cause.getCause()) != null && subCause instanceof SocketTimeoutException) {
                                ScmServiceInterfaceProxy.this.handleCancelled(repositoryMonitor);
                            }
                            throw (TeamRepositoryException)cause;
                        }
                        if (cause instanceof RuntimeException) {
                            throw (RuntimeException)cause;
                        }
                        throw new TeamRepositoryException(cause);
                    }
                    finally {
                        ScmServiceInterfaceProxy.this.stopPollingForMessages(ScmServiceInterfaceProxy.this.context.teamRepository(), (IRepositoryProgressMonitorHandle)repositoryMonitor);
                    }
                }
            }, jobProgressMonitor);
            return retVal;
        }
        catch (OperationCanceledException cause) {
            this.handleCancelled(repositoryMonitor);
            throw cause;
        }
    }

    protected void startPollingForMessages(ITeamRepository repository, IRepositoryProgressMonitorHandle repositoryMonitor, IProgressMonitor jobProgressMonitor) {
        ScmProgressMonitorUpdateJob.startPollingForMessages(repository, repositoryMonitor, jobProgressMonitor);
    }

    protected void stopPollingForMessages(ITeamRepository repository, IRepositoryProgressMonitorHandle repositoryMonitor) {
        ScmProgressMonitorUpdateJob.stopPollingForMessages(repository, repositoryMonitor);
    }

    private boolean calledByTeamAdvisorView(Method method) {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        int i = 0;
        while (i < elements.length) {
            StackTraceElement stackTraceElement = elements[i];
            if (stackTraceElement.getClassName().equals("OperationAdviceManager") || stackTraceElement.getClassName().startsWith("TeamAdvisorView")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void handleCancelled(final IRepositoryProgressMonitor repositoryMonitor) {
        ITeamRepository repo = this.context.teamRepository();
        int errorState = repo.getErrorState();
        if (errorState == 0 && this.context.teamRepository().loggedIn()) {
            Job tellServerToCancel = new Job(Messages.ScmServiceInterfaceProxy_1){

                protected IStatus run(IProgressMonitor arg0) {
                    try {
                        repositoryMonitor.setCancelled(true);
                        ScmServiceInterfaceProxy.this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

                            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                                IScmService scm = (IScmService)ScmServiceInterfaceProxy.this.context.getServiceInterface(IScmService.class);
                                scm.saveProgress(repositoryMonitor);
                                return null;
                            }
                        }, arg0);
                        return Status.OK_STATUS;
                    }
                    catch (NotLoggedInException e) {
                        return Status.OK_STATUS;
                    }
                    catch (TeamRepositoryException e) {
                        return new Status(1, "com.ibm.team.scm.common", Messages.ScmServiceInterfaceProxy_2, (Throwable)e);
                    }
                }
            };
            tellServerToCancel.setSystem(true);
            tellServerToCancel.setPriority(50);
            tellServerToCancel.schedule();
        }
    }
}

