/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.internal.Messages;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import com.ibm.team.scm.common.IRepositoryProgressMonitorHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class ScmProgressMonitorUpdateJob
extends Job {
    private static final long MINIUMUM_DELAY = 10000L;
    private static final long EXPIRY_INTERNAL = 18000000L;
    private static final ScmProgressMonitorUpdateJob instance = new ScmProgressMonitorUpdateJob();
    private final Map<UUID, Map<UUID, Monitor>> monitors = new HashMap<UUID, Map<UUID, Monitor>>();

    static {
        instance.setSystem(true);
    }

    public static void startPollingForMessages(ITeamRepository repository, IRepositoryProgressMonitorHandle repositoryMonitor, IProgressMonitor jobProgressMonitor) {
        ScmProgressMonitorUpdateJob job = ScmProgressMonitorUpdateJob.getInstance();
        job.pollForMessages(repository, repositoryMonitor, jobProgressMonitor);
    }

    public static void stopPollingForMessages(ITeamRepository repository, IRepositoryProgressMonitorHandle repositoryMonitor) {
        ScmProgressMonitorUpdateJob job = ScmProgressMonitorUpdateJob.getInstance();
        job.stopPolling(repository, repositoryMonitor);
    }

    private static ScmProgressMonitorUpdateJob getInstance() {
        return instance;
    }

    public ScmProgressMonitorUpdateJob() {
        super(Messages.ScmProgressMonitorUpdateJob_0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        ScmProgressMonitorUpdateJob scmProgressMonitorUpdateJob;
        IStatus iStatus;
        try {
            iStatus = this.updateMonitors(monitor);
            scmProgressMonitorUpdateJob = this;
        }
        catch (Throwable throwable) {
            ScmProgressMonitorUpdateJob scmProgressMonitorUpdateJob2 = this;
            synchronized (scmProgressMonitorUpdateJob2) {
                long currentTimeMillis = System.currentTimeMillis();
                long delay = -1L;
                for (Map<UUID, Monitor> map : this.monitors.values()) {
                    for (Monitor m : map.values()) {
                        if (m.isExpired()) continue;
                        long d = m.setLastChecked(currentTimeMillis);
                        if (delay == -1L) {
                            delay = d;
                            continue;
                        }
                        if (d >= delay) continue;
                        delay = d;
                    }
                }
                if (delay > 0L) {
                    this.schedule(delay);
                }
            }
        }
        synchronized (scmProgressMonitorUpdateJob) {
            long currentTimeMillis = System.currentTimeMillis();
            long delay = -1L;
            for (Map<UUID, Monitor> map : this.monitors.values()) {
                for (Monitor m : map.values()) {
                    if (m.isExpired()) continue;
                    long d = m.setLastChecked(currentTimeMillis);
                    if (delay == -1L) {
                        delay = d;
                        continue;
                    }
                    if (d >= delay) continue;
                    delay = d;
                }
            }
            if (delay > 0L) {
                this.schedule(delay);
            }
        }
        return iStatus;
        throw throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus updateMonitors(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Collection<ITeamRepository> repositories = this.getRepositories();
        progress.setWorkRemaining(repositories.size());
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (ITeamRepository repository : repositories) {
            try {
                Map<UUID, Monitor> monitors = this.getMonitors(repository);
                List<IRepositoryProgressMonitor> rpms = this.fetchMonitors(repository, this.getHandles(monitors), (IProgressMonitor)progress.newChild(1));
                for (IRepositoryProgressMonitor rpm : rpms) {
                    Monitor m;
                    if (rpm == null || (m = monitors.get(rpm.getItemId())) == null) continue;
                    m.update(rpm);
                }
            }
            catch (OperationCanceledException e) {
                this.schedule();
                throw e;
            }
            catch (Exception e) {
                exceptions.add(e);
                ScmProgressMonitorUpdateJob scmProgressMonitorUpdateJob = this;
                synchronized (scmProgressMonitorUpdateJob) {
                    this.monitors.remove(repository.getId());
                }
            }
        }
        if (exceptions.isEmpty()) {
            return Status.OK_STATUS;
        }
        if (exceptions.size() == 1) {
            return this.getStatusFor((Exception)exceptions.get(0));
        }
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        for (Exception exception : exceptions) {
            statuses.add(this.getStatusFor(exception));
        }
        return new MultiStatus("com.ibm.team.scm.client", 0, statuses.toArray(new IStatus[statuses.size()]), "Multiple errors occurred update the progress for repository operations", null);
    }

    private IStatus getStatusFor(Exception e) {
        return new Status(4, "com.ibm.team.scm.client", "An error occurred updating a progress monitor for a repository operation", (Throwable)e);
    }

    private synchronized Map<UUID, Monitor> getMonitors(ITeamRepository repository) {
        HashMap<UUID, Monitor> result = new HashMap<UUID, Monitor>();
        Map<UUID, Monitor> map = this.monitors.get(repository.getId());
        if (map != null) {
            for (Monitor monitor : map.values()) {
                result.put(monitor.getRepositoryMonitorHandle().getItemId(), monitor);
            }
        }
        return result;
    }

    private List<IRepositoryProgressMonitorHandle> getHandles(Map<UUID, Monitor> monitors) {
        ArrayList<IRepositoryProgressMonitorHandle> handles = new ArrayList<IRepositoryProgressMonitorHandle>();
        for (Monitor monitor : monitors.values()) {
            if (monitor.isExpired()) continue;
            handles.add(monitor.getRepositoryMonitorHandle());
        }
        return handles;
    }

    private synchronized Collection<ITeamRepository> getRepositories() {
        HashSet<ITeamRepository> repos = new HashSet<ITeamRepository>();
        for (Map<UUID, Monitor> map : this.monitors.values()) {
            Iterator<Monitor> values = map.values().iterator();
            if (!values.hasNext()) continue;
            repos.add(values.next().getTeamRepository());
        }
        return repos;
    }

    private List<IRepositoryProgressMonitor> fetchMonitors(ITeamRepository repository, List<IRepositoryProgressMonitorHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        if (handles.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return repository.itemManager().fetchCompleteItems(handles, 1, monitor);
    }

    private synchronized void pollForMessages(ITeamRepository repository, IRepositoryProgressMonitorHandle repositoryMonitor, IProgressMonitor jobProgressMonitor) {
        Map<UUID, Monitor> map = this.monitors.get(repository.getId());
        if (map == null) {
            map = new HashMap<UUID, Monitor>();
            this.monitors.put(repository.getId(), map);
        }
        map.put(repositoryMonitor.getItemId(), new Monitor(repository, repositoryMonitor, jobProgressMonitor));
        this.schedule(10000L);
    }

    private synchronized void stopPolling(ITeamRepository repository, IRepositoryProgressMonitorHandle repositoryMonitor) {
        Map<UUID, Monitor> map = this.monitors.get(repository.getId());
        if (map != null) {
            map.remove(repositoryMonitor.getItemId());
            if (map.isEmpty()) {
                this.monitors.remove(repository.getId());
            }
        }
        if (this.monitors.isEmpty()) {
            this.cancel();
        }
    }

    public synchronized boolean shouldRun() {
        return !this.monitors.isEmpty();
    }

    private static class Monitor {
        private final ITeamRepository repository;
        private final IRepositoryProgressMonitorHandle repositoryMonitor;
        private final IProgressMonitor jobProgressMonitor;
        private long lastCheckTime;
        private int checkCount;
        private long creationTime;
        private String lastMessage;
        private long delay;

        public Monitor(ITeamRepository repository, IRepositoryProgressMonitorHandle repositoryMonitor, IProgressMonitor jobProgressMonitor) {
            this.repository = repository;
            this.repositoryMonitor = repositoryMonitor;
            this.jobProgressMonitor = jobProgressMonitor;
            this.creationTime = System.currentTimeMillis();
            this.delay = 10000L;
        }

        public ITeamRepository getTeamRepository() {
            return this.repository;
        }

        public IRepositoryProgressMonitorHandle getRepositoryMonitorHandle() {
            return this.repositoryMonitor;
        }

        public IProgressMonitor getProgressMonitor() {
            return this.jobProgressMonitor;
        }

        public void update(IRepositoryProgressMonitor rpm) {
            String message = rpm.getMessage();
            if (this.lastMessage == null || !this.lastMessage.equals(message)) {
                this.lastMessage = message;
                String name = this.repository.getName() == null ? this.repository.getRepositoryURI() : this.repository.getName();
                this.getProgressMonitor().subTask(NLS.bind((String)Messages.ScmProgressMonitorUpdateJob_1, (Object)name, (Object)message));
                this.delay = Math.max(10000L, this.delay / 2L);
            } else {
                this.delay *= 2L;
            }
        }

        public long setLastChecked(long currentTimeMillis) {
            this.lastCheckTime = currentTimeMillis;
            ++this.checkCount;
            if (this.lastMessage == null) {
                this.delay *= 2L;
            }
            return this.delay;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this.creationTime + 18000000L;
        }
    }
}

