/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.internal.client.ProcessClientService;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorRecord;
import com.ibm.team.repository.common.IContributorUserId;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.query.BaseContributorRecordQueryModel;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ScmContributorUtil {
    public static final int MAX_SIZE = 1024;
    public static final int FLAG_INCLUDE_BOTH_USERS = 0;
    public static final int FLAG_INCLUDE_USERS_WITH_USERIDS = 1;
    public static final int FLAG_INCLUDE_USERS_WITHOUT_USERIDS = 2;

    public static List fetchContributors(ITeamRepository repository, int userIdFilter, int maxResultSize, IProgressMonitor monitor) throws TeamRepositoryException {
        IItemQuery query = ScmContributorUtil.createContributors(userIdFilter, maxResultSize);
        return ScmContributorUtil.queryItems(query, repository, monitor);
    }

    private static IItemQuery createContributors(int userIdFilter, int maxResultSize) {
        BaseContributorRecordQueryModel.ContributorRecordQueryModel model = BaseContributorRecordQueryModel.ContributorRecordQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
        query.orderByAsc((IField)model.name());
        if (userIdFilter == 2) {
            IPredicate noUserId = model.userIds()._isEmpty();
            query.filter(noUserId);
        } else if (userIdFilter == 1) {
            IPredicate userId = model.userIds()._isEmpty()._not();
            query.filter(userId);
        }
        query.setResultLimit(maxResultSize);
        return query;
    }

    private static List queryItems(IItemQuery query, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)((query.getResultLimit() / 1024 + 1) * 2));
        try {
            UUID repoID = teamRepository.getId();
            if (repoID == null || !teamRepository.loggedIn() || teamRepository.getErrorState() != 0) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            ArrayList allItems = new ArrayList();
            int pageSize = 1024;
            ProcessClientService processService = (ProcessClientService)teamRepository.getClientLibrary(IProcessItemService.class);
            IItemQueryPage page = processService.queryItems(query, IQueryService.EMPTY_PARAMETERS, pageSize, (IProgressMonitor)progress.newChild(1));
            if (page.getResultSize() > 0) {
                List items = teamRepository.itemManager().fetchCompleteItems(page.getItemHandles(), 0, (IProgressMonitor)progress.newChild(1));
                allItems.addAll(items);
                while (page.hasNext()) {
                    UUID token = page.getToken();
                    int nextStartPosition = page.getNextStartPosition();
                    page = (IItemQueryPage)processService.fetchPage(token, nextStartPosition, pageSize, (IProgressMonitor)progress.newChild(1));
                    items = teamRepository.itemManager().fetchCompleteItems(page.getItemHandles(), 0, (IProgressMonitor)progress.newChild(1));
                    allItems.addAll(items);
                }
            }
            ArrayList arrayList = allItems;
            return arrayList;
        }
        finally {
            progress.done();
        }
    }

    public static void setUserId(ITeamRepository teamRepository, IContributorRecord contributor, String newUserId, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        Assert.isTrue((boolean)contributor.getUserIds().isEmpty());
        contributor = (IContributorRecord)contributor.getWorkingCopy();
        contributor.getUserIds().add(IContributorUserId.FACTORY.create(newUserId));
        teamRepository.contributorManager().updateContributorRecords(Collections.singletonList(contributor), Collections.EMPTY_LIST, (IProgressMonitor)progress);
    }
}

