/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.WorkspaceManager;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import com.ibm.team.scm.common.IRepositoryProgressMonitorHandle;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.RelatedArtifacts;
import com.ibm.team.scm.common.internal.dto2.RelatedArtifactsDTO;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.StateId;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public final class RelatedArtifactsUtils {
    private RelatedArtifactsUtils() {
        throw new RuntimeException("Do not create instances of " + this.getClass().getName());
    }

    public static Map<StateId<IVersionable>, RelatedArtifacts> getRelatedArtifacts(Collection<IVersionableHandle> itemStateHandles, URI gcUri, String[] options, ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)repo);
        IScmService scmService = RelatedArtifactsUtils.getScmService(repo);
        return RelatedArtifactsUtils.getRelatedArtifacts(itemStateHandles, gcUri, options, scmService, monitor);
    }

    private static Map<StateId<IVersionable>, RelatedArtifacts> getRelatedArtifacts(Collection<IVersionableHandle> itemStateHandles, URI gcUri, String[] options, IScmService scmService, IProgressMonitor progress) throws TeamRepositoryException {
        if (itemStateHandles == null || itemStateHandles.isEmpty()) {
            return Collections.emptyMap();
        }
        RelatedArtifactsUtils.assertStateHandlesValid(itemStateHandles);
        Assert.isNotNull((Object)options);
        Assert.isNotNull((Object)scmService);
        IVersionableHandle[] stateHandleArg = itemStateHandles.toArray(new IVersionableHandle[itemStateHandles.size()]);
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)1);
        IRepositoryProgressMonitor progressMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)monitor.newChild(1));
        RelatedArtifactsDTO[] serviceResult = scmService.getRelatedArtifacts(stateHandleArg, gcUri.toString(), options, (IRepositoryProgressMonitorHandle)progressMonitor);
        Map result = NewCollection.hashMap((int)(itemStateHandles.size() * 2));
        int i = 0;
        RelatedArtifactsDTO[] relatedArtifactsDTOArray = serviceResult;
        int n = serviceResult.length;
        int n2 = 0;
        while (n2 < n) {
            RelatedArtifactsDTO dto = relatedArtifactsDTOArray[n2];
            StateId stateId = new StateId((IItemHandle)stateHandleArg[i++]);
            RelatedArtifacts artifacts = RelatedArtifacts.create((RelatedArtifactsDTO)dto);
            result.put(stateId, artifacts);
            ++n2;
        }
        return result;
    }

    private static void assertStateHandlesValid(Collection<IVersionableHandle> itemStateHandles) {
        for (IVersionableHandle h : itemStateHandles) {
            if (h == null) continue;
            Assert.isLegal((boolean)h.hasStateId());
        }
    }

    private static IScmService getScmService(ITeamRepository repo) throws TeamRepositoryException {
        WorkspaceManager wm = (WorkspaceManager)SCMPlatform.getWorkspaceManager(repo);
        return wm.getServerConfigurationService();
    }
}

