/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IItemCustomAttributes;
import com.ibm.team.scm.common.dto.ICustomAttributeList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class ItemCustomAttributes
implements IItemCustomAttributes {
    protected final ICustomAttributeList extendedAttrs;

    protected ItemCustomAttributes(ICustomAttributeList extendedAttrs) {
        this.extendedAttrs = extendedAttrs;
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.extendedAttrs.getAttributes().keySet();
    }

    @Override
    public String getAttributeValue(String attrName) {
        Map attrMap = this.extendedAttrs.getAttributes();
        if (attrMap.containsKey(attrName)) {
            return (String)attrMap.get(attrName);
        }
        return null;
    }

    @Override
    public void setAttributes(Map<String, Object> newAttrMap) {
        Map attrMap = this.extendedAttrs.getAttributes();
        for (Map.Entry<String, Object> entry : newAttrMap.entrySet()) {
            if (entry.getValue() instanceof String) {
                attrMap.put(entry.getKey(), (String)entry.getValue());
                continue;
            }
            attrMap.put(entry.getKey(), entry.getValue().toString());
        }
        this.extendedAttrs.setAttributes(attrMap);
    }

    @Override
    public void setStringAttributes(Map<String, String> newAttrMap) {
        Map attrMap = this.extendedAttrs.getAttributes();
        attrMap.putAll(newAttrMap);
        this.extendedAttrs.setAttributes(attrMap);
    }

    @Override
    public void removeAttributes(Set<String> attrNames) {
        Map attrMap = this.extendedAttrs.getAttributes();
        for (String attrName : attrNames) {
            if (!attrMap.containsKey(attrName)) continue;
            attrMap.remove(attrName);
        }
        this.extendedAttrs.setAttributes(attrMap);
    }

    @Override
    public abstract void saveCustomAttributes(IProgressMonitor var1) throws TeamRepositoryException;
}

