/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.ConnectionDescriptor;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.internal.flow.FlowTable;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class FlowUtils {
    public static List<IFlowNodeConnection.IComponentOp> getAcceptComponentSynchronizationOps(boolean workspaceContext, Collection<? extends IComponentHandle> components, IWorkspaceConnection source, IWorkspaceConnection target, IChangeHistorySyncReport report) throws TeamRepositoryException {
        List remoteComponents = ItemLists.handlesToIds((Collection)report.remoteComponents());
        List localComponents = ItemLists.handlesToIds((Collection)report.localComponents());
        HashSet affectedComponents = new HashSet();
        affectedComponents.addAll(ItemLists.handlesToIds(components));
        if (workspaceContext) {
            affectedComponents.addAll(ItemLists.handlesToIds((Collection)source.getComponents()));
        }
        ArrayList<IFlowNodeConnection.IComponentOp> componentOps = new ArrayList<IFlowNodeConnection.IComponentOp>();
        for (ItemId componentId : affectedComponents) {
            boolean existsLocal = localComponents.contains(componentId);
            boolean existsRemote = remoteComponents.contains(componentId);
            if (existsLocal && existsRemote) continue;
            IComponentHandle componentHandle = (IComponentHandle)componentId.toHandle();
            boolean hasFlow = FlowUtils.hasComponentSyncState(componentHandle, target, source);
            IFlowNodeConnection.IComponentOp op = null;
            if (existsLocal && !existsRemote) {
                if (hasFlow) {
                    op = target.componentOpFactory().removeComponent(componentHandle, false);
                }
            } else if (!existsLocal && existsRemote && !hasFlow) {
                op = target.componentOpFactory().addComponent(componentHandle, source, false);
            }
            if (op == null) continue;
            componentOps.add(op);
        }
        return componentOps;
    }

    public static boolean hasComponentSyncState(IComponentHandle component, IWorkspaceConnection source, IWorkspaceConnection target) {
        IFlowTable flowTable = source.getFlowTable();
        IWorkspace targetWorkspaceHandle = target.getResolvedWorkspace();
        List componentHandles = FlowUtils.getComponentsSyncState(flowTable, (IWorkspaceHandle)targetWorkspaceHandle);
        for (IComponentHandle componentHandle : componentHandles) {
            if (!component.sameItemId((IItemHandle)componentHandle)) continue;
            return true;
        }
        return false;
    }

    public static List getComponentsSyncState(IFlowTable flowTable, IWorkspaceHandle target) {
        IFlowEntry entry = FlowUtils.getDeliverFlow(flowTable, target);
        return entry == null ? Collections.EMPTY_LIST : entry.getComponentScopes();
    }

    private static IFlowEntry getDeliverFlow(IFlowTable flowTable, IWorkspaceHandle target) {
        return ((FlowTable)flowTable).getDeliverFlow((IFlowNodeHandle)target, true);
    }

    public static void addComponentSyncState(IWorkspaceConnection sourceConnection, IConnection targetConnection, IComponentHandle component, IProgressMonitor monitor) throws TeamRepositoryException {
        FlowUtils.addComponentSyncStates(sourceConnection, targetConnection, Arrays.asList(component), monitor);
    }

    public static void addComponentSyncStates(IWorkspaceConnection sourceConnection, IConnection targetConnection, List<IComponentHandle> components, IProgressMonitor monitor) throws TeamRepositoryException {
        if (targetConnection instanceof IBaselineConnection) {
            return;
        }
        IWorkspaceConnection target = (IWorkspaceConnection)targetConnection;
        IFlowTable flowTable = sourceConnection.getFlowTable().getWorkingCopy();
        IWorkspaceHandle targetWorkspace = (IWorkspaceHandle)target.getResolvedWorkspace().getItemHandle();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean addedSyncState = false;
        for (IComponentHandle component : components) {
            if (FlowUtils.hasComponentSyncState(component, sourceConnection, target)) continue;
            FlowUtils.addComponentSyncState(flowTable, targetWorkspace, component);
            addedSyncState = true;
        }
        if (addedSyncState) {
            sourceConnection.setFlowTable(flowTable, (IProgressMonitor)progress.newChild(100));
        }
        progress.done();
    }

    private static void addComponentSyncState(IFlowTable flowTable, IWorkspaceHandle target, IComponentHandle componentToAdd) {
        IFlowEntry flowEntry = FlowUtils.getDeliverFlow(flowTable, target);
        if (flowEntry == null) {
            throw new IllegalStateException("Flow table does not contain entry");
        }
        flowEntry.addComponent(componentToAdd);
    }

    public static void removeComponentSyncState(IWorkspaceConnection sourceConnection, IConnection targetConnection, IComponentHandle component, IProgressMonitor monitor) throws TeamRepositoryException {
        FlowUtils.removeComponentSyncStates(sourceConnection, targetConnection, Arrays.asList(component), monitor);
    }

    public static void removeComponentSyncStates(IWorkspaceConnection sourceConnection, IConnection targetConnection, List<IComponentHandle> components, IProgressMonitor monitor) throws TeamRepositoryException {
        if (targetConnection instanceof IBaselineConnection) {
            return;
        }
        IWorkspaceConnection target = (IWorkspaceConnection)targetConnection;
        IFlowTable flowTable = sourceConnection.getFlowTable().getWorkingCopy();
        IWorkspaceHandle targetWorkspace = (IWorkspaceHandle)target.getResolvedWorkspace().getItemHandle();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        for (IComponentHandle component : components) {
            FlowUtils.removeComponentSyncState(flowTable, targetWorkspace, component);
        }
        sourceConnection.setFlowTable(flowTable, (IProgressMonitor)progress.newChild(100));
    }

    private static void removeComponentSyncState(IFlowTable flowTable, IWorkspaceHandle target, IComponentHandle componentToRemove) {
        IFlowEntry flowEntry = FlowUtils.getDeliverFlow(flowTable, target);
        if (flowEntry == null) {
            throw new IllegalStateException("Flow table does not contain entry");
        }
        flowEntry.removeComponent(componentToRemove);
    }

    private static IWorkspaceConnection getDefaultFlowTarget(IFlowEntry entry2, List<IFlowEntry> flowEntries, ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        if (entry2 != null && entry2.getFlowNode() instanceof IWorkspaceHandle) {
            return FlowUtils.getConnectionFromFlowEntry(entry2, repository, monitor);
        }
        for (IFlowEntry entry2 : flowEntries) {
            if (!(entry2.getFlowNode() instanceof IWorkspaceHandle)) continue;
            return FlowUtils.getConnectionFromFlowEntry(entry2, repository, monitor);
        }
        return null;
    }

    public static IWorkspaceConnection getDefaultIncomingFlowTarget(IWorkspaceConnection connection, IProgressMonitor monitor) throws TeamRepositoryException {
        IFlowTable flowTable = connection.getFlowTable();
        return FlowUtils.getDefaultFlowTarget(flowTable.getDefaultAcceptFlow(), flowTable.acceptSources(), connection.teamRepository(), monitor);
    }

    public static IWorkspaceConnection getDefaultOutgoingFlowTarget(IWorkspaceConnection connection, IProgressMonitor monitor) throws TeamRepositoryException {
        IFlowTable flowTable = connection.getFlowTable();
        return FlowUtils.getDefaultFlowTarget(flowTable.getDefaultDeliverFlow(), flowTable.deliverTargets(), connection.teamRepository(), monitor);
    }

    private static ConnectionDescriptor getDefaultFlowTargetDescriptor(IFlowEntry entry2, List<IFlowEntry> flowEntries, ITeamRepository repository) {
        if (entry2 != null && entry2.getFlowNode() instanceof IWorkspaceHandle) {
            return FlowUtils.createConnectionDescriptorFromFlowEntry(entry2, repository);
        }
        for (IFlowEntry entry2 : flowEntries) {
            if (!(entry2.getFlowNode() instanceof IWorkspaceHandle)) continue;
            return FlowUtils.createConnectionDescriptorFromFlowEntry(entry2, repository);
        }
        return null;
    }

    public static ConnectionDescriptor getDefaultIncomingFlowTargetDescriptor(IWorkspaceConnection connection) {
        IFlowTable flowTable = connection.getFlowTable();
        return FlowUtils.getDefaultFlowTargetDescriptor(flowTable.getDefaultAcceptFlow(), flowTable.acceptSources(), connection.teamRepository());
    }

    public static ConnectionDescriptor getDefaultOutgoingFlowTargetDescriptor(IWorkspaceConnection connection) {
        IFlowTable flowTable = connection.getFlowTable();
        return FlowUtils.getDefaultFlowTargetDescriptor(flowTable.getDefaultDeliverFlow(), flowTable.deliverTargets(), connection.teamRepository());
    }

    private static ConnectionDescriptor createConnectionDescriptorFromFlowEntry(IFlowEntry flowEntry, ITeamRepository defaultRepository) {
        if (flowEntry.getRemoteRepositoryIdentifier() == null || flowEntry.getRemoteRepositoryURI() == null) {
            return new ConnectionDescriptor(defaultRepository.getId(), defaultRepository.getRepositoryURI(), (IContextHandle)flowEntry.getFlowNode());
        }
        return new ConnectionDescriptor(flowEntry.getRemoteRepositoryIdentifier(), flowEntry.getRemoteRepositoryURI(), (IContextHandle)flowEntry.getFlowNode());
    }

    private static IWorkspaceConnection getConnectionFromFlowEntry(IFlowEntry entry, ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceHandle wsHandle = (IWorkspaceHandle)entry.getFlowNode();
        ITeamRepository repo = entry.getRemoteRepositoryURI() == null ? repository : TeamPlatform.getTeamRepositoryService().getTeamRepository(entry.getRemoteRepositoryURI());
        return SCMPlatform.getWorkspaceManager(repo).getWorkspaceConnection(wsHandle, monitor);
    }

    public static void addFlowTarget(IWorkspaceConnection local, IWorkspaceConnection remote, IProgressMonitor monitor) throws TeamRepositoryException {
        FlowUtils.addFlowTarget(local, remote, true, monitor);
    }

    public static void addFlowTarget(IWorkspaceConnection local, IWorkspaceConnection remote, boolean setDefault, IProgressMonitor monitor) throws TeamRepositoryException {
        IFlowTable flowTable = local.getFlowTable().getWorkingCopy();
        FlowUtils.addFlowTarget(flowTable, local, remote, setDefault);
        local.setFlowTable(flowTable, monitor);
    }

    public static void setDefaultFlowTarget(IWorkspaceConnection local, IWorkspaceConnection remote, IProgressMonitor monitor) throws TeamRepositoryException {
        IFlowTable flowTable = local.getFlowTable().getWorkingCopy();
        FlowUtils.setDefaultFlowTarget(flowTable, (IWorkspaceHandle)(remote == null ? null : remote.getResolvedWorkspace()));
        local.setFlowTable(flowTable, monitor);
    }

    public static void addFlowTarget(IFlowTable flowTable, IWorkspaceConnection local, IWorkspaceConnection remote, boolean makeDefaultFlow) throws TeamRepositoryException {
        List localComponents = ItemLists.handlesToIds((Collection)local.getComponents());
        List remoteComponents = ItemLists.handlesToIds((Collection)remote.getComponents());
        localComponents.retainAll(remoteComponents);
        IWorkspaceHandle target = (IWorkspaceHandle)remote.getResolvedWorkspace().getItemHandle();
        UUID repoId = null;
        String repoURI = null;
        if (remote.teamRepository() != null && !remote.teamRepository().equals(local.teamRepository())) {
            repoId = remote.teamRepository().getId();
            repoURI = remote.teamRepository().getRepositoryURI();
        }
        flowTable.addAcceptFlow((IFlowNodeHandle)target, repoId, repoURI, (Collection)Collections.EMPTY_LIST, null);
        flowTable.addDeliverFlow((IFlowNodeHandle)target, repoId, repoURI, (Collection)ItemLists.idsToHandles((Collection)localComponents), null);
        if (flowTable.acceptSources().size() == 1 || makeDefaultFlow) {
            FlowUtils.setDefaultFlowTarget(flowTable, target);
            FlowUtils.setCurrentFlowTarget(flowTable, target);
        }
    }

    public static void setCurrentFlowTarget(IFlowTable flowTable, IWorkspaceHandle target) {
        if (target == null) {
            flowTable.unsetCurrentAcceptFlow();
            flowTable.unsetCurrentDeliverFlow();
        } else {
            IFlowEntry deliverEntry;
            IFlowEntry acceptEntry = flowTable.getAcceptFlow((IFlowNodeHandle)target);
            if (acceptEntry != null) {
                flowTable.setCurrent(acceptEntry);
            }
            if ((deliverEntry = flowTable.getDeliverFlow((IFlowNodeHandle)target)) != null) {
                flowTable.setCurrent(deliverEntry);
            }
        }
    }

    public static void setDefaultFlowTarget(IFlowTable flowTable, IWorkspaceHandle target) {
        if (target == null) {
            flowTable.unsetDefaultAcceptFlow();
            flowTable.unsetDefaultDeliverFlow();
        } else {
            IFlowEntry deliverEntry;
            IFlowEntry acceptEntry = flowTable.getAcceptFlow((IFlowNodeHandle)target);
            if (acceptEntry != null) {
                flowTable.setDefault(acceptEntry);
            }
            if ((deliverEntry = flowTable.getDeliverFlow((IFlowNodeHandle)target)) != null) {
                flowTable.setDefault(deliverEntry);
            }
        }
    }

    public static boolean hasDeliverFlow(IWorkspaceConnection source, IWorkspaceConnection target) {
        return FlowUtils.getDeliverFlow(source.getFlowTable(), (IWorkspaceHandle)target.getResolvedWorkspace()) != null;
    }

    public static boolean hasAcceptFlow(IWorkspaceConnection target, IWorkspaceConnection source) {
        return FlowUtils.getAcceptFlow(target.getFlowTable(), (IWorkspaceHandle)source.getResolvedWorkspace()) != null;
    }

    private static IFlowEntry getAcceptFlow(IFlowTable flowTable, IWorkspaceHandle source) {
        return ((FlowTable)flowTable).getAcceptFlow((IFlowNodeHandle)source, true);
    }
}

