/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.ClientConfigurationProxy;
import com.ibm.team.scm.client.internal.Connection;
import com.ibm.team.scm.client.internal.Messages;
import com.ibm.team.scm.client.internal.SCMClientUtil;
import com.ibm.team.scm.client.internal.VersionableManager;
import com.ibm.team.scm.client.internal.WorkspaceManager;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import com.ibm.team.scm.common.IRepositoryProgressMonitorHandle;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.VersionablePermissionDeniedException;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.IPermissionContextProvider;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import com.ibm.team.scm.common.dto.ISynchronizationTimes;
import com.ibm.team.scm.common.dto.IVersionablePermissionsReport;
import com.ibm.team.scm.common.internal.dto.FolderEntryReport;
import com.ibm.team.scm.common.internal.dto.ServiceConfigurationProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ConnectionBasedClientConfigurationProxy
extends ClientConfigurationProxy {
    private final Connection connection;
    private final IComponentHandle component;

    ConnectionBasedClientConfigurationProxy(Connection connection, IComponentHandle component) {
        this.connection = connection;
        this.component = component;
        if (this.component == null) {
            throw new IllegalArgumentException("component must not be null");
        }
    }

    @Override
    public ITeamRepository teamRepository() {
        return this.connection.teamRepository();
    }

    @Override
    public boolean isLive() {
        return this.connection instanceof IWorkspaceConnection;
    }

    @Override
    public IComponentHandle component() {
        return this.component;
    }

    @Override
    public boolean isAvailable(IProgressMonitor monitor) {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (!this.teamRepository().loggedIn()) {
                SCMClientUtil.checkMonitor(monitor);
                return false;
            }
            if (this.connection instanceof IBaselineConnection) {
                SCMClientUtil.checkMonitor(monitor);
                return true;
            }
            if (this.connection instanceof IWorkspaceConnection) {
                SCMClientUtil.checkMonitor(monitor);
                return true;
            }
            throw new IllegalStateException();
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public Map childEntries(IFolderHandle folderHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.childEntries(folderHandle, null, monitor);
    }

    public Map childEntries(IFolderHandle folderHandle, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (folderHandle == null) {
                throw new IllegalArgumentException();
            }
            this.connection.validate();
            SCMClientUtil.checkMonitor(monitor);
            IScmService service = this.workspaceManager().getServerConfigurationService();
            FolderEntryReport interimResult = service.configurationChildEntriesMultiple(this.createConfigProvider(), new IFolderHandle[]{folderHandle}, Connection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor))[0];
            monitor.worked(99);
            SCMClientUtil.checkMonitor(monitor);
            if (interimResult == null) {
                IVersionablePermissionsReport[] permissions = service.getPermissions(new IVersionableHandle[]{folderHandle}, this.component(), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
                String message = NLS.bind((String)Messages.EraBasedClientConfigurationProxy_3, (Object)folderHandle.getItemId().getUuidValue(), (Object[])new Object[0]);
                if (permissions.length == 1 && permissions[0].isReportOfInaccessible()) {
                    throw VersionablePermissionDeniedException.exceptionFor((String)message, (UUID)this.connection.teamRepository().getId(), (IContextHandle)this.connection.getContextHandle(), (IComponentHandle)this.component, (IVersionableHandle)folderHandle);
                }
                throw new ItemNotFoundException(Messages.ConnectionBasedClientConfigurationProxy_0);
            }
            Map map = Collections.unmodifiableMap(interimResult.getEntries());
            return map;
        }
        finally {
            monitor.done();
        }
    }

    private ServiceConfigurationProvider createConfigProvider() {
        if (this.connection instanceof IBaselineConnection) {
            return ServiceConfigurationProvider.FACTORY.create(((IBaselineConnection)((Object)this.connection)).getBaseline());
        }
        if (this.connection instanceof IWorkspaceConnection) {
            return ServiceConfigurationProvider.FACTORY.create((IWorkspaceHandle)((IWorkspaceConnection)((Object)this.connection)).getResolvedWorkspace(), this.component);
        }
        throw new IllegalStateException();
    }

    @Override
    public Map childEntriesForRoot(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.childEntriesForRoot(null, monitor);
    }

    public Map childEntriesForRoot(ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            this.connection.validate();
            SCMClientUtil.checkMonitor(monitor);
            IScmService service = this.workspaceManager().getServerConfigurationService();
            FolderEntryReport interimResult = service.configurationChildEntriesForRoot(this.createConfigProvider(), Connection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            monitor.worked(99);
            SCMClientUtil.checkMonitor(monitor);
            if (interimResult == null) {
                throw new ItemNotFoundException(Messages.ConnectionBasedClientConfigurationProxy_1);
            }
            Map map = Collections.unmodifiableMap(interimResult.getEntries());
            return map;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List childEntries(List folderHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.childEntries(folderHandles, null, monitor);
    }

    public List childEntries(List folderHandles, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (folderHandles == null) {
                throw new IllegalArgumentException();
            }
            ArrayList<IFolderHandle> uniqueHandles = new ArrayList<IFolderHandle>(folderHandles.size());
            HashSet<UUID> inList = new HashSet<UUID>((int)((double)folderHandles.size() / 0.75));
            for (Object o : folderHandles) {
                if (!(o instanceof IFolderHandle)) {
                    throw new IllegalArgumentException();
                }
                IFolderHandle folder = (IFolderHandle)o;
                if (!inList.add(folder.getItemId())) continue;
                uniqueHandles.add(folder);
            }
            this.connection.validate();
            SCMClientUtil.checkMonitor(monitor);
            IScmService service = this.workspaceManager().getServerConfigurationService();
            FolderEntryReport[] interimResult = service.configurationChildEntriesMultiple(this.createConfigProvider(), uniqueHandles.toArray(new IFolderHandle[uniqueHandles.size()]), Connection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            monitor.worked(99);
            SCMClientUtil.checkMonitor(monitor);
            Iterator it = uniqueHandles.iterator();
            HashMap resultMap = new HashMap();
            FolderEntryReport[] folderEntryReportArray = interimResult;
            int n = interimResult.length;
            int n2 = 0;
            while (n2 < n) {
                FolderEntryReport r = folderEntryReportArray[n2];
                IFolderHandle parent = (IFolderHandle)it.next();
                Map children = r == null ? null : r.getEntries();
                resultMap.put(parent.getItemId(), children == null ? null : Collections.unmodifiableMap(children));
                ++n2;
            }
            ArrayList<Map> result = new ArrayList<Map>(folderHandles.size());
            for (IFolderHandle f : folderHandles) {
                result.add((Map)resultMap.get(f.getItemId()));
            }
            SCMClientUtil.checkMonitor(monitor);
            List list = Collections.unmodifiableList(result);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    private List fetch(List versionableItems, Collection requiredProperties, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (versionableItems == null) {
                throw new IllegalArgumentException();
            }
            for (Object element : versionableItems) {
                if (element == null) {
                    throw new IllegalArgumentException();
                }
                if (element instanceof IVersionableHandle) continue;
                throw new IllegalArgumentException();
            }
            SCMClientUtil.checkMonitor(monitor);
            this.connection.validate();
            IScmService service = this.workspaceManager().getServerConfigurationService();
            String[] properties = null;
            if (requiredProperties != null) {
                properties = requiredProperties.toArray(new String[requiredProperties.size()]);
            }
            ArrayList<IVersionable> states = new ArrayList<IVersionable>(versionableItems.size());
            int left = versionableItems.size();
            ISynchronizationTimes[] syncTimes = Connection.getSyncTimes(syncInfo);
            int i = 0;
            while (left > 0) {
                int from = i * 2048;
                int size = Math.min(2048, left);
                List<IVersionable> result = Arrays.asList(service.configurationFetch(this.createConfigProvider(), versionableItems.subList(from, from + size).toArray(new IVersionableHandle[size]), properties, syncTimes, (IRepositoryProgressMonitorHandle)this.monitorFor(monitor)));
                states.addAll(result);
                left -= size;
                ++i;
            }
            monitor.worked(50);
            SCMClientUtil.checkMonitor(monitor);
            IVersionable[] result = states.toArray(new IVersionable[states.size()]);
            int i2 = 0;
            while (i2 < result.length) {
                if (ItemUtil.DELETED_UUID.equals((Object)result[i2].getStateId())) {
                    result[i2] = null;
                }
                ++i2;
            }
            SCMClientUtil.checkMonitor(monitor);
            List list = this.share(Arrays.asList(result));
            return list;
        }
        finally {
            monitor.done();
        }
    }

    private IVersionable fetch(IVersionableHandle item, Collection requiredProperties, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (item == null) {
                throw new IllegalArgumentException();
            }
            this.connection.validate();
            List results = this.fetch(Arrays.asList(item), requiredProperties, syncInfo, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            SCMClientUtil.checkMonitor(monitor);
            IVersionable v = (IVersionable)results.get(0);
            if (v == null) {
                IScmService service = this.workspaceManager().getServerConfigurationService();
                IVersionablePermissionsReport[] permissions = service.getPermissions(new IVersionableHandle[]{item}, this.component(), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
                if (permissions.length == 1 && permissions[0].isReportOfInaccessible()) {
                    throw VersionablePermissionDeniedException.exceptionFor((String)Messages.EraBasedClientConfigurationProxy_3, (UUID)this.connection.teamRepository().getId(), (IContextHandle)this.connection.getContextHandle(), (IComponentHandle)this.component, (IVersionableHandle)item);
                }
                throw new ItemNotFoundException(Messages.ConnectionBasedClientConfigurationProxy_2);
            }
            SCMClientUtil.checkMonitor(monitor);
            IVersionable iVersionable = this.share(v);
            return iVersionable;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List locateAncestors(List versionableHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.locateAncestors(versionableHandles, null, monitor);
    }

    public List locateAncestors(List versionableHandles, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (versionableHandles == null) {
                throw new IllegalArgumentException();
            }
            for (Object element : versionableHandles) {
                if (element != null && element instanceof IVersionableHandle) continue;
                throw new IllegalArgumentException();
            }
            this.connection.validate();
            IScmService service = this.workspaceManager().getServerConfigurationService();
            IVersionableHandle[] versionables = versionableHandles.toArray(new IVersionableHandle[versionableHandles.size()]);
            IAncestorReport[] reports = service.configurationLocateAncestors(this.createConfigProvider(), versionables, Connection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            SCMClientUtil.checkMonitor(monitor);
            monitor.worked(50);
            List<IAncestorReport> result = Collections.unmodifiableList(Arrays.asList(reports));
            SCMClientUtil.checkMonitor(monitor);
            List<IAncestorReport> list = result;
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IVersionableHandle resolvePath(IFolderHandle folderHandle, String[] nameSegments, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.resolvePath(folderHandle, nameSegments, null, monitor);
    }

    public IVersionableHandle resolvePath(IFolderHandle folderHandle, String[] nameSegments, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (folderHandle == null) {
                throw new IllegalArgumentException();
            }
            if (nameSegments == null) {
                throw new IllegalArgumentException();
            }
            int i = 0;
            while (i < nameSegments.length) {
                String s = nameSegments[i];
                if (s == null || s.length() < 1 || s.length() > 250) {
                    throw new IllegalArgumentException();
                }
                ++i;
            }
            SCMClientUtil.checkMonitor(monitor);
            this.connection.validate();
            IScmService service = this.workspaceManager().getServerConfigurationService();
            IVersionableHandle resultHandle = service.configurationResolvePath(this.createConfigProvider(), folderHandle, nameSegments, Connection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            SCMClientUtil.checkMonitor(monitor);
            monitor.worked(50);
            IVersionableHandle iVersionableHandle = resultHandle;
            return iVersionableHandle;
        }
        finally {
            monitor.done();
        }
    }

    private IFolder rootFolder(Collection requiredProperties, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            this.connection.validate();
            IScmService service = this.workspaceManager().getServerConfigurationService();
            String[] properties = null;
            if (requiredProperties != null) {
                properties = requiredProperties.toArray(new String[requiredProperties.size()]);
            }
            IFolder result = service.configurationRootFolder(this.createConfigProvider(), properties, Connection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            monitor.worked(90);
            IFolder iFolder = (IFolder)this.share((IVersionable)result);
            return iFolder;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IFolderHandle rootFolderHandle(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.rootFolder(Collections.EMPTY_LIST, null, monitor);
    }

    public IFolderHandle rootFolderHandle(ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.rootFolder(Collections.EMPTY_LIST, syncInfo, monitor);
    }

    @Override
    public IFolder completeRootFolder(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.rootFolder(null, null, monitor);
    }

    public IFolder completeRootFolder(ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.rootFolder(null, syncInfo, monitor);
    }

    @Override
    public IVersionable fetchCompleteItem(IVersionableHandle versionableItem, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fetch(versionableItem, null, null, monitor);
    }

    public IVersionable fetchCompleteItem(IVersionableHandle versionableItem, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fetch(versionableItem, null, syncInfo, monitor);
    }

    @Override
    public List fetchCompleteItems(List versionableItems, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fetch(versionableItems, null, null, monitor);
    }

    public List fetchCompleteItems(List versionableItems, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fetch(versionableItems, null, syncInfo, monitor);
    }

    @Override
    public IFolder partialRootFolder(Collection requiredProperties, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.rootFolder(requiredProperties, null, monitor);
    }

    public IFolder partialRootFolder(Collection requiredProperties, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.rootFolder(requiredProperties, syncInfo, monitor);
    }

    @Override
    public IVersionable fetchPartialItem(IVersionableHandle versionableItem, Collection requiredProperties, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fetch(versionableItem, requiredProperties, null, monitor);
    }

    public IVersionable fetchPartialItem(IVersionableHandle versionableItem, Collection requiredProperties, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fetch(versionableItem, requiredProperties, syncInfo, monitor);
    }

    @Override
    public List fetchPartialItems(List versionableItems, Collection requiredProperties, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fetch(versionableItems, requiredProperties, null, monitor);
    }

    public List fetchPartialItems(List versionableItems, Collection requiredProperties, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fetch(versionableItems, requiredProperties, syncInfo, monitor);
    }

    @Override
    public List determineAncestorsInHistory(List versionableHandles, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        this.connection.validate();
        return super.determineAncestorsInHistory(versionableHandles, syncInfo, monitor);
    }

    @Override
    public List<IAncestorReport> fetchAncestorsByName(String exactVersionableName, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (exactVersionableName == null || exactVersionableName.equals("")) {
                throw new IllegalArgumentException();
            }
            this.connection.validate();
            IScmService service = this.workspaceManager().getServerConfigurationService();
            SCMClientUtil.checkMonitor(monitor);
            IAncestorReport[] reports = service.configurationFindByName(this.createConfigProvider(), exactVersionableName, Connection.getSyncTimes(null), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            List<IAncestorReport> list = Arrays.asList(reports);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    private IVersionable share(IVersionable versionableItem) {
        return (IVersionable)((VersionableManager)this.workspaceManager().versionableManager()).applyItemStates(Collections.singletonList(versionableItem)).get(0);
    }

    private List share(List versionableItems) {
        return ((VersionableManager)this.workspaceManager().versionableManager()).applyItemStates(versionableItems);
    }

    @Override
    protected WorkspaceManager workspaceManager() {
        return this.connection.workspaceManager();
    }

    @Override
    protected IRepositoryProgressMonitor monitorFor(IProgressMonitor monitor) {
        return IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor);
    }

    @Override
    public void setVersionablePermissions(IVersionableHandle[] versionables, IPermissionContextProvider contextProvider, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (versionables == null) {
                throw new IllegalArgumentException();
            }
            int i = 0;
            while (i < versionables.length) {
                IVersionableHandle element = versionables[i];
                if (element == null) {
                    throw new IllegalArgumentException();
                }
                ++i;
            }
            SCMClientUtil.checkMonitor(monitor);
            this.connection.validate();
            IScmService service = this.workspaceManager().getServerConfigurationService();
            int left = versionables.length;
            int i2 = 0;
            while (left > 0) {
                IVersionableHandle[] toSet;
                int from = i2 * 2048;
                int size = Math.min(2048, left);
                if (versionables.length > 2048) {
                    toSet = new IVersionableHandle[size];
                    System.arraycopy(versionables, from, toSet, 0, size);
                } else {
                    toSet = versionables;
                }
                service.configurationSetSubtreePermissions(this.createConfigProvider(), toSet, contextProvider, null, (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
                left -= size;
                ++i2;
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected ServiceConfigurationProvider getServiceConfigurationProvider() {
        return this.createConfigProvider();
    }
}

