/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IChangeHistory;
import com.ibm.team.scm.client.IChangeHistoryDescriptor;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.BaselineConnection;
import com.ibm.team.scm.client.internal.ClientChangeSetEntry;
import com.ibm.team.scm.client.internal.ClientEraDescriptor;
import com.ibm.team.scm.client.internal.Connection;
import com.ibm.team.scm.client.internal.EraBasedClientConfigurationProxy;
import com.ibm.team.scm.client.internal.RemoteRepoDescriptorUtils;
import com.ibm.team.scm.client.internal.SCMClientUtil;
import com.ibm.team.scm.client.internal.WorkspaceConnection;
import com.ibm.team.scm.client.internal.WorkspaceManager;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import com.ibm.team.scm.common.IRepositoryProgressMonitorHandle;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.InvalidAuthenticationTokenException;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import com.ibm.team.scm.common.internal.ChangeHistoryEntry;
import com.ibm.team.scm.common.internal.ChangeHistoryHandle;
import com.ibm.team.scm.common.internal.ComponentHandle;
import com.ibm.team.scm.common.internal.dto.EraDescriptor;
import com.ibm.team.scm.common.internal.dto.HistoryProvider;
import com.ibm.team.scm.common.internal.dto.RemoteRepoDescriptor;
import com.ibm.team.scm.common.internal.dto.ServiceHistoryProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ClientChangeHistoryProxy
implements IChangeHistory {
    private final Connection connection;
    private ServiceHistoryProvider provider = null;
    private final ComponentHandle component;
    private final Object lock = new Object();
    private boolean isLive;

    ClientChangeHistoryProxy(Connection connection, ComponentHandle component, boolean isLive) {
        this.connection = connection;
        this.isLive = isLive;
        this.component = component;
    }

    public ClientChangeHistoryProxy(Connection connection, IComponentHandle component, ChangeHistoryHandle era) {
        this.connection = connection;
        this.component = (ComponentHandle)component;
        this.isLive = false;
        this.setHistoryHandle(era, false);
    }

    @Override
    public ITeamRepository teamRepository() {
        return this.connection.teamRepository();
    }

    @Override
    public boolean isLive() {
        return this.isLive;
    }

    @Override
    public boolean isAvailable(IProgressMonitor monitor) {
        try {
            return this.isAvailable(null, monitor);
        }
        catch (StaleDataException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isAvailable(ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws StaleDataException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (!this.teamRepository().loggedIn()) {
                return false;
            }
            IScmService service = this.workspaceManager().getServerConfigurationService();
            SCMClientUtil.checkMonitor(monitor);
            boolean bl = service.isAvailable(this.getHistoryProvider(), Connection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List recent(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.recent(null, monitor);
    }

    public List recent(ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            IScmService service = this.workspaceManager().getServerConfigurationService();
            ChangeHistoryEntry[] recentChanges = service.recentEntries(this.getHistoryProvider(), Connection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            monitor.worked(70);
            SCMClientUtil.checkMonitor(monitor);
            ArrayList<ClientChangeSetEntry> result = new ArrayList<ClientChangeSetEntry>(recentChanges.length);
            int i = 0;
            while (i < recentChanges.length) {
                result.add(new ClientChangeSetEntry(recentChanges[i]));
                ++i;
            }
            ArrayList<ClientChangeSetEntry> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IChangeHistoryDescriptor getHistoryDescriptor(boolean requireStateHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            ClientEraDescriptor result;
            IScmService service = this.workspaceManager().getServerConfigurationService();
            ServiceHistoryProvider historyProvider = this.getHistoryProvider();
            EraDescriptor descriptor = service.getChangeHistoryDescriptor(historyProvider, requireStateHandles, null, (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            monitor.worked(70);
            SCMClientUtil.checkMonitor(monitor);
            ClientEraDescriptor clientEraDescriptor = result = new ClientEraDescriptor(descriptor, this.connection, this.component);
            return clientEraDescriptor;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List<IChangeHistoryDescriptor> getHistoryDescriptors(int numberOfChangeSets, boolean requireStateHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (numberOfChangeSets == 0) {
                List<IChangeHistoryDescriptor> list = Collections.emptyList();
                return list;
            }
            IScmService service = this.workspaceManager().getServerConfigurationService();
            EraDescriptor[] descriptor = service.getChangeHistoryDescriptors(this.getHistoryProvider(), numberOfChangeSets, requireStateHandles, null, (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            monitor.worked(70);
            SCMClientUtil.checkMonitor(monitor);
            ArrayList<IChangeHistoryDescriptor> result = new ArrayList<IChangeHistoryDescriptor>();
            int i = 0;
            while (i < descriptor.length) {
                EraDescriptor eraDescriptor = descriptor[i];
                result.add(new ClientEraDescriptor(eraDescriptor, this.connection, this.component));
                ++i;
            }
            ArrayList<IChangeHistoryDescriptor> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IChangeHistory previousHistory(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.previousHistory(null, monitor);
    }

    public IChangeHistory previousHistory(ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            IScmService service = this.workspaceManager().getServerConfigurationService();
            ChangeHistoryHandle previous = service.previousHistory(this.getHistoryProvider(), Connection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            monitor.worked(70);
            SCMClientUtil.checkMonitor(monitor);
            if (previous == null) {
                return null;
            }
            ClientChangeHistoryProxy history = new ClientChangeHistoryProxy(this.connection, this.component, false);
            history.setHistoryHandle(previous, false);
            ClientChangeHistoryProxy clientChangeHistoryProxy = history;
            return clientChangeHistoryProxy;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IChangeHistorySyncReport compareChangeHistories(IChangeHistory other, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.compareChangeHistories(other, null, monitor);
    }

    public IChangeHistorySyncReport compareChangeHistories(IChangeHistory other, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IChangeHistorySyncReport r;
            if (other == null) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.workspaceManager().getServerConfigurationService();
            RemoteRepoDescriptor remoteDescriptor = null;
            InvalidAuthenticationTokenException authEx = null;
            while (true) {
                RemoteRepoDescriptor newDescriptor = this.extractRemoteDescriptor((ClientChangeHistoryProxy)other, (IProgressMonitor)progress.newChild(5));
                if (remoteDescriptor != null && newDescriptor.getAuthToken().getTruth().equals(remoteDescriptor.getAuthToken().getTruth())) {
                    throw authEx;
                }
                remoteDescriptor = newDescriptor;
                try {
                    r = service.compareChangeHistories(this.getHistoryProvider(), ((ClientChangeHistoryProxy)other).getHistoryProvider(), remoteDescriptor, Connection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor((IProgressMonitor)progress));
                }
                catch (InvalidAuthenticationTokenException e) {
                    if (remoteDescriptor == null) {
                        throw e;
                    }
                    RemoteRepoDescriptorUtils.resetRemoteDescriptor(other.teamRepository());
                    authEx = e;
                    progress.setWorkRemaining(100);
                    continue;
                }
                break;
            }
            IChangeHistorySyncReport iChangeHistorySyncReport = r;
            return iChangeHistorySyncReport;
        }
        finally {
            progress.done();
        }
    }

    private RemoteRepoDescriptor extractRemoteDescriptor(ClientChangeHistoryProxy proxy, IProgressMonitor monitor) throws TeamRepositoryException {
        RemoteRepoDescriptor remoteDescriptor = null;
        if (!proxy.teamRepository().getId().equals((Object)this.teamRepository().getId())) {
            remoteDescriptor = RemoteRepoDescriptorUtils.getRemoteDescriptor(proxy.teamRepository(), monitor);
        }
        return remoteDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceHistoryProvider getHistoryProvider() {
        ServiceHistoryProvider prov = null;
        Object object = this.lock;
        synchronized (object) {
            prov = this.provider;
        }
        if (prov == null) {
            if (this.connection instanceof IBaselineConnection) {
                prov = ServiceHistoryProvider.FACTORY.create(((BaselineConnection)this.connection).getHistoryHandle());
            } else if (this.connection instanceof IWorkspaceConnection) {
                prov = ServiceHistoryProvider.FACTORY.create((IWorkspaceHandle)((IWorkspaceConnection)((Object)this.connection)).getResolvedWorkspace(), (IComponentHandle)this.component);
            } else {
                throw new IllegalStateException();
            }
        }
        object = this.lock;
        synchronized (object) {
            this.provider = prov;
        }
        return prov;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setHistoryHandle(ChangeHistoryHandle history, boolean isLive) {
        Object object = this.lock;
        synchronized (object) {
            this.provider = this.createHistoryProvider(history);
            this.isLive = isLive;
        }
    }

    private ServiceHistoryProvider createHistoryProvider(ChangeHistoryHandle history) {
        if (this.connection instanceof IWorkspaceConnection) {
            return ServiceHistoryProvider.FACTORY.create((IWorkspaceHandle)((IWorkspaceConnection)((Object)this.connection)).getResolvedWorkspace(), (IComponentHandle)this.component, history);
        }
        return ServiceHistoryProvider.FACTORY.create(history);
    }

    @Override
    public IComponentHandle getComponent() {
        return this.component;
    }

    private WorkspaceManager workspaceManager() {
        return this.connection.workspaceManager();
    }

    @Override
    public UUID getEraIdentifier() {
        return this.getHistoryHandle().getItemId();
    }

    private ChangeHistoryHandle getHistoryHandle() {
        HistoryProvider prov = (HistoryProvider)this.getHistoryProvider();
        if (prov.getChangeHistory() != null) {
            return prov.getChangeHistory();
        }
        return ((WorkspaceConnection)this.connection).getHistoryHandle(this.component);
    }

    @Override
    public List getRelatedEntries(IChangeSetHandle cs, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getRelatedEntries(cs, null, monitor);
    }

    public List getRelatedEntries(IChangeSetHandle cs, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            IScmService service = this.workspaceManager().getServerConfigurationService();
            ChangeHistoryEntry[] related = service.getRelatedChangeEntries(this.getHistoryProvider(), cs, Connection.getSyncTimes(syncInfo), (IRepositoryProgressMonitorHandle)this.monitorFor(monitor));
            monitor.worked(90);
            SCMClientUtil.checkMonitor(monitor);
            ArrayList<ClientChangeSetEntry> relatedList = new ArrayList<ClientChangeSetEntry>(related.length);
            int i = 0;
            while (i < related.length) {
                relatedList.add(new ClientChangeSetEntry(related[i]));
                ++i;
            }
            ArrayList<ClientChangeSetEntry> arrayList = relatedList;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IConnection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IConfiguration configuration() {
        ChangeHistoryHandle ours = null;
        Object object = this.lock;
        synchronized (object) {
            ours = this.getHistoryHandle();
        }
        ChangeHistoryHandle theirs = null;
        if (this.connection instanceof IBaselineConnection) {
            theirs = ((BaselineConnection)this.connection).getHistoryHandle();
        } else if (this.connection instanceof IWorkspaceConnection) {
            theirs = ((WorkspaceConnection)this.connection).getHistoryHandle(this.component);
        } else {
            throw new IllegalStateException();
        }
        if (ours == null || ours != null && ours.equals((Object)theirs)) {
            if (this.connection instanceof IBaselineConnection) {
                return ((IBaselineConnection)((Object)this.connection)).configuration();
            }
            if (this.connection instanceof IWorkspaceConnection) {
                try {
                    return ((IWorkspaceConnection)((Object)this.connection)).configuration((IComponentHandle)this.component);
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    // empty catch block
                }
            }
        }
        return new EraBasedClientConfigurationProxy(ours, this.teamRepository(), (IComponentHandle)this.component);
    }

    @Override
    public List getHistoryFor(final IVersionableHandle versionableHandle, final int limit, final boolean examineEras, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (versionableHandle == null) {
                throw new IllegalArgumentException();
            }
            if (limit <= 0) {
                throw new IllegalArgumentException();
            }
            SCMClientUtil.checkMonitor(monitor);
            final IScmService service = this.workspaceManager().getServerConfigurationService();
            monitor.worked(10);
            ChangeHistoryEntry[] results = (ChangeHistoryEntry[])this.connection.getContext().callCancelableService(new IClientLibraryContext.IServiceRunnable(){

                public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return service.getHistoryForVersionable(ClientChangeHistoryProxy.this.getHistoryProvider(), versionableHandle, limit, examineEras, null, (IRepositoryProgressMonitorHandle)ClientChangeHistoryProxy.this.monitorFor(monitor));
                }
            }, monitor);
            monitor.worked(50);
            ArrayList<ClientChangeSetEntry> entries = new ArrayList<ClientChangeSetEntry>(results.length);
            ChangeHistoryEntry[] changeHistoryEntryArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                ChangeHistoryEntry entry = changeHistoryEntryArray[n2];
                entries.add(new ClientChangeSetEntry(entry));
                ++n2;
            }
            List result = Collections.unmodifiableList(entries);
            SCMClientUtil.checkMonitor(monitor);
            List list = result;
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List getHistoryFor(IVersionableHandle versionableHandle, int limit, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getHistoryFor(versionableHandle, limit, true, monitor);
    }

    private IRepositoryProgressMonitor monitorFor(IProgressMonitor monitor) {
        return IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor);
    }

    public List getHistoryForFolder(final IFolderHandle folderHandle, final int limit, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 10);
        try {
            if (folderHandle == null) {
                throw new IllegalArgumentException();
            }
            if (limit <= 0) {
                throw new IllegalArgumentException();
            }
            SCMClientUtil.checkMonitor(monitor);
            final IScmService service = this.workspaceManager().getServerConfigurationService();
            monitor.worked(1);
            ChangeHistoryEntry[] results = (ChangeHistoryEntry[])this.connection.getContext().callCancelableService(new IClientLibraryContext.IServiceRunnable(){

                public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return service.getHistoryForFolder(ClientChangeHistoryProxy.this.getHistoryProvider(), folderHandle, limit, 0, null, (IRepositoryProgressMonitorHandle)ClientChangeHistoryProxy.this.monitorFor(monitor));
                }
            }, monitor);
            monitor.worked(8);
            ArrayList<ClientChangeSetEntry> entries = new ArrayList<ClientChangeSetEntry>(results.length);
            ChangeHistoryEntry[] changeHistoryEntryArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                ChangeHistoryEntry entry = changeHistoryEntryArray[n2];
                entries.add(new ClientChangeSetEntry(entry));
                ++n2;
            }
            List result = Collections.unmodifiableList(entries);
            SCMClientUtil.checkMonitor(monitor);
            List list = result;
            return list;
        }
        finally {
            monitor.done();
        }
    }
}

