/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.scm.client.internal.ChangeSetTracker;
import com.ibm.team.scm.client.internal.WorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.internal.ConfigUtil;
import com.ibm.team.scm.common.internal.dto.WorkspaceRefreshParameter;
import com.ibm.team.scm.common.internal.dto.WorkspaceRefreshResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ChangeSetClientCache {
    private Map<IComponentHandle, IChangeSetHandle> currentChangeSets = new TreeMap<IComponentHandle, IChangeSetHandle>(ItemUtil.itemIdComparator);
    protected ChangeSetTracker activeTracker = new ChangeSetTracker();
    private long activeState;
    public static final IChangeSetHandle CURRENT_UNSET = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle(UUID.generate(), null);

    public void updateCaches(WorkspaceRefreshResult refreshedData, WorkspaceRefreshParameter parm, Map<IComponentHandle, IChangeSetHandle> newCurrents, Set<UUID> staleComponents, IItemManager itemManager, WorkspaceConnection ws, IProgressMonitor monitor) throws TeamRepositoryException {
        boolean recomputeActiveState = false;
        long newState = refreshedData.getActiveState();
        if (newState != this.activeState) {
            boolean fullResult;
            if (staleComponents.isEmpty()) {
                this.activeState = newState;
            } else {
                recomputeActiveState = true;
            }
            boolean bl = fullResult = parm != null && parm.getActiveState() != 0L && !parm.getActiveChangeSets().isEmpty();
            if (parm != null && parm.getActiveState() == newState) {
                recomputeActiveState = true;
            } else {
                Map newStateHandles = ConfigUtil.tableForItems((Collection)refreshedData.getActiveChangeSetHandles());
                Map newChangeSets = ConfigUtil.tableForItems((Collection)refreshedData.getActiveChangeSets());
                Map oldActive = ConfigUtil.tableForItems(this.activeTracker.getChangeSets());
                for (IChangeSetHandle cs : oldActive.values()) {
                    UUID id = cs.getItemId();
                    if (!newStateHandles.containsKey(id) && !newChangeSets.containsKey(id)) {
                        IComponentHandle component = this.activeTracker.getComponentForChangeSet(cs);
                        if (component == null || !fullResult || staleComponents.contains(component.getItemId())) continue;
                        this.activeTracker.removeChangeSet(cs);
                        continue;
                    }
                    IChangeSetHandle handle = (IChangeSetHandle)newStateHandles.get(id);
                    if (handle == null || !handle.sameStateId((IItemHandle)cs)) continue;
                    newStateHandles.remove(id);
                }
                if (!newStateHandles.isEmpty()) {
                    ArrayList<IChangeSetHandle> toFetch = new ArrayList<IChangeSetHandle>();
                    for (IChangeSetHandle handle : newStateHandles.values()) {
                        IComponentHandle component;
                        IChangeSet knownItem = (IChangeSet)itemManager.getSharedItemIfKnown((IItemHandle)handle);
                        IComponentHandle iComponentHandle = component = knownItem != null ? knownItem.getComponent() : null;
                        if (component == null) {
                            component = this.activeTracker.getComponentForChangeSet(handle);
                        }
                        if (component != null && staleComponents.contains(component.getItemId())) continue;
                        if (knownItem == null || knownItem.getStateId() == null || !knownItem.sameStateId((IItemHandle)handle)) {
                            toFetch.add(handle);
                            continue;
                        }
                        this.activeTracker.addChangeSet(knownItem);
                    }
                    List completeStates = itemManager.fetchCompleteItems(toFetch, 1, monitor);
                    for (IChangeSet changeSet : completeStates) {
                        if (staleComponents.contains(changeSet.getComponent().getItemId())) continue;
                        if (!recomputeActiveState) {
                            IChangeSetHandle origHandle = (IChangeSetHandle)newStateHandles.get(changeSet.getItemId());
                            recomputeActiveState = !origHandle.sameStateId((IItemHandle)changeSet);
                        }
                        this.activeTracker.addChangeSet(changeSet);
                    }
                }
            }
        }
        for (IChangeSetHandle changeSet : refreshedData.getActiveRemoved()) {
            IComponentHandle component = this.activeTracker.getComponentForChangeSet(changeSet);
            if (component == null || staleComponents.contains(component.getItemId())) continue;
            this.activeTracker.removeChangeSet(changeSet);
        }
        for (IChangeSet changeSet : refreshedData.getActiveChangeSets()) {
            if (staleComponents.contains(changeSet.getComponent().getItemId())) continue;
            this.activeTracker.addChangeSet(changeSet);
        }
        if (recomputeActiveState) {
            this.activeState = ConfigUtil.calculateActiveState(this.activeTracker.getChangeSets());
        }
        this.updateCurrents(newCurrents);
    }

    private void updateCurrents(Map<IComponentHandle, IChangeSetHandle> newCurrents) {
        for (Map.Entry<IComponentHandle, IChangeSetHandle> entry : newCurrents.entrySet()) {
            IComponentHandle key = entry.getKey();
            if (entry.getValue() == CURRENT_UNSET) {
                this.currentChangeSets.remove(key);
                continue;
            }
            this.currentChangeSets.put(key, (IChangeSetHandle)EcoreUtil.copy((EObject)((EObject)entry.getValue())));
        }
    }

    public IComponentHandle getComponent(IChangeSetHandle cs) {
        for (Map.Entry<IComponentHandle, IChangeSetHandle> e : this.currentChangeSets.entrySet()) {
            if (!e.getValue().sameItemId((IItemHandle)cs)) continue;
            return e.getKey();
        }
        return this.activeTracker.getComponentForChangeSet(cs);
    }

    public long getActiveState() {
        return this.activeState;
    }

    public List<IChangeSetHandle> getActiveChangeSets() {
        return this.activeTracker.getChangeSets();
    }

    public List<IChangeSetHandle> getActiveChangeSetsByComponent(IComponentHandle component) {
        return this.activeTracker.getByComponent(component);
    }

    public IChangeSetHandle getCurrentChangeSet(IComponentHandle component) {
        return this.currentChangeSets.get(component);
    }

    public Map<IComponentHandle, IChangeSetHandle> getCurrentChangeSets() {
        return this.currentChangeSets;
    }

    public void setCurrentChangeSet(IComponentHandle component, IChangeSetHandle changeSet) {
        this.currentChangeSets.put(component, changeSet);
    }

    public void unsetCurrentChangeSet(IComponentHandle component) {
        this.currentChangeSets.put(component, null);
    }

    public IComponentHandle removeCurrent(IChangeSetHandle changeSet) {
        for (Map.Entry<IComponentHandle, IChangeSetHandle> entry : this.currentChangeSets.entrySet()) {
            if (!changeSet.sameItemId((IItemHandle)entry.getValue())) continue;
            entry.setValue(null);
            return entry.getKey();
        }
        return null;
    }
}

