/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.content;

import com.ibm.team.internal.repository.rcp.streams.DigestComputingInputStream;
import com.ibm.team.internal.repository.rcp.streams.TeeInputStream;
import com.ibm.team.internal.repository.rcp.streams.UnsynchronizedBufferedOutputStream;
import com.ibm.team.internal.repository.rcp.streams.UnsynchronizedByteArrayOutputStream;
import com.ibm.team.repository.client.IRetryPolicy;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.ConnectionUtil;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.serialize.IDeserializer2;
import com.ibm.team.repository.common.serialize.SerializeException;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.transport.IAbortableHttpRequest;
import com.ibm.team.repository.common.transport.ITeamServer;
import com.ibm.team.repository.common.transport.ITeamService;
import com.ibm.team.repository.common.transport.TeamServiceCallContextImpl;
import com.ibm.team.repository.common.transport.TeamServiceException;
import com.ibm.team.repository.transport.client.AuthenticationException;
import com.ibm.team.repository.transport.client.ITeamRestServiceClient;
import com.ibm.team.repository.transport.client.RemoteTeamServer;
import com.ibm.team.repository.transport.client.RequestResponsePair;
import com.ibm.team.scm.client.content.AbstractVersionedContentManagerInputStreamProvider;
import com.ibm.team.scm.client.content.BasicAsyncVersionedContentManagerSession;
import com.ibm.team.scm.client.content.BasicSynchronousVersionedContentManagerSession;
import com.ibm.team.scm.client.content.Messages;
import com.ibm.team.scm.client.content.ReleasingAndAbortingCancellableInputStream;
import com.ibm.team.scm.client.content.util.VersionedContentManagerByteArrayInputStreamPovider;
import com.ibm.team.scm.client.internal.content.BufferedRequestEntity;
import com.ibm.team.scm.client.internal.content.MonitoredInputStream;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.ContentStatusResponse;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IVersionedContent;
import com.ibm.team.scm.common.IVersionedContentService;
import com.ibm.team.scm.common.internal.ScmFactory;
import com.ibm.team.scm.common.internal.VersionedContent;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.sql.Timestamp;
import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.io.ChunkedInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class BasicVersionedContentManager<StoreContext, RetrieveContext, SessionType> {
    protected static final Method fetchMethod;
    protected static final Method storeMethod;
    protected static final Method getCleanupPeriodMethod;
    protected static final Method deleteMethod;
    protected static final Method getContentStatusMethod;
    protected static final String versionedContentServiceName;
    private static volatile int maxSimultaneousDownloads;
    protected final ITeamServer server;
    protected final IClientLibraryContext ctx;
    protected static final int MAX_IO_RETRIES = 3;

    static {
        versionedContentServiceName = IVersionedContentService.class.getName();
        try {
            fetchMethod = IVersionedContentService.class.getDeclaredMethod("fetchContent", new Class[0]);
            storeMethod = IVersionedContentService.class.getDeclaredMethod("storeContent", new Class[0]);
            getCleanupPeriodMethod = IVersionedContentService.class.getDeclaredMethod("getCleanupPeriod", new Class[0]);
            deleteMethod = IVersionedContentService.class.getDeclaredMethod("deleteContent", new Class[0]);
            getContentStatusMethod = IVersionedContentService.class.getDeclaredMethod("getContentStatus", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        maxSimultaneousDownloads = 10;
    }

    protected ITeamServer getTeamServer(IClientLibraryContext context) {
        try {
            Field f = context.teamRepository().getClass().getDeclaredField("teamServer");
            f.setAccessible(true);
            return (ITeamServer)f.get(context.teamRepository());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    protected BasicVersionedContentManager(IClientLibraryContext context) {
        this.ctx = context;
        this.server = this.getTeamServer(context);
    }

    protected InputStream wrapInputStreamForUpload(InputStream in, StoreContext context) throws TeamRepositoryException, IOException {
        return in;
    }

    protected ITeamRepository teamRepository() {
        return this.ctx.teamRepository();
    }

    protected StreamLengthUtility getStreamLengthUtility(InputStream in, StoreContext context) {
        return new StreamLengthUtility(in, context);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IVersionedContent storeContent(AbstractVersionedContentManagerInputStreamProvider streamProvider, ContentHash predecessorHintHash, final StoreContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        if (streamProvider == null) {
            throw new IllegalArgumentException();
        }
        try {
            IVersionedContent iVersionedContent;
            StreamLengthUtility slu = null;
            InputStream in = streamProvider.getInputStream(1);
            try {
                void var11_14;
                AbstractVersionedContentManagerInputStreamProvider wrapped;
                slu = this.getStreamLengthUtility(in, context);
                slu.run();
                long length = slu.getStreamLength();
                ContentHash hash = slu.getContentHashCode();
                in.close();
                in = null;
                byte[] bytes = slu.getInputBytes();
                if (bytes != null) {
                    wrapped = streamProvider;
                    VersionedContentManagerByteArrayInputStreamPovider versionedContentManagerByteArrayInputStreamPovider = new VersionedContentManagerByteArrayInputStreamPovider(bytes, 0, (int)length){

                        @Override
                        public InputStream wrapInputStream(InputStream in) throws IOException, TeamRepositoryException {
                            return wrapped.wrapInputStream(in);
                        }
                    };
                } else {
                    wrapped = streamProvider;
                    AbstractVersionedContentManagerInputStreamProvider abstractVersionedContentManagerInputStreamProvider = new AbstractVersionedContentManagerInputStreamProvider(){

                        @Override
                        public InputStream getInputStream(int flags) throws IOException, TeamRepositoryException {
                            return wrapped.getInputStream(flags);
                        }

                        @Override
                        public InputStream wrapInputStream(InputStream in) throws IOException, TeamRepositoryException {
                            in = BasicVersionedContentManager.this.wrapInputStreamForUpload(in, context);
                            return wrapped.wrapInputStream(in);
                        }

                        @Override
                        public void dispose() throws IOException, TeamRepositoryException {
                        }
                    };
                }
                IVersionedContent result = this.internalStoreContent((AbstractVersionedContentManagerInputStreamProvider)var11_14, length, predecessorHintHash, hash, context, monitor);
                slu.cleanup();
                slu = null;
                streamProvider.dispose();
                streamProvider = null;
                iVersionedContent = result;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            if (in == null) throw throwable;
                            in.close();
                            throw throwable;
                        }
                        finally {
                            if (slu != null) {
                                slu.cleanup();
                            }
                        }
                    }
                    catch (IOException iOException) {
                        throw throwable;
                    }
                    catch (TeamRepositoryException teamRepositoryException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new TeamRepositoryException((Object)this.teamRepository(), e.getMessage(), (Throwable)e);
                }
            }
            try {
                try {
                    if (in == null) return iVersionedContent;
                    in.close();
                    return iVersionedContent;
                }
                finally {
                    if (slu != null) {
                        slu.cleanup();
                    }
                }
            }
            catch (IOException iOException) {
                return iVersionedContent;
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
            return iVersionedContent;
        }
        finally {
            if (streamProvider != null) {
                try {
                    streamProvider.dispose();
                }
                catch (TeamRepositoryException teamRepositoryException) {
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected URI getStoreURI(AbstractVersionedContentManagerInputStreamProvider in, long length, ContentHash predecessorHintHash, ContentHash contentHashCode, StoreContext context) throws TeamRepositoryException {
        try {
            URI uri = new URI(this.server.getRepositoryURL());
            String queryParms = "hashcode=" + contentHashCode.toString();
            if (predecessorHintHash != null) {
                queryParms = String.valueOf(queryParms) + "&predecessorHintHash=" + predecessorHintHash.toString();
            }
            if (length > Integer.MAX_VALUE) {
                queryParms = String.valueOf(queryParms) + "&length=" + Long.toString(length);
            }
            String path = String.valueOf(uri.getPath()) + "service" + "/" + IVersionedContentService.class.getName() + "/" + "content";
            String existingQuery = uri.getQuery();
            if (existingQuery != null && existingQuery.trim().length() != 0) {
                queryParms = String.valueOf(existingQuery.trim()) + '&' + queryParms;
            }
            uri = new URI(null, null, path, queryParms, uri.getFragment());
            return uri;
        }
        catch (URISyntaxException e1) {
            throw new TeamRepositoryException((Object)this.teamRepository(), e1.getMessage(), (Throwable)e1);
        }
    }

    protected String getContentType(AbstractVersionedContentManagerInputStreamProvider in, long length, ContentHash predecessorHintHash, ContentHash hash, URI uri, StoreContext context) {
        return "application/octet-stream";
    }

    protected void invokeContentPut(AbstractVersionedContentManagerInputStreamProvider in, long length, ContentHash predecessorHintHash, ContentHash hash, URI uri, StoreContext context) throws TeamRepositoryException {
        HttpPut put = new HttpPut();
        BufferedRequestEntity requestEntity = new BufferedRequestEntity(in, length, this.getContentType(in, length, predecessorHintHash, hash, uri, context), 16384);
        put.setEntity((HttpEntity)requestEntity);
        this.addContentStoreHeaders(put, in, length, predecessorHintHash, hash, uri, context);
        RequestResponsePair method = new RequestResponsePair((HttpRequestBase)put);
        try {
            int result = this.executeMethod(method, true);
            if (result != 201) {
                throw new TeamRepositoryException("Unexpected result code: " + result);
            }
        }
        finally {
            HttpClientUtils.closeQuietly((CloseableHttpResponse)method.getResponse());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int executeMethod(final RequestResponsePair method, boolean tearDownOnSuccess) throws TeamRepositoryException {
        boolean success = false;
        boolean returning = false;
        TeamServiceCallContextImpl.setUpCall((IAbortableHttpRequest)new IAbortableHttpRequest(){

            public String getURI() {
                return method.getRequest().getURI().toString();
            }

            public void abort() {
                method.getRequest().abort();
            }
        });
        try {
            int code = ((RemoteTeamServer)this.server).executeMethod(null, method, false, true, false);
            success = true;
            if (code == 404) {
                Throwable t = this.deserializeException(method);
                if (t instanceof TeamRepositoryException) throw (TeamRepositoryException)t;
                throw new TeamRepositoryException(t);
            }
            returning = true;
            int n = code;
            return n;
        }
        catch (TeamServiceException e) {
            Throwable noCause;
            if (success || method.getResponse() != null && e.getStatusCode() != method.getResponse().getStatusLine().getStatusCode()) {
                throw e;
            }
            Throwable cause = e.getCause();
            if (cause != null) {
                if (!(e instanceof AuthenticationException) || !(cause instanceof PermissionDeniedException) || cause.getCause() != null) throw e;
                noCause = cause;
            } else {
                noCause = e;
            }
            success = false;
            try {
                cause = this.deserializeException(method);
                success = true;
            }
            catch (Exception ex) {
                cause = ex;
            }
            if (success) {
                if (cause instanceof TeamRepositoryException) throw (TeamRepositoryException)cause;
                throw new TeamRepositoryException(cause);
            }
            try {
                noCause.initCause(cause);
                throw e;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            throw e;
        }
        catch (IOException e) {
            throw new TeamServiceException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (tearDownOnSuccess || !returning || BasicVersionedContentManager.isCancelledInContext()) {
                TeamServiceCallContextImpl.tearDownCall();
            }
        }
    }

    private static boolean isCancelledInContext() {
        TeamServiceCallContextImpl c = TeamServiceCallContextImpl.getCurrent();
        if (c != null) {
            return c.isCanceled();
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected Throwable deserializeException(RequestResponsePair method) throws TeamRepositoryException {
        bOut = new UnsynchronizedByteArrayOutputStream();
        try {
            entity = method.getResponse().getEntity();
            if (entity == null) {
                this.ensureLoggedIn();
                bOut.close();
                throw new TeamRepositoryException("Expected a response");
            }
            in = entity.getContent();
            r = new InputStreamReader((InputStream)new TeeInputStream(in, new OutputStream[]{bOut}), HttpUtil.CharsetEncoding.UTF8.toCharset());
        }
        catch (IOException e) {
            bOut.close();
            throw new TeamRepositoryException("Couldn't create stream from response body.", (Throwable)e);
        }
        try {
            return IDeserializer2.FACTORY.newInstance(HttpUtil.MediaType.JSON, null).deserializeException((Reader)r, this.getClass().getClassLoader(), null);
        }
        catch (SerializeException e) {
            try {
                buf = new byte[32768];
                while (bOut.size() < 0x400000 && in.read(buf) != -1) {
                }
            }
            catch (IOException ex) {
                throw new TeamRepositoryException((Throwable)e);
            }
            b = new StringBuilder();
            b.append(method.getResponse().getStatusLine().toString());
            b.append("\r\n");
            var10_10 = method.getResponse().getAllHeaders();
            var9_13 = var10_10.length;
            var8_16 = 0;
            ** while (var8_16 < var9_13)
        }
lbl-1000:
        // 1 sources

        {
            h = var10_10[var8_16];
            b.append(h.toString());
            ++var8_16;
            continue;
        }
lbl38:
        // 1 sources

        if (in instanceof ChunkedInputStream) {
            var11_22 = footers = ((ChunkedInputStream)in).getFooters();
            var10_11 = footers.length;
            var9_13 = 0;
            while (var9_13 < var10_11) {
                h = var11_22[var9_13];
                b.append(h.toString());
                ++var9_13;
            }
        }
        renderedAsText = false;
        try {
            headers = method.getResponse().getHeaders("Content-Type");
            if (headers != null && headers.length == 1 && this.isTextHtml(contentType = headers[0].getValue().trim()) && (charset = this.getCharset(contentType)) != null) {
                html = new String(bOut.getBuffer(), charset);
                b.append("\r\n");
                b.append(html);
                renderedAsText = true;
            }
        }
        catch (Throwable headers) {
            // empty catch block
        }
        if (!renderedAsText) {
            b.append("\r\n");
            bytes = bOut.getBuffer();
            len = bOut.size();
            i = 0;
            while (i < len) {
                val = bytes[i] & 255;
                b.append(Integer.toHexString(val >> 4));
                b.append(Integer.toHexString(val & 15));
                ++i;
            }
        }
        throw new TeamRepositoryException(b.toString(), (Throwable)e);
    }

    private String getCharset(String contentType) {
        String[] split;
        String[] stringArray = split = contentType.split(";");
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String[] keyValue;
            String string = stringArray[n2];
            if (string.trim().startsWith("charset") && (keyValue = string.split("=")).length == 2) {
                return keyValue[1].trim();
            }
            ++n2;
        }
        return null;
    }

    private boolean isTextHtml(String contentType) {
        return contentType.startsWith("text/html");
    }

    protected void addContentStoreHeaders(HttpPut put, AbstractVersionedContentManagerInputStreamProvider in, long length, ContentHash predecessorHintHash, ContentHash hash, URI uri, StoreContext context) throws TeamRepositoryException {
        if (length > Integer.MAX_VALUE) {
            ((AbstractHttpEntity)put.getEntity()).setChunked(true);
        }
        put.setHeader("Content-Type", this.getContentType(in, length, predecessorHintHash, hash, uri, context));
        put.setURI(uri);
        put.setHeader("User-Agent", this.getClass().getName());
        put.setHeader("Accept", HttpUtil.MediaType.JSON.toString());
        put.setHeader("Accept-Charset", HttpUtil.CharsetEncoding.UTF8.toString());
        this.addServiceVersionHeaderForStore((HttpRequestBase)put, context);
        BasicVersionedContentManager.setAcceptLanguageHeader((HttpRequestBase)put);
        this.setUseridHeader((HttpRequestBase)put);
    }

    protected void addServiceVersionHeaderForStore(HttpRequestBase request, StoreContext ctx) {
        this.addServiceVersionHeader(request, IVersionedContentService.class.getName());
    }

    protected void addServiceVersionHeader(HttpRequestBase request, String serviceName) {
        ITeamService teamService = this.server.getServiceByName(serviceName);
        if (teamService == null) {
            return;
        }
        String version = teamService.getVersion();
        if (version != null && version.length() > 0) {
            request.setHeader("X-com-ibm-team-service-version", version);
        }
    }

    protected void deleteContent(ContentHash hash, boolean force, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final URI uri = this.getDeleteContentURI(hash, force);
        try {
            this.ctx.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

                public Object run(IProgressMonitor progressMonitor) throws TeamRepositoryException {
                    long start = System.currentTimeMillis();
                    Method method = BasicVersionedContentManager.this.getDeleteMethodForStatistics();
                    String serviceName = BasicVersionedContentManager.this.getDeleteServiceNameForStatistics();
                    BasicVersionedContentManager.this.preInvoke();
                    boolean success = false;
                    boolean connectionError = false;
                    try {
                        try {
                            BasicVersionedContentManager.this.invokeDeleteContent(uri);
                            success = true;
                        }
                        catch (TeamRepositoryException e) {
                            connectionError = BasicVersionedContentManager.this.onServiceError((Exception)((Object)e));
                            throw e;
                        }
                        catch (RuntimeException e) {
                            connectionError = BasicVersionedContentManager.this.onServiceError(e);
                            throw e;
                        }
                    }
                    catch (Throwable throwable) {
                        BasicVersionedContentManager.this.postInvoke(System.currentTimeMillis() - start, !success, connectionError, method, serviceName);
                        throw throwable;
                    }
                    BasicVersionedContentManager.this.postInvoke(System.currentTimeMillis() - start, !success, connectionError, method, serviceName);
                    return null;
                }
            }, (IProgressMonitor)progress.newChild(100));
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected URI getDeleteContentURI(ContentHash hash, boolean force) throws TeamRepositoryException {
        try {
            URI uri = new URI(this.server.getRepositoryURL());
            String path = String.valueOf(uri.getPath()) + "service" + "/" + IVersionedContentService.class.getName() + "/" + "content" + "/" + hash.toString();
            String queryParms = "force=" + Boolean.toString(force);
            String existingQuery = uri.getQuery();
            if (existingQuery != null && existingQuery.trim().length() != 0) {
                queryParms = String.valueOf(existingQuery.trim()) + '&' + queryParms;
            }
            uri = new URI(null, null, path, queryParms, uri.getFragment());
            return uri;
        }
        catch (URISyntaxException e1) {
            throw new TeamRepositoryException((Object)this.teamRepository(), e1.getMessage(), (Throwable)e1);
        }
    }

    protected Method getDeleteMethodForStatistics() {
        return deleteMethod;
    }

    protected String getDeleteServiceNameForStatistics() {
        return versionedContentServiceName;
    }

    protected void invokeDeleteContent(URI uri) throws TeamRepositoryException {
        HttpDelete delete = new HttpDelete();
        RequestResponsePair method = new RequestResponsePair((HttpRequestBase)delete);
        this.addDeleteContentHeaders(delete, uri);
        try {
            int result = this.executeMethod(method, true);
            if (result != 200) {
                throw new TeamRepositoryException("Unexpected result code: " + result);
            }
        }
        finally {
            HttpClientUtils.closeQuietly((CloseableHttpResponse)method.getResponse());
        }
    }

    protected void addDeleteContentHeaders(HttpDelete delete, URI uri) throws TeamRepositoryException {
        delete.setURI(uri);
        delete.setHeader("User-Agent", this.getClass().getName());
        delete.setHeader("Accept", HttpUtil.MediaType.JSON.toString());
        delete.addHeader("Accept", HttpUtil.MediaType.ANY.toString());
        delete.setHeader("Accept-Charset", HttpUtil.CharsetEncoding.UTF8.toString());
        this.addServiceVersionHeaderForDeleteContent((HttpRequestBase)delete);
        BasicVersionedContentManager.setAcceptLanguageHeader((HttpRequestBase)delete);
        this.setUseridHeader((HttpRequestBase)delete);
    }

    protected void addServiceVersionHeaderForDeleteContent(HttpRequestBase request) {
        this.addServiceVersionHeader(request, IVersionedContentService.class.getName());
    }

    protected long getCleanupPeriod(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final URI uri = this.getRetrieveCleanupPeriodURI();
        try {
            long l = (Long)this.ctx.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Long>(){

                /*
                 * Loose catch block
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Long run(IProgressMonitor progressMonitor) throws TeamRepositoryException {
                    Long l;
                    long start = System.currentTimeMillis();
                    Method method = BasicVersionedContentManager.this.getCleanupPeriodMethodForStatistics();
                    String serviceName = BasicVersionedContentManager.this.getCleanupPeriodServiceNameForStatistics();
                    BasicVersionedContentManager.this.preInvoke();
                    boolean success = false;
                    boolean connectionError = false;
                    try {
                        long result = BasicVersionedContentManager.this.invokeGetCleanupPeriod(uri);
                        success = true;
                        l = result;
                    }
                    catch (TeamRepositoryException e) {
                        try {
                            connectionError = BasicVersionedContentManager.this.onServiceError((Exception)((Object)e));
                            throw e;
                            catch (RuntimeException e2) {
                                connectionError = BasicVersionedContentManager.this.onServiceError(e2);
                                throw e2;
                            }
                        }
                        catch (Throwable throwable) {
                            BasicVersionedContentManager.this.postInvoke(System.currentTimeMillis() - start, !success, connectionError, method, serviceName);
                            throw throwable;
                        }
                    }
                    BasicVersionedContentManager.this.postInvoke(System.currentTimeMillis() - start, !success, connectionError, method, serviceName);
                    return l;
                }
            }, (IProgressMonitor)progress.newChild(100));
            return l;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected URI getRetrieveCleanupPeriodURI() throws TeamRepositoryException {
        try {
            URI uri = new URI(this.server.getRepositoryURL());
            String path = String.valueOf(uri.getPath()) + "service" + "/" + IVersionedContentService.class.getName() + "/" + "cleanupPeriod";
            uri = new URI(null, null, path, uri.getQuery(), uri.getFragment());
            return uri;
        }
        catch (URISyntaxException e1) {
            throw new TeamRepositoryException((Object)this.teamRepository(), e1.getMessage(), (Throwable)e1);
        }
    }

    protected Method getCleanupPeriodMethodForStatistics() {
        return getCleanupPeriodMethod;
    }

    protected String getCleanupPeriodServiceNameForStatistics() {
        return versionedContentServiceName;
    }

    /*
     * Exception decompiling
     */
    protected long invokeGetCleanupPeriod(URI uri) throws TeamRepositoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void addGetCleanupPeriodHeaders(HttpRequestBase getRequest, URI uri) throws TeamRepositoryException {
        getRequest.setURI(uri);
        getRequest.setHeader("User-Agent", this.getClass().getName());
        getRequest.setHeader("Accept", HttpUtil.MediaType.JSON.toString());
        getRequest.addHeader("Accept", HttpUtil.MediaType.ANY.toString());
        getRequest.setHeader("Accept-Charset", HttpUtil.CharsetEncoding.UTF8.toString());
        this.addServiceVersionHeaderForGetCleanupPeriod(getRequest);
        BasicVersionedContentManager.setAcceptLanguageHeader(getRequest);
        this.setUseridHeader(getRequest);
    }

    protected void addServiceVersionHeaderForGetCleanupPeriod(HttpRequestBase request) {
        this.addServiceVersionHeader(request, IVersionedContentService.class.getName());
    }

    protected ContentStatusResponse[] getContentStatus(IVersionableHandle[] v, ContentHash[] h, IProgressMonitor monitor) throws TeamRepositoryException {
        if (v == null) {
            throw new IllegalArgumentException();
        }
        if (h == null) {
            throw new IllegalArgumentException();
        }
        if (v.length != h.length) {
            throw new IllegalArgumentException();
        }
        IVersionableHandle[] iVersionableHandleArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            IVersionableHandle vh = iVersionableHandleArray[n2];
            if (vh != null && vh.getStateId() == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        iVersionableHandleArray = h;
        n = h.length;
        n2 = 0;
        while (n2 < n) {
            IVersionableHandle ch = iVersionableHandleArray[n2];
            if (ch == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        if (v.length <= 1024) {
            return this.getContentStatusChunk(v, h, monitor);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)v.length);
        IVersionableHandle[] vchunk = new IVersionableHandle[1024];
        ContentHash[] hchunk = new ContentHash[1024];
        ContentStatusResponse[] result = new ContentStatusResponse[v.length];
        int remaining = v.length;
        int i = 0;
        while (remaining != 0) {
            int len = Math.min(remaining, 1024);
            if (len != 1024) {
                hchunk = new ContentHash[len];
                vchunk = new IVersionableHandle[len];
            }
            System.arraycopy(v, i, vchunk, 0, len);
            System.arraycopy(h, i, hchunk, 0, len);
            ContentStatusResponse[] chunkresult = this.getContentStatusChunk(vchunk, hchunk, (IProgressMonitor)progress.newChild(len));
            System.arraycopy(chunkresult, 0, result, i, len);
            remaining -= len;
            i += len;
        }
        if (monitor != null) {
            monitor.done();
        }
        return result;
    }

    protected ContentStatusResponse[] getContentStatusChunk(final IVersionableHandle[] v, final ContentHash[] h, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final URI uri = this.getRetrieveContentStatusURI(v, h);
        try {
            ContentStatusResponse[] contentStatusResponseArray = (ContentStatusResponse[])this.ctx.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<ContentStatusResponse[]>(){

                /*
                 * Loose catch block
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public ContentStatusResponse[] run(IProgressMonitor progressMonitor) throws TeamRepositoryException {
                    ContentStatusResponse[] contentStatusResponseArray;
                    long start = System.currentTimeMillis();
                    Method method = BasicVersionedContentManager.this.getContentStatusMethodForStatistics(v, h);
                    String serviceName = BasicVersionedContentManager.this.getContentStatusServiceNameForStatistics(v, h);
                    BasicVersionedContentManager.this.preInvoke();
                    boolean success = false;
                    boolean connectionError = false;
                    try {
                        ContentStatusResponse[] result = BasicVersionedContentManager.this.invokeGetContentStatus(uri, v, h);
                        success = true;
                        contentStatusResponseArray = result;
                    }
                    catch (TeamRepositoryException e) {
                        try {
                            connectionError = BasicVersionedContentManager.this.onServiceError((Exception)((Object)e));
                            throw e;
                            catch (RuntimeException e2) {
                                connectionError = BasicVersionedContentManager.this.onServiceError(e2);
                                throw e2;
                            }
                        }
                        catch (Throwable throwable) {
                            BasicVersionedContentManager.this.postInvoke(System.currentTimeMillis() - start, !success, connectionError, method, serviceName);
                            throw throwable;
                        }
                    }
                    BasicVersionedContentManager.this.postInvoke(System.currentTimeMillis() - start, !success, connectionError, method, serviceName);
                    return contentStatusResponseArray;
                }
            }, (IProgressMonitor)progress.newChild(100));
            return contentStatusResponseArray;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected URI getRetrieveContentStatusURI(IVersionableHandle[] v, ContentHash[] h) throws TeamRepositoryException {
        try {
            URI uri = new URI(this.server.getRepositoryURL());
            String path = String.valueOf(uri.getPath()) + "service" + "/" + IVersionedContentService.class.getName() + "/" + "contentStatus";
            uri = new URI(null, null, path, uri.getQuery(), uri.getFragment());
            return uri;
        }
        catch (URISyntaxException e1) {
            throw new TeamRepositoryException((Object)this.teamRepository(), e1.getMessage(), (Throwable)e1);
        }
    }

    protected Method getContentStatusMethodForStatistics(IVersionableHandle[] v, ContentHash[] h) {
        return getContentStatusMethod;
    }

    protected String getContentStatusServiceNameForStatistics(IVersionableHandle[] v, ContentHash[] h) {
        return versionedContentServiceName;
    }

    protected ContentStatusResponse[] invokeGetContentStatus(URI uri, IVersionableHandle[] v, ContentHash[] h) throws TeamRepositoryException {
        HttpPost post = new HttpPost();
        RequestResponsePair method = new RequestResponsePair((HttpRequestBase)post);
        this.addGetContentStatusHeaders((HttpRequestBase)post, uri, v, h);
        this.addGetContentStatusBody(post, uri, v, h);
        try {
            ContentStatusResponse[] contentStatusResponseArray;
            int result = this.executeMethod(method, false);
            try {
                if (result != 200) {
                    throw new TeamRepositoryException("Unexpected result code: " + result);
                }
                CloseableHttpResponse response = method.getResponse();
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    this.ensureLoggedIn();
                    throw new TeamRepositoryException("Expected a response");
                }
                Charset entityCharset = ContentType.getOrDefault((HttpEntity)entity).getCharset();
                InputStream in = entity.getContent();
                if (in == null) {
                    this.ensureLoggedIn();
                    throw new TeamRepositoryException("Expected a response");
                }
                InputStreamReader r = new InputStreamReader(in, entityCharset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT));
                JSONArray results = JSONArray.parse((Reader)r);
                r.close();
                int len = results.size();
                ContentStatusResponse[] statuses = new ContentStatusResponse[len];
                int i = 0;
                while (i < len) {
                    Timestamp deletedDate;
                    IContributorHandle deletedBy;
                    JSONObject jo = (JSONObject)results.get(i);
                    int ord = ((Number)jo.get((Object)"contentStatus")).intValue();
                    IVersionedContentService.ContentStatus status = null;
                    IVersionedContentService.ContentStatus[] contentStatusArray = IVersionedContentService.ContentStatus.values();
                    int n = contentStatusArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IVersionedContentService.ContentStatus s = contentStatusArray[n2];
                        if (s.ordinal() == ord) {
                            status = s;
                            break;
                        }
                        ++n2;
                    }
                    if (status == null) {
                        throw new TeamRepositoryException("Unexpected content status value " + ord);
                    }
                    if (status == IVersionedContentService.ContentStatus.DELETED) {
                        UUID deletedByUUID = UUID.valueOf((String)((String)jo.get((Object)"deletedBy")));
                        deletedBy = (IContributorHandle)IContributor.ITEM_TYPE.createItemHandle(deletedByUUID, null);
                        deletedDate = new Timestamp(((Number)jo.get((Object)"deletedDate")).longValue());
                    } else {
                        deletedBy = null;
                        deletedDate = null;
                    }
                    statuses[i] = new ContentStatusResponse(status, deletedDate, deletedBy);
                    ++i;
                }
                contentStatusResponseArray = statuses;
            }
            catch (Throwable throwable) {
                try {
                    TeamServiceCallContextImpl.tearDownCall();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
            }
            TeamServiceCallContextImpl.tearDownCall();
            return contentStatusResponseArray;
        }
        finally {
            HttpClientUtils.closeQuietly((CloseableHttpResponse)method.getResponse());
        }
    }

    protected void addGetContentStatusHeaders(HttpRequestBase postRequest, URI uri, IVersionableHandle[] v, ContentHash[] h) throws TeamRepositoryException {
        postRequest.setURI(uri);
        postRequest.setHeader("User-Agent", this.getClass().getName());
        postRequest.setHeader("Accept", HttpUtil.MediaType.JSON.toString());
        postRequest.addHeader("Accept", HttpUtil.MediaType.ANY.toString());
        postRequest.setHeader("Accept-Charset", HttpUtil.CharsetEncoding.UTF8.toString());
        this.addServiceVersionHeaderForGetContentStatus(postRequest);
        BasicVersionedContentManager.setAcceptLanguageHeader(postRequest);
        this.setUseridHeader(postRequest);
    }

    protected void addGetContentStatusBody(HttpPost post, URI uri, IVersionableHandle[] v, ContentHash[] h) throws TeamRepositoryException {
        byte[] content;
        JSONArray a = new JSONArray(v.length);
        int i = 0;
        while (i < v.length) {
            JSONObject arg = new JSONObject();
            arg.put((Object)"contentHash", (Object)h[i].toString());
            IVersionableHandle vh = v[i];
            if (vh == null) {
                arg.put((Object)"versionableHandle", null);
            } else {
                JSONObject item = new JSONObject();
                item.put((Object)"itemType", (Object)ItemUtil.itemType2String((IType)vh.getItemType()));
                item.put((Object)"itemId", (Object)vh.getItemId().getUuidValue());
                item.put((Object)"stateId", (Object)vh.getStateId().getUuidValue());
                arg.put((Object)"versionableHandle", (Object)item);
            }
            a.add((Object)arg);
            ++i;
        }
        try {
            content = a.toString(false).getBytes(HttpUtil.CharsetEncoding.UTF8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 should always be available", e);
        }
        post.setEntity((HttpEntity)new ByteArrayEntity(content, ContentType.create((String)HttpUtil.MediaType.JSON.toString(), (Charset)HttpUtil.CharsetEncoding.UTF8.toCharset())));
    }

    protected void addServiceVersionHeaderForGetContentStatus(HttpRequestBase request) {
        this.addServiceVersionHeader(request, IVersionedContentService.class.getName());
    }

    protected IVersionedContent internalStoreContent(final AbstractVersionedContentManagerInputStreamProvider in, final long length, final ContentHash predecessorHintHash, final ContentHash contentHashCode, final StoreContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            final URI uri = this.getStoreURI(in, length, predecessorHintHash, contentHashCode, context);
            final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            SubMonitor cancellationChild = progress.newChild(0);
            final AbstractVersionedContentManagerInputStreamProvider provider = new AbstractVersionedContentManagerInputStreamProvider(){

                @Override
                public InputStream getInputStream(int flags) throws IOException, TeamRepositoryException {
                    return in.getInputStream(flags);
                }

                @Override
                public void dispose() throws IOException, TeamRepositoryException {
                }

                @Override
                public InputStream wrapInputStream(InputStream stream) throws IOException, TeamRepositoryException {
                    progress.setWorkRemaining(100);
                    return new MonitoredInputStream(in.wrapInputStream(stream), length, (IProgressMonitor)progress.newChild(100));
                }
            };
            this.ctx.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

                /*
                 * Loose catch block
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public ITeamRestServiceClient.IRestClientConnection.Response run(IProgressMonitor progressMonitor) throws TeamRepositoryException {
                    long start = System.currentTimeMillis();
                    Method method = BasicVersionedContentManager.this.getStoreMethodForStatistics(length, predecessorHintHash, contentHashCode, context);
                    String serviceName = BasicVersionedContentManager.this.getStoreServiceNameForStatistics(length, predecessorHintHash, contentHashCode, context);
                    BasicVersionedContentManager.this.preInvoke();
                    boolean success = false;
                    boolean connectionError = false;
                    try {
                        BasicVersionedContentManager.this.invokeContentPut(provider, length, predecessorHintHash, contentHashCode, uri, context);
                        success = true;
                    }
                    catch (TeamRepositoryException e) {
                        try {
                            connectionError = BasicVersionedContentManager.this.onServiceError((Exception)((Object)e));
                            throw e;
                            catch (RuntimeException e2) {
                                connectionError = BasicVersionedContentManager.this.onServiceError(e2);
                                throw e2;
                            }
                        }
                        catch (Throwable throwable) {
                            BasicVersionedContentManager.this.postInvoke(System.currentTimeMillis() - start, !success, connectionError, method, serviceName);
                            throw throwable;
                        }
                    }
                    BasicVersionedContentManager.this.postInvoke(System.currentTimeMillis() - start, !success, connectionError, method, serviceName);
                    return null;
                }
            }, (IProgressMonitor)cancellationChild);
            progress.done();
            IVersionedContent iVersionedContent = this.createVersionedContent(contentHashCode, predecessorHintHash, length, context);
            return iVersionedContent;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected Method getStoreMethodForStatistics(long length, ContentHash predecessorHintHash, ContentHash contentHashCode, StoreContext context) {
        return storeMethod;
    }

    protected String getStoreServiceNameForStatistics(long length, ContentHash predecessorHintHash, ContentHash contentHashCode, StoreContext context) {
        return versionedContentServiceName;
    }

    protected IVersionedContent createVersionedContent(ContentHash hash, ContentHash predecessorHintHash, long size, StoreContext context) {
        VersionedContent vc = ScmFactory.eINSTANCE.createVersionedContent();
        vc.setHash(hash);
        vc.setPredecessorHint(predecessorHintHash);
        vc.setSize(size);
        return vc;
    }

    protected void retrieveContent(IVersionableHandle versionable, IVersionedContent content, OutputStream outStream, RetrieveContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        if (outStream == null) {
            throw new IllegalArgumentException();
        }
        try {
            try {
                if (content == null) {
                    throw new IllegalArgumentException();
                }
                if (versionable == null) {
                    throw new IllegalArgumentException();
                }
                if (versionable.getItemId() == null) {
                    throw new IllegalArgumentException();
                }
                if (versionable.getStateId() == null) {
                    throw new IllegalArgumentException();
                }
                this.internalRetrieveContent(versionable, content, outStream, context, monitor);
                outStream.close();
                outStream = null;
            }
            catch (IOException e) {
                throw new TeamRepositoryException((Object)this.teamRepository(), e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected InputStream retrieveContentStream(IVersionableHandle versionable, IVersionedContent content, RetrieveContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        if (content == null) {
            throw new IllegalArgumentException();
        }
        if (versionable.getItemId() == null) {
            throw new IllegalArgumentException();
        }
        if (versionable.getStateId() == null) {
            throw new IllegalArgumentException();
        }
        return this.internalRetrieveContentStream(versionable, content, context, monitor);
    }

    protected InputStream internalRetrieveContentStream(final IVersionableHandle item, final IVersionedContent content, final RetrieveContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final URI uri = this.getRetrieveURI(item, content, context);
        boolean success = false;
        final TeamServiceCallContextImpl outerCtx = TeamServiceCallContextImpl.getCurrent();
        Object in = (InputStream)this.ctx.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<InputStream>(){

            public InputStream run(IProgressMonitor progressMonitor) throws TeamRepositoryException {
                long start = System.currentTimeMillis();
                long end = 0L;
                int tries = 0;
                Method method = BasicVersionedContentManager.this.getRetrieveMethodForStatistics(item, content, context);
                String serviceName = BasicVersionedContentManager.this.getRetrieveServiceNameForStatistics(item, content, context);
                IRetryPolicy retryPolicy = BasicVersionedContentManager.this.ctx.teamRepository().getRetryPolicy();
                int maxRetries = retryPolicy.getMaxRetries(serviceName, method);
                BasicVersionedContentManager.this.preInvoke();
                TeamServiceCallContextImpl ctx = TeamServiceCallContextImpl.getCurrent();
                if (ctx == outerCtx) {
                    ctx = null;
                }
                boolean outerSuccess = false;
                InputStream in = null;
                try {
                    boolean connectionError = false;
                    boolean success = false;
                    while (!success) {
                        block26: {
                            try {
                                in = BasicVersionedContentManager.this.invokeContentGet(item, content, uri, context, ctx, retryPolicy, serviceName, method, (IProgressMonitor)progress);
                                success = true;
                            }
                            catch (TeamRepositoryException e) {
                                connectionError = BasicVersionedContentManager.this.onServiceError((Exception)((Object)e));
                                if (++tries <= maxRetries && retryPolicy.isRetryable(serviceName, method, (Throwable)e)) {
                                    end = System.currentTimeMillis();
                                    TeamServiceCallContextImpl.setUpPause();
                                    try {
                                        retryPolicy.pauseBeforeRetry(serviceName, method, tries);
                                    }
                                    finally {
                                        TeamServiceCallContextImpl.tearDownPause();
                                    }
                                } else {
                                    throw e;
                                }
                                if (end == 0L) {
                                    end = System.currentTimeMillis();
                                }
                                BasicVersionedContentManager.this.postInvoke(end - start, !success, connectionError, method, serviceName);
                                if (tries > 1) {
                                    BasicVersionedContentManager.this.reportRetryStatistics(BasicVersionedContentManager.this.teamRepository(), serviceName, method);
                                }
                                start = System.currentTimeMillis();
                                end = 0L;
                                continue;
                            }
                            catch (RuntimeException e) {
                                try {
                                    connectionError = BasicVersionedContentManager.this.onServiceError(e);
                                    throw e;
                                }
                                catch (Throwable throwable) {
                                    if (end == 0L) {
                                        end = System.currentTimeMillis();
                                    }
                                    BasicVersionedContentManager.this.postInvoke(end - start, !success, connectionError, method, serviceName);
                                    if (tries > 1) {
                                        BasicVersionedContentManager.this.reportRetryStatistics(BasicVersionedContentManager.this.teamRepository(), serviceName, method);
                                    }
                                    start = System.currentTimeMillis();
                                    end = 0L;
                                    throw throwable;
                                }
                            }
                            if (end != 0L) break block26;
                            end = System.currentTimeMillis();
                        }
                        BasicVersionedContentManager.this.postInvoke(end - start, !success, connectionError, method, serviceName);
                        if (tries > 1) {
                            BasicVersionedContentManager.this.reportRetryStatistics(BasicVersionedContentManager.this.teamRepository(), serviceName, method);
                        }
                        start = System.currentTimeMillis();
                        end = 0L;
                    }
                    outerSuccess = true;
                }
                finally {
                    if (!outerSuccess && in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
                return in;
            }
        }, (IProgressMonitor)progress.newChild(5));
        try {
            final ContentHash expected = content.getHash();
            in = new DigestComputingInputStream((InputStream)in, ContentHash.getHashDigest()){
                private boolean checkedHash;
                {
                    super($anonymous0, $anonymous1);
                    this.checkedHash = false;
                }

                public int read() throws IOException {
                    if (this.checkedHash) {
                        return -1;
                    }
                    int r = super.read();
                    if (r == -1) {
                        this.checkHash();
                    }
                    return r;
                }

                private void checkHash() throws IOException {
                    ContentHash actual = ContentHash.valueOf((byte[])this.getFinalDigest());
                    if (!actual.equals((Object)expected)) {
                        throw new IOException("Expected content hash of " + actual.toString() + " but got " + expected.toString());
                    }
                    this.checkedHash = true;
                }

                public int read(byte[] b, int off, int len) throws IOException {
                    if (this.checkedHash) {
                        return -1;
                    }
                    int r = super.read(b, off, len);
                    if (r == -1) {
                        this.checkHash();
                    }
                    return r;
                }
            };
            in = new MonitoredInputStream((InputStream)in, content.getSize(), (IProgressMonitor)progress);
            success = true;
            Object object = in;
            return object;
        }
        finally {
            if (!success) {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected Method getRetrieveMethodForStatistics(IVersionableHandle item, IVersionedContent content, RetrieveContext context) {
        return fetchMethod;
    }

    protected String getRetrieveServiceNameForStatistics(IVersionableHandle item, IVersionedContent content, RetrieveContext context) {
        return versionedContentServiceName;
    }

    protected URI getRetrieveURI(IVersionableHandle handle, IVersionedContent content, RetrieveContext context) throws TeamRepositoryException {
        try {
            URI uri = new URI(this.server.getRepositoryURL());
            String path = String.valueOf(uri.getPath()) + "service" + "/" + IVersionedContentService.class.getName() + "/" + "content" + "/" + handle.getItemType().getNamespaceURI() + "/" + handle.getItemType().getName() + "/" + handle.getItemId().getUuidValue() + "/" + handle.getStateId().getUuidValue() + "/" + content.getHash();
            uri = new URI(null, null, path, uri.getQuery(), uri.getFragment());
            return uri;
        }
        catch (URISyntaxException e1) {
            throw new TeamRepositoryException((Object)this.teamRepository(), e1.getMessage(), (Throwable)e1);
        }
    }

    protected void preInvoke() throws TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        TeamServiceCallContextImpl.checkCancelable();
        this.ensureLoggedIn();
        TeamRepository repository = (TeamRepository)this.teamRepository();
        repository.statistics().incStatisticValue("com.ibm.team.repository.beingCalledContext", (Object)repository, "debugBeingCalledFlag", 1L);
        if (repository.getDebugMode() == 1) {
            try {
                Thread.sleep(repository.getConnectionTimeout() * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected boolean onServiceError(Exception exception) throws TeamRepositoryException {
        this.ensureLoggedIn();
        boolean connectionError = ConnectionUtil.setConnectionError((Exception)exception, (TeamRepository)((TeamRepository)this.teamRepository()));
        if (exception instanceof TeamRepositoryException) {
            ((TeamRepositoryException)((Object)exception)).setOrigin((Object)this.teamRepository());
        }
        return connectionError;
    }

    protected void postInvoke(long elapsedTime, boolean errorOccured, boolean connectionError, Method method, String serviceName) {
        TeamRepository repository = (TeamRepository)this.teamRepository();
        if (!errorOccured) {
            repository.setErrorState(0, null);
        }
        repository.statistics().decStatisticValue("com.ibm.team.repository.beingCalledContext", (Object)repository, "debugBeingCalledFlag", 1L);
        this.reportCallStatistics((ITeamRepository)repository, serviceName, method, connectionError, elapsedTime);
    }

    private void reportCallStatistics(ITeamRepository repository, String serviceName, Method serviceMethod, boolean connectionError, long elapsedTime) {
        if (!connectionError) {
            repository.statistics().incStatisticValue("com.ibm.team.repository.statistics.serviceMethod", (Object)serviceMethod, "serviceMethodElapsedTime", elapsedTime);
            repository.statistics().incStatisticValue("com.ibm.team.repository.statistics.service", (Object)serviceName, "serviceElapsedTime", elapsedTime);
            repository.statistics().incStatisticValue("com.ibm.team.repository.totalContext", (Object)repository, "totalServiceElapsedTime", elapsedTime);
        }
        repository.statistics().incStatisticValue("com.ibm.team.repository.statistics.serviceMethod", (Object)serviceMethod, "serviceMethodCallCount", 1L);
        repository.statistics().incStatisticValue("com.ibm.team.repository.statistics.service", (Object)serviceName, "serviceCallCount", 1L);
        repository.statistics().incStatisticValue("com.ibm.team.repository.totalContext", (Object)repository, "totalServiceCallCount", 1L);
    }

    private void reportRetryStatistics(ITeamRepository repository, String serviceName, Method serviceMethod) {
        repository.statistics().incStatisticValue("com.ibm.team.repository.statistics.serviceMethod", (Object)serviceMethod, "serviceMethodRetryCount", 1L);
        repository.statistics().incStatisticValue("com.ibm.team.repository.statistics.service", (Object)serviceName, "serviceRetryCount", 1L);
        repository.statistics().incStatisticValue("com.ibm.team.repository.totalContext", (Object)repository, "totalServiceRetryCount", 1L);
    }

    protected void ensureLoggedIn() throws NotLoggedInException {
        if (!this.teamRepository().loggedIn()) {
            String uri = this.teamRepository().getRepositoryURI();
            NotLoggedInException e = new NotLoggedInException(uri);
            e.setOrigin((Object)this.teamRepository());
            throw e;
        }
    }

    protected RequestResponsePair invokePartialContentGet(IVersionableHandle handle, IVersionedContent content, URI uri, long startingOffset, RetrieveContext context) throws TeamRepositoryException {
        HttpGet get = new HttpGet();
        this.addContentRetrieveHeaders((HttpRequestBase)get, handle, content, uri, context);
        if (startingOffset != 0L) {
            get.setHeader("Range", "bytes=" + Long.toString(startingOffset) + "-");
        }
        boolean success = false;
        RequestResponsePair method = new RequestResponsePair((HttpRequestBase)get);
        try {
            int result = this.executeMethod(method, false);
            if (startingOffset == 0L && result != 200 || startingOffset != 0L && result != 206) {
                throw new TeamRepositoryException("Unexpected result code: " + result);
            }
            success = true;
            RequestResponsePair requestResponsePair = method;
            return requestResponsePair;
        }
        finally {
            if (!success) {
                try {
                    try {
                        method.getRequest().abort();
                    }
                    finally {
                        HttpClientUtils.closeQuietly((CloseableHttpResponse)method.getResponse());
                    }
                }
                finally {
                    TeamServiceCallContextImpl.tearDownCall();
                }
            }
        }
    }

    protected InputStream invokeContentGet(final IVersionableHandle handle, final IVersionedContent content, final URI uri, final RetrieveContext context, TeamServiceCallContextImpl serviceCallCtx, final IRetryPolicy retryPolicy, final String serviceName, final Method serviceMethod, IProgressMonitor monitor) throws TeamRepositoryException {
        HttpGet get = new HttpGet();
        RequestResponsePair method = new RequestResponsePair((HttpRequestBase)get);
        boolean success = false;
        try {
            int result;
            int tries = 0;
            while (true) {
                this.addContentRetrieveHeaders((HttpRequestBase)get, handle, content, uri, context);
                try {
                    result = this.executeMethod(method, false);
                }
                catch (TeamServiceException e) {
                    if (++tries > 3) {
                        throw e;
                    }
                    if (!this.isCauseIOException((TeamRepositoryException)((Object)e))) {
                        throw e;
                    }
                    method.getRequest().abort();
                    HttpClientUtils.closeQuietly((CloseableHttpResponse)method.getResponse());
                    get = new HttpGet();
                    method = new RequestResponsePair((HttpRequestBase)get);
                    continue;
                }
                break;
            }
            if (result != 200) {
                throw new TeamRepositoryException("Unexpected result code: " + result);
            }
            final ITeamRepository repository = this.teamRepository();
            final int maxNonIORetries = retryPolicy.getMaxRetries(serviceName, serviceMethod);
            ReleasingAndAbortingCancellableInputStream in = new ReleasingAndAbortingCancellableInputStream(method.getRequest(), method.getResponse().getEntity(), serviceCallCtx, monitor){
                IOException originalEx;
                long position;
                int retryableTries;
                int ioTries;

                @Override
                public int read() throws IOException {
                    while (true) {
                        int byteRead;
                        try {
                            byteRead = super.read();
                        }
                        catch (IOException e) {
                            if (this.position == content.getSize()) {
                                String msg = Messages.BasicVersionedContentManager_3;
                                LogFactory.getLog((String)BasicVersionedContentManager.this.getClass().getName()).warn((Object)msg, (Throwable)e);
                                return -1;
                            }
                            throw e;
                        }
                        if (byteRead == -1) {
                            if (this.position == content.getSize()) {
                                return -1;
                            }
                        } else {
                            if (this.position == content.getSize()) {
                                String msg = Messages.BasicVersionedContentManager_0;
                                LogFactory.getLog((String)BasicVersionedContentManager.this.getClass().getName()).error((Object)msg, (Throwable)new IOException(msg));
                                return -1;
                            }
                            this.ioTries = 0;
                            this.retryableTries = 0;
                            ++this.position;
                            return byteRead;
                        }
                        this.reAcquireStream();
                    }
                }

                private void reAcquireStream() throws IOException {
                    Throwable cause = null;
                    long start = 0L;
                    long elapsed = 0L;
                    boolean connectionError = false;
                    ++this.ioTries;
                    while (true) {
                        if (this.ioTries > 3 || this.retryableTries > maxNonIORetries) {
                            this.reportFailure(this.originalEx, (Exception)cause);
                        }
                        this.pushContext();
                        try {
                            LogFactory.getLog((String)BasicVersionedContentManager.this.getClass().getName()).warn((Object)Messages.BasicVersionedContentManager_2, cause == null ? this.originalEx : cause);
                            start = System.currentTimeMillis();
                            elapsed = 0L;
                            connectionError = false;
                            RequestResponsePair partialGet = BasicVersionedContentManager.this.invokePartialContentGet(handle, content, uri, this.position, context);
                            this.resetStream(partialGet.getRequest(), partialGet.getResponse().getEntity());
                        }
                        catch (TeamRepositoryException tre) {
                            try {
                                connectionError = BasicVersionedContentManager.this.onServiceError((Exception)((Object)tre));
                            }
                            catch (TeamRepositoryException teamRepositoryException) {
                                // empty catch block
                            }
                            elapsed = System.currentTimeMillis() - start;
                            if (maxNonIORetries == 0 || BasicVersionedContentManager.this.isCauseIOException(tre)) {
                                ++this.ioTries;
                            } else if (retryPolicy.isRetryable(serviceName, serviceMethod, (Throwable)tre)) {
                                ++this.retryableTries;
                                if (this.retryableTries <= maxNonIORetries) {
                                    retryPolicy.pauseBeforeRetry(serviceName, serviceMethod, this.retryableTries);
                                }
                            } else {
                                this.reportFailure(this.originalEx, (Exception)((Object)tre));
                            }
                            cause = tre;
                            continue;
                        }
                        finally {
                            this.popContext();
                            if (start == 0L) continue;
                            if (elapsed == 0L) {
                                elapsed = System.currentTimeMillis() - start;
                            }
                            BasicVersionedContentManager.this.reportCallStatistics(repository, serviceName, serviceMethod, connectionError, elapsed);
                            BasicVersionedContentManager.this.reportRetryStatistics(repository, serviceName, serviceMethod);
                            continue;
                        }
                        break;
                    }
                }

                private void reportFailure(IOException originalIOError, Exception cause) throws IOException, EOFException {
                    if (originalIOError != null) {
                        throw originalIOError;
                    }
                    EOFException ex = new EOFException(Messages.BasicVersionedContentManager_1);
                    if (cause != null) {
                        ex.initCause(cause);
                    }
                    throw ex;
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    while (true) {
                        int bytesRead;
                        try {
                            bytesRead = super.read(b, off, len);
                        }
                        catch (IOException e) {
                            if (this.position == content.getSize()) {
                                String msg = Messages.BasicVersionedContentManager_3;
                                LogFactory.getLog((String)BasicVersionedContentManager.this.getClass().getName()).warn((Object)msg, (Throwable)e);
                                return -1;
                            }
                            throw e;
                        }
                        if (bytesRead == -1) {
                            if (this.position == content.getSize()) {
                                return -1;
                            }
                        } else {
                            if (this.position + (long)bytesRead > content.getSize()) {
                                String msg = Messages.BasicVersionedContentManager_0;
                                LogFactory.getLog((String)BasicVersionedContentManager.this.getClass().getName()).error((Object)msg, (Throwable)new IOException(msg));
                                bytesRead = (int)(content.getSize() - this.position);
                                if (bytesRead == 0) {
                                    return -1;
                                }
                                this.position = content.getSize();
                                return bytesRead;
                            }
                            if (bytesRead != 0) {
                                this.ioTries = 0;
                                this.retryableTries = 0;
                                this.position += (long)bytesRead;
                            }
                            return bytesRead;
                        }
                        this.reAcquireStream();
                    }
                }

                @Override
                public long skip(long n) throws IOException {
                    long skipped;
                    try {
                        skipped = super.skip(n);
                    }
                    catch (IOException e) {
                        if (this.position == content.getSize()) {
                            String msg = Messages.BasicVersionedContentManager_3;
                            LogFactory.getLog((String)BasicVersionedContentManager.this.getClass().getName()).warn((Object)msg, (Throwable)e);
                            return 0L;
                        }
                        throw e;
                    }
                    if (skipped != 0L) {
                        this.ioTries = 0;
                        this.retryableTries = 0;
                    }
                    if (skipped + this.position > content.getSize()) {
                        String msg = Messages.BasicVersionedContentManager_0;
                        LogFactory.getLog((String)BasicVersionedContentManager.this.getClass().getName()).error((Object)msg, (Throwable)new IOException(msg));
                        skipped = content.getSize() - this.position;
                        this.position = content.getSize();
                        return skipped;
                    }
                    this.position += skipped;
                    return skipped;
                }

                @Override
                protected void readError(IOException e) throws IOException {
                    if (this.originalEx == null) {
                        this.originalEx = e;
                    }
                    if (this.position == content.getSize()) {
                        throw e;
                    }
                    ++this.ioTries;
                    long start = 0L;
                    long elapsed = 0L;
                    boolean connectionError = false;
                    Throwable ex = e;
                    while (true) {
                        if (this.ioTries > 3 || this.retryableTries > maxNonIORetries) {
                            throw this.originalEx;
                        }
                        LogFactory.getLog((String)BasicVersionedContentManager.this.getClass().getName()).warn((Object)Messages.BasicVersionedContentManager_2, ex);
                        try {
                            start = System.currentTimeMillis();
                            RequestResponsePair partialGet = BasicVersionedContentManager.this.invokePartialContentGet(handle, content, uri, this.position, context);
                            this.resetStream(partialGet.getRequest(), partialGet.getResponse().getEntity());
                        }
                        catch (TeamRepositoryException tre) {
                            try {
                                connectionError = BasicVersionedContentManager.this.onServiceError((Exception)((Object)tre));
                            }
                            catch (TeamRepositoryException teamRepositoryException) {
                                // empty catch block
                            }
                            elapsed = System.currentTimeMillis() - start;
                            if (maxNonIORetries == 0 || BasicVersionedContentManager.this.isCauseIOException(tre)) {
                                ++this.ioTries;
                            } else if (retryPolicy.isRetryable(serviceName, serviceMethod, (Throwable)tre)) {
                                ++this.retryableTries;
                                if (this.retryableTries <= maxNonIORetries) {
                                    retryPolicy.pauseBeforeRetry(serviceName, serviceMethod, this.retryableTries);
                                }
                            } else {
                                throw this.originalEx;
                            }
                            ex = tre;
                            continue;
                        }
                        finally {
                            if (start == 0L) continue;
                            if (elapsed == 0L) {
                                elapsed = System.currentTimeMillis() - start;
                            }
                            BasicVersionedContentManager.this.reportCallStatistics(repository, serviceName, serviceMethod, connectionError, elapsed);
                            BasicVersionedContentManager.this.reportRetryStatistics(repository, serviceName, serviceMethod);
                            continue;
                        }
                        break;
                    }
                }

                @Override
                public boolean markSupported() {
                    return false;
                }

                @Override
                public void mark(int readlimit) {
                }

                @Override
                public void reset() throws IOException {
                    throw new IOException("mark/reset not supported");
                }
            };
            success = true;
            ReleasingAndAbortingCancellableInputStream releasingAndAbortingCancellableInputStream = in;
            return releasingAndAbortingCancellableInputStream;
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        finally {
            if (!success) {
                try {
                    try {
                        method.getRequest().abort();
                    }
                    finally {
                        HttpClientUtils.closeQuietly((CloseableHttpResponse)method.getResponse());
                    }
                }
                finally {
                    TeamServiceCallContextImpl.tearDownCall();
                }
            }
        }
    }

    private boolean isCauseIOException(TeamRepositoryException e) {
        Throwable ex = e;
        while ((ex = ex.getCause()) != null) {
            if (!(ex instanceof IOException)) continue;
            return true;
        }
        return false;
    }

    protected void addContentRetrieveHeaders(HttpRequestBase getRequest, IVersionableHandle handle, IVersionedContent content, URI uri, RetrieveContext context) throws TeamRepositoryException {
        getRequest.setURI(uri);
        getRequest.setHeader("User-Agent", this.getClass().getName());
        getRequest.setHeader("Accept", HttpUtil.MediaType.JSON.toString());
        getRequest.addHeader("Accept", HttpUtil.MediaType.ANY.toString());
        getRequest.setHeader("Accept-Charset", HttpUtil.CharsetEncoding.UTF8.toString());
        BasicVersionedContentManager.setAcceptLanguageHeader(getRequest);
        this.addServiceVersionHeaderForRetrieve(getRequest, context);
        this.setUseridHeader(getRequest);
    }

    protected void addServiceVersionHeaderForRetrieve(HttpRequestBase request, RetrieveContext ctx) {
        this.addServiceVersionHeader(request, IVersionedContentService.class.getName());
    }

    protected void internalRetrieveContent(IVersionableHandle handle, IVersionedContent content, OutputStream out, RetrieveContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        InputStream inStream = this.internalRetrieveContentStream(handle, content, context, monitor);
        try {
            try {
                UnsynchronizedBufferedOutputStream bOut = new UnsynchronizedBufferedOutputStream(out, 32768);
                BasicVersionedContentManager.read(inStream, (OutputStream)bOut);
                bOut.flushToStream();
                inStream.close();
                inStream = null;
            }
            catch (IOException e) {
                TeamRepositoryException tre = new TeamRepositoryException((Throwable)e);
                tre.setOrigin((Object)this.teamRepository());
                throw tre;
            }
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected static void read(InputStream in, OutputStream out) throws IOException {
        byte[] bytes = new byte[32768];
        int len = in.read(bytes);
        while (len != -1) {
            out.write(bytes, 0, len);
            len = in.read(bytes);
        }
    }

    protected SessionType createAsyncSession(int threads, boolean allowFailures, String sessionName, long totalWork, IProgressMonitor monitor) {
        return (SessionType)new BasicAsyncVersionedContentManagerSession(threads, allowFailures, sessionName, totalWork, this, monitor);
    }

    protected SessionType createSyncSession(boolean allowFailures, String sessionName, long totalWork, IProgressMonitor monitor) {
        return (SessionType)new BasicSynchronousVersionedContentManagerSession(sessionName, totalWork, this, monitor);
    }

    protected SessionType createSession(int threads, boolean allowFailures, String sessionName, long totalWork, IProgressMonitor monitor) {
        if (threads < 0) {
            throw new IllegalArgumentException("Maximum number of threads must be zero or more.");
        }
        if (threads == 0) {
            return this.createSyncSession(allowFailures, sessionName, totalWork, monitor);
        }
        return this.createAsyncSession(threads, allowFailures, sessionName, totalWork, monitor);
    }

    protected SessionType createSession(String sessionName, boolean allowFailures, long totalWork, IProgressMonitor monitor) {
        return this.createSession(maxSimultaneousDownloads, allowFailures, sessionName, totalWork, monitor);
    }

    public static void setMaxSimultaneousDownloads(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Maximum number of threads must be zero or more.");
        }
        maxSimultaneousDownloads = count;
    }

    public static int getMaxSimultaneousDownloads() {
        return maxSimultaneousDownloads;
    }

    protected static void setAcceptLanguageHeader(HttpRequestBase request) {
        String variant;
        if (request == null) {
            throw new IllegalArgumentException("method must not be null");
        }
        Locale locale = Locale.getDefault();
        StringBuffer buffer = new StringBuffer(locale.getLanguage());
        String country = locale.getCountry();
        if (country.length() > 0) {
            buffer.append('-').append(country);
        }
        if ((variant = locale.getVariant()).length() > 0) {
            buffer.append('-').append(variant);
        }
        request.setHeader("Accept-Language", buffer.toString());
    }

    protected void setUseridHeader(HttpRequestBase request) {
        String userid = this.server.getUserid();
        if (userid == null) {
            return;
        }
        try {
            userid = URLEncoder.encode(userid, HttpUtil.CharsetEncoding.UTF8.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        request.setHeader("X-com-ibm-team-userid", userid);
    }

    protected class StreamLengthUtility {
        protected final InputStream input;
        protected byte[] inputBytes;
        protected long length = -1L;
        protected ContentHash contentHashCode;
        protected final StoreContext context;

        public StreamLengthUtility(InputStream is, StoreContext context) {
            this.input = is;
            this.context = context;
        }

        public void run() throws TeamRepositoryException {
            byte[] content = new byte[32768];
            int r = -1;
            boolean success = false;
            try {
                try {
                    DigestComputingInputStream hashCalculator = ContentHash.getDigestComputingStream((InputStream)BasicVersionedContentManager.this.wrapInputStreamForUpload(this.input, this.context));
                    int lengthSoFar = 0;
                    while (lengthSoFar != content.length) {
                        r = hashCalculator.read(content, lengthSoFar, content.length - lengthSoFar);
                        if (r == -1) break;
                        lengthSoFar += r;
                    }
                    if (r == -1) {
                        this.inputBytes = content;
                    } else {
                        while ((r = hashCalculator.read(content)) != -1) {
                        }
                    }
                    this.length = hashCalculator.getContentSize();
                    this.contentHashCode = ContentHash.valueOf((byte[])hashCalculator.getFinalDigest());
                    success = true;
                }
                catch (IOException e) {
                    throw new TeamRepositoryException((Object)BasicVersionedContentManager.this.teamRepository(), e.getMessage(), (Throwable)e);
                }
            }
            finally {
                if (!success) {
                    this.length = -1L;
                    try {
                        this.input.close();
                    }
                    catch (IOException e) {}
                } else {
                    try {
                        this.input.close();
                    }
                    catch (IOException e) {
                        throw new TeamRepositoryException((Object)BasicVersionedContentManager.this.teamRepository(), e.getMessage(), (Throwable)e);
                    }
                }
            }
        }

        public long getStreamLength() throws TeamRepositoryException {
            if (this.length == -1L) {
                this.run();
            }
            return this.length;
        }

        public byte[] getInputBytes() throws TeamRepositoryException {
            if (this.length == -1L) {
                this.run();
            }
            return this.inputBytes;
        }

        public ContentHash getContentHashCode() throws TeamRepositoryException {
            if (this.length == -1L) {
                this.run();
            }
            return this.contentHashCode;
        }

        public void cleanup() throws TeamRepositoryException {
            this.inputBytes = null;
        }
    }
}

