/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client;

import com.ibm.team.calm.foundation.common.RTCCommonUtils;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.linktypes.client.ILinkTypeClientLibrary;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.Messages;
import com.ibm.team.scm.common.Pair;
import com.ibm.team.scm.common.internal.gc.Direction;
import com.ibm.team.scm.common.internal.gc.ExternalLink;
import com.ibm.team.scm.common.internal.gc.ExternalLinks;
import com.ibm.team.scm.common.internal.gc.GCUriUtils;
import com.ibm.team.scm.common.internal.gc.OslcFileLink;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.links.CustomLinkTypeInfo;
import com.ibm.team.scm.common.links.ILinkTypeInfo;
import com.ibm.team.scm.common.links.LinkTypeIdentifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public final class LinkTypeClientUtils {
    private LinkTypeClientUtils() {
        throw new RuntimeException("Do not create instances of " + this.getClass().getName());
    }

    public static ILinkTypeInfo getLinkTypeInfo(ITeamRepository repo, LinkTypeIdentifier linkTypeId, IProgressMonitor monitor) throws TeamRepositoryException {
        ILinkTypeClientLibrary library = (ILinkTypeClientLibrary)repo.getClientLibrary(ILinkTypeClientLibrary.class);
        ILinkType linkType = library.getLinkTypeForSpecificVersion(linkTypeId.toLinkServiceId(), linkTypeId.getInstanceId());
        return CustomLinkTypeInfo.create((ILinkType)linkType);
    }

    public static Collection<ILinkType> getAllLinkTypes(ITeamRepository repo, IProjectAreaHandle projectArea, IItemType sourceItemType, IProgressMonitor monitor) throws TeamRepositoryException {
        final ILinkTypeClientLibrary library = (ILinkTypeClientLibrary)repo.getClientLibrary(ILinkTypeClientLibrary.class);
        return RTCCommonUtils.getLinkTypesForSourceType((RTCCommonUtils.ILinkTypeFetcher)new RTCCommonUtils.ILinkTypeFetcher(){

            public Collection<ILinkType> getAvailableLinkTypes(IProjectAreaHandle projectArea) throws TeamRepositoryException {
                return library.getAvailableLinkTypes(projectArea);
            }
        }, (IItemType)sourceItemType, (IProjectAreaHandle)projectArea);
    }

    public static Collection<Pair<ExternalLink, OslcFileLink>> asOslcFileLinks(ExternalLinks links, String gcContext, ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        Collection linkCollection = links.getAllExternalLinks();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)linkCollection.size());
        ArrayList result = NewCollection.arrayList();
        for (ExternalLink link : linkCollection) {
            OslcFileLink oslcFileLink;
            LinkTypeIdentifier linkTypeId;
            ILinkTypeInfo linkTypeInfo;
            URI uri = link.getUri();
            if (gcContext != null) {
                uri = GCUriUtils.makeGCQualifiedUri((URI)uri, (URI)URI.create(gcContext));
            }
            if ((linkTypeInfo = LinkTypeClientUtils.getLinkTypeInfo(repo, linkTypeId = link.getLinkTypeId(), (IProgressMonitor)progress.newChild(1))) == null) {
                oslcFileLink = LinkTypeClientUtils.createOslcFileLinkForUnknownLinkType(uri, link.getLinkTypeId());
            } else {
                URI iconUri = linkTypeInfo.getIconUri();
                oslcFileLink = OslcFileLink.create((URI)uri, (String)linkTypeInfo.getLabel(), (URI)iconUri, (URI)linkTypeInfo.getOslcPropertyUri(), (Direction)Direction.Outgoing);
            }
            result.add(Pair.create((Object)link, (Object)oslcFileLink));
        }
        return result;
    }

    private static OslcFileLink createOslcFileLinkForUnknownLinkType(URI relatedArtifactUri, LinkTypeIdentifier linkTypeId) {
        return OslcFileLink.create((URI)relatedArtifactUri, (String)Messages.UNKNOWN_RELATIONSHIP, null, (URI)URI.create("http://localhost/unknown_relationship/" + linkTypeId.toLinkServiceId() + "/" + linkTypeId.getInstanceId()), (Direction)Direction.Outgoing);
    }
}

