/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.trs.common.internal.trs.model.impl;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ExtensionsUtil {
    public static Object getAttribute(String attributeName, Map stringExtensions, Map mediumStringExtensions, Map largeStringExtensions, Map booleanExtensions, Map intExtensions, Map longExtensions, Map timestampExtensions, Map bigDecimalExtensions) {
        if (stringExtensions.containsKey(attributeName)) {
            return stringExtensions.get(attributeName);
        }
        if (mediumStringExtensions.containsKey(attributeName)) {
            return mediumStringExtensions.get(attributeName);
        }
        if (largeStringExtensions.containsKey(attributeName)) {
            return largeStringExtensions.get(attributeName);
        }
        if (booleanExtensions.containsKey(attributeName)) {
            return booleanExtensions.get(attributeName);
        }
        if (intExtensions.containsKey(attributeName)) {
            return intExtensions.get(attributeName);
        }
        if (longExtensions.containsKey(attributeName)) {
            return longExtensions.get(attributeName);
        }
        if (timestampExtensions.containsKey(attributeName)) {
            return timestampExtensions.get(attributeName);
        }
        if (bigDecimalExtensions.containsKey(attributeName)) {
            return bigDecimalExtensions.get(attributeName);
        }
        return null;
    }

    public static Object setAttribute(String attributeName, Object value, Map stringExtensions, Map mediumStringExtensions, Map largeStringExtensions, Map booleanExtensions, Map intExtensions, Map longExtensions, Map timestampExtensions, Map bigDecimalExtensions) {
        Object oldValue = null;
        if (stringExtensions.containsKey(attributeName)) {
            oldValue = stringExtensions.remove(attributeName);
        }
        if (mediumStringExtensions.containsKey(attributeName)) {
            oldValue = mediumStringExtensions.remove(attributeName);
        }
        if (largeStringExtensions.containsKey(attributeName)) {
            oldValue = largeStringExtensions.remove(attributeName);
        }
        if (booleanExtensions.containsKey(attributeName)) {
            oldValue = booleanExtensions.remove(attributeName);
        }
        if (intExtensions.containsKey(attributeName)) {
            oldValue = intExtensions.remove(attributeName);
        }
        if (longExtensions.containsKey(attributeName)) {
            oldValue = longExtensions.remove(attributeName);
        }
        if (timestampExtensions.containsKey(attributeName)) {
            oldValue = timestampExtensions.remove(attributeName);
        }
        if (bigDecimalExtensions.containsKey(attributeName)) {
            oldValue = bigDecimalExtensions.remove(attributeName);
        }
        if (value instanceof Integer) {
            intExtensions.put(attributeName, value);
        } else if (value instanceof Long) {
            longExtensions.put(attributeName, value);
        } else if (value instanceof Boolean) {
            booleanExtensions.put(attributeName, value);
        } else if (value instanceof Timestamp) {
            timestampExtensions.put(attributeName, value);
        } else if (value instanceof BigDecimal) {
            bigDecimalExtensions.put(attributeName, value);
        } else if (value instanceof String) {
            int length;
            try {
                length = ((String)value).getBytes("UTF-8").length;
            }
            catch (UnsupportedEncodingException e) {
                length = ((String)value).length() * 2;
            }
            if (length < 200) {
                stringExtensions.put(attributeName, value);
            } else if (length < 500) {
                mediumStringExtensions.put(attributeName, value);
            } else {
                largeStringExtensions.put(attributeName, value);
            }
        } else {
            throw new IllegalArgumentException();
        }
        return oldValue;
    }

    public static Collection<String> getAttributeNames(Map<?, ?> ... extensions) {
        HashSet<String> names = new HashSet<String>();
        Map<?, ?>[] mapArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            Map<?, ?> map = mapArray[n2];
            Set<?> keySet = map.keySet();
            for (Object object : keySet) {
                names.add((String)object);
            }
            ++n2;
        }
        return names;
    }

    public static Object removeAttribute(String attributeName, Map<?, ?> ... extensions) {
        Object removed = null;
        Map<?, ?>[] mapArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            Map<?, ?> map = mapArray[n2];
            Object r = map.remove(attributeName);
            if (r != null) {
                removed = r;
            }
            ++n2;
        }
        return removed;
    }
}

