/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.trs.common;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.ISimpleItem;
import com.ibm.team.rtc.trs.common.IValidationData;
import com.ibm.team.rtc.trs.common.IValidationEntry;
import com.ibm.team.rtc.trs.common.IValidationEntryHandle;
import com.ibm.team.rtc.trs.common.internal.trs.model.AttributeRepairData;
import com.ibm.team.rtc.trs.common.internal.trs.model.ETagRepairData;
import com.ibm.team.rtc.trs.common.internal.trs.model.ProgressData;
import com.ibm.team.rtc.trs.common.internal.trs.model.TrsFactory;
import com.ibm.team.rtc.trs.common.internal.trs.model.TrsPackage;
import com.ibm.team.rtc.trs.common.internal.trs.model.ValidationEntry;
import com.ibm.team.rtc.trs.common.internal.trs.model.ValidationResult;
import java.sql.Timestamp;
import java.util.List;

public interface IValidationResult
extends ISimpleItem {
    public static final int SCHEDULED = 0;
    public static final int IN_PROGRESS = 1;
    public static final int COMPLETED_OK = 2;
    public static final int COMPLETED_RESULTS = 3;
    public static final int ARCHIVED = 4;
    public static final int REPAIR_SCHEDULED = 5;
    public static final int REPAIR_IN_PROGRESS = 6;
    public static final String REMOVE_ATTRIBUTE = "AttributeRepairData.removeAttribute";
    public static final IItemType ITEM_TYPE = IItemType.IRegistry.INSTANCE.getItemType(TrsPackage.eINSTANCE.getValidationResult().getName(), "com.ibm.team.rtc.trs");
    public static final IValidationFactory FACTORY = new IValidationFactory(){};

    public String getFeedId();

    public int getStatus();

    public List<IValidationEntryHandle> getValidationEntries();

    public IItemHandle getItem();

    public String getType();

    public String getDescription();

    public static interface IValidationFactory {
        default public IValidationResult createValidationResult(int status) {
            ValidationResult result = TrsFactory.eINSTANCE.createValidationResult();
            result.initNew();
            result.setStatus(status);
            return result;
        }

        default public IValidationResult createValidationResult(String type, Timestamp eventTime, IItemHandle item, String description) {
            if (type == null) {
                throw new IllegalArgumentException();
            }
            if (eventTime == null) {
                throw new IllegalArgumentException();
            }
            ValidationResult result = TrsFactory.eINSTANCE.createValidationResult();
            result.initNew();
            result.setStatus(0);
            result.setEventTime(eventTime);
            result.setItem(item);
            result.setType(type);
            result.setDescription(description);
            return result;
        }

        default public IValidationEntry createValidationEntry(String resource, int severity, String message) {
            if (resource == null) {
                throw new IllegalArgumentException();
            }
            ValidationEntry entry = TrsFactory.eINSTANCE.createValidationEntry();
            entry.initNew();
            entry.setResourceUri(resource);
            entry.setMessage(message);
            entry.setSeverity(severity);
            return entry;
        }

        default public IValidationData createAttributeRepairData(String attributeName, String expectedValue) {
            AttributeRepairData repairData = TrsFactory.eINSTANCE.createAttributeRepairData();
            repairData.setAttributeName(attributeName);
            repairData.setExpectedValue(expectedValue);
            return repairData;
        }

        default public IValidationData createETagRepairData(String expectedETag) {
            ETagRepairData repairData = TrsFactory.eINSTANCE.createETagRepairData();
            repairData.setExpectedValue(expectedETag);
            return repairData;
        }

        default public IValidationData createMissingBaseEntryRepairData() {
            return TrsFactory.eINSTANCE.createMissingBaseEntryRepairData();
        }

        default public IValidationData createProgressData(int completedItems, int totalItems) {
            ProgressData data = TrsFactory.eINSTANCE.createProgressData();
            data.setTotalItems(totalItems);
            data.setCompletedItems(completedItems);
            return data;
        }
    }
}

