/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.trs.common;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.ISimpleItem;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.trs.common.ChangeKind;
import com.ibm.team.rtc.trs.common.IChangeLogEntryFactory;
import com.ibm.team.rtc.trs.common.IChangeLogEntryHandle;
import com.ibm.team.rtc.trs.common.IChangeLogPatchEntry;
import com.ibm.team.rtc.trs.common.ITriple;
import com.ibm.team.rtc.trs.common.internal.trs.model.ChangeLogEntry;
import com.ibm.team.rtc.trs.common.internal.trs.model.ChangeLogPatchEntry;
import com.ibm.team.rtc.trs.common.internal.trs.model.StringTriple;
import com.ibm.team.rtc.trs.common.internal.trs.model.Triple;
import com.ibm.team.rtc.trs.common.internal.trs.model.TrsFactory;
import com.ibm.team.rtc.trs.common.internal.trs.model.TrsPackage;
import java.sql.Timestamp;

public interface IChangeLogEntry
extends IChangeLogEntryHandle,
ISimpleItem {
    public static final IItemType ITEM_TYPE = IItemType.IRegistry.INSTANCE.getItemType(TrsPackage.eINSTANCE.getChangeLogEntry().getName(), "com.ibm.team.rtc.trs");
    public static final IChangeLogEntryFactory FACTORY = new IChangeLogEntryFactory(){

        @Override
        public IChangeLogPatchEntry createChangeLogPatchEntry(String resourceUri, IItemHandle item, Timestamp eventTime, ChangeKind changeKind, UUID changeEventId, String beforeETag, String afterEtag, ITriple[] additions, ITriple[] deletions) {
            return this.createChangeLogPatchEntry(resourceUri, item, eventTime, changeEventId, beforeETag, afterEtag, additions, deletions);
        }

        @Override
        public IChangeLogPatchEntry createChangeLogPatchEntry(String resourceUri, IItemHandle item, Timestamp eventTime, UUID changeEventId, String beforeETag, String afterEtag, ITriple[] additions, ITriple[] deletions) {
            ITriple triple;
            if (deletions.length == 0 && additions.length == 0) {
                throw new IllegalArgumentException("A patch must have at least one change");
            }
            ChangeLogPatchEntry entry = TrsFactory.eINSTANCE.createChangeLogPatchEntry();
            entry.setResourceUri(resourceUri);
            entry.setItem(item);
            entry.setEventTime(eventTime);
            entry.setChangeEventId(changeEventId);
            entry.setKind(ChangeKind.Modification.getKind());
            entry.setBeforeETag(beforeETag);
            entry.setAfterETag(afterEtag);
            ITriple[] iTripleArray = additions;
            int n = additions.length;
            int n2 = 0;
            while (n2 < n) {
                triple = iTripleArray[n2];
                entry.getAdditions().add(triple);
                ++n2;
            }
            iTripleArray = deletions;
            n = deletions.length;
            n2 = 0;
            while (n2 < n) {
                triple = iTripleArray[n2];
                entry.getDeletions().add(triple);
                ++n2;
            }
            return entry;
        }

        @Override
        public IChangeLogEntry createChangeLogEntry(String resourceUri, IItemHandle item, Timestamp eventTime, ChangeKind changeKind, UUID changeEventId, String afterETag) {
            ChangeLogEntry entry = TrsFactory.eINSTANCE.createChangeLogEntry();
            entry.setResourceUri(resourceUri);
            entry.setItem(item);
            entry.setEventTime(eventTime);
            entry.setChangeEventId(changeEventId);
            entry.setKind(changeKind.getKind());
            entry.setAfterETag(afterETag);
            return entry;
        }

        @Override
        public ITriple createTriple(String subject, String predicate, String object) {
            Triple triple = TrsFactory.eINSTANCE.createTriple();
            triple.setSubject(subject);
            triple.setPredicate(predicate);
            triple.setObject(object);
            return triple;
        }

        @Override
        public ITriple createResourceTriple(String subject, String predicate, String resourceUri) {
            return this.createTriple(subject, predicate, resourceUri);
        }

        @Override
        public ITriple createStringTriple(String subject, String predicate, String object) {
            StringTriple triple = TrsFactory.eINSTANCE.createStringTriple();
            triple.setSubject(subject);
            triple.setPredicate(predicate);
            triple.setObject(object);
            return triple;
        }
    };

    public String getFeedId();

    public String getResourceUri();

    public IItemHandle getItem();

    public Timestamp getEventTime();

    public long getSequence();

    public UUID getChangeEventId();

    public ChangeKind getChangeKind();

    public String getAfterETag();
}

