/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2010, 2013. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp. 
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.rtc.foundation.api.ui.internal.util.CompositeMoveHandler"); //$NON-NLS-1$

dojo.require("com.ibm.jdojo.util.Assert"); //$NON-NLS-1$

(function() {
var Assert= com.ibm.jdojo.util.Assert;

dojo.declare("com.ibm.team.rtc.foundation.api.ui.internal.util.CompositeMoveHandler", null, { //$NON-NLS-1$
	"-chains-": { constructor: "manual" },

	//fHandlers: null,

	constructor: function() {
		this.fHandlers= [];
	},

	add: function(handler) {
		if (handler == null) 
			return ;
		this.fHandlers.push(handler);
	},

	canMove: function(request, readAccessor) {
		var result= new CompositeMoveResponse();
		for (var i= 0; i < this.fHandlers.length; i++){
			var handler= this.fHandlers[i];
			var response= handler.canMove(request, readAccessor);
			result.add(response);
			if (response != null && !response.canMove()) 
				return result;
		}
		if (result.allNull()) {
			return null;
		}
		return result;
	},

	move: function(response, updateAccessor) {
		if (!(response instanceof CompositeMoveResponse)) Assert.fail("response instanceof CompositeMoveResponse", "CompositeMoveHandler:90");
		var respones= response.getResponses();
		if (!(respones.length === this.fHandlers.length)) Assert.fail("respones.length === this.fHandlers.length", "CompositeMoveHandler:93");
		for (var i= 0; i < this.fHandlers.length; i++){
			var childResponse= respones[i];
			if (childResponse != null) {
				this.fHandlers[i].move(childResponse, updateAccessor);
			}
		}
	},

	isSupported: function(location) {
		for (var i= 0; i < this.fHandlers.length; i++){
			var handler= this.fHandlers[i];
			if (handler.isSupported(location)) {
				return true;
			}
		}
		return false;
	},

	$interfaces: {
		'com.ibm.team.rtc.foundation.api.ui.essentials.IMoveHandler': true //$NON-NLS-1$
	}
});
var CompositeMoveResponse= dojo.declare("com.ibm.team.rtc.foundation.api.ui.internal.util.CompositeMoveHandler.CompositeMoveResponse", null, { //$NON-NLS-1$
	"-chains-": { constructor: "manual" },

	//fCanMove: null,

	//fAllNull: null,

	//fResponses: null,

	//fData: null,

	constructor: function() {
		this.fCanMove= true;
		this.fAllNull= true;
		this.fResponses= [];
	},

	add: function(response) {
		if (response != null) {
			this.fAllNull= false;
			this.fCanMove= this.fCanMove && response.canMove();
		}
		this.fResponses.push(response);
		this.fData= null;
	},

	getResponses: function() {
		return this.fResponses;
	},

	canMove: function() {
		if (this.fAllNull) 
			return false;
		return this.fCanMove;
	},

	allNull: function() {
		return this.fAllNull;
	},

	getData: function() {
		if (this.fData == null) {
			this.fData= [];
			var $subject= this.fResponses;
			var $length= $subject.length;
			for (var $count= 0; $count < $length; $count++){
				var response= $subject[$count];
				if (response != null) {
					this.fData.push(response.getData());
				} else {
					this.fData.push(null);
				}
			}
		}
		return this.fData;
	},

	$interfaces: {
		'com.ibm.team.rtc.foundation.api.ui.essentials.IMoveHandler.IMoveResponse': true //$NON-NLS-1$
	}
});

})();
