/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2010, 2012. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp. 
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.rtc.foundation.api.ui.internal.util.CompositeCreateHandler"); //$NON-NLS-1$

dojo.require("com.ibm.jdojo.util.Assert"); //$NON-NLS-1$

(function() {
var Assert= com.ibm.jdojo.util.Assert;

dojo.declare("com.ibm.team.rtc.foundation.api.ui.internal.util.CompositeCreateHandler", null, { //$NON-NLS-1$
	"-chains-": { constructor: "manual" },

	//fHandlers: null,

	constructor: function() {
		this.fHandlers= [];
	},

	add: function(handler) {
		if (handler == null) 
			return ;
		this.fHandlers.push(handler);
	},

	canCreate: function(request, readAccessor) {
		var result= new CompositeCreateResponse();
		for (var i= 0; i < this.fHandlers.length; i++){
			var handler= this.fHandlers[i];
			var response= handler.canCreate(request, readAccessor);
			result.add(response);
			if (response != null && !response.canCreate()) 
				return result;
		}
		if (result.allNull()) {
			return null;
		}
		return result;
	},

	onCreate: function(response, newItem, updateAccessor) {
		if (!(response instanceof CompositeCreateResponse)) Assert.fail("response instanceof CompositeCreateResponse", "CompositeCreateHandler:90");
		var respones= response.getResponses();
		if (!(respones.length === this.fHandlers.length)) Assert.fail("respones.length === this.fHandlers.length", "CompositeCreateHandler:93");
		for (var i= 0; i < this.fHandlers.length; i++){
			var childResponse= respones[i];
			if (childResponse != null) {
				this.fHandlers[i].onCreate(childResponse, newItem, updateAccessor);
			}
		}
	},

	$interfaces: {
		'com.ibm.team.rtc.foundation.api.ui.essentials.ICreateHandler': true //$NON-NLS-1$
	}
});
var CompositeCreateResponse= dojo.declare("com.ibm.team.rtc.foundation.api.ui.internal.util.CompositeCreateHandler.CompositeCreateResponse", null, { //$NON-NLS-1$
	"-chains-": { constructor: "manual" },

	//fCanCreate: null,

	//fAllNull: null,

	//fResponses: null,

	//fData: null,

	constructor: function() {
		this.fCanCreate= true;
		this.fAllNull= true;
		this.fResponses= [];
	},

	add: function(response) {
		if (response != null) {
			this.fAllNull= false;
			this.fCanCreate= this.fCanCreate && response.canCreate();
		}
		this.fResponses.push(response);
		this.fData= null;
	},

	getResponses: function() {
		return this.fResponses;
	},

	canCreate: function() {
		if (this.fAllNull) 
			return false;
		return this.fCanCreate;
	},

	allNull: function() {
		return this.fAllNull;
	},

	getData: function() {
		if (this.fData == null) {
			this.fData= [];
			var $subject= this.fResponses;
			var $length= $subject.length;
			for (var $count= 0; $count < $length; $count++){
				var response= $subject[$count];
				if (response != null) {
					this.fData.push(response.getData());
				} else {
					this.fData.push(null);
				}
			}
		}
		return this.fData;
	},

	$interfaces: {
		'com.ibm.team.rtc.foundation.api.ui.essentials.ICreateHandler.ICreateResponse': true //$NON-NLS-1$
	}
});

})();
