/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.foundation.api.ui.internal.util;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.team.rtc.foundation.api.ui.essentials.IModificationPolicy;
import com.ibm.team.rtc.foundation.api.ui.essentials.IMoveHandler;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReader;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdater;
import java.util.ArrayList;
import java.util.List;

public class CompositeMoveHandler
extends DojoObject
implements IMoveHandler {
    private List<IMoveHandler> fHandlers = new ArrayList<IMoveHandler>();

    public void add(IMoveHandler handler) {
        if (handler == null) {
            return;
        }
        this.fHandlers.add(handler);
    }

    @Override
    public IMoveHandler.IMoveResponse canMove(IMoveHandler.IMoveRequest request, IViewModelReader readAccessor) {
        CompositeMoveResponse result = new CompositeMoveResponse();
        int i = 0;
        while (i < this.fHandlers.size()) {
            IMoveHandler handler = this.fHandlers.get(i);
            IMoveHandler.IMoveResponse response = handler.canMove(request, readAccessor);
            result.add(response);
            if (response != null && !response.canMove()) {
                return result;
            }
            ++i;
        }
        if (result.allNull()) {
            return null;
        }
        return result;
    }

    @Override
    public void move(IMoveHandler.IMoveResponse response, IViewModelUpdater updateAccessor) {
        assert (response instanceof CompositeMoveResponse);
        List<IMoveHandler.IMoveResponse> respones = ((CompositeMoveResponse)response).getResponses();
        assert (respones.size() == this.fHandlers.size());
        int i = 0;
        while (i < this.fHandlers.size()) {
            IMoveHandler.IMoveResponse childResponse = respones.get(i);
            if (childResponse != null) {
                this.fHandlers.get(i).move(childResponse, updateAccessor);
            }
            ++i;
        }
    }

    @Override
    public boolean isSupported(IModificationPolicy.Location location) {
        int i = 0;
        while (i < this.fHandlers.size()) {
            IMoveHandler handler = this.fHandlers.get(i);
            if (handler.isSupported(location)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static class CompositeMoveResponse
    extends DojoObject
    implements IMoveHandler.IMoveResponse {
        private boolean fCanMove = true;
        private boolean fAllNull = true;
        private List<IMoveHandler.IMoveResponse> fResponses = new ArrayList<IMoveHandler.IMoveResponse>();
        private List<Object> fData = null;

        private CompositeMoveResponse() {
        }

        public void add(IMoveHandler.IMoveResponse response) {
            if (response != null) {
                this.fAllNull = false;
                this.fCanMove = this.fCanMove && response.canMove();
            }
            this.fResponses.add(response);
            this.fData = null;
        }

        public List<IMoveHandler.IMoveResponse> getResponses() {
            return this.fResponses;
        }

        @Override
        public boolean canMove() {
            if (this.fAllNull) {
                return false;
            }
            return this.fCanMove;
        }

        public boolean allNull() {
            return this.fAllNull;
        }

        @Override
        public Object getData() {
            if (this.fData == null) {
                this.fData = new ArrayList<Object>();
                for (IMoveHandler.IMoveResponse response : this.fResponses) {
                    if (response != null) {
                        this.fData.add(response.getData());
                        continue;
                    }
                    this.fData.add(null);
                }
            }
            return this.fData;
        }
    }
}

