/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.foundation.api.ui.internal.util;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.team.rtc.foundation.api.ui.essentials.ICreateHandler;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReader;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdater;
import java.util.ArrayList;
import java.util.List;

public class CompositeCreateHandler
extends DojoObject
implements ICreateHandler {
    private List<ICreateHandler> fHandlers = new ArrayList<ICreateHandler>();

    public void add(ICreateHandler handler) {
        if (handler == null) {
            return;
        }
        this.fHandlers.add(handler);
    }

    @Override
    public ICreateHandler.ICreateResponse canCreate(ICreateHandler.ICreateRequest request, IViewModelReader readAccessor) {
        CompositeCreateResponse result = new CompositeCreateResponse();
        int i = 0;
        while (i < this.fHandlers.size()) {
            ICreateHandler handler = this.fHandlers.get(i);
            ICreateHandler.ICreateResponse response = handler.canCreate(request, readAccessor);
            result.add(response);
            if (response != null && !response.canCreate()) {
                return result;
            }
            ++i;
        }
        if (result.allNull()) {
            return null;
        }
        return result;
    }

    @Override
    public void onCreate(ICreateHandler.ICreateResponse response, Object newItem, IViewModelUpdater updateAccessor) {
        assert (response instanceof CompositeCreateResponse);
        List<ICreateHandler.ICreateResponse> respones = ((CompositeCreateResponse)response).getResponses();
        assert (respones.size() == this.fHandlers.size());
        int i = 0;
        while (i < this.fHandlers.size()) {
            ICreateHandler.ICreateResponse childResponse = respones.get(i);
            if (childResponse != null) {
                this.fHandlers.get(i).onCreate(childResponse, newItem, updateAccessor);
            }
            ++i;
        }
    }

    private static class CompositeCreateResponse
    extends DojoObject
    implements ICreateHandler.ICreateResponse {
        private boolean fCanCreate = true;
        private boolean fAllNull = true;
        private List<ICreateHandler.ICreateResponse> fResponses = new ArrayList<ICreateHandler.ICreateResponse>();
        private List<Object> fData = null;

        private CompositeCreateResponse() {
        }

        public void add(ICreateHandler.ICreateResponse response) {
            if (response != null) {
                this.fAllNull = false;
                this.fCanCreate = this.fCanCreate && response.canCreate();
            }
            this.fResponses.add(response);
            this.fData = null;
        }

        public List<ICreateHandler.ICreateResponse> getResponses() {
            return this.fResponses;
        }

        @Override
        public boolean canCreate() {
            if (this.fAllNull) {
                return false;
            }
            return this.fCanCreate;
        }

        public boolean allNull() {
            return this.fAllNull;
        }

        @Override
        public Object getData() {
            if (this.fData == null) {
                this.fData = new ArrayList<Object>();
                for (ICreateHandler.ICreateResponse response : this.fResponses) {
                    if (response != null) {
                        this.fData.add(response.getData());
                        continue;
                    }
                    this.fData.add(null);
                }
            }
            return this.fData;
        }
    }
}

