/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.internal.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class CommonCSVTokenizer {
    private static final char QUOTE = '\"';
    protected final Reader fReader;
    protected final String fDelimiter;
    protected String fLineSeparator;
    protected final List<List<String>> fTokens;

    public CommonCSVTokenizer(Reader reader, String delimiter, int numRows, IProgressMonitor monitor) throws IOException {
        this.fReader = reader;
        this.fDelimiter = delimiter;
        this.fTokens = new ArrayList<List<String>>();
        this.fLineSeparator = System.getProperty("line.separator");
        if (this.fLineSeparator == null || this.fLineSeparator.length() == 0) {
            this.fLineSeparator = "\n";
        }
        this.parse(numRows, monitor);
    }

    public List<List<String>> getTokens() {
        return this.fTokens;
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parse(int maxRows, IProgressMonitor monitor) throws IOException {
        bufReader = null;
        try {
            prevRow = new StringBuilder();
            bufReader = new BufferedReader(this.fReader);
            parseAll = maxRows < 0;
            if (true) ** GOTO lbl30
            do {
                quoteCount = this.count(line, '\"');
                if (prevRow.length() == 0) {
                    if (quoteCount == 0 || quoteCount % 2 == 0) {
                        tokens = this.parseTokens(line);
                        if (!tokens.isEmpty()) {
                            this.fTokens.add(tokens);
                        }
                    } else {
                        prevRow.append(line);
                    }
                } else if (quoteCount == 0 || quoteCount % 2 == 0) {
                    prevRow.append(this.fLineSeparator).append(line);
                } else {
                    prevRow.append(this.fLineSeparator).append(line);
                    tokens = this.parseTokens(prevRow.toString());
                    if (!tokens.isEmpty()) {
                        this.fTokens.add(tokens);
                    }
                    prevRow.setLength(0);
                }
lbl30:
                // 5 sources

                if (monitor.isCanceled() || !parseAll && this.fTokens.size() >= maxRows) return;
            } while ((line = bufReader.readLine()) != null);
            return;
        }
        finally {
            if (bufReader != null) {
                bufReader.close();
            }
        }
    }

    private List<String> parseTokens(String line) {
        ArrayList<StringBuilder> builderList = new ArrayList<StringBuilder>();
        int tokenIndex = 0;
        boolean inQuotes = false;
        boolean inOpenEscapedQuotes = false;
        builderList.add(new StringBuilder());
        int i = 0;
        while (i < line.length()) {
            char curChar = line.charAt(i);
            if (curChar == '\"' && !inQuotes) {
                inQuotes = true;
            } else if (curChar == '\"' && inQuotes) {
                if (!inOpenEscapedQuotes && i + 1 < line.length() && line.charAt(i + 1) == '\"') {
                    inOpenEscapedQuotes = true;
                    ((StringBuilder)builderList.get(tokenIndex)).append(curChar);
                } else if (i > 0 && line.charAt(i - 1) == '\"' && inOpenEscapedQuotes) {
                    inOpenEscapedQuotes = false;
                } else {
                    inQuotes = false;
                    inOpenEscapedQuotes = false;
                }
            } else if (!inQuotes && String.valueOf(curChar).equals(this.fDelimiter)) {
                ++tokenIndex;
                builderList.add(new StringBuilder());
            } else {
                ((StringBuilder)builderList.get(tokenIndex)).append(curChar);
            }
            ++i;
        }
        ArrayList<String> tokens = new ArrayList<String>(builderList.size());
        for (StringBuilder builder : builderList) {
            tokens.add(builder.toString());
        }
        return tokens;
    }

    private int count(String str, char c) {
        int count = 0;
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == c) {
                ++count;
            }
            ++i;
        }
        return count;
    }
}

