/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.internal.setup.builders;

import com.ibm.team.process.common.internal.setup.builders.IProcessBuilderContext;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorDetails;
import com.ibm.team.repository.common.IContributorDetailsHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Contributor;
import com.ibm.team.repository.common.service.IContributorService;
import com.ibm.team.repository.common.service.IExternalUserRegistryService;
import com.ibm.team.rtc.common.internal.setup.builders.AbstractArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.BuildContext;
import com.ibm.team.rtc.common.internal.setup.builders.ContributorDetailsBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.ValueKey;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class ContributorBuilder
extends AbstractArtifactBuilder<IContributor> {
    public static final String DEFAULT_PASSWORD = "password";
    protected static final ValueKey<String> NAME_KEY = new ValueKey(String.valueOf(ContributorBuilder.class.getName()) + ".name");
    protected static final ValueKey<UUID> CONTEXT_ID_KEY = new ValueKey(String.valueOf(ContributorBuilder.class.getName()) + ".contextId");
    protected static final ValueKey<ContributorDetailsBuilder> DETAILS_KEY = new ValueKey(String.valueOf(ContributorBuilder.class.getName()) + ".details");
    protected static final ValueKey<String> USER_ID_KEY = new ValueKey(String.valueOf(ContributorBuilder.class.getName()) + ".userId");
    protected static final ValueKey<String> PASSWORD_KEY = new ValueKey(String.valueOf(ContributorBuilder.class.getName()) + ".password");
    protected static final ValueKey<String> EMAIL_ADDRESS_KEY = new ValueKey(String.valueOf(ContributorBuilder.class.getName()) + ".emailAddress");
    protected static final ValueKey<Boolean> ARCHIVED = new ValueKey(String.valueOf(ContributorBuilder.class.getName()) + ".archived");
    protected static final ValueKey<List<String>> JAZZ_ROLES = new ValueKey(String.valueOf(ContributorBuilder.class.getName()) + ".jazzRoles");
    protected static final ValueKey<UUID> ITEM_ID_KEY = new ValueKey(String.valueOf(ContributorBuilder.class.getName()) + ".itemId");

    public ContributorBuilder(IProcessBuilderContext buildContext) {
        super(buildContext);
        this.setBuilderValue(JAZZ_ROLES, new LinkedList());
    }

    public ContributorBuilder contextId(UUID contextId) {
        this.setBuilderValue(CONTEXT_ID_KEY, contextId);
        return this;
    }

    public ContributorBuilder name(String name) {
        this.setBuilderValue(NAME_KEY, name);
        return this;
    }

    public ContributorBuilder password(String password) {
        this.setBuilderValue(PASSWORD_KEY, password);
        return this;
    }

    public ContributorBuilder details(ContributorDetailsBuilder detailsBuilder) {
        this.setBuilderValue(DETAILS_KEY, detailsBuilder);
        return this;
    }

    public ContributorBuilder userId(String userId) {
        this.setBuilderValue(USER_ID_KEY, userId);
        return this;
    }

    public ContributorBuilder email(String emailAddress) {
        this.setBuilderValue(EMAIL_ADDRESS_KEY, emailAddress);
        return this;
    }

    public ContributorBuilder role(String ... roles) {
        this.getBuilderValue(JAZZ_ROLES).addAll(Arrays.asList(roles));
        return this;
    }

    public ContributorBuilder itemId(UUID itemId) {
        this.setBuilderValue(ITEM_ID_KEY, itemId);
        return this;
    }

    public ContributorBuilder archived(boolean archived) {
        this.setBuilderValue(ARCHIVED, archived);
        return this;
    }

    @Override
    protected IProcessBuilderContext getContext() {
        return (IProcessBuilderContext)super.getContext();
    }

    @Override
    protected IContributor doBuild(BuildContext buildContext) {
        Contributor contributor = (Contributor)this.artifact(IContributor.ITEM_TYPE);
        UUID uuid = UUID.generate();
        String uuidStr = uuid.getUuidValue();
        contributor.setContextId(this.chooseValue(CONTEXT_ID_KEY, contributor.getContextId(), UUID.generate()));
        contributor.setName(this.chooseValue(NAME_KEY, contributor.getName(), uuidStr));
        contributor.setUserId(this.chooseValue(USER_ID_KEY, contributor.getUserId(), uuidStr));
        contributor.setEmailAddress(this.chooseValue(EMAIL_ADDRESS_KEY, contributor.getEmailAddress(), String.valueOf(uuidStr) + "@none.com"));
        contributor.setArchived(this.chooseValue(ARCHIVED, contributor.isArchived()).booleanValue());
        if (this.isBuilderValueSet(DETAILS_KEY)) {
            contributor.setDetails((IContributorDetailsHandle)this.getBuilderValue(DETAILS_KEY).build(new BuildContext(buildContext)));
        }
        if (this.isBuilderValueSet(ITEM_ID_KEY)) {
            contributor.setItemId(this.chooseValue(ITEM_ID_KEY, contributor.getItemId(), uuid));
        }
        return contributor;
    }

    protected String getPassword() {
        if (this.isBuilderValueSet(PASSWORD_KEY)) {
            return this.getBuilderValue(PASSWORD_KEY);
        }
        return DEFAULT_PASSWORD;
    }

    @Override
    protected IContributor doSave(BuildContext context) throws TeamRepositoryException {
        if (this.isBuilderValueSet(ITEM_ID_KEY)) {
            throw new IllegalArgumentException("Cannot specify itemId when item is saved in repository.");
        }
        ContributorDetailsBuilder detailsBuilder = this.getBuilderValue(DETAILS_KEY);
        if (detailsBuilder != null) {
            this.removeBuilderValue(DETAILS_KEY);
        }
        IContributor contributor = this.getContext().getLibrary(IContributorService.class).saveContributor((IContributor)this.build(context));
        if (detailsBuilder != null) {
            contributor = (IContributor)contributor.getWorkingCopy();
            detailsBuilder.use((IContributorDetails)this.getContext().resolve((IItemHandle)contributor.getDetails()));
            contributor.setDetails((IContributorDetailsHandle)detailsBuilder.build(new BuildContext(context)));
            contributor = this.getContext().getLibrary(IContributorService.class).saveContributor(contributor);
        }
        this.getContext().getLibrary(IExternalUserRegistryService.class).addExternalUser(contributor.getUserId(), this.getPassword(), contributor.getName(), contributor.getEmailAddress(), this.getBuilderValue(JAZZ_ROLES).toArray(new String[0]));
        return (IContributor)this.getContext().resolve((IItemHandle)contributor);
    }
}

