/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.internal.setup.builders;

import com.ibm.team.rtc.common.internal.setup.ISetupStore;
import com.ibm.team.rtc.common.internal.setup.builders.AbstractArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilderContext;
import com.ibm.team.rtc.common.internal.setup.builders.IPostSaveHook;

public abstract class AbstractSetup {
    protected final ISetupStore fStore;
    protected final IArtifactBuilderContext fBuildContext;

    public AbstractSetup(IArtifactBuilderContext buildContext, ISetupStore store) {
        this.fBuildContext = buildContext;
        this.fStore = store;
    }

    protected <K, T extends AbstractArtifactBuilder<K>> T register(String id, T artifactBuilder) {
        return this.register(id, artifactBuilder, false);
    }

    protected <K, T extends AbstractArtifactBuilder<K>> T register(final String id, T artifactBuilder, final boolean persist) {
        if (this.fStore.contains(id)) {
            ((AbstractArtifactBuilder)artifactBuilder).use(this.fStore.get(id));
        }
        ((AbstractArtifactBuilder)artifactBuilder).addPostSaveHook(new IPostSaveHook<K>(){

            @Override
            public void itemSaved(AbstractArtifactBuilder.ArtifactSavedEvent<K> event) {
                switch (event.fEventType) {
                    case SAVE: {
                        AbstractSetup.this.fStore.set(id, event.fArtifact, persist);
                        break;
                    }
                    case UPDATE: {
                        AbstractSetup.this.fStore.update(event.fArtifact);
                        break;
                    }
                }
            }
        });
        return (T)artifactBuilder;
    }
}

