/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.common.internal.setup.builders;

import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.internal.setup.builders.AbstractProcessBuilder;
import com.ibm.team.process.common.internal.setup.builders.IProcessBuilderContext;
import com.ibm.team.process.common.internal.setup.builders.IterationBuilder;
import com.ibm.team.process.common.internal.setup.builders.ProjectAreaBuilder;
import com.ibm.team.process.common.internal.setup.builders.TeamAreaBuilder;
import com.ibm.team.process.internal.common.impl.DevelopmentLineImpl;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.common.internal.setup.builders.AbstractArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.BuildContext;
import com.ibm.team.rtc.common.internal.setup.builders.IPostSaveHook;
import com.ibm.team.rtc.common.internal.setup.builders.ValueKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class DevelopmentLineBuilder
extends AbstractProcessBuilder<IDevelopmentLine> {
    private static final ValueKey<String> NAME_KEY = new ValueKey(String.valueOf(DevelopmentLineBuilder.class.getName()) + ".name");
    private static final ValueKey<Date> START_DATE_KEY = new ValueKey(String.valueOf(DevelopmentLineBuilder.class.getName()) + ".startDate");
    private static final ValueKey<UUID> CONTEXT_ID = new ValueKey(String.valueOf(DevelopmentLineBuilder.class.getName()) + ".contextId");
    private static final ValueKey<Date> END_DATE_KEY = new ValueKey(String.valueOf(DevelopmentLineBuilder.class.getName()) + ".endDate");
    private static final ValueKey<IIterationHandle> CURRENT_ITERATION_KEY = new ValueKey(String.valueOf(DevelopmentLineBuilder.class.getName()) + ".currentIteration");
    private static final ValueKey<List<IIteration>> ITERATION_KEY = new ValueKey(String.valueOf(DevelopmentLineBuilder.class.getName()) + ".iteration");
    private static final ValueKey<IProjectArea> PROJECT_AREA_KEY = new ValueKey(String.valueOf(DevelopmentLineBuilder.class.getName()) + ".projectArea");
    private static final ValueKey<String> ID_KEY = new ValueKey(String.valueOf(DevelopmentLineBuilder.class.getName()) + ".id");
    private static final ValueKey<Boolean> ARCHIVED_KEY = new ValueKey(String.valueOf(DevelopmentLineBuilder.class.getName()) + ".archived");

    public DevelopmentLineBuilder(IProcessBuilderContext buildContext) {
        super(buildContext);
        this.setBuilderValue(ITERATION_KEY, new ArrayList());
    }

    public DevelopmentLineBuilder name(String name) {
        this.setBuilderValue(NAME_KEY, name);
        return this;
    }

    public DevelopmentLineBuilder archived(Boolean archived) {
        this.setBuilderValue(ARCHIVED_KEY, archived);
        return this;
    }

    public DevelopmentLineBuilder iteration(IIteration ... iteration) {
        this.getBuilderValue(ITERATION_KEY).addAll(Arrays.asList(iteration));
        return this;
    }

    public DevelopmentLineBuilder iteration(IterationBuilder ... iterations) {
        this.addChildBuilder(iterations);
        return this;
    }

    public DevelopmentLineBuilder currentIteration(IIterationHandle currentIteration) {
        this.setBuilderValue(CURRENT_ITERATION_KEY, currentIteration);
        return this;
    }

    public DevelopmentLineBuilder currentIteration(IterationBuilder currentIteration) {
        this.addChildBuilder(currentIteration);
        currentIteration.addPostSaveHook(new IPostSaveHook<IIteration>(){

            @Override
            public void itemSaved(AbstractArtifactBuilder.ArtifactSavedEvent<IIteration> saveEvent) {
                DevelopmentLineBuilder.this.currentIteration((IIterationHandle)saveEvent.fArtifact);
            }
        });
        return this;
    }

    public DevelopmentLineBuilder startDate(Date date) {
        this.setBuilderValue(START_DATE_KEY, date);
        return this;
    }

    public DevelopmentLineBuilder endDate(Date date) {
        this.setBuilderValue(END_DATE_KEY, date);
        return this;
    }

    public DevelopmentLineBuilder projectArea(IProjectArea projectArea) {
        this.setBuilderValue(PROJECT_AREA_KEY, projectArea);
        return this;
    }

    public DevelopmentLineBuilder projectArea(ProjectAreaBuilder projectArea) {
        this.setBuilderValue(PROJECT_AREA_KEY, (IProjectArea)projectArea.build());
        return this;
    }

    public DevelopmentLineBuilder id(String id) {
        this.setBuilderValue(ID_KEY, id);
        return this;
    }

    public DevelopmentLineBuilder teamArea(TeamAreaBuilder teamAreaBuilder) {
        this.addChildBuilder(teamAreaBuilder);
        return this;
    }

    @Override
    protected void postSaveChildren(BuildContext saveContext, IDevelopmentLine devLine) throws TeamRepositoryException {
        this.addIterations(saveContext, devLine);
    }

    @Override
    protected BuildContext contributeToContext(IDevelopmentLine artifact, BuildContext context) {
        BuildContext result = super.contributeToContext(artifact, context);
        result.setProperty(BuildContext.DEVELOPMENT_LINE, artifact);
        return result;
    }

    @Override
    protected IDevelopmentLine doArtifactSave(BuildContext context) throws TeamRepositoryException {
        if (this.artifactExists() && !context.isPropertySet(BuildContext.PROJECT_AREA)) {
            context.setProperty(BuildContext.PROJECT_AREA, (IProjectArea)((IProjectArea)this.getContext().resolve((IItemHandle)((IDevelopmentLine)this.getExistingArtifact()).getProjectArea())).getWorkingCopy());
        }
        IDevelopmentLine devLine = this.createArtifact(context);
        context.getProperty(BuildContext.BULK_PROCESS_SAVE).put(devLine, this);
        devLine = this.performSave(devLine, context);
        IProjectArea projectArea = this.getBuilderValue(PROJECT_AREA_KEY, context.getProperty(BuildContext.PROJECT_AREA));
        if (projectArea != null) {
            projectArea = (IProjectArea)projectArea.getWorkingCopy();
            projectArea.setProjectDevelopmentLine((IDevelopmentLineHandle)devLine);
        }
        BuildContext.ProcessItemMap property = context.getProperty(BuildContext.BULK_PROCESS_SAVE);
        property.put(projectArea, null);
        return devLine;
    }

    @Override
    protected IDevelopmentLine doArtifactBuild(BuildContext context) {
        IDevelopmentLine devLine = this.createArtifact(context);
        this.addIterations(context, devLine);
        IProjectArea projectArea = this.getBuilderValue(PROJECT_AREA_KEY, context.getProperty(BuildContext.PROJECT_AREA));
        if (projectArea != null) {
            projectArea.setProjectDevelopmentLine((IDevelopmentLineHandle)devLine);
        }
        return devLine;
    }

    public IDevelopmentLine createArtifact(BuildContext context) {
        IDevelopmentLine devLine = (IDevelopmentLine)this.artifact(IDevelopmentLine.ITEM_TYPE);
        devLine.setId(this.chooseValue(ID_KEY, devLine.getId(), UUID.generate().getUuidValue()));
        devLine.setName(this.chooseValue(NAME_KEY, devLine.getName(), UUID.generate().getUuidValue()));
        devLine.setContextId(this.chooseValue(CONTEXT_ID, devLine.getContextId(), UUID.generate()));
        devLine.setStartDate(this.chooseValue(START_DATE_KEY, devLine.getStartDate(), new GregorianCalendar().getTime()));
        devLine.setEndDate((Date)this.chooseValue(END_DATE_KEY, devLine.getEndDate(), null));
        ((DevelopmentLineImpl)devLine).setArchived(this.chooseValue(ARCHIVED_KEY, devLine.isArchived(), false).booleanValue());
        IProjectArea projectArea = this.getBuilderValue(PROJECT_AREA_KEY, context.getProperty(BuildContext.PROJECT_AREA));
        if (projectArea != null) {
            projectArea = (IProjectArea)projectArea.getWorkingCopy();
            devLine.setProjectArea((IProjectAreaHandle)projectArea);
            projectArea.addDevelopmentLine((IDevelopmentLineHandle)devLine);
            context.updateItem((IItem)projectArea);
        }
        return devLine;
    }

    private void addIterations(BuildContext buildContext, IDevelopmentLine devLine) {
        devLine = buildContext.getUpdatedItem(devLine);
        for (IIteration iteration : this.getBuilderValue(ITERATION_KEY)) {
            devLine.addIteration((IIterationHandle)iteration);
            iteration.setDevelopmentLine((IDevelopmentLineHandle)devLine);
            if (!buildContext.isPropertySet(BuildContext.BULK_PROCESS_SAVE)) continue;
            buildContext.getProperty(BuildContext.BULK_PROCESS_SAVE).put(iteration, null);
        }
        IIterationHandle[] iterations = devLine.getIterations();
        IIterationHandle first = iterations.length != 0 ? iterations[0] : null;
        IIterationHandle current = devLine.getCurrentIteration();
        devLine.setCurrentIteration(this.chooseValue(CURRENT_ITERATION_KEY, current != null ? current : first));
    }

    @Override
    protected IProcessItem getParentArtifact(IDevelopmentLine devLine) {
        if (devLine.getProjectArea() instanceof IProjectArea) {
            return (IProcessItem)devLine.getProjectArea();
        }
        return null;
    }
}

