/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.common.internal.setup.builders;

import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.internal.setup.builders.IProcessBuilderContext;
import com.ibm.team.process.internal.common.service.IProcessService;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.common.internal.setup.builders.AbstractArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.BuildContext;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilder;

public abstract class AbstractProcessBuilder<T extends IProcessItem>
extends AbstractArtifactBuilder<T> {
    public AbstractProcessBuilder(IProcessBuilderContext buildContext) {
        super(buildContext);
    }

    @Override
    protected T doSave(BuildContext saveContext) throws TeamRepositoryException {
        boolean savedByParent = saveContext.isPropertySet(BuildContext.BULK_PROCESS_SAVE);
        if (!savedByParent) {
            saveContext.setProperty(BuildContext.BULK_PROCESS_SAVE, new BuildContext.ProcessItemMap());
        }
        T artifact = this.doArtifactSave(saveContext);
        saveContext.getProperty(BuildContext.BULK_PROCESS_SAVE).put(artifact, this);
        for (IArtifactBuilder<?> builder : this.getChildBuilders()) {
            builder.save(this.createContext(artifact, saveContext));
        }
        this.postSaveChildren(saveContext, artifact);
        if (!savedByParent) {
            artifact = this.performSave(artifact, saveContext);
        }
        return (T)((IProcessItem)saveContext.getUpdatedItem(artifact));
    }

    protected void postSaveChildren(BuildContext saveContext, T artifact) throws TeamRepositoryException {
    }

    @Override
    protected T doBuild(BuildContext buildContext) {
        if (!buildContext.isPropertySet(BuildContext.BULK_PROCESS_SAVE)) {
            buildContext.setProperty(BuildContext.BULK_PROCESS_SAVE, new BuildContext.ProcessItemMap());
        }
        T artifact = this.doArtifactBuild(buildContext);
        buildContext.getProperty(BuildContext.BULK_PROCESS_SAVE).put(artifact, this);
        for (IArtifactBuilder<?> builder : this.getChildBuilders()) {
            builder.build(this.createContext(artifact, buildContext));
        }
        return artifact;
    }

    private BuildContext createContext(T artifact, BuildContext saveContext) {
        return this.contributeToContext(artifact, new BuildContext(saveContext));
    }

    protected T performSave(T artifact, BuildContext saveContext) throws TeamRepositoryException {
        IItem[] clientItems;
        BuildContext.ProcessItemMap itemsToBeSaved = saveContext.getProperty(BuildContext.BULK_PROCESS_SAVE);
        itemsToBeSaved.put(0, this.getParentArtifact(artifact), null);
        IItem[] iItemArray = clientItems = this.saveProcessItems(saveContext, itemsToBeSaved);
        int n = clientItems.length;
        int n2 = 0;
        while (n2 < n) {
            IItem clientItem = iItemArray[n2];
            if (!clientItem.sameItemId(artifact)) {
                AbstractArtifactBuilder builder = (AbstractArtifactBuilder)itemsToBeSaved.get((IProcessItem)clientItem);
                saveContext.updateItem(clientItem);
                if (builder != null) {
                    builder.updateItem(clientItem);
                }
            } else {
                artifact = (IProcessItem)clientItem;
                saveContext.updateItem((IItem)artifact);
            }
            ++n2;
        }
        return artifact;
    }

    private IItem[] saveProcessItems(BuildContext saveContext, BuildContext.ProcessItemMap itemMap) throws TeamRepositoryException {
        IItem[] clientItems;
        IProcessItem[] itemsToBeSaved = new IProcessItem[itemMap.size()];
        int i = 0;
        for (IProcessItem item : itemMap.keySet()) {
            itemsToBeSaved[i++] = (IProcessItem)saveContext.getUpdatedItem(item).getWorkingCopy();
        }
        IProcessService processServerService = this.getContext().getLibrary(IProcessService.class);
        IItem[] iItemArray = clientItems = processServerService.saveProcessItems(itemsToBeSaved).getClientItems();
        int n = clientItems.length;
        int n2 = 0;
        while (n2 < n) {
            IItem clientItem = iItemArray[n2];
            saveContext.updateItem(clientItem);
            ++n2;
        }
        return clientItems;
    }

    @Override
    protected IProcessBuilderContext getContext() {
        return (IProcessBuilderContext)super.getContext();
    }

    protected IItem resolve(IItemHandle itemHandle) throws TeamRepositoryException {
        if (itemHandle == null) {
            return null;
        }
        if (itemHandle.getFullState() != null) {
            return itemHandle.getFullState();
        }
        if (this.getContext() == null) {
            return null;
        }
        return this.getContext().resolve(itemHandle);
    }

    protected IProcessItem getParentArtifact(T artifact) {
        return null;
    }

    protected BuildContext contributeToContext(T artifact, BuildContext context) {
        return context;
    }

    protected abstract T doArtifactBuild(BuildContext var1);

    protected T doArtifactSave(BuildContext saveContext) throws TeamRepositoryException {
        throw new UnsupportedOperationException("Cannot call save() while running unit tests. ");
    }
}

