/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.internal.util.jdojo;

import com.ibm.team.rtc.common.scriptengine.IInvokeableProxy;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.IScriptableProxy;
import com.ibm.team.rtc.common.scriptengine.environment.dojo.IDojoTypeContext;
import com.ibm.team.rtc.common.scriptengine.internal.bridge.proxy.FunctionInvocationHandler;
import com.ibm.team.rtc.common.scriptengine.internal.bridge.proxy.ScriptableInvocationHandler;
import com.ibm.team.rtc.common.scriptengine.internal.util.jdojo.InterfaceSet;
import com.ibm.team.rtc.common.scriptengine.internal.util.jdojo.JDojoTypeUtils;
import com.ibm.team.rtc.common.scriptengine.internal.util.jdojo.ProxyClassLoader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class ProxyFactory {
    private static final InterfaceSet SCRIPTABLE_PROXY = InterfaceSet.EMPTY.add(IScriptableProxy.class);
    private static final InterfaceSet INVOKABLE_PROXY = InterfaceSet.EMPTY.add(IInvokeableProxy.class);
    private final IScriptEnvironment fScriptEnvironment;
    private final Map<Scriptable, InterfaceSet> fPrototypeInterfaceCache = new HashMap<Scriptable, InterfaceSet>();
    private static final ProxyClassLoader fProxyClassLoader = new ProxyClassLoader();

    public ProxyFactory(IScriptEnvironment scriptEnvironment) {
        this.fScriptEnvironment = scriptEnvironment;
    }

    public synchronized IScriptableProxy createProxy(Scriptable object, Class<?> ... enforcedProxyTypes) {
        if (object == null) {
            return null;
        }
        InterfaceSet apiInterfaces = this.getInterfaceSet(SCRIPTABLE_PROXY, object.getPrototype(), enforcedProxyTypes);
        fProxyClassLoader.prepare(apiInterfaces);
        return (IScriptableProxy)Proxy.newProxyInstance(fProxyClassLoader, apiInterfaces.toArray(), (InvocationHandler)new ScriptableInvocationHandler(this.fScriptEnvironment, object));
    }

    public synchronized IScriptableProxy createFunctionProxy(Function function, Class<?> singleMethodInterface) {
        if (function == null) {
            return null;
        }
        Scriptable proxySubject = JDojoTypeUtils.getHitchScope(function);
        if (proxySubject == null) {
            proxySubject = function;
        }
        InterfaceSet apiInterfaces = this.getInterfaceSet(INVOKABLE_PROXY, proxySubject.getPrototype(), singleMethodInterface);
        fProxyClassLoader.prepare(apiInterfaces);
        return (IScriptableProxy)Proxy.newProxyInstance(fProxyClassLoader, apiInterfaces.toArray(), (InvocationHandler)new FunctionInvocationHandler(this.fScriptEnvironment, proxySubject, singleMethodInterface, function));
    }

    private InterfaceSet getInterfaceSet(InterfaceSet baseSet, Scriptable prototype, Class<?> ... enforcedProxyTypes) {
        InterfaceSet result = baseSet;
        if (prototype != null) {
            result = result.add(this.getApiInterface(prototype));
        }
        Class<?>[] classArray = enforcedProxyTypes;
        int n = enforcedProxyTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> enforcedProxyType = classArray[n2];
            if (enforcedProxyType != null) {
                result = result.add(enforcedProxyType);
            }
            ++n2;
        }
        return result;
    }

    private InterfaceSet getApiInterface(Scriptable prototype) {
        IDojoTypeContext dojoTypeContext = this.fScriptEnvironment.adapt(IDojoTypeContext.class);
        InterfaceSet result = this.fPrototypeInterfaceCache.get(prototype);
        if (result == null) {
            Scriptable superPrototype;
            result = InterfaceSet.EMPTY;
            Object interfaceProperty = prototype.get("$interfaces", prototype);
            if (interfaceProperty instanceof Scriptable) {
                Object[] propertyIds;
                Scriptable supportedInterfaces = (Scriptable)interfaceProperty;
                Object[] objectArray = propertyIds = supportedInterfaces.getIds();
                int n = propertyIds.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> apiType;
                    Object propertyId = objectArray[n2];
                    if (propertyId instanceof String && Boolean.TRUE.equals(supportedInterfaces.get((String)propertyId, supportedInterfaces)) && (apiType = dojoTypeContext.resolveApiType((String)propertyId)) != null && apiType.isInterface()) {
                        result = result.add(apiType);
                    }
                    ++n2;
                }
            }
            if ((superPrototype = prototype.getPrototype()) != null) {
                result = result.add(this.getApiInterface(superPrototype));
            }
            this.fPrototypeInterfaceCache.put(prototype, result);
        }
        return result;
    }
}

