/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.internal.util.jdojo;

import com.ibm.jdojo.lang.IJSFunction;
import com.ibm.jdojo.lang.annotations.Stub;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class JDojoTypeUtils {
    public static boolean isSingleMethodInterface(Class<?> typeClass) {
        return JDojoTypeUtils.findSingleMethod(typeClass) != null;
    }

    public static Method findSingleMethod(Class<?> typeClass) {
        if (!typeClass.isInterface()) {
            return null;
        }
        if (!(IJSFunction.class.isAssignableFrom(typeClass) || Comparable.class.equals(typeClass) || Runnable.class.equals(typeClass))) {
            return null;
        }
        Method method = JDojoTypeUtils.findFirstMethod(typeClass);
        return method != null && JDojoTypeUtils.isOnlyMethod(method, typeClass) ? method : null;
    }

    public static Scriptable getHitchScope(Function function) {
        Scriptable result = null;
        Object sourceObject = function.get("$source", (Scriptable)function);
        if (sourceObject instanceof Scriptable) {
            result = (Scriptable)sourceObject;
        } else {
            Scriptable parentScope = function.getParentScope();
            if (parentScope != null && (sourceObject = parentScope.get("scope", parentScope)) instanceof Scriptable) {
                result = (Scriptable)sourceObject;
            }
        }
        return result;
    }

    public static String getScriptTypeName(Class<?> scriptTypeClazz) {
        Stub stub = scriptTypeClazz.getAnnotation(Stub.class);
        return stub != null && !stub.value().equals("<default>") ? stub.value() : scriptTypeClazz.getName().replace('$', '.');
    }

    private static Method findFirstMethod(Class<?> typeClass) {
        Method[] methods = typeClass.getMethods();
        if (methods.length > 0) {
            return methods[0];
        }
        Class<?>[] classArray = typeClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> superInterface = classArray[n2];
            Method singleMethod = JDojoTypeUtils.findFirstMethod(superInterface);
            if (singleMethod != null) {
                return singleMethod;
            }
            ++n2;
        }
        return null;
    }

    private static boolean isOnlyMethod(Method method, Class<?> typeClass) {
        Method[] methods = typeClass.getMethods();
        if (methods.length > 1) {
            return false;
        }
        if (methods.length == 1) {
            Method candidateMethod = methods[0];
            if (!candidateMethod.getName().equals(method.getName())) {
                return false;
            }
            if (!Arrays.equals(candidateMethod.getParameterTypes(), method.getParameterTypes())) {
                return false;
            }
        }
        Class<?>[] classArray = typeClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> superInterface = classArray[n2];
            if (!JDojoTypeUtils.isOnlyMethod(method, superInterface)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

