/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.internal.util.jdojo;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;

class InterfaceSet {
    private static final Comparator<Class<?>> INTERFACE_ORDER = new Comparator<Class<?>>(){

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    public static final InterfaceSet EMPTY = new InterfaceSet();
    private final Class<?>[] fInterfaces;

    private InterfaceSet() {
        this.fInterfaces = new Class[0];
    }

    private InterfaceSet(Class<?>[] source, Class<?> ... extension) {
        HashSet allTypes = new HashSet((int)((double)(source.length + extension.length) * 1.5));
        allTypes.addAll(Arrays.asList(source));
        allTypes.addAll(Arrays.asList(extension));
        this.fInterfaces = allTypes.toArray(new Class[allTypes.size()]);
        Arrays.sort(this.fInterfaces, INTERFACE_ORDER);
    }

    public InterfaceSet add(InterfaceSet additionalSet) {
        return new InterfaceSet(this.fInterfaces, additionalSet.toArray());
    }

    public InterfaceSet add(Class<?> additionalType) {
        return new InterfaceSet(this.fInterfaces, additionalType);
    }

    public Class<?>[] toArray() {
        return this.fInterfaces;
    }

    public int hashCode() {
        return Arrays.hashCode(this.fInterfaces);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InterfaceSet)) {
            return false;
        }
        return Arrays.equals(this.fInterfaces, ((InterfaceSet)obj).fInterfaces);
    }
}

