/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.internal.types.scripttype;

import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.NamedProperty;
import com.ibm.team.rtc.common.scriptengine.internal.util.ExceptionHelper;
import com.ibm.team.rtc.common.scriptengine.internal.util.IScriptingHelper;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.Assert;
import org.mozilla.javascript.Scriptable;

public class ScriptTypePropertyAccessor
implements NamedProperty {
    private final String fName;
    private final Method fGetter;
    private final Method fSetter;
    private final IScriptingHelper fScriptingHelper;

    public ScriptTypePropertyAccessor(String name, Method getter, Method setter, IScriptEnvironment scriptEnvironment) {
        this.fName = name;
        this.fGetter = getter;
        this.fSetter = setter;
        this.fScriptingHelper = scriptEnvironment.adapt(IScriptingHelper.class);
    }

    @Override
    public String getPropertyName() {
        return this.fName;
    }

    @Override
    public boolean isReadonly() {
        return this.fSetter == null;
    }

    @Override
    public Object getValue(Scriptable start) {
        Assert.isLegal((boolean)this.fGetter.getDeclaringClass().isInstance(start));
        try {
            return this.fScriptingHelper.convertToScript(this.fGetter.invoke((Object)start, new Object[0]), this.fGetter.getReturnType());
        }
        catch (Exception e) {
            throw ExceptionHelper.handle(e);
        }
    }

    @Override
    public void setValue(Scriptable start, Object value) {
        Assert.isLegal((boolean)this.fSetter.getDeclaringClass().isInstance(start));
        try {
            this.fSetter.invoke((Object)start, this.fScriptingHelper.convertToJava(value, this.fSetter.getParameterTypes()[0]));
        }
        catch (Exception e) {
            throw ExceptionHelper.handle(e);
        }
    }
}

