/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.internal.types.scripttype;

import com.ibm.team.rtc.common.scriptengine.AbstractScriptType;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.ScriptEnvironmentSetupException;
import com.ibm.team.rtc.common.scriptengine.environment.IScriptTypeFeature;
import com.ibm.team.rtc.common.scriptengine.internal.types.scripttype.ScriptTypeConstructorFunction;
import com.ibm.team.rtc.common.scriptengine.internal.util.IScriptingHelper;
import com.ibm.team.rtc.common.scriptengine.internal.util.jdojo.JDojoTypeUtils;
import org.eclipse.core.runtime.Assert;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ScriptTypeFeature
implements IScriptTypeFeature {
    private final Class<? extends AbstractScriptType> fFacadeClass;
    private ScriptTypeConstructorFunction fTypeConstructor;

    public ScriptTypeFeature(Class<? extends AbstractScriptType> facadeClass) {
        this.fFacadeClass = facadeClass;
    }

    @Override
    public void define(Context cx, Scriptable scope, IScriptEnvironment scriptEnvironment) throws ScriptEnvironmentSetupException {
        try {
            this.fTypeConstructor = new ScriptTypeConstructorFunction(this.fFacadeClass, scriptEnvironment);
            String typeName = this.fTypeConstructor.getScriptTypeName();
            IScriptingHelper scriptingHelper = scriptEnvironment.adapt(IScriptingHelper.class);
            scriptingHelper.dojoProvide(typeName);
            scriptingHelper.setObject(typeName, this.fTypeConstructor);
        }
        catch (Exception e) {
            throw new ScriptEnvironmentSetupException(e);
        }
    }

    @Override
    public void initialize(Context cx, Scriptable scope, IScriptEnvironment scriptEnvironment) throws ScriptEnvironmentSetupException {
        try {
            Assert.isNotNull((Object)this.fTypeConstructor);
            this.fTypeConstructor.initialize(cx, scope, scriptEnvironment);
        }
        catch (Exception e) {
            throw new ScriptEnvironmentSetupException(e);
        }
    }

    public Class<?> getFacadeClass() {
        return this.fFacadeClass;
    }

    @Override
    public String getProvidedTypeName() {
        return JDojoTypeUtils.getScriptTypeName(this.fFacadeClass);
    }

    public <T> T getAdapter(Class<T> type) {
        return null;
    }

    public String toString() {
        String bundleName = "<unknown bundle>";
        Bundle bundle = FrameworkUtil.getBundle(this.fFacadeClass);
        if (bundle != null) {
            bundleName = bundle.getSymbolicName();
        }
        return String.format("(Wrapper) Script Type (provides '%s', facade class '%s', loaded from bundle '%s')", this.getProvidedTypeName(), this.fFacadeClass.getName(), bundleName);
    }
}

