/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.internal.types.scripttype;

import com.ibm.jdojo.lang.annotations.Stub;
import com.ibm.team.rtc.common.scriptengine.AbstractScriptType;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.annotation.Constant;
import com.ibm.team.rtc.common.scriptengine.annotation.Constructor;
import com.ibm.team.rtc.common.scriptengine.annotation.Function;
import com.ibm.team.rtc.common.scriptengine.annotation.Property;
import com.ibm.team.rtc.common.scriptengine.annotation.WrapType;
import com.ibm.team.rtc.common.scriptengine.environment.dojo.IDojoTypeContext;
import com.ibm.team.rtc.common.scriptengine.internal.ScriptEnginePlugin;
import com.ibm.team.rtc.common.scriptengine.internal.types.AbstractTypeConstructorFunction;
import com.ibm.team.rtc.common.scriptengine.internal.types.ClassProptotype;
import com.ibm.team.rtc.common.scriptengine.internal.types.ITypeConstructorFunction;
import com.ibm.team.rtc.common.scriptengine.internal.types.scripttype.ScriptTypeMethodWrapperFunction;
import com.ibm.team.rtc.common.scriptengine.internal.types.scripttype.ScriptTypePropertyAccessor;
import com.ibm.team.rtc.common.scriptengine.internal.util.IScriptingHelper;
import com.ibm.team.rtc.common.scriptengine.internal.util.jdojo.JDojoTypeUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class ScriptTypeConstructorFunction
extends AbstractTypeConstructorFunction {
    public ScriptTypeConstructorFunction(Class<? extends AbstractScriptType> typeClass, IScriptEnvironment scriptEnvironment) {
        super(typeClass, scriptEnvironment);
    }

    @Override
    public String getScriptTypeName() {
        return JDojoTypeUtils.getScriptTypeName(this.fTypeClass);
    }

    @Override
    public Class<?> getJavaTypeClass() {
        WrapType wrapType = this.fTypeClass.getAnnotation(WrapType.class);
        return wrapType != null ? wrapType.value() : this.fTypeClass;
    }

    @Override
    protected java.lang.reflect.Constructor<?> findConstructor(IScriptEnvironment scriptEnvironment) {
        java.lang.reflect.Constructor<?>[] constructorArray = this.fTypeClass.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            java.lang.reflect.Constructor<?> candidateConstructor = constructorArray[n2];
            if (candidateConstructor.getAnnotation(Constructor.class) != null) {
                Class<?>[] parameterTypes = candidateConstructor.getParameterTypes();
                if (parameterTypes.length < 2 || parameterTypes[0] != Context.class || parameterTypes[1] != Scriptable.class) {
                    ScriptEnginePlugin.log(String.format("WARNING: skipped declared constructor of type '%s' due to an invalid signature", this.getScriptTypeName()), new Exception());
                } else {
                    return candidateConstructor;
                }
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected ClassProptotype createClassPrototype(IScriptEnvironment scriptEnvironment) {
        ITypeConstructorFunction superTypeClassPrototype = null;
        Class superclass = this.fTypeClass.getSuperclass();
        while (AbstractScriptType.class != superclass) {
            if (superclass.getAnnotation(Stub.class) != null) {
                superTypeClassPrototype = scriptEnvironment.adapt(IDojoTypeContext.class).getTypeConstructorFunction(superclass);
                break;
            }
            superclass = superclass.getSuperclass();
        }
        return new ClassProptotype(this, superTypeClassPrototype);
    }

    @Override
    protected void initializeClassPrototype(IScriptEnvironment scriptEnvironment) {
        IScriptingHelper scriptingHelper = scriptEnvironment.adapt(IScriptingHelper.class);
        ClassProptotype classPrototype = this.getClassPrototype();
        HashMap<String, Method[]> getterSetterProperties = new HashMap<String, Method[]>();
        Class<AbstractScriptType> currentTypeClass = this.fTypeClass;
        while (true) {
            String name;
            AccessibleObject[] accessibleObjectArray = currentTypeClass.getDeclaredMethods();
            int n = accessibleObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Property propertyAnnotation;
                Method method = accessibleObjectArray[n2];
                if (Modifier.isPublic(method.getModifiers()) && method.getAnnotation(Function.class) != null) {
                    ScriptTypeMethodWrapperFunction function = new ScriptTypeMethodWrapperFunction(method, scriptEnvironment);
                    if (Modifier.isStatic(method.getModifiers())) {
                        this.defineStaticFunction(function);
                    } else {
                        classPrototype.defineFunction(function);
                    }
                }
                if ((propertyAnnotation = method.getAnnotation(Property.class)) != null) {
                    name = propertyAnnotation.name();
                    Method[] getterSetterMethods = (Method[])getterSetterProperties.get(name);
                    if (getterSetterMethods == null) {
                        getterSetterMethods = new Method[2];
                        getterSetterProperties.put(name, getterSetterMethods);
                    }
                    getterSetterMethods[propertyAnnotation.accessor() == Property.Kind.Getter ? 0 : 1] = method;
                }
                ++n2;
            }
            accessibleObjectArray = currentTypeClass.getDeclaredFields();
            n = accessibleObjectArray.length;
            n2 = 0;
            while (n2 < n) {
                Constant constantAnnotation;
                AccessibleObject field = accessibleObjectArray[n2];
                if (Modifier.isPublic(((Field)field).getModifiers()) && (constantAnnotation = ((Field)field).getAnnotation(Constant.class)) != null) {
                    String string = name = "".equals(constantAnnotation.value()) ? ((Field)field).getName() : constantAnnotation.value();
                    if (!Modifier.isStatic(((Field)field).getModifiers()) || !Modifier.isFinal(((Field)field).getModifiers())) {
                        ScriptEnginePlugin.log(String.format("WARNING: skipped non-static, non-final const '%s' on type '%s'", name, this.getScriptTypeName()), new Exception());
                    } else {
                        try {
                            ScriptTypeConstructorFunction.defineProperty((Scriptable)this, (String)name, (Object)scriptingHelper.convertToScript(((Field)field).get(null), ((Field)field).getType()), (int)5);
                        }
                        catch (Exception e) {
                            ScriptEnginePlugin.log(String.format("WARNING: failed to define constant '%s' on type '%s'", ((Field)field).getName(), this.getScriptTypeName()), e);
                        }
                    }
                }
                ++n2;
            }
            Class candidateSuperclass = currentTypeClass.getSuperclass();
            if (candidateSuperclass == AbstractScriptType.class || candidateSuperclass.getAnnotation(Stub.class) != null) break;
            currentTypeClass = candidateSuperclass.asSubclass(AbstractScriptType.class);
        }
        for (Map.Entry entry : getterSetterProperties.entrySet()) {
            classPrototype.defineProperty(new ScriptTypePropertyAccessor((String)entry.getKey(), ((Method[])entry.getValue())[0], ((Method[])entry.getValue())[1], scriptEnvironment));
        }
    }
}

