/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.internal.types.api;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.team.rtc.common.scriptengine.environment.dojo.IDojoTypeContext;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class ApiUtil {
    ApiUtil() {
    }

    public static Class<?> findSuperType(Class<?> type) {
        Class<?> result = type.getSuperclass();
        return result != Object.class && result != DojoObject.class ? result : null;
    }

    public static Set<Class<?>> findNewApiInterfaces(Class<?> type, IDojoTypeContext dojoTypeContext) {
        HashSet superTypeInterfaces = new HashSet();
        Class<?> superType = ApiUtil.findSuperType(type);
        if (superType != null) {
            ApiUtil.collectInterfaces(superType, superTypeInterfaces, null, true);
        }
        HashSet typeInterfaces = new HashSet();
        ApiUtil.collectInterfaces(type, typeInterfaces, superTypeInterfaces, false);
        Iterator iterator = typeInterfaces.iterator();
        while (iterator.hasNext()) {
            Class candidateInterface = (Class)iterator.next();
            if (dojoTypeContext.isApiType(candidateInterface)) continue;
            iterator.remove();
        }
        return typeInterfaces;
    }

    private static void collectInterfaces(Class<?> type, Set<Class<?>> typeInterfaces, Set<Class<?>> ignore, boolean includeSupertype) {
        Class<?> superclass;
        Class<?>[] classArray = type.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> candidateInterface = classArray[n2];
            if (ignore == null || !ignore.contains(candidateInterface)) {
                typeInterfaces.add(candidateInterface);
                ApiUtil.collectInterfaces(candidateInterface, typeInterfaces, ignore, includeSupertype);
            }
            ++n2;
        }
        if (includeSupertype && (superclass = type.getSuperclass()) != null) {
            ApiUtil.collectInterfaces(superclass, typeInterfaces, ignore, true);
        }
    }
}

