/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.internal.types.api;

import com.ibm.team.rtc.common.scriptengine.IScriptTypeConverterFactory;
import com.ibm.team.rtc.common.scriptengine.environment.IScriptTypeFeature;
import com.ibm.team.rtc.common.scriptengine.environment.dojo.ITypeResolver;
import com.ibm.team.rtc.common.scriptengine.internal.ScriptEnginePlugin;
import com.ibm.team.rtc.common.scriptengine.internal.types.api.ApiClassFeature;
import com.ibm.team.rtc.common.scriptengine.internal.types.api.ApiEnumerationFeature;
import com.ibm.team.rtc.common.scriptengine.internal.types.api.ApiInterfaceFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ApiTypeResolver
implements ITypeResolver {
    private final List<BundleDescriptor> fBundlesDescriptors = new ArrayList<BundleDescriptor>();
    private final Map<String, IScriptTypeFeature> fTypesFeatures = new HashMap<String, IScriptTypeFeature>();

    public ApiTypeResolver() {
        this.readApiExtensions();
    }

    @Override
    public void initializeConversion(IScriptTypeConverterFactory converterFactory) {
    }

    @Override
    public IScriptTypeFeature resolve(String typeName) {
        Class<?> apiType;
        IScriptTypeFeature result = this.fTypesFeatures.get(typeName);
        if (result == null && (apiType = this.resolveClass(typeName)) != null) {
            result = apiType.isInterface() ? new ApiInterfaceFeature(apiType) : (apiType.isEnum() ? new ApiEnumerationFeature(apiType) : new ApiClassFeature(apiType));
            this.fTypesFeatures.put(typeName, result);
        }
        return result;
    }

    public Class<?> resolveClass(String typeName) {
        for (BundleDescriptor descriptor : this.fBundlesDescriptors) {
            try {
                Class result;
                if (!this.matchesPattern(descriptor, typeName) || !descriptor.bundle.equals(FrameworkUtil.getBundle((Class)(result = descriptor.bundle.loadClass(typeName))))) continue;
                return result;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isApiType(Class<?> type) {
        Bundle bundle = FrameworkUtil.getBundle(type);
        for (BundleDescriptor descriptor : this.fBundlesDescriptors) {
            if (!descriptor.bundle.equals(bundle) || !this.matchesPattern(descriptor, type.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean matchesPattern(BundleDescriptor descriptor, String typeName) {
        if (descriptor.patterns == null) {
            return true;
        }
        Pattern[] patternArray = descriptor.patterns;
        int n = descriptor.patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern typePattern = patternArray[n2];
            if (typePattern.matcher(typeName).matches()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void readApiExtensions() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint apiBundleExtensionPoint = extensionRegistry.getExtensionPoint("com.ibm.team.rtc.common.scriptengine.apiBundle");
        IExtension[] iExtensionArray = apiBundleExtensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configurationElements;
            IExtension apiBundleExtension = iExtensionArray[n2];
            BundleDescriptor apiBundle = new BundleDescriptor();
            apiBundle.bundle = Platform.getBundle((String)apiBundleExtension.getNamespaceIdentifier());
            ArrayList<Pattern> patternList = new ArrayList<Pattern>();
            IConfigurationElement[] iConfigurationElementArray = configurationElements = apiBundleExtension.getConfigurationElements();
            int n3 = configurationElements.length;
            int n4 = 0;
            while (n4 < n3) {
                String patternString;
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                if ("include".equals(configurationElement.getName()) && (patternString = configurationElement.getAttribute("pattern")) != null) {
                    patternList.add(Pattern.compile(patternString));
                }
                ++n4;
            }
            if (patternList.size() > 0) {
                apiBundle.patterns = patternList.toArray(new Pattern[patternList.size()]);
            }
            this.fBundlesDescriptors.add(apiBundle);
            ++n2;
        }
        if (ScriptEnginePlugin.TRACE_TYPE_RESOLVING) {
            StringBuilder trace = new StringBuilder();
            trace.append(String.format("Registred API Bundles:%n", new Object[0]));
            for (BundleDescriptor descriptor : this.fBundlesDescriptors) {
                trace.append(String.format("%s: pattern: '%s'", descriptor.bundle.getSymbolicName(), Arrays.toString(descriptor.patterns)));
            }
            ScriptEnginePlugin.trace(trace.toString(), new Object[0]);
        }
    }

    private static class BundleDescriptor {
        Bundle bundle;
        Pattern[] patterns;

        private BundleDescriptor() {
        }
    }
}

