/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.internal.types.api;

import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.ScriptEnvironmentSetupException;
import com.ibm.team.rtc.common.scriptengine.environment.dojo.IDojoTypeContext;
import com.ibm.team.rtc.common.scriptengine.internal.types.AbstractTypeConstructorFunction;
import com.ibm.team.rtc.common.scriptengine.internal.types.ClassProptotype;
import com.ibm.team.rtc.common.scriptengine.internal.types.FieldAccessor;
import com.ibm.team.rtc.common.scriptengine.internal.types.ITypeConstructorFunction;
import com.ibm.team.rtc.common.scriptengine.internal.types.api.ApiMethodWrapperFunction;
import com.ibm.team.rtc.common.scriptengine.internal.types.api.ApiUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ApiTypeConstructorFunction
extends AbstractTypeConstructorFunction {
    public ApiTypeConstructorFunction(Class<?> typeClass, IScriptEnvironment scriptEnvironment) {
        super(typeClass, scriptEnvironment);
    }

    @Override
    public String getScriptTypeName() {
        return this.fTypeClass.getName().replace('$', '.');
    }

    @Override
    public Class<?> getJavaTypeClass() {
        return this.fTypeClass;
    }

    @Override
    protected Constructor<?> findConstructor(IScriptEnvironment scriptEnvironment) {
        if (!scriptEnvironment.adapt(IDojoTypeContext.class).isApiType(this.fTypeClass)) {
            return null;
        }
        Constructor<?>[] constructors = this.fTypeClass.getConstructors();
        if (constructors.length > 1) {
            throw new ScriptEnvironmentSetupException(String.format("Only one constructor is allowed for type type '%s'", this.getScriptTypeName()));
        }
        if (constructors.length == 1) {
            return constructors[0];
        }
        return null;
    }

    @Override
    protected ClassProptotype createClassPrototype(IScriptEnvironment scriptEnvironment) {
        ITypeConstructorFunction superTypeClassPrototype = null;
        Class<?> superType = ApiUtil.findSuperType(this.fTypeClass);
        if (superType != null) {
            superTypeClassPrototype = scriptEnvironment.adapt(IDojoTypeContext.class).getTypeConstructorFunction(superType);
        }
        return new ClassProptotype(this, superTypeClassPrototype);
    }

    @Override
    protected void initializeClassPrototype(IScriptEnvironment scriptEnvironment) {
        int n;
        IDojoTypeContext dojoTypeContext = scriptEnvironment.adapt(IDojoTypeContext.class);
        ClassProptotype classPrototype = this.getClassPrototype();
        Set<Class<?>> typeInterfaces = ApiUtil.findNewApiInterfaces(this.fTypeClass, dojoTypeContext);
        classPrototype.setSupportedInterfaces(typeInterfaces, scriptEnvironment);
        HashMap<String, Member> properties = new HashMap<String, Member>();
        for (Class<?> typeInterface : typeInterfaces) {
            Method[] methodArray = typeInterface.getDeclaredMethods();
            int n2 = methodArray.length;
            n = 0;
            while (n < n2) {
                Method method = methodArray[n];
                if (Modifier.isPublic(method.getModifiers())) {
                    this.checkMember(method, properties);
                    classPrototype.defineFunction(new ApiMethodWrapperFunction(method, scriptEnvironment));
                }
                ++n;
            }
        }
        if (dojoTypeContext.isApiType(this.fTypeClass)) {
            HashMap<String, Member> staticProperties = new HashMap<String, Member>();
            AccessibleObject[] accessibleObjectArray = this.fTypeClass.getDeclaredMethods();
            n = accessibleObjectArray.length;
            int n3 = 0;
            while (n3 < n) {
                Method method = accessibleObjectArray[n3];
                if (Modifier.isPublic(method.getModifiers())) {
                    if (Modifier.isStatic(method.getModifiers())) {
                        this.checkMember(method, staticProperties);
                        this.defineStaticFunction(new ApiMethodWrapperFunction(method, scriptEnvironment));
                    } else {
                        this.checkMember(method, properties);
                        classPrototype.defineFunction(new ApiMethodWrapperFunction(method, scriptEnvironment));
                    }
                }
                ++n3;
            }
            accessibleObjectArray = this.fTypeClass.getDeclaredFields();
            n = accessibleObjectArray.length;
            n3 = 0;
            while (n3 < n) {
                AccessibleObject field = accessibleObjectArray[n3];
                if (Modifier.isPublic(((Field)field).getModifiers())) {
                    if (Modifier.isStatic(((Field)field).getModifiers())) {
                        this.checkMember((Member)((Object)field), staticProperties);
                        this.defineStaticField(new FieldAccessor((Field)field, scriptEnvironment));
                    } else {
                        this.checkMember((Member)((Object)field), properties);
                        classPrototype.defineProperty(new FieldAccessor((Field)field, scriptEnvironment));
                    }
                }
                ++n3;
            }
        }
    }

    private void checkMember(Member member, Map<String, Member> properties) {
        Member knownMember = properties.get(member.getName());
        if (knownMember != null) {
            if (member instanceof Method) {
                if (!(knownMember instanceof Method)) {
                    throw new ScriptEnvironmentSetupException(String.format("Member '%s#%s' shadowed by method '%s#%s' on type '%s'", knownMember.getDeclaringClass().getName(), knownMember.getName(), member.getDeclaringClass().getName(), member.getName(), this.getScriptTypeName()));
                }
                if (!Arrays.equals(((Method)knownMember).getParameterTypes(), ((Method)member).getParameterTypes())) {
                    throw new ScriptEnvironmentSetupException(String.format("Overloading methods is not supported. Found methods '%s#%s' and '%s#%s' on type '%s'", knownMember.getDeclaringClass().getName(), knownMember.getName(), member.getDeclaringClass().getName(), member.getName(), this.getScriptTypeName()));
                }
            } else {
                throw new ScriptEnvironmentSetupException(String.format("Member '%s#%s' shadowed by field '%s#%s' on type '%s'", knownMember.getDeclaringClass().getName(), knownMember.getName(), member.getDeclaringClass().getName(), member.getName(), this.getScriptTypeName()));
            }
        }
        properties.put(member.getName(), member);
    }
}

