/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.internal.types.api;

import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.ScriptEnvironmentSetupException;
import com.ibm.team.rtc.common.scriptengine.environment.IScriptTypeFeature;
import com.ibm.team.rtc.common.scriptengine.internal.types.api.ApiInnerTypeHelper;
import com.ibm.team.rtc.common.scriptengine.internal.types.api.ApiInterfaceConstructorFunction;
import com.ibm.team.rtc.common.scriptengine.internal.util.IScriptingHelper;
import org.eclipse.core.runtime.Assert;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ApiInterfaceFeature
implements IScriptTypeFeature {
    private final Class<?> fInterfaceClass;
    private ApiInterfaceConstructorFunction fInterfaceConstructor;
    private ApiInnerTypeHelper fInnerTypeHelper;

    public ApiInterfaceFeature(Class<?> apiInterface) {
        Assert.isLegal((boolean)apiInterface.isInterface());
        this.fInterfaceClass = apiInterface;
        this.fInnerTypeHelper = new ApiInnerTypeHelper(apiInterface);
    }

    @Override
    public String getProvidedTypeName() {
        return this.fInterfaceClass.getName();
    }

    @Override
    public synchronized void define(Context cx, Scriptable scope, IScriptEnvironment scriptEnvironment) throws ScriptEnvironmentSetupException {
        try {
            this.fInterfaceConstructor = new ApiInterfaceConstructorFunction(this.fInterfaceClass, scriptEnvironment);
            String typeName = this.fInterfaceConstructor.getScriptTypeName();
            IScriptingHelper scriptingHelper = scriptEnvironment.adapt(IScriptingHelper.class);
            scriptingHelper.dojoProvide(typeName);
            scriptingHelper.setObject(typeName, this.fInterfaceConstructor);
            this.fInnerTypeHelper.define(cx, scope, scriptEnvironment);
        }
        catch (Exception e) {
            throw new ScriptEnvironmentSetupException(e);
        }
    }

    @Override
    public synchronized void initialize(Context cx, Scriptable scope, IScriptEnvironment scriptEnvironment) throws ScriptEnvironmentSetupException {
        try {
            Assert.isNotNull((Object)this.fInterfaceConstructor);
            this.fInterfaceConstructor.initialize(cx, scope, scriptEnvironment);
            this.fInnerTypeHelper.initialize(cx, scope, scriptEnvironment);
        }
        catch (Exception e) {
            throw new ScriptEnvironmentSetupException(e);
        }
    }

    public <T> T getAdapter(Class<T> type) {
        return null;
    }

    public String toString() {
        String bundleName = "<unknown bundle>";
        Bundle bundle = FrameworkUtil.getBundle(this.fInterfaceClass);
        if (bundle != null) {
            bundleName = bundle.getSymbolicName();
        }
        return String.format("API Interface Feature '%s' (loaded from bundle '%s')", this.getProvidedTypeName(), bundleName);
    }
}

