/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.scriptengine.internal.types.api;

import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.ScriptEnvironmentSetupException;
import com.ibm.team.rtc.common.scriptengine.environment.IScriptTypeFeature;
import com.ibm.team.rtc.common.scriptengine.internal.types.api.ApiEnumConstructorFunction;
import com.ibm.team.rtc.common.scriptengine.internal.types.api.ApiInnerTypeHelper;
import com.ibm.team.rtc.common.scriptengine.internal.util.IScriptingHelper;
import org.eclipse.core.runtime.Assert;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ApiEnumerationFeature
implements IScriptTypeFeature {
    private final Class<?> fTypeClass;
    private ApiEnumConstructorFunction fTypeConstructor;
    private ApiInnerTypeHelper fInnerTypeHelper;

    public ApiEnumerationFeature(Class<?> typeClass) {
        Assert.isLegal((boolean)typeClass.isEnum());
        this.fTypeClass = typeClass;
        this.fInnerTypeHelper = new ApiInnerTypeHelper(typeClass);
    }

    @Override
    public String getProvidedTypeName() {
        return this.fTypeClass.getName();
    }

    @Override
    public synchronized void define(Context cx, Scriptable scope, IScriptEnvironment scriptEnvironment) throws ScriptEnvironmentSetupException {
        try {
            this.fTypeConstructor = new ApiEnumConstructorFunction(this.fTypeClass, scriptEnvironment);
            String typeName = this.fTypeConstructor.getScriptTypeName();
            IScriptingHelper scriptingHelper = scriptEnvironment.adapt(IScriptingHelper.class);
            scriptingHelper.dojoProvide(typeName);
            scriptingHelper.setObject(typeName, this.fTypeConstructor);
            this.fInnerTypeHelper.define(cx, scope, scriptEnvironment);
        }
        catch (Exception e) {
            throw new ScriptEnvironmentSetupException(e);
        }
    }

    @Override
    public synchronized void initialize(Context cx, Scriptable scope, IScriptEnvironment scriptEnvironment) throws ScriptEnvironmentSetupException {
        try {
            Assert.isNotNull((Object)this.fTypeConstructor);
            this.fTypeConstructor.initialize(cx, scope, scriptEnvironment);
            this.fInnerTypeHelper.initialize(cx, scope, scriptEnvironment);
        }
        catch (Exception e) {
            throw new ScriptEnvironmentSetupException(e);
        }
    }

    public <T> T getAdapter(Class<T> type) {
        return null;
    }

    public String toString() {
        String bundleName = "<unknown bundle>";
        Bundle bundle = FrameworkUtil.getBundle(this.fTypeClass);
        if (bundle != null) {
            bundleName = bundle.getSymbolicName();
        }
        return String.format("API Enumeration Feature '%s' (loaded from bundle '%s')", this.getProvidedTypeName(), bundleName);
    }
}

